function initialisePage() {
    getDiagnosis().done(function(diagnosis) {
        handleDiagnosis(diagnosis);
    });
}

function getDiagnosis() {
    var request = {
        request: 'get_diagnosis'
    };
    return $.post('/utils/childless_tran_HS_226534/index.php', JSON.stringify(request));
}

function fixIssues() {
    var loading = $('#loading');
    loading.css('display', 'flex');
    loading.html('Processing... Please wait');
    $('#resolvedIssuesWrapper').css('display', 'none');
    $('#resolvedBatchesWrapper').css('display', 'none');

    var request = {
        request: 'fix_issues'
    };
    $.post('/utils/childless_tran_HS_226534/index.php', JSON.stringify(request)).done(function(result) {
        handleFixedIssues(result);
        getDiagnosis().done(function(diagnosis) {
            handleFinalDiagnosis(diagnosis);
        });
    });
}

function handleDiagnosis(diagnosis) {
    var loading = $('#loading');
    loading.css('display', 'none');
    $('#preDiagnosisFile').html(diagnosis.diagnosis_file);
    $('#actions').css('display', 'flex');
    $('#links').css('display', 'block');
}

function handleFinalDiagnosis(diagnosis) {
    var loading = $('#loading');
    loading.css('display', 'none');
    $('#postDiagnosisFile').html(diagnosis.diagnosis_file);
}

function handleFixedIssues(result) {
    var loading = $('#loading');
    loading.css('display', 'None');
    $('#tranExportFile').html(result.transaction_export_file);
    $('#tranItemExportFile').html(result.transaction_item_export_file);
}

function goHome() {
    window.location = '/utils/';
}