<?php

function tranExportReport($transactions)
{
    if (count($transactions) == 0) {
        return [];
    }

    $list = array_map(function($value) {
        return "'$value'";
    }, $transactions);
    $list = implode(',', $list);

    $filter = "fn_tran.fn_tran_ix IN ($list)";
    return tran_export($filter);
}

function tranItemExportReport($transactions)
{
    if (count($transactions) == 0) {
        return [];
    }

    $list = array_map(function($value) {
        return "'$value'";
    }, $transactions);
    $list = implode(',', $list);

    $filter = "fn_tran.fn_tran_ix IN ($list)";
    return tran_item_export($filter);
}

function diagnosisReport(
    $invalidInvoices,
    $invalidPayments,
    $invalidDeposits,
    $itemlessDepositReversals,
    $wrongValueDepositReversals,
    $missingDepositReversals,
    $itemlessVoidedInvoices,
    $wrongValueVoidedInvoices,
    $itemlessVoidedDepositReversals,
    $wrongValueVoidedDepositReversals
)
{
    $diagnosis = [
        'batched_invalid_invoices' => [],
        'unbatched_invalid_invoices' => [],
        'batched_invalid_payments' => [],
        'unbatched_invalid_payments' => [],
        'batched_invalid_deposits' => [],
        'unbatched_invalid_deposits' => [],
        'batched_itemless_deposit_reversals' => [],
        'unbatched_itemless_deposit_reversals' => [],
        'batched_wrong_value_deposit_reversals' => [],
        'unbatched_wrong_value_deposit_reversals' => [],
        'batched_missing_deposit_reversals' => [],
        'unbatched_missing_deposit_reversals' => [],
        'batched_itemless_voided_invoices' => [],
        'unbatched_itemless_voided_invoices' => [],
        'batched_wrong_value_voided_invoices' => [],
        'unbatched_wrong_value_voided_invoices' => [],
        'batched_itemless_voided_deposit_reversals' => [],
        'unbatched_itemless_voided_deposit_reversals' => [],
        'batched_wrong_value_voided_deposit_reversals' => [],
        'unbatched_wrong_value_voided_deposit_reversals' => []
    ];

    $affected_batches = [];

    foreach (fetchTransactionInformation($invalidInvoices) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_invalid_invoices'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_invalid_invoices'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($invalidPayments) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_invalid_payments'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_invalid_payments'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($invalidDeposits) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_invalid_deposits'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_invalid_deposits'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($itemlessDepositReversals) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_itemless_deposit_reversals'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_itemless_deposit_reversals'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($wrongValueDepositReversals) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_wrong_value_deposit_reversals'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_wrong_value_deposit_reversals'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($missingDepositReversals) as $transaction) {
        array_push(
            $diagnosis['unbatched_missing_deposit_reversals'],
            $transaction
        );
    }

    foreach (fetchTransactionInformation($itemlessVoidedInvoices) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_itemless_voided_invoices'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_itemless_voided_invoices'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($wrongValueVoidedInvoices) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_wrong_value_voided_invoices'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_wrong_value_voided_invoices'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($itemlessVoidedDepositReversals) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_itemless_voided_deposit_reversals'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_itemless_voided_deposit_reversals'],
                $transaction
            );
        }
    }

    foreach (fetchTransactionInformation($wrongValueVoidedDepositReversals) as $transaction) {
        if ($transaction['fn_batch_id']) {
            array_push(
                $diagnosis['batched_wrong_value_voided_deposit_reversals'],
                $transaction
            );
            if (!in_array($transaction['fn_batch_id'], $affected_batches)) {
                array_push($affected_batches, $transaction['fn_batch_id']);
            }
        } else {
            array_push(
                $diagnosis['unbatched_wrong_value_voided_deposit_reversals'],
                $transaction
            );
        }
    }

    $diagnosis['affected_batches'] = $affected_batches;
    return $diagnosis;
}

function fetchTransactionInformation($transactions)
{
    global $lDB;

    if (!$transactions) {
        return [];
    }

    $list = array_map(function($value) {
        return "'$value'";
    }, $transactions);
    $list = implode(',', $list);

    $data = $lDB->get("
        SELECT
            fn_tran_ix AS fn_tran_id,
            fn_batch_id,
            rv_reservation_id
        FROM fn_tran
        WHERE fn_tran_ix IN ($list)
    ", 6);
    return $data;
}

function addNoteToBatches($transactions, $note)
{
    global $lDB;

    $list = array_map(function($value) {
        return "'$value'";
    }, $transactions);
    $list = implode(',', $list);

    $lDB->put("
        UPDATE fn_batch
        INNER JOIN fn_tran ON fn_tran.fn_batch_id = fn_batch.fn_batch_ix
        SET fn_batch_note = CONCAT(fn_batch_note, '$note')
        WHERE fn_tran.fn_tran_ix IN ($list)
    ");
}