<?php

/**
 * Common initialisation
 */

$GLOBALS['systemName'] = "";			// This is for debugging purposes
$GLOBALS['sessionTimeoutDefault'] = 1800;	// In seconds, 30 minutes
$GLOBALS['dbHost'] = "";

require_once(__DIR__ . "/../../class.mysqldb.php");
require_once(__DIR__ . "/../../inc.ixfields.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../functions.pos.php");
require_once(__DIR__ . "/../../db.rv_extra.php");
require_once(__DIR__ . "/../../db.rv_reservation.php");

$GLOBALS['debugEcho'] = true;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['trTables'] = array();
$GLOBALS['flagChngs'] = "0";
$GLOBALS['debug'] = "0";
$GLOBALS['envWebOverride'] = false;
$GLOBALS['isWebServer'] = isset($GLOBALS['isWebServer']) ? $GLOBALS['isWebServer'] : false;
$GLOBALS['dbUpgradeInProcess'] = isset($GLOBALS['dbUpgradeInProcess']) ? $GLOBALS['dbUpgradeInProcess'] : false;
$GLOBALS['userid'] = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : "";

$options = getopt("",["principal:", "principal-name:", "env:", "env-code:", "training"]);
$principalId = $options['principal'] ?? "";
$GLOBALS['systemName'] = $options['principal-name'] ?? $GLOBALS['systemName'];
$databaseId = $options['env'] ?? "";
$databaseCode = $options['env-code'] ?? "";
$training = array_key_exists("training",$options);

// How many times to try renaming a locked data file
$GLOBALS['initialRetryOpen'] = 10;

if(isset($_SERVER['argv'][1]) && $_SERVER['argv'][1] == "debug") {
	$GLOBALS['debug_pos'] = true;
} else {
	$GLOBALS['debug_pos'] = false;
}

// Connect to the censys table an get the principal id
$cDB = new MySQLDB("censys","root","",$GLOBALS['dbHost']);
if(!empty($principalId)) {
	$principalWhere = "WHERE cn_principal_id = '$principalId'";
} elseif($GLOBALS['systemName'] != "") {
	$principalWhere = "WHERE cn_prn_name_short = '$GLOBALS[systemName]'";
} else {
	$principalWhere = "WHERE cn_prn_name_short != 'demo' AND cn_prn_name_short != 'test'";
}

$principal = $cDB->get("SELECT cn_principal_id, cn_prn_name FROM cn_principal $principalWhere",1);
if(!$principal) {
	die("ERROR: No principal found!");
}
$principalId = $principal['cn_principal_id'];

// Get the DB id
if(empty($databaseId)) {
	$databaseId = $cDB->get("SELECT cn_prn_db_me_id FROM cn_principal $principalWhere",4);
	if($databaseId == "0" || $databaseId == "") {
		$databaseId = $cDB->get("SELECT cn_sys_db_me_id FROM cn_system",4);
	}
}

if($training) {
	$db_type = "training";
} else {
	$db_type = "live";
}
$lDB = new MySQLDB("cn_" . $db_type . "_" . str_pad($principalId,4,"0",STR_PAD_LEFT),"root","",$GLOBALS['dbHost']);

if(!empty($databaseCode)) {
	$databaseId = $lDB->get("SELECT rf_database_id FROM rf_database WHERE rf_db_code = '$databaseCode'",4);
}
// Get the Database code
$dbInfo = $lDB->get("
	SELECT
		rf_db_code,
		rf_db_description,
		rf_db_pos_folder,
		rf_db_pos_frequency,
		rf_db_time_zone
	FROM
		rf_database
	WHERE
		rf_database_id = '$databaseId'
",1);
$GLOBALS['dbcode'] = $dbInfo['rf_db_code'];
$GLOBALS['sleepTime'] = $dbInfo['rf_db_pos_frequency'];				// Amount of time between transaction polling
$GLOBALS['POS_DIR'] = $dbInfo['rf_db_pos_folder'];					// Path to the POS transactions
set_timezone($dbInfo['rf_db_time_zone']);

echo "\n\n";
posLog("ResRequest <--> " . $GLOBALS['POS_NAME'] . " POS integration service");
posLog(" * Detected settings:
    . Principal id - $principalId ($principal[cn_prn_name])
    . Environment  - $databaseId ($dbInfo[rf_db_description])
    . Type         - " . ($training?"Training":"Live"));

if(empty($GLOBALS['POS_DIR'])) {
	die("ERROR: POS directory empty!");
}

if(substr($GLOBALS['POS_DIR'],-1,1) != "/" && substr($GLOBALS['POS_DIR'],-1,1) != "\\") {
	if(strpos($GLOBALS['POS_DIR'],"\\") !== false) {
		$GLOBALS['POS_DIR'] .= "\\";
	} else {
		$GLOBALS['POS_DIR'] .= "/";
	}
}

if(!is_dir($GLOBALS['POS_DIR'])) {
	die("ERROR: POS directory '$GLOBALS[POS_DIR]' not found!");
}

$GLOBALS['propertyList'] = $lDB->get("SELECT pr_business_id FROM rf_db_business WHERE rf_db_code = '$GLOBALS[dbcode]'",3);

$GLOBALS['isPropServer'] = false;
$rf_db_env_type_ind = $lDB->get("select rf_db_env_type_ind from rf_database where rf_db_code = '$GLOBALS[dbcode]'",4);

if ($rf_db_env_type_ind == "4") $GLOBALS['isPropServer'] = true;

posLog(" * Accepting Transactions for the following property codes: " . join(", ",$propertyList));

$sessionTimeout = -1;

/**
 * Functions
 */

function posLog($message, $level='info') {
	global $debug_pos;

	if($debug_pos || $level != "debug") {
		$prefix = $level . " - " . date('Y-m-d H:i:s') . " -- ";
		echo $prefix . str_replace("\n", "\n" . str_repeat(" ",strlen($prefix)),$message) . "\n";
	}
}

function posWriteAndRename($filename,$data,$deleteExisting=false) {
	$tmpFilename = $filename . ".rtmp";
	$fp = @fopen($tmpFilename,"w");
	if($fp === false) {
		return false;
	}
	posLog("Writing response $filename with contents:\n$data","raw");
	$result = fwrite($fp, $data);
	fclose($fp);
	if($result === false) {
		return false;
	}
	if($deleteExisting && file_exists($filename)) {
		if(unlink($filename) === false) {
			return false;
		}
	}
	if(rename($tmpFilename, $filename) === false) {
		return false;
	}
	return true;
}

