<?php

function addTags($aValues,$aHTML) {
	$keys = array_keys($aValues);
	$newKeys = array();
	foreach($keys as $item) {
		array_push($newKeys,"!$item!");
	}
	$newValues = array();
	foreach($aValues as $aKey=>$aValue) {
		if(!is_array($aValue)) {
			$newValues[$aKey] = $aValue;
		} else {
			$newValues[$aKey] = "";
		}
	}
	return str_replace($newKeys,$newValues,$aHTML);
}

function getHTML($gFilename) {
	$sectionArray = preg_split("/\|\|(\w*?)\|\|/",join("\n",file($gFilename)),-1,PREG_SPLIT_DELIM_CAPTURE);
	$htmlArray = array();
	for($count=0; $count < floor(sizeof($sectionArray)/2); $count++) {
		$htmlArray[$sectionArray[($count*2)+1]] = trim($sectionArray[$count*2]);
	}
	return $htmlArray;
}

function redirect($url){
	header("Location:".$url);
}

function createTables() {
	// Step 1
	sqlPut("DROP TABLE IF EXISTS ai_csv_contact");
	sqlPut("
		CREATE TABLE ai_csv_contact (
		  company varchar(255) default NULL,
		  title varchar(255) default NULL,
		  first_name varchar(255) default NULL,
		  last_name varchar(255) default NULL,
		  position varchar(255) default NULL,
		  fax varchar(255) default NULL,
		  phone varchar(255) default NULL,
		  mobile varchar(255) default NULL,
		  email varchar(255) default NULL,
		  web_addr varchar(255) default NULL,
		  postal_1 varchar(255) default NULL,
		  postal_2 varchar(255) default NULL,
		  postal_3 varchar(255) default NULL,
		  postal_city varchar(255) default NULL,
		  postal_code varchar(255) default NULL,
		  postal_country varchar(255) default NULL,
		  phys_1 varchar(255) default NULL,
		  phys_2 varchar(255) default NULL,
		  phys_3 varchar(255) default NULL,
		  phys_city varchar(255) default NULL,
		  phys_code varchar(255) default NULL,
		  phys_country varchar(255) default NULL,
		  statutory_1 varchar(255) default NULL,
		  statutory_2 varchar(255) default NULL,
		  statutory_3 varchar(255) default NULL,
		  commission varchar(255) default NULL,
		  commission_flag varchar(255) default NULL,
		  rate_type_default varchar(255) default NULL,
		  payment_plan varchar(255) default NULL,
		  agent_note varchar(255) default NULL,
		  interest varchar(255) default NULL
		) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1
	");
}

function importFile() {
	// Step 2
	$file = __DIR__ . "/" . $_POST['filename'];
	sqlPut("
		LOAD DATA INFILE '$file'
			INTO TABLE ai_csv_contact
			FIELDS TERMINATED BY ','
      OPTIONALLY ENCLOSED BY '\"'
      LINES TERMINATED BY '\\r\\n'
			IGNORE 1 LINES
      (
        company,
        title,
        first_name,
        last_name,
        position,
        fax,
        phone,
        mobile,
        email,
        web_addr,
        postal_1,
        postal_2,
        postal_3,
        postal_city,
        postal_code,
        postal_country,
        phys_1,
        phys_2,
        phys_3,
        phys_city,
        phys_code,
        phys_country,
        statutory_1,
        statutory_2,
        statutory_3,
        commission,
        commission_flag,
        rate_type_default,
        payment_plan,
        agent_note,
        interest
      );
	");
}

function staging() {
	// Step 3
  global $lDB;
  $keyString = "CASE WHEN last_name = '' AND first_name = '' THEN company ELSE CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) END AS `key`";
	sqlPut("
		UPDATE
			ai_csv_contact
		SET
			company = TRIM(company),
			title = TRIM(title),
			first_name = TRIM(first_name),
			last_name = TRIM(last_name),
			position = TRIM(position),
			fax = TRIM(fax),
			phone = TRIM(phone),
			mobile = TRIM(mobile),
			email = TRIM(email),
			web_addr = TRIM(web_addr),
			postal_1 = TRIM(postal_1),
			postal_2 = TRIM(postal_2),
			postal_3 = TRIM(postal_3),
			postal_city = TRIM(postal_city),
			postal_code = TRIM(postal_code),
			postal_country = TRIM(postal_country),
			phys_1 = TRIM(phys_1),
			phys_2 = TRIM(phys_2),
			phys_3 = TRIM(phys_3),
			phys_city = TRIM(phys_city),
			phys_code = TRIM(phys_code),
			phys_country = TRIM(phys_country),
			statutory_1 = TRIM(statutory_1),
			statutory_2 = TRIM(statutory_2),
			statutory_3 = TRIM(statutory_3),
			commission = TRIM(commission),
			commission_flag = TRIM(commission_flag),
			rate_type_default = TRIM(rate_type_default),
			payment_plan = TRIM(payment_plan),
      agent_note = TRIM(agent_note),
      interest = TRIM(interest)"
  );

	sqlPut("DROP TABLE IF EXISTS ai_persona");
	sqlPut("CREATE TABLE ai_persona (
			`key` VARCHAR(255) NOT NULL default '',
			pr_persona_ix VARCHAR(36) NOT NULL default '',
			pr_org_yn TINYINT(1) NOT NULL default 0,
			pr_name_last VARCHAR(95) NOT NULL default '',
			pr_name_first VARCHAR(50) NOT NULL default '',
			pr_title_id VARCHAR(36) NOT NULL default '',
			position VARCHAR(255) NOT NULL default '',
			pr_name_suffix_id VARCHAR(36) NOT NULL default '',
			pr_email VARCHAR(50) NOT NULL default '',
			pr_corr_addr_line1 VARCHAR(50) NOT NULL default '',
			pr_corr_addr_line2 VARCHAR(50) NOT NULL default '',
			pr_corr_addr_line3 VARCHAR(50) NOT NULL default '',
			pr_corr_city VARCHAR(50) NOT NULL default '',
			pr_corr_country_id VARCHAR(36) NOT NULL default '',
			pr_corr_post_code VARCHAR(50) NOT NULL default '',
			pr_phys_addr_line1 VARCHAR(50) NOT NULL default '',
			pr_phys_addr_line2 VARCHAR(50) NOT NULL default '',
			pr_phys_addr_line3 VARCHAR(50) NOT NULL default '',
			pr_phys_city VARCHAR(50) NOT NULL default '',
			pr_phys_country_id VARCHAR(36) NOT NULL default '',
			pr_phys_post_code VARCHAR(50) NOT NULL default '',
			rf_comms_preference_id VARCHAR(36) NOT NULL default '',
			pr_web_addr VARCHAR(50) NOT NULL default '',
			pr_statutory_1 VARCHAR(20) NOT NULL default '',
			pr_statutory_2 VARCHAR(20) NOT NULL default '',
			pr_statutory_3 VARCHAR(20) NOT NULL default '',
			pr_persona_link_id VARCHAR(36) NOT NULL default '',
			pr_persona_fwd_id VARCHAR(36) NOT NULL default '',
			interest VARCHAR(255) NOT NULL default ''
		) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1");

	sqlPut("DROP TABLE IF EXISTS ai_agent");
	sqlPut("CREATE TABLE ai_agent (
			`key` VARCHAR(255) NOT NULL default '',
			pr_agent_comm_deduct_yn TINYINT(1) NOT NULL default 0,
			pr_agent_commission_perc DECIMAL(16,2) NOT NULL default 0,
			pr_agent_account VARCHAR(50) NOT NULL default '',
			ac_pay_plan_id VARCHAR(36) NOT NULL default '',
			pr_agent_show_allocs_ind TINYINT(2) NOT NULL default 0,
			pr_agent_alloc_auto_yn TINYINT(1) NOT NULL default 1,
			pr_agent_alloc_ext_yn TINYINT(1) NOT NULL default 0,
			pr_agent_note_open TEXT NOT NULL default ''
		) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1");

	sqlPut("DROP TABLE IF EXISTS ai_phone");
	sqlPut("CREATE TABLE ai_phone (
			`key` VARCHAR(255) NOT NULL default '',
			rf_phone_type_id VARCHAR(36) NOT NULL default '',
			pr_phone_number VARCHAR(50) NOT NULL default '',
			pr_phone_detail VARCHAR(50) NOT NULL default '',
			pr_default_yn TINYINT(1) NOT NULL default 0
		) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1");

	sqlPut("DROP TABLE IF EXISTS ai_link");
	sqlPut("CREATE TABLE ai_link (
			pr_link_from VARCHAR(255) NOT NULL default '',
			pr_link_to VARCHAR(255) NOT NULL default '',
			rf_link_type_id VARCHAR(36) NOT NULL default ''
		) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1");

	sqlPut("DROP TABLE IF EXISTS ai_sales_obj_data");
	sqlPut("CREATE TABLE ai_sales_obj_data (
			`key` VARCHAR(255) NOT NULL default '',
      `pr_sales_obj_data_text` varchar(30) DEFAULT NULL,
      `pr_sales_obj_data_memo` text,
      `pr_persona_id` varchar(36) DEFAULT NULL,
      `rc_obj_sales_data_id` varchar(36) DEFAULT NULL,
      `rc_obj_sales_id` varchar(36) DEFAULT NULL
		) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1");

	sqlPut("INSERT INTO ai_persona
			(`key`,pr_org_yn,pr_name_last)
		SELECT DISTINCT
			company,
			'1',
			company
		FROM
      ai_csv_contact
    WHERE
      company != ''");

	sqlPut("UPDATE
			ai_persona
			LEFT JOIN ai_csv_contact ON ai_csv_contact.company = ai_persona.`key`
				AND ai_csv_contact.first_name = '' AND ai_csv_contact.last_name = ''
			LEFT JOIN rf_country AS corr_country ON corr_country.rf_country_name = ai_csv_contact.postal_country
			LEFT JOIN rf_country AS phys_country ON phys_country.rf_country_name = ai_csv_contact.phys_country
      LEFT JOIN pr_persona ON pr_persona.pr_name_last = ai_csv_contact.company
		SET
			ai_persona.pr_persona_ix = pr_persona.pr_persona_ix,
			ai_persona.pr_email = ai_csv_contact.email,
			ai_persona.pr_web_addr = ai_csv_contact.web_addr,
			ai_persona.pr_corr_addr_line1 = ai_csv_contact.postal_1,
			ai_persona.pr_corr_addr_line2 = ai_csv_contact.postal_2,
			ai_persona.pr_corr_addr_line3 = ai_csv_contact.postal_3,
			ai_persona.pr_corr_city = ai_csv_contact.postal_city,
			ai_persona.pr_corr_country_id = corr_country.rf_country_ix,
			ai_persona.pr_corr_post_code = ai_csv_contact.postal_code,
			ai_persona.pr_phys_addr_line1 = ai_csv_contact.phys_1,
			ai_persona.pr_phys_addr_line2 = ai_csv_contact.phys_2,
			ai_persona.pr_phys_addr_line3 = ai_csv_contact.phys_3,
			ai_persona.pr_phys_city = ai_csv_contact.phys_city,
			ai_persona.pr_phys_country_id = phys_country.rf_country_ix,
			ai_persona.pr_phys_post_code = ai_csv_contact.phys_code,
			ai_persona.pr_statutory_1 = ai_csv_contact.statutory_1,
			ai_persona.pr_statutory_2 = ai_csv_contact.statutory_2,
			ai_persona.pr_statutory_3 = ai_csv_contact.statutory_3");

	sqlPut("INSERT INTO ai_agent
			(`key`,pr_agent_commission_perc,pr_agent_comm_deduct_yn,ac_pay_plan_id,pr_agent_note_open)
		SELECT DISTINCT
			company,
			commission,
			CASE
				WHEN  commission_flag = 'nett' THEN 1
				WHEN  commission_flag = 'gross' THEN 0
			END AS commission_flag,
			ac_pay_plan.ac_pay_plan_ix,
			CASE
				WHEN TRIM(agent_note) = '\\r' THEN NULL
				WHEN TRIM(agent_note) = '' THEN NULL
				ELSE agent_note
			END AS agent_note
		FROM
			ai_csv_contact
			LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_desc = ai_csv_contact.payment_plan");

	sqlPut("INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
			SELECT DISTINCT
				company,
				'RS1',
				fax,
				NULL,
				0
			FROM
				ai_csv_contact
			WHERE
				TRIM(fax) != ''
				AND ai_csv_contact.first_name = ''
				AND ai_csv_contact.last_name = ''");

	sqlPut("INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
			SELECT DISTINCT
				company,
				'RS3',
				phone,
				NULL,
				1
			FROM
				ai_csv_contact
			WHERE
				TRIM(phone) != ''
				AND ai_csv_contact.first_name = ''
				AND ai_csv_contact.last_name = ''");

	sqlPut("INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
			SELECT DISTINCT
				company,
				'RS4',
				mobile,
				NULL,
				0
			FROM
				ai_csv_contact
			WHERE
				TRIM(mobile) != ''
				AND ai_csv_contact.first_name = ''
				AND ai_csv_contact.last_name = ''");

	sqlPut("INSERT INTO ai_link
			(
				pr_link_from,
				pr_link_to,
				rf_link_type_id
			)
			SELECT
				CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
				company,
				'RS2'
			FROM
				ai_csv_contact
			WHERE
				ai_csv_contact.last_name != '' OR ai_csv_contact.first_name != ''");

	sqlPut("INSERT INTO ai_persona
			(`key`,
      pr_persona_ix,
			pr_org_yn,
			pr_name_last,
			pr_name_first,
      pr_title_id,
			pr_email,
			pr_corr_addr_line1,
			pr_corr_addr_line2,
			pr_corr_addr_line3,
			pr_corr_city,
			pr_corr_country_id,
			pr_corr_post_code,
			pr_phys_addr_line1,
			pr_phys_addr_line2,
			pr_phys_addr_line3,
			pr_phys_city,
			pr_phys_country_id,
			pr_phys_post_code
			)
		SELECT
			CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
      pr_persona_ix,
			'0',
			last_name,
			first_name,
      rf_title.rf_title_ix,
			email,
			postal_1,
			postal_2,
			postal_3,
			postal_city,
			corr_country.rf_country_ix AS corr_country_ix,
			postal_code,
			phys_1,
			phys_2,
			phys_3,
			phys_city,
			phys_country.rf_country_ix AS phys_country_ix,
			phys_code
		FROM
			ai_csv_contact
			LEFT JOIN rf_country AS corr_country ON corr_country.rf_country_name = ai_csv_contact.postal_country
			LEFT JOIN rf_country AS phys_country ON phys_country.rf_country_name = ai_csv_contact.phys_country
      LEFT JOIN rf_title ON rf_title_desc = ai_csv_contact.title
      LEFT JOIN pr_persona ON pr_persona.pr_name_first = ai_csv_contact.first_name
        AND pr_persona.pr_name_last = ai_csv_contact.last_name
        AND pr_persona.pr_email = ai_csv_contact.email
		WHERE
			ai_csv_contact.last_name != '' OR ai_csv_contact.first_name != ''");

	sqlPut("INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
			SELECT
				CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
				'RS1',
				fax,
				NULL,
				0
			FROM
				ai_csv_contact
			WHERE
				TRIM(fax) != ''
				AND (
					ai_csv_contact.last_name != ''
					OR ai_csv_contact.first_name != ''
				)");

	sqlPut("INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
			SELECT
				CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
				'RS3',
				phone,
				NULL,
				1
			FROM
				ai_csv_contact
			WHERE
				TRIM(phone) != ''
				AND (
					ai_csv_contact.last_name != ''
					OR ai_csv_contact.first_name != ''
				)");

	sqlPut("INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
			SELECT
				CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
				'RS4',
				mobile,
				NULL,
				0
			FROM
				ai_csv_contact
			WHERE
				TRIM(mobile) != ''
				AND (
					ai_csv_contact.last_name != ''
					OR ai_csv_contact.first_name != ''
				)");

  $salesDataMappings = array(
    'position' => array('rc_obj_sales_label' => 'Position', 'rc_obj_sales_type_ind' => DB_RC_OBJ_SALES_TEXTBOX),
    'interest' => array('rc_obj_sales_label' => 'Interested in', 'rc_obj_sales_type_ind' => DB_RC_OBJ_SALES_CHECKBOX)
  );
  foreach($salesDataMappings as $column => $mapping) {
    switch ($mapping['rc_obj_sales_type_ind']) {
      case DB_RC_OBJ_SALES_TEXTBOX:
        sqlPut("INSERT INTO ai_sales_obj_data
            (
              `key`,
              pr_sales_obj_data_text,
              pr_sales_obj_data_memo,
              pr_persona_id,
              rc_obj_sales_data_id,
              rc_obj_sales_id
            )
            SELECT
              $keyString,
              $column,
              NULL,
              NULL,
              NULL,
              (SELECT rc_obj_sales_ix FROM rc_obj_sales WHERE rc_obj_sales_label = '".$mapping['rc_obj_sales_label']."')
            FROM
              ai_csv_contact
            WHERE
              (ai_csv_contact.last_name != '' OR ai_csv_contact.first_name != '')
              AND ($column != '' AND $column IS NOT NULL)
          ");
        break;
      case DB_RC_OBJ_SALES_CHECKBOX:
        $salesObjects = $lDB->get("
          SELECT
            $keyString,
            $column AS sales_values,
            (SELECT rc_obj_sales_ix FROM rc_obj_sales WHERE rc_obj_sales_label = '".$mapping['rc_obj_sales_label']."') AS rc_obj_sales_ix
          FROM
            ai_csv_contact
          WHERE
            (ai_csv_contact.last_name != '' OR ai_csv_contact.first_name != '' OR ai_csv_contact.company != '')
            AND $column IS NOT NULL AND $column != ''
        ",6);
        foreach($salesObjects as $salesObject) {
          $salesValues = explode("|",$salesObject['sales_values']);
          foreach($salesValues as $salesValue) {
            sqlPut("INSERT INTO ai_sales_obj_data
                (
                  `key`,
                  pr_sales_obj_data_text,
                  pr_sales_obj_data_memo,
                  pr_persona_id,
                  rc_obj_sales_data_id,
                  rc_obj_sales_id
                )
                VALUES (
                  '".$salesObject['key']."',
                  NULL,
                  NULL,
                  NULL,
                  (SELECT rc_obj_sales_data_ix FROM rc_obj_sales_data WHERE rc_obj_sales_data_content = '".trim($salesValue)."' AND rc_obj_sales_id = '".$salesObject['rc_obj_sales_ix']."'),
                  '".$salesObject['rc_obj_sales_ix']."'
                )"
              );
          }
        }
        break;
    }
  }
}

function importData() {
	// Step 4
	global $other;
	global $lDB;
	foreach($_SESSION['contact_import']['tables'] as $tableName=>$tableInfo) {
		$table =& $_SESSION['contact_import']['tables'][$tableName];
		$imports = $lDB->get("SELECT * FROM $table[importFrom]",6);
		if($tableName == "pr_persona") {
			$key = array();
		}
		foreach($imports as $import) {
			switch($tableName) {
			case "pr_persona":
        if(empty($import[$table['fields']['key']])) {
					$other .= "Skipping contact. Empty row " . $import[$table['fields']['key']] . "<br/>";
					continue;
        }
				if(isset($import[$table['fields']['key']]) && array_key_exists($import[$table['fields']['key']],$key)) {
					$other .= "Skipping contact. Key already exists " . $import[$table['fields']['key']] . "<br/>";
					continue;
				}

        if (!empty($import[$table['fields']['pr_persona_ix']])) {
          // pr_persona exists, update it
          $pr_persona_ix = $import[$table['fields']['pr_persona_ix']];
          $key[$import[$table['fields']['key']]] = $pr_persona_ix;
          $fields = array();
          foreach($table['fields'] as $name => $value) {
            if(
              !empty($import[$table['fields'][$name]])
              && $name != "key"
              && $name != $tableName . "_ix"
            ) {
              $fields[] = "$name = '".$lDB->escape($import[$table['fields'][$name]])."'";
            }
          }
          $sql = implode(",", $fields);
          if (count($fields) > 0) {
            $lDB->put("
              UPDATE pr_persona SET
                $sql
              WHERE
                pr_persona_ix = '$pr_persona_ix'
            ");
          }
        } else {
          $key[$import[$table['fields']['key']]] = db_pr_persona_insert(
            $import[$table['fields']['pr_org_yn']],
            $import[$table['fields']['pr_name_last']],
            $import[$table['fields']['pr_name_first']],
            $import[$table['fields']['pr_title_id']],
            $import[$table['fields']['pr_name_suffix_id']],
            $import[$table['fields']['pr_email']],
            $import[$table['fields']['pr_corr_addr_line1']],
            $import[$table['fields']['pr_corr_addr_line2']],
            $import[$table['fields']['pr_corr_addr_line3']],
            $import[$table['fields']['pr_corr_city']],
            $import[$table['fields']['pr_corr_country_id']],
            $import[$table['fields']['pr_corr_post_code']],
            $import[$table['fields']['pr_phys_addr_line1']],
            $import[$table['fields']['pr_phys_addr_line2']],
            $import[$table['fields']['pr_phys_addr_line3']],
            $import[$table['fields']['pr_phys_city']],
            $import[$table['fields']['pr_phys_country_id']],
            $import[$table['fields']['pr_phys_post_code']],
            $import[$table['fields']['rf_comms_preference_id']],
            $import[$table['fields']['pr_web_addr']],
            $import[$table['fields']['pr_statutory_1']],
            $import[$table['fields']['pr_statutory_2']],
            $import[$table['fields']['pr_statutory_3']],
            $import[$table['fields']['pr_persona_link_id']],
            $import[$table['fields']['pr_persona_fwd_id']]
          );
        }
				break;
			case "pr_agent":
        if(empty($import[$table['fields']['key']])) {
					$other .= "Skipping agent. Empty row " . $import[$table['fields']['key']] . "<br/>";
					continue;
        }
				if(!db_pr_persona_exists($key[$import[$table['fields']['key']]])) {
					$other .= "Skipping agent. Missing contact ". $import[$table['fields']['key']]."<br/>";
					continue;
				}
				db_pr_agent_insert(
					$key[$import[$table['fields']['key']]],
					$import[$table['fields']['pr_agent_comm_deduct_yn']],
					$import[$table['fields']['pr_agent_commission_perc']],
					$import[$table['fields']['pr_agent_account']],
					$import[$table['fields']['ac_pay_plan_id']],
					$import[$table['fields']['pr_agent_show_allocs_ind']],
					$import[$table['fields']['pr_agent_alloc_auto_yn']],
					$import[$table['fields']['pr_agent_alloc_ext_yn']],
					$import[$table['fields']['pr_agent_note_open']]
				);
				break;
			case "pr_phone":
				if(!db_pr_persona_exists($key[$import[$table['fields']['key']]])) {
					$other .= "Skipping phone. Missing contact ".$import[$table['fields']['key']]."<br/>";
					continue;
				}
				db_pr_phone_insert(
					$key[$import[$table['fields']['key']]],
					$import[$table['fields']['rf_phone_type_id']],
					$import[$table['fields']['pr_phone_number']],
					$import[$table['fields']['pr_phone_detail']],
					$import[$table['fields']['pr_default_yn']]
				);
				break;
			case "pr_link":
				if(!db_pr_persona_exists($key[$import[$table['fields']['pr_link_from']]])) {
					$other .= "Skipping link. Missing from contact " .$import[$table['fields']['pr_link_from']]. "<br/>";
					continue;
				}
				if(!db_pr_persona_exists($key[$import[$table['fields']['pr_link_to']]])) {
					$other .= "Skipping link. Missing contact " .$import[$table['fields']['pr_link_to']]. "<br/>";
					continue;
				}
				db_pr_link_insert(
					$key[$import[$table['fields']['pr_link_from']]],
					$key[$import[$table['fields']['pr_link_to']]],
					$import[$table['fields']['rf_link_type_id']]
				);
				break;
			case "pr_sales_obj_data":
        if(empty($key[$import[$table['fields']['key']]])) {
					$other .= "Skipping sales data. Empty row <br/>";
					continue;
        }
        $pr_sales_obj_data_content = !empty($import[$table['fields']['pr_sales_obj_data_text']]) ? $import[$table['fields']['pr_sales_obj_data_text']] : $import[$table['fields']['rc_obj_sales_data_id']];
        if (!empty($pr_sales_obj_data_content)) {
          db_pr_sales_obj_data_insert(
            $key[$import[$table['fields']['key']]],
            $import[$table['fields']['rc_obj_sales_id']],
            $pr_sales_obj_data_content
          );
        }
				break;
			}
		}
	}

	$rateTypes = $lDB->get("
		SELECT
			ai_csv_contact.company,
			ai_csv_contact.rate_type_default
		FROM
			ai_csv_contact
		WHERE
			ai_csv_contact.first_name = ''
			AND ai_csv_contact.last_name = ''
	",2);
	foreach($rateTypes as $rateType) {
		$agent = $rateType['company'];
		$rates = explode("\n",$rateType['rate_type_default']);
		foreach($rates as $rate) {
			$rate = trim($rate);
			$rt_rate_type_id = $lDB->get("
				SELECT
					rt_rate_type.rt_rate_type_ix
				FROM
					rt_rate_type
				WHERE
					rt_rate_type.rt_rate_type_desc = '$rate'
			",4);
			if(!empty($rt_rate_type_id)) {
				$count = $lDB->get("SELECT COUNT(*) FROM pr_agent_rate WHERE pr_agent_id = '".$key[$agent]."'",4);
				if($count > 0) {
					$pr_agent_rate_default_yn = "0";
				} else {
					$pr_agent_rate_default_yn = "1";
				}
				$countDuplicates = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						pr_agent_rate
					WHERE
						pr_agent_id = '".$key[$agent]."'
						AND rt_rate_type_id = '$rt_rate_type_id'
						AND pr_agent_rate_default_yn = '$pr_agent_rate_default_yn'
				");
				if ($countDuplicates == 0) {
					$lDB->put("
						INSERT INTO pr_agent_rate (
							pr_agent_rate_db,
							pr_agent_id,
							rt_rate_type_id,
							pr_agent_rate_default_yn
						) VALUES (
							'$GLOBALS[dbcode]',
							'".$key[$agent]."',
							'$rt_rate_type_id',
							'$pr_agent_rate_default_yn'
						)
					");
				}
			} else {
				if($rate != "") {
					$other .= "Skipping rate. Missing rate '$rate' for agent $agent<br />";
				}
			}
		}
	}

  $other = "<h2>Import completed</h2><p class='text-small'>" . $other;
	$other .= "Imported " . sizeof($key) . " contact record(s).</p><br /><br />\n";
}

function setDefaultAgentRates() {
	// Step 5
	sqlPut("INSERT IGNORE INTO pr_agent_rate (
			pr_agent_rate_db,
			pr_agent_rate_ix,
			pr_agent_rate_default_yn,
			pr_agent_id,
			rt_rate_type_id,
			pr_agent_rate_trf_yn
		) SELECT DISTINCT
			'WB',
			(SELECT GET_UUID()),
			'1',
			pr_agent.pr_agent_id,
			rt_rate_type.rt_rate_type_ix,
			'1'
		FROM
			ai_csv_contact
			INNER JOIN pr_persona ON TRIM(pr_persona.pr_name_last) = TRIM(ai_csv_contact.company)
			INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
			INNER JOIN rt_rate_type ON TRIM(rt_rate_type.rt_rate_type_desc) = TRIM(ai_csv_contact.rate_type_default)");
}

function cleanup() {
	// Step 6
	sqlPut("DROP TABLE IF EXISTS ai_csv_contact");
	sqlPut("DROP TABLE IF EXISTS ai_persona");
	sqlPut("DROP TABLE IF EXISTS ai_agent");
	sqlPut("DROP TABLE IF EXISTS ai_phone");
	sqlPut("DROP TABLE IF EXISTS ai_link");
	sqlPut("DROP TABLE IF EXISTS ai_sales_obj_data");
	unset($_SESSION['contact_import']);
	unset($_SESSION['step']);
	unset($_SESSION['ai_persona_table']);
  step();
}

function step($step = "") {
	if (!isset($_SESSION)) {
		$_SESSION['step'] = 1;
	} elseif (!empty($step)) {
		$_SESSION['step'] = $step;
	}
}

function sqlPut($string) {
  global $lDB;
  mysqli_real_query($lDB->conn, "CALL sp_set_environment('".$GLOBALS['dbcode']."');");
  mysqli_query($lDB->conn,$string);
  $error = mysqli_error($lDB->conn);
  if (!empty($error)) {
    echo "<strong class='red'>SQL ERROR:</strong> $error<br/>";
    echo "<strong>Query:</strong> $string<br/><br/>";
  }
}
?>
