-- STEP 1: Create the CSV import table {

DROP TABLE IF EXISTS ai_csv_contact;
CREATE TABLE ai_csv_contact (
  company varchar(255) default NULL,
  first_name varchar(255) default NULL,
  last_name varchar(255) default NULL,
  fax varchar(255) default NULL,
  phone varchar(255) default NULL,
  mobile varchar(255) default NULL,
  email varchar(255) default NULL,
  web_addr varchar(255) default NULL,
  postal_1 varchar(255) default NULL,
  postal_2 varchar(255) default NULL,
  postal_3 varchar(255) default NULL,
  postal_city varchar(255) default NULL,
  postal_code varchar(255) default NULL,
  postal_country varchar(255) default NULL,
  phys_1 varchar(255) default NULL,
  phys_2 varchar(255) default NULL,
  phys_3 varchar(255) default NULL,
  phys_city varchar(255) default NULL,
  phys_code varchar(255) default NULL,
  phys_country varchar(255) default NULL,
  tax_number varchar(255) default NULL,
  commission varchar(255) default NULL,
  commission_flag varchar(255) default NULL,
  rate_type_default varchar(255) default NULL,
  payment_plan varchar(255) default NULL,
  agent_note varchar(255) default NULL
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;


/*

	"I use Heidi SQL for this step." - Nick

	"I use the awesome magical powers of vim & cli for this setup." - Dylan

*/

-- }


-- STEP 2: Import from the CSV file {
LOAD DATA LOCAL INFILE '/home/nicol/repositories/resrequest/resrequest/utils/contact_import/agents.csv'
	INTO TABLE ai_csv_contact
	FIELDS TERMINATED BY ','
		OPTIONALLY ENCLOSED BY '"'
	IGNORE 1 LINES
	(company, first_name, last_name, fax, phone, mobile, email, web_addr, postal_1, postal_2, postal_3, postal_city, postal_code, postal_country, phys_1, phys_2, phys_3, phys_city, phys_code, phys_country, tax_number, commission, commission_flag, rate_type_default, payment_plan, agent_note);

/*

  LOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE 'file_name'
    [REPLACE | IGNORE]
    INTO TABLE tbl_name
    [CHARACTER SET charset_name]
    [{FIELDS | COLUMNS}
        [TERMINATED BY 'string']
        [[OPTIONALLY] ENCLOSED BY 'char']
        [ESCAPED BY 'char']
    ]
    [LINES
        [STARTING BY 'string']
        [TERMINATED BY 'string']
    ]
    [IGNORE number LINES]
    [(col_name_or_user_var,...)]
    [SET col_name = expr,...]      
*/

-- }


-- STEP 3: Create contact staging tables and import from the CSV table {

UPDATE 
	ai_csv_contact 
SET
	company = TRIM(company),
	first_name = TRIM(first_name),
	last_name = TRIM(last_name),
	fax = TRIM(fax),
	phone = TRIM(phone),
	mobile = TRIM(mobile),
	email = TRIM(email),
	web_addr = TRIM(web_addr),
	postal_1 = TRIM(postal_1),
	postal_2 = TRIM(postal_2),
	postal_3 = TRIM(postal_3),
	postal_city = TRIM(postal_city),
	postal_code = TRIM(postal_code),
	postal_country = TRIM(postal_country),
	phys_1 = TRIM(phys_1),
	phys_2 = TRIM(phys_2),
	phys_3 = TRIM(phys_3),
	phys_city = TRIM(phys_city),
	phys_code = TRIM(phys_code),
	phys_country = TRIM(phys_country),
	tax_number = TRIM(tax_number),
	commission = TRIM(commission),
	commission_flag = TRIM(commission_flag),
	rate_type_default = TRIM(rate_type_default),
	payment_plan = TRIM(payment_plan),
	agent_note = TRIM(agent_note);

DROP TABLE IF EXISTS ai_persona;
CREATE TABLE ai_persona (
	`key` VARCHAR(255) NOT NULL default '',
	pr_org_yn TINYINT(1) NOT NULL default 0,
	pr_name_last VARCHAR(95) NOT NULL default '',
	pr_name_first VARCHAR(50) NOT NULL default '',
	pr_title_id VARCHAR(13) NOT NULL default '',
	pr_name_suffix_id VARCHAR(13) NOT NULL default '',
	pr_email VARCHAR(50) NOT NULL default '',
	pr_corr_addr_line1 VARCHAR(50) NOT NULL default '',
	pr_corr_addr_line2 VARCHAR(50) NOT NULL default '',
	pr_corr_addr_line3 VARCHAR(50) NOT NULL default '',
	pr_corr_city VARCHAR(50) NOT NULL default '',
	pr_corr_country_id VARCHAR(13) NOT NULL default '',
	pr_corr_post_code VARCHAR(50) NOT NULL default '',
	pr_phys_addr_line1 VARCHAR(50) NOT NULL default '',
	pr_phys_addr_line2 VARCHAR(50) NOT NULL default '',
	pr_phys_addr_line3 VARCHAR(50) NOT NULL default '',
	pr_phys_city VARCHAR(50) NOT NULL default '',
	pr_phys_country_id VARCHAR(13) NOT NULL default '',
	pr_phys_post_code VARCHAR(50) NOT NULL default '',
	rf_comms_preference_id VARCHAR(13) NOT NULL default '',
	pr_web_addr VARCHAR(50) NOT NULL default '',
	pr_tax_number VARCHAR(20) NOT NULL default '',
	pr_persona_link_id VARCHAR(13) NOT NULL default '',
	pr_persona_fwd_id VARCHAR(13) NOT NULL default ''
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;

DROP TABLE IF EXISTS ai_agent;
CREATE TABLE ai_agent (
	`key` VARCHAR(255) NOT NULL default '',
	pr_agent_comm_deduct_yn TINYINT(1) NOT NULL default 0,
	pr_agent_commission_perc DECIMAL(16,2) NOT NULL default 0,
	pr_agent_account VARCHAR(50) NOT NULL default '',
	ac_pay_plan_id VARCHAR(13) NOT NULL default '',
	pr_agent_show_allocs_ind TINYINT(2) NOT NULL default 0,
	pr_agent_alloc_auto_yn TINYINT(1) NOT NULL default 1,
	pr_agent_alloc_ext_yn TINYINT(1) NOT NULL default 0,
	pr_agent_note_open TEXT NOT NULL default ''
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;

DROP TABLE IF EXISTS ai_phone;
CREATE TABLE ai_phone (
	`key` VARCHAR(255) NOT NULL default '',
	rf_phone_type_id VARCHAR(13) NOT NULL default '',
	pr_phone_number VARCHAR(50) NOT NULL default '',
	pr_phone_detail VARCHAR(50) NOT NULL default '',
	pr_default_yn TINYINT(1) NOT NULL default 0
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;

DROP TABLE IF EXISTS ai_link;
CREATE TABLE ai_link (
	pr_link_from VARCHAR(255) NOT NULL default '',
	pr_link_to VARCHAR(255) NOT NULL default '',
	rf_link_type_id VARCHAR(13) NOT NULL default ''
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;

INSERT INTO ai_persona 
	(`key`,pr_org_yn,pr_name_last)
SELECT DISTINCT
	company,
	'1',
	company
FROM
	ai_csv_contact;

UPDATE
	ai_persona
	LEFT JOIN ai_csv_contact ON ai_csv_contact.company = ai_persona.`key`
		AND ai_csv_contact.first_name = '' AND ai_csv_contact.last_name = ''
	LEFT JOIN rf_country AS corr_country ON corr_country.rf_country_name = ai_csv_contact.postal_country
	LEFT JOIN rf_country AS phys_country ON phys_country.rf_country_name = ai_csv_contact.phys_country
SET
	ai_persona.pr_email = ai_csv_contact.email,
	ai_persona.pr_web_addr = ai_csv_contact.web_addr,
	ai_persona.pr_corr_addr_line1 = ai_csv_contact.postal_1,
	ai_persona.pr_corr_addr_line2 = ai_csv_contact.postal_2,
	ai_persona.pr_corr_addr_line3 = ai_csv_contact.postal_3,
	ai_persona.pr_corr_city = ai_csv_contact.postal_city,
	ai_persona.pr_corr_country_id = corr_country.rf_country_ix,
	ai_persona.pr_corr_post_code = ai_csv_contact.postal_code,
	ai_persona.pr_phys_addr_line1 = ai_csv_contact.phys_1,
	ai_persona.pr_phys_addr_line2 = ai_csv_contact.phys_2,
	ai_persona.pr_phys_addr_line3 = ai_csv_contact.phys_3,
	ai_persona.pr_phys_city = ai_csv_contact.phys_city,
	ai_persona.pr_phys_country_id = phys_country.rf_country_ix,
	ai_persona.pr_phys_post_code = ai_csv_contact.phys_code,
	ai_persona.pr_tax_number = ai_csv_contact.tax_number
;

INSERT INTO ai_agent
	(`key`,pr_agent_commission_perc,pr_agent_comm_deduct_yn,ac_pay_plan_id,pr_agent_note_open)
SELECT DISTINCT
	company,
	commission,
	CASE    
	WHEN  commission_flag = "nett" THEN 1
	WHEN  commission_flag = "gross" THEN 0
	END AS commission_flag,
	CONCAT(ac_pay_plan.ac_pay_plan_db,ac_pay_plan.ac_pay_plan_id),
	agent_note
FROM
	ai_csv_contact
	LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_desc = ai_csv_contact.payment_plan
;

INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
	SELECT DISTINCT
		company,
		'RS1',
		fax,
		NULL,
		0
	FROM
		ai_csv_contact
	WHERE
		TRIM(fax) != ''
		AND ai_csv_contact.first_name = ''
		AND ai_csv_contact.last_name = ''
;

INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
	SELECT DISTINCT
		company,
		'RS3',
		phone,
		NULL,
		1
	FROM
		ai_csv_contact
	WHERE
		TRIM(phone) != ''
		AND ai_csv_contact.first_name = ''
		AND ai_csv_contact.last_name = ''
;

INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
	SELECT DISTINCT
		company,
		'RS4',
		mobile,
		NULL,
		0
	FROM
		ai_csv_contact
	WHERE
		TRIM(mobile) != ''
		AND ai_csv_contact.first_name = ''
		AND ai_csv_contact.last_name = ''
;

INSERT INTO ai_persona
	(`key`,
	pr_org_yn,
	pr_name_last,
	pr_name_first,
	pr_email,
	pr_corr_addr_line1,
	pr_corr_addr_line2,
	pr_corr_addr_line3,
	pr_corr_city,
	pr_corr_country_id,
	pr_corr_post_code,
	pr_phys_addr_line1,
	pr_phys_addr_line2,
	pr_phys_addr_line3,
	pr_phys_city,
	pr_phys_country_id,
	pr_phys_post_code
	)
SELECT
	CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
	'0',
	last_name,
	first_name,
	email,
	postal_1,
	postal_2,
	postal_3,
	postal_city,
	corr_country.rf_country_ix AS corr_country_ix,
	postal_code,
	phys_1,
	phys_2,
	phys_3,
	phys_city,
	phys_country.rf_country_ix AS phys_country_ix,
	phys_code
FROM
	ai_csv_contact
	LEFT JOIN rf_country AS corr_country ON corr_country.rf_country_name = ai_csv_contact.postal_country
	LEFT JOIN rf_country AS phys_country ON phys_country.rf_country_name = ai_csv_contact.phys_country
WHERE
	ai_csv_contact.last_name != '' OR ai_csv_contact.first_name != ''	
;

INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
	SELECT
		CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
		'RS1',
		fax,
		NULL,
		0
	FROM
		ai_csv_contact
	WHERE
		TRIM(fax) != ''
		AND (
			ai_csv_contact.last_name != ''
			OR ai_csv_contact.first_name != ''
		)
;

INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
	SELECT
		CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
		'RS3',
		phone,
		NULL,
		1
	FROM
		ai_csv_contact
	WHERE
		TRIM(phone) != ''
		AND (
			ai_csv_contact.last_name != ''
			OR ai_csv_contact.first_name != ''
		)
;

INSERT INTO ai_phone (`key`, rf_phone_type_id, pr_phone_number, pr_phone_detail, pr_default_yn)
	SELECT
		CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
		'RS4',
		mobile,
		NULL,
		0
	FROM
		ai_csv_contact
	WHERE
		TRIM(mobile) != ''
		AND (
			ai_csv_contact.last_name != ''
			OR ai_csv_contact.first_name != ''
		)
;

INSERT INTO ai_link
	(
		pr_link_from,
		pr_link_to,
		rf_link_type_id
	)
	SELECT
		CONCAT(company,CONCAT('_',CONCAT(last_name,CONCAT('_',first_name)))) as `key`,
		company,
		'RS2'
	FROM
		ai_csv_contact	
	WHERE
		ai_csv_contact.last_name != '' OR ai_csv_contact.first_name != ''			
;

-- }


-- STEP 4: Run the contact import tool (git repo contact_import) {

/*
	The contact import tool, from the contact_import repo
	should be installed in the utils directory of the resrequest code
*/

-- }


-- STEP 5: Import default agent rates {

/*

ALTER TABLE pr_agent_rate DROP INDEX pr_agent_rate_ix;
INSERT INTO pr_agent_rate (
	pr_agent_rate_db,
	pr_agent_rate_default_yn,
	pr_agent_id,
	rt_rate_type_id,
	pr_agent_rate_trf_yn
) SELECT DISTINCT
	'WA',
	'1',
	pr_agent.pr_agent_id,
	rt_rate_type.rt_rate_type_ix,
	'1'
FROM
	ai_csv_contact
	INNER JOIN pr_persona ON TRIM(pr_persona.pr_name_last) = TRIM(ai_csv_contact.company)
	INNER JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
	INNER JOIN rt_rate_type ON TRIM(rt_rate_type.rt_rate_type_desc) = TRIM(ai_csv_contact.rate_type_default);

UPDATE pr_agent_rate SET pr_agent_rate_ix = CONCAT(pr_agent_rate_db,pr_agent_rate_id);
ALTER TABLE pr_agent_rate ADD UNIQUE pr_agent_rate_ix (pr_agent_rate_ix);

*/

-- }


-- STEP 6: Remove staging tables {

/*
DROP TABLE ai_csv_contact;
DROP TABLE ai_persona;
DROP TABLE ai_agent;
DROP TABLE ai_phone;
DROP TABLE ai_link;
*/

-- }

-- TESTS {

/* 
Find agents without contact details
SELECT
	pr_persona.pr_name_last
FROM
	pr_agent
	INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent.pr_agent_id
	LEFT JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
WHERE
	pr_persona.pr_org_yn = 1
	AND pr_phone.pr_phone_number IS NULL
	AND TRIM(pr_persona.pr_email) = ''
	AND TRIM(pr_corr_addr_line1) = ''
	AND TRIM(pr_phys_addr_line1) = ''
*/

-- }
