<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

$versionDir = "../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results

//require_once("config.php");
require_once('functions.php');

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master

require_once(__DIR__ . '/../../db.pr_persona.php');
require_once(__DIR__ . '/../../db.pr_agent.php');
require_once(__DIR__ . '/../../db.pr_link.php');
require_once(__DIR__ . '/../../db.pr_phone.php');
require_once(__DIR__ . '/../../db.rc_obj_sales.php');
require_once(__DIR__ . '/../../db.pr_sales_obj_data.php');

global $other;
global $lDB;
$other = "";
if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'createtables': // Step 1
			createTables();
			step(2);
			break;
		case 'importfile': // Step 2
			importFile();
			step(3);
			break;
		case 'staging': // Step 3
			staging();
			step(4);
			break;
		case 'import': // Step 4
			importData();
			step(5);
			break;
		case 'setdefaultagentrates': // Step 5
			setDefaultAgentRates();
			step(6);
			break;
		case 'cleanup': // Step 6
			cleanup();
			step();
			break;
		default:
			break;
	}
}

step();

if(!isset($_SESSION['contact_import']) || !is_array($_SESSION['contact_import']) || (isset($_POST['action']) && $_POST['action'] == "reset")) {
	if(!isset($_POST['action']) || $_POST['action'] == "reset") {
		$_POST = array();
	}
	$_SESSION['contact_import'] = null;
	$_SESSION['contact_import'] = array(
		'tables'=>array(
			'pr_persona'=>array(
				'name'=>"Contacts (pr_persona)",
				'fields'=>array(
					'key'=>'',
					'pr_persona_ix'=>'',
					'pr_org_yn'=>'',
					'pr_name_last'=>'',
					'pr_name_first'=>'',
					'pr_title_id'=>'',
					'pr_name_suffix_id'=>'',
					'pr_email'=>'',
					'pr_corr_addr_line1'=>'',
					'pr_corr_addr_line2'=>'',
					'pr_corr_addr_line3'=>'',
					'pr_corr_city'=>'',
					'pr_corr_country_id'=>'',
					'pr_corr_post_code'=>'',
					'pr_phys_addr_line1'=>'',
					'pr_phys_addr_line2'=>'',
					'pr_phys_addr_line3'=>'',
					'pr_phys_city'=>'',
					'pr_phys_country_id'=>'',
					'pr_phys_post_code'=>'',
					'rf_comms_preference_id'=>'',
					'pr_web_addr'=>'',
					'pr_statutory_1'=>'',
					'pr_statutory_2'=>'',
					'pr_statutory_3'=>'',
					'pr_persona_link_id'=>'',
					'pr_persona_fwd_id'=>''	
				)
			),
			'pr_agent'=>array(
				'name'=>"Agents (pr_agent)",
				'fields'=>array(
					'key'=>'',
					'pr_agent_comm_deduct_yn'=>'',
					'pr_agent_commission_perc'=>'',
					'pr_agent_account'=>'',
					'ac_pay_plan_id'=>'',
					'pr_agent_show_allocs_ind'=>'',
					'pr_agent_alloc_auto_yn'=>'',
					'pr_agent_alloc_ext_yn'=>'',
					'pr_agent_note_open'=>''
				)
			),
			'pr_phone'=>array(
				'name'=>"Phone numbers (pr_phone)",
				'fields'=>array(
					'key'=>'',
					'rf_phone_type_id'=>'',
					'pr_phone_number'=>'',
					'pr_phone_detail'=>'',
					'pr_default_yn'=>''
				)
			),
			'pr_link'=>array(
				'name'=>"Links (pr_link)",
				'fields'=>array(
					'pr_link_from'=>'',
					'pr_link_to'=>'',
					'rf_link_type_id'=>''
				)
			),
			'pr_sales_obj_data'=>array(
				'name'=>"Sales Profile (pr_sales_obj_data)",
				'fields'=>array(
					'key'=>'',
          'pr_sales_obj_data_text' => '',
          'pr_sales_obj_data_memo' => '',
          'pr_persona_id' => '',
          'rc_obj_sales_data_id' => '',
          'rc_obj_sales_id' => ''
				)
			)
		)
	);
}

$html = getHTML(__DIR__ . "/contact_import.htm");

$t = array();
$t['title'] = "Contact import";
$t['image'] = "arilou.gif";
if(isset($_SESSION['ai_persona_table'])) {
	$t['settings'] = "$_SESSION[ai_persona_table]|$_SESSION[ai_agent_table]";
} else {
	$t['settings'] = "";
}

$tableList = $lDB->get("SHOW TABLES LIKE 'ai_%'",3);

$tables = "";
if (isset($_SESSION['contact_import'])) {
	foreach($_SESSION['contact_import']['tables'] as $tableName=>$tableInfo) {
		$table =& $_SESSION['contact_import']['tables'][$tableName];
		$table['table'] = $tableName;
		if(isset($_POST[$tableName."_table"]) && $_POST[$tableName."_table"] != "") {
			$table['importFrom'] = $_POST[$tableName."_table"];
		}
		$options = "";
		foreach($tableList as $item) {
			$selected = "";
			if(isset($table['importFrom']) && $table['importFrom'] == $item) {
				$selected = "selected";
			}
			$options .= "<option $selected value=\"$item\">$item</option>";
		}
		$table['options'] = $options;
		$table['detail_show'] = "style=\"display:none;\"";
		if(isset($table['importFrom']) && $table['importFrom'] != "" && $_POST['action'] != 'cleanup') {
			$table['detail_show'] = "";
			$fields = $lDB->get("DESC $table[importFrom]",2);
			$details = "";
			if (!empty($fields)) {
				foreach($table['fields'] as $systemField=>$importField) {
					$options = "";
					foreach($fields as $field) {
						$selected = "";
						if($systemField == $field['Field'] && $importField == "") {
							$table['fields'][$systemField] = $field['Field'];
							$selected = "selected";
						}
						if(isset($_POST[$tableName."_".$systemField]) && $_POST[$tableName."_".$systemField] != "") {
							$table['fields'][$systemField] = $_POST[$tableName."_".$systemField];
							$importField = $_POST[$tableName."_".$systemField];
						}
						if($importField == $field['Field']) {
							$selected = "selected";
						}
						$options .= "<option $selected value=\"$field[Field]\">$field[Field]</option>";
					}
					$details .= addTags(array(
						'id'=>$tableName."_".$systemField,
						'name'=>$systemField,
						'options'=>$options
					),$html['field_select']);
				}
			}
			$table['detail_rows'] = $details;
		}

		$tables .= addTags($table,$html['table_select']);
	}
}
$t['tables'] = $tables;

$output = $html['header'] . $other . $html['table_options']. $html['footer'];
$sessionStep = isset($_SESSION['step']) ? $_SESSION['step'] : "";
$output = addTags(array('step'=>$sessionStep),$output);
$output = addTags($t,$output);
$clientName = $lDB->get("
    SELECT
        rf_default.rf_site_title
    FROM
        rf_default
",4);
$clientName = $clientName ? $clientName:"<i>[Client site title not set in defaults]</i>";
$codeVersion = getSystemVersion();
$dbVersion = $lDB->get("
    SELECT
        rf_database.rf_db_version_db
    FROM
        rf_database
    WHERE
        rf_database.rf_db_code = '$dbcode'
",4);
$output = addTags(
  array(
    "clientName" => $clientName,
    "db_code" =>  $dbcode,
    "codeVersion" => $codeVersion,
    "dbVersion" => $dbVersion
  ),
  $output
);
echo $output;
?>
