<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

$content = '';

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

function redirect($url){
	redirectTo("".$url);
}

function template($filename, $tags=[]) {
	return str_replace(
		array_map(function($tag) {
				return "{{ " . $tag . " }}";
			},
			array_keys($tags)
		),
		array_values($tags),
		join("", file(__DIR__ . "/" . $filename . ".html"))
	);
}

function getIssues($fields=false) {
	global $lDB;

	$mode = 2;
	if($fields === false) {
		$fields = ["COUNT(pf_field.pf_field_ix)"];
		$mode = 4;
	}

	return $lDB->get("
		SELECT
			" . join(", ", $fields) . "
		FROM
			pf_object
			INNER JOIN pf_option ON pf_option.pf_object_id = pf_object.pf_object_ix
			INNER JOIN pf_field ON pf_field.pf_option_id = pf_option.pf_option_ix
		WHERE
			pf_object.pf_object_name = 'financial_analysis_day'
			AND pf_field.pf_field_name = 'grouping'
			AND (
				pf_field.pf_field_contents LIKE '%fn_folio.fn_folio_date_year%'
				OR pf_field.pf_field_contents LIKE '%fn_folio.fn_folio_date_month%'
			)
	",$mode);
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master

if(array_key_exists('image', $_GET)) {
	$image = __DIR__ . "/" . preg_replace("/[^[:alnum:].\-_]/","",$_GET['image']);
	if(
		file_exists($image)
		&& in_array(strtolower(pathinfo($image, PATHINFO_EXTENSION)), [
			"gif",
			"png",
			"jpg",
			"jpeg"
		])
	) {
		header('Content-Type: ' . mime_content_type($image));
		header('Content-Length: ' . filesize($image));
		readfile($image);
	} else {
		http_response_code(404);
	}
	die();
}

echo template("header");

if(!array_key_exists("action",$_POST) || empty($_POST['action'])) {
	$issues = getIssues();
	$hasIssue = $issues > 0;
	echo template("setup",[
		'occurrences'=>$issues,
		'fixit'=>($hasIssue ? template("fixit") : template("nofix"))
	]);
} elseif($_POST['action'] == "fix") {
	$issues = getIssues([
		"pf_field.pf_field_ix",
		"pf_field.pf_field_contents"
	]);
	foreach($issues as $issue) {
		$groups = unserialize($issue['pf_field_contents']);
		$newGroups = [];
		foreach($groups as $key=>$item) {
			if($key == "fn_folio.fn_folio_date_year") {
				$key = "rv_reservation.rv_date_year";
				$item['name'] = "rv_reservation.rv_date_year";
			}
			if($key == "fn_folio.fn_folio_date_month") {
				$key = "rv_reservation.rv_date_month";
				$item['name'] = "rv_reservation.rv_date_month";
			}

			$newGroups[$key] = $item;
		}

		$lDB->put("
			UPDATE
				pf_field
			SET
				pf_field_contents = '" . $lDB->escape(serialize($newGroups)) . "'
			WHERE
				pf_field.pf_field_ix = '" . $lDB->escape($issue['pf_field_ix']) . "'
		");
	}
	echo template("fixed",[
		'occurrences'=>sizeof($issues)
	]);
} else {
	echo template("error");
}



echo template("footer");

