$(document).ready(function() {
	$("#firstInvoiceResult").empty();
	$("#secondInvoiceResult").empty();
});

function fetchInvoice(invoice_id, position) {
	$("#spinner").show();
	let invoiceDiv = "";
	switch (position) {
		case 1:
			invoiceDiv = "#firstInvoiceResult";
			break;
		case 2:
			invoiceDiv = "#secondInvoiceResult";
			break;
		default:
			invoiceDiv = "#firstInvoiceResult, #secondInvoiceResult"
			break;
	}
	$(invoiceDiv).empty();

	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "fetchInvoice",
			invoice: invoice_id
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		result = JSON.parse(result);

		var formattedResult = JSON.stringify(result, null, 2).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
		if (formattedResult == 'null') {formattedResult = "No invoice found";}
		$(invoiceDiv).append("<pre>" + formattedResult + "</pre>");

	});
}

function getInvoiceDetails(invoice_id) {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceQuery",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val(),
			invoice: invoice_id
		}
	})
	.done(function(result) {
		return JSON.parse(result);
	});
}

