<?php
	if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
		header('Location: /utils/');
		exit;
	}
	
	// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
	require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../class.fiscalator.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../functions.system.php");
	require_once(__DIR__ . "/../../functions.php");
	require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
	require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
	require_once(__DIR__ . "/../../db.rv_reservation.php");
	require_once(__DIR__ . "/../../db.rv_reservation_item.php");
	require_once(__DIR__ . "/../../db.rv_extra.php");
	require_once(__DIR__ . "/../../db.fn_folio.php");
	require_once(__DIR__ . "/../../db.rv_res_item_group.php");
	require_once(__DIR__ . "/../../db.rv_payment.php");
	require_once(__DIR__ . "/../../db.rv_payment_item.php");
	require_once(__DIR__ . "/../../functions.reservation.php");
	require_once(__DIR__ . "/../../functions.financial.php");
	require_once(__DIR__ . "/../../functions.rates.php");
	require_once(__DIR__ . "/../../db.tc_sequence.php");

	include("header.php");
?>

		<div id="mainContainer" class="uk-container">
			<div class="uk-margin-small-top uk-grid" id="invoiceContainer">
				<div id='invoice1' class="uk-width-1-2">
					<div>First Invoice Number:</div>
					<div class="uk-flex uk-flex-space-between">
						<input type="text" id="firstInvoiceNumber" class="uk-input uk-margin-small-right"></input>
						<input
							type="button"
							class="uk-button uk-button-rounded"
							id="btnInvoiceSubmitted"
							value="Search"
							onclick="fetchInvoice($('#firstInvoiceNumber').val(), 1);">
						</input>
					</div>
					<div id="firstInvoiceResult"></div>
				</div>
				<div id='invoice2' class="uk-width-1-2">
					<div>Second Invoice Number:</div>
					<div class="uk-flex uk-flex-space-between">
						<input type="text" id="secondInvoiceNumber" class="uk-input uk-margin-small-right"></input>
						<input
							type="button"
							class="uk-button uk-button-rounded"
							id="btnInvoiceSubmitted"
							value="Search"
							onclick="fetchInvoice($('#secondInvoiceNumber').val(), 2);">
						</input>
					</div>
					<div id="secondInvoiceResult"></div>
				</div>
			</div>

			<div id="spinner" uk-spinner></div>
		</div>

	</body>
</html>
