<?php

// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
require_once(__DIR__ . "/../../functions.system.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
require_once(__DIR__ . "/../../db.rv_reservation.php");
require_once(__DIR__ . "/../../db.rv_reservation_item.php");
require_once(__DIR__ . "/../../db.rv_extra.php");
require_once(__DIR__ . "/../../db.fn_folio.php");
require_once(__DIR__ . "/../../db.rv_res_item_group.php");
require_once(__DIR__ . "/../../db.rv_payment.php");
require_once(__DIR__ . "/../../db.rv_payment_item.php");
require_once(__DIR__ . "/../../functions.reservation.php");
require_once(__DIR__ . "/../../functions.financial.php");
require_once(__DIR__ . "/../../functions.rates.php");
require_once(__DIR__ . "/../../db.tc_sequence.php");
require_once(__DIR__ . "/../../class.fiscalator.php");

if (!is_dir($GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/fiscal_invoice_fix")) {
    mkdir($GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/fiscal_invoice_fix", 0777, true);
}

if (isset($_POST) && isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'invoiceUnitList':
            echo invoiceUnitList();
            break;
        case 'invoiceAnalysis':
            echo invoiceAnalysis($_POST['invUnitId']);
            break;
        case 'invoiceList':
            echo invoiceList($_POST['invUnitId'], $_POST['invoicePrefix']);
            break;
        case 'invoiceQuery':
            echo invoiceQuery($_POST['fiscalatorKey'], $_POST['invoice']);
            break;
        case 'reverseFiscalInvoice':
            echo reverseFiscalInvoice($_POST['fiscalatorKey'], $_POST['invoiceId'], $_POST['originalInvoiceId'], $_POST['type'], $_POST['postData'], $_POST['zfpUrl'], $_POST['ipAddress']);
            break;
        case 'fixFalseZeroInvoices':
            echo fixFalseZeroInvoices($_POST['invoiceListArray']);
            break;
        default:
            echo 'No action specified';
            break;
    }
}

function invoiceUnitList() {
    global $lDB;

    $invoicingUnits = $lDB->get("
        SELECT
            TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as name,
            pr_business.fiscalator_key as fiscalatorKey,
            pr_business.pr_business_id as invUnitId
        FROM
            pr_business
            LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
        WHERE
            pr_business.fiscalator_key != ''
            AND pr_business.fiscalator_key IS NOT NULL
    ", 2);

    return json_encode($invoicingUnits);
}

function invoiceAnalysis($invUnitId) {
    global $lDB;

    return json_encode($lDB->get("
        SELECT
            fn_invoice.pr_business_id,
            LEFT(fs_invoice.fn_invoice_doc,9) as 'Fiscal_prefix',
            COUNT(left(fs_invoice.fn_invoice_doc,9)) as Invoices
        FROM
            fs_invoice
            left join fn_invoice on fn_invoice.fn_invoice_ix = fs_invoice.fn_invoice_id
            left join pr_business on pr_business.pr_business_id = fn_invoice.pr_business_id
        WHERE
            fs_invoice.fn_invoice_doc != ''
            AND
            fs_invoice.fn_invoice_doc not like '%,%'
            AND
            fn_invoice.pr_business_id = '" . $invUnitId . "'
        GROUP BY
            fn_invoice.pr_business_id,
            left(fs_invoice.fn_invoice_doc,9)
        ORDER BY
            fn_invoice.pr_business_id,
            Invoices DESC,
            left(fs_invoice.fn_invoice_doc,9)
    ",2));
}

function invoiceList($invUnitId, $invoicePrefix) {
    global $lDB;

    return json_encode($lDB->get("
        SELECT
            fs_invoice.fn_invoice_id AS Invoice,
            fs_invoice.fn_invoice_doc AS Fiscal_Doc,
            fs_invoice.fs_data AS Fiscal_Data,
            fs_invoice.fs_time_created AS Created,
            fs_invoice.fs_time_changed AS Changed
        FROM
            fs_invoice
            left join fn_invoice on fn_invoice.fn_invoice_ix = fs_invoice.fn_invoice_id
            left join pr_business on pr_business.pr_business_id = fn_invoice.pr_business_id
        WHERE
            fs_invoice.fn_invoice_doc != ''
            AND
            fs_invoice.fn_invoice_doc not like '%,%'
            AND
            fn_invoice.pr_business_id = '" . $invUnitId . "'
            AND
            left(fs_invoice.fn_invoice_doc,9) = '" . $invoicePrefix . "'
        ORDER BY
            fs_invoice.fn_invoice_id, left(fs_invoice.fn_invoice_doc,9)  DESC
    ",2));
}

function invoiceQuery($fiscalatorKey, $invoice) {
    $fiscalator = new Fiscalator();
    return $fiscalator->fiscalatorApiCall($fiscalatorKey, "GET", "invoicequery/" . $invoice);
}

function taxPercentageLookup($fiscalatorKey, $tenantCode) {
    $fiscalator = new Fiscalator();
    return $fiscalator->fiscalatorApiCall($fiscalatorKey, "POST", "taxpercentagelookup/" . $tenantCode, true);
}

function mappingQuery($fiscalatorKey, $type, $tenantCode) {
    $fiscalator = new Fiscalator();
    return $fiscalator->fiscalatorApiCall($fiscalatorKey, "POST", "mappingquery/" . $type . "/" . $tenantCode, true);
}

function reverseFiscalInvoice($fiscalatorKey, $invoiceId, $originalInvoiceId, $type, $postData, $zfpUrl, $ipAddress) 
{

    $invoice = json_decode($postData, true);
    $inventories = array();
    foreach ($invoice['items'] as $key => $item) {
        if (floatval($item['unit_nett_amount']) == 0) {
            continue 1;     // Exit item iteration
        }
        $taxCode = isset($item['tax_code']) && !empty($item['tax_code']) ? mappingQuery($fiscalatorKey, 'taxrate', $item['tax_code']) : "";
        if ($taxCode == "99") {     // Not VAT related
            continue 1;     // Exit item iteration
        }
        if (empty($taxCode)) {
            return array(
                    "response_message" => 'Tax rate is not mapped: ' . $item['tax_code'],
                    "invoiceId" => $invoice['invoice_id']
            );
        }

        $HsCode = "";
        if ($taxCode != "A") {      // Not standard 16%, we require a mapped HS code
            $HsCode = mappingQuery($fiscalatorKey, 'commodity', $item['product_code']);
            if (empty($HsCode)) {
                return array(
                    array(
                        "response_message" => 'Item code mapping error: ' . $item['product_code'],
                        "invoiceId" => $invoice['invoice_id'],
                        "invoiceType" => '1'
                    )
                );
            }
        }

        /* Convert amounts into GL currency
        * Rounding:
        * TIMS amounts use 2 decimal places and apply the following rounding rules, which we need to emulate:
        * The 4th decimal is dropped (not taken into account)
        * The 3rd decimal is rounded to 0 if it is 0-5 inclusive / to 1 if it is 6-9
        * Example:
        * 1.4569 → 1.46 (9 dropped, 6 rounds 2nd decimal +1)
        * 1.4557 → 1.45 (7 dropped, 5 adds 0 to 2nd decimal
        */
        if ($invoice['invoice_currency'] != $invoice['gl_currency']) {
            $item['unit_nett_amount'] = number_format(round(number_format($item['unit_nett_amount'], 3, '.', ''), 2, PHP_ROUND_HALF_DOWN), 2, '.', '') * $invoice['fn_inv_exch_rate'];
        }

        $taxRate = taxPercentageLookup($fiscalatorKey, $taxCode);
        $price = number_format(round(number_format($item['unit_nett_amount'], 3, '.', ''), 2, PHP_ROUND_HALF_DOWN), 2, '.', '');
        $priceInclusive = $price * (1+($taxRate/100));
        // Build up API commands for inventories
        $inventories[] =array(
            "NamePLU=\"" . substr(str_replace(str_split('",()'), '', $item['name']),0,28) . "\"",
            "OptionVATClass=" . $taxCode,
            "Price=" . strval(number_format(round($priceInclusive,2),2,'.','')),
            "MeasureUnit=",
            "HSCode=" . $HsCode,
            "HSName=",
            "VATGrRate=" . $taxRate,
            "Quantity=" . $item['qty'],
            "DiscAddP="
        );
    }

    $buyerTin = isset($invoice['buyerTin']) && !empty($invoice['buyerTin']) ? $invoice['buyerTin'] : "";

    $invoiceDetails = array(
        "CompanyName=\"" . str_replace(str_split('",()'), '', $invoice['invoice_from']) . "\"",
        "ClientPINnum=" . $buyerTin,
        "HeadQuarters=",
        "Address=\"" . str_replace(str_split('",()'), '', $invoice['address']) . "\"",
        "PostalCodeAndCity=",
        "ExemptionNum=",
        "RelatedInvoiceNum=\"" . $originalInvoiceId . "\"",
        "TraderSystemInvNum=\"" . $invoice['invoice_id'] . "CN\""
    );

    writeToFile(" ");
    writeToFile(date('Y-m-d H:i:s', time()));
    writeToFile("Selected Invoice: " . $invoiceId . " - " . $originalInvoiceId);
    writeToFile(" ");
    writeToFile("========== Settings ==========");
    $apiResult = apiCallTremol(
        "GET",
        "Settings(tcp=1,ip=" . $ipAddress . ",port=8000,password=Password)",
        "",
        $zfpUrl
    );
    $apiData = processCallResults("Settings", $apiResult);
    if (!empty($apiData->error)) {
        if (isset($apiData->error['code']) && isset($apiData->error['message'])) {
            echo "Error: " . $apiData->error['code'] . ": - " . $apiData->error['message'];
        }
        else {
            echo "Error: " . print_r($apiData->error,true);
        }
        die();
    }

    writeToFile(" ");
    writeToFile("========== ReadStatus ==========");
    $apiResult = apiCallTremol(
        "GET",
        "ReadStatus",
        "",
        $zfpUrl
    );
    $apiData = processCallResults("ReadStatus", $apiResult);
    if (!empty($apiData->error)) {
        echo "Error: " . $apiData->error['code'] . ": - " . $apiData->error['message'];
        die();
    }

    $transactionType = strtolower($type) == 'invoice' ? 'OpenCreditNoteWithFreeCustomerData' : 'OpenDebitNoteWithFreeCustomerData';
    writeToFile(" ");
    writeToFile("========== " .  $transactionType . " ==========");
    $apiResult = apiCallTremol(
        "GET",
        $transactionType,
        join(",", $invoiceDetails),
        $zfpUrl
    );
    $apiData = processCallResults($transactionType, $apiResult);
    if (!empty($apiData->error)) {
        print_r($apiData->error);
        echo "Error: " . $apiData->error['code'] . " - " . $apiData->error['message'];
        die();
    }

    foreach ($inventories as $inventory) {
        $apiResult = apiCallTremol(
            "GET",
            "SellPLUfromExtDB",
            join(",", $inventory),
            $zfpUrl
        );
        $apiData = processCallResults("SellPLUfromExtDB", $apiResult);
        if (!empty($apiData->error)) {
            echo "Error: " . $apiData->error['code'] . " - " . $apiData->error['message'];
            $apiCancel = apiCallTremol("GET", "CancelReceipt", "", $zfpUrl);
            processCallResults("CancelReceipt", $apiCancel);
            die();
        }
    }

    $apiResult = apiCallTremol(
        "GET",
        "ReadVATrates",
        "",
        $zfpUrl
    );
    $apiData = processCallResults("ReadVATrates", $apiResult);
    if (!empty($apiData->error)) {
        echo "Error: " . $apiData->error['code'] . " - " . $apiData->error['message'];
        $apiCancel = apiCallTremol("GET", "CancelReceipt", "", $zfpUrl);
        processCallResults("CancelReceipt", $apiCancel);
        die();
    }

    $apiResult = apiCallTremol(
        "GET",
        "ReadCurrentReceiptInfo",
        "",
        $zfpUrl
    );
    $apiData = processCallResults("ReadCurrentReceiptInfo", $apiResult);
    if (!empty($apiData->error)) {
        print_r($apiData->error);
        echo "Error: " . $apiData->error['code'] . " - " . $apiData->error['message'];
        $apiCancel = apiCallTremol("GET", "CancelReceipt", "", $zfpUrl);
        processCallResults("CancelReceipt", $apiCancel);
        die();
    }

    $apiResult = apiCallTremol(
        "GET",
        "CloseReceipt",
        "",
        $zfpUrl
    );
    $apiData = processCallResults("CloseReceipt", $apiResult);
    if (!empty($apiData->error)) {
        echo "CloseReceipt Error: " . $apiData->error['code'] . " - " . $apiData->error['message'];
        die();
    }

    $apiSerialResult = apiCallTremol(
        "GET",
        "ReadCUnumbers()",
        "",
        $zfpUrl
    );
    $apiSerialData = processCallResults("ReadCUnumbers", $apiSerialResult);
    if (!empty($apiSerialData->error)) {
        echo "ReadCUnumbers Error: " . $apiSerialData->error['code'] . " - " . $apiSerialData->error['message'];
        die();
    }
    
    $apiTimeStampResult = apiCallTremol(
        "GET",
        "ReadDateTime()",
        "",
        $zfpUrl
    );
    $apiTimestampData = processCallResults("ReadDateTime", $apiTimeStampResult);
    if (!empty($apiTimestampData->error)) {
        echo "ReadDateTime Error: " . $apiTimestampData->error['code'] . " - " . $apiTimestampData->error['message'];
        die();
    }
                
    if (updateInvoiceFiscalRecords($invoiceId)) {
        return "Completed successfully.";
    }
    else {
        return "Error: Unable to update invoice fiscal records";
    }
    
}

function updateInvoiceFiscalRecords($invoiceId) {
    global $lDB;
    if (empty($invoiceId)) {
        return;
    }
    if (!is_array($invoiceId)) {
        $invoiceId = array($invoiceId);
    }

    foreach($invoiceId as $invoice) {
        $fn_invoice = false;
        $fs_invoice = false;
        $fn_invoice = $lDB->put("
            UPDATE
                fn_invoice
            SET
                fn_invoice.fn_inv_fiscal_status_ind = '4'
            WHERE
                fn_invoice.fn_invoice_ix = '" . $invoice . "'
        ");
        $fs_invoice = $lDB->put("
            UPDATE
                fs_invoice
            SET
                fn_invoice_doc = '',
                fs_data = '{\"status\":false,\"statusDesc\":\"Error\"}'
            WHERE
                fs_invoice.fn_invoice_id = '" . $invoice . "'
        ");
    }
    return $fn_invoice && $fs_invoice;
}

function fixFalseZeroInvoices($invoiceIdArray) {

    global $lDB;

    $invoiceIdArray = json_decode($invoiceIdArray);
    if (empty($invoiceIdArray)) {
        echo "No invoices to fix";
        return;
    }
    $fixedArray = [];
    foreach ($invoiceIdArray as $invoiceId) {
        $lDB->put("
            UPDATE
                fn_invoice
            SET
                fn_invoice.fn_inv_fiscal_status_ind = '4'
            WHERE
                fn_invoice.fn_invoice_ix = '" . $invoiceId . "'
        ");
        
        $lDB->put("
            UPDATE
                fs_invoice
            SET
                fn_invoice_doc = '',
                fs_data = '{\"status\":false,\"statusDesc\":\"Error\"}'
            WHERE
                fs_invoice.fn_invoice_id = '" . $invoiceId . "'
        ");
        array_push($fixedArray, $invoiceId);
        writeToFile("Fixed invoice: " . $invoiceId);
    }
    echo json_encode($fixedArray);
    die();
}

function apiCallTremol($method, $endPoint, $data="", $zfpUrl="")
{
    $result = (object) array(
        "result" => "",
        "error" => ""
    );
    if (is_array($data)) {
        $result->error = "Bad request. Data not a string";
        return $result;
    }
    if (!empty($data)) {
        $data = "(" . $data . ")";
    }
    $apiURL = $zfpUrl ?? "http://167.99.85.94:4444"; // Current hard coded ZFP lab server
    $fullUrl = removeSlashes($apiURL) . "/" . removeSlashes($endPoint) . $data;
    $fullUrl = str_replace(" ", "%20", $fullUrl);

    writeToFile("========== apiCallTremol() Start ========== : " . date('Y-m-d H:i:s', time()));
    writeToFile($method);
    writeToFile($fullUrl);

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $fullUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_USERAGENT      => 'Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0',
        CURLOPT_POST           => false,
        CURLOPT_HEADER         => false,    // don't return headers
        CURLOPT_AUTOREFERER    => true,     // set referer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
        CURLOPT_TIMEOUT        => 120,      // timeout on response
        CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
        CURLOPT_SSL_VERIFYPEER => false,     // Disable to allow self signed certificates
        CURLOPT_SSL_VERIFYHOST => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $result->result = curl_exec($curl);

    writeToFile("========== Call result: result->result: ==========");
    writeToFile($result->result);
    if (curl_errno($curl)) {
        $result->error = curl_error($curl);
        writeToFile("========== curl error: ==========");
        writeToFile($result->error);
    }
    curl_close($curl);

    writeToFile("========== apiCallTremol() End ===== " . date('Y-m-d H:i:s', time()));
    return $result;
}

function removeSlashes($string)
{
    if (substr($string, 0, 1) == "/") {
        $string = substr($string, 1);
    }
    if (substr($string, -1) == "/") {
        $string = substr($string, 0, (strlen($string)-1));
    }
    return $string;
}

function xmlToArray($xml, $array=true)
{
    // $array=false to convert to object instead
    return json_decode(
        json_encode(
            simplexml_load_string(
                $xml
            )
        ),
        $array
    );
}

function processCallResults($call, $apiResult) {

    writeToFile($call);
    if ($apiResult->result && simplexml_load_string($apiResult->result)) {
        $apiData = new SimpleXMLElement($apiResult->result);
    }
    else {
        $apiData = $apiResult->result;
        writeToFile(print_r($apiData));
}
    $code = isset($apiData['Code']) ? (string) $apiData['Code'] : "";
    writeToFile("Code: " . $code);
    if ((!empty($code) && $code != "0") || isset($apiData->Err->Message)) {
        $apiResult->error['code'] = $code;
        $apiResult->error['message'] = $apiData->Err->Message;
        writeToFile($apiData->Err);
        writeToFile($apiData->Err->Message);
        writeToFile("processCallResults() ===== Ends with error ==========");
    }
    if (strtolower($call) == "cancelreceipt") {
        writeToFile($apiResult->result);
        writeToFile("processCallResults() ===== Ends with cancelReceipt ==========");
    }
    writeToFile("processCallResults() ===== Ends ==========");
    return $apiResult;
}

function writeToFile($data)
{
	$logFileName = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/fiscal_invoice_fix/" . date("Y-m-d") . ".log";
    if (!is_file($logFileName)) {
        $logFile = fopen($logFileName, "w") or die("Unable to open log file!");
        fwrite($logFile, date("Y-m-d H:i:s"));
        fwrite($logFile, "\n\n");
        fclose($logFile);
    }
	$logFile = fopen($logFileName, "a") or die("Unable to open log file!");
	fwrite($logFile, $data);
	fwrite($logFile, "\n");
	fclose($logFile);
}