let fiscalatorKey = '';
let ipAddress = '';
let fiscalPrefix = '';
let postData = {};
let selectedPostData = {};
let invoiceListArray = [];
let fixedInvoices = [];
const invoiceIpList = {
	"000000000": {
	  "merchant": "Error",
	  "ip_address": "N/A",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011039413": {
	  "merchant": "Bushtops",
	  "ip_address": "41.215.128.251",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011039863": {
	  "merchant": "Angama",
	  "ip_address": "41.215.74.106",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011040009": {
	  "merchant": "Finch Hattons",
	  "ip_address": "41.90.233.130",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011060396": {
	  "merchant": "SOPA",
	  "ip_address": "197.254.28.227",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011060383": {
	  "merchant": "Elewana: Tortilis",
	  "ip_address": "197.254.28.226",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011060385": {
	  "merchant": "Elewana: Sand River",
	  "ip_address": "197.254.28.230",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011060393": {
	  "merchant": "Elewana: Lewa",
	  "ip_address": "197.254.28.228",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"011060388": {
	  "merchant": "Elewana: Elephant Pepper",
	  "ip_address": "197.254.28.229",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"008011076": {
	  "merchant": "Test System 1",
	  "ip_address": "196.207.19.134",
	  "ZFP_url": "http://167.99.85.94:4444"
	},
	"008010096": {
	  "merchant": "Test System 2",
	  "ip_address": "196.207.19.133",
	  "ZFP_url": "http://167.99.85.94:4444"
	}
};
$(document).ready(function() {
	$("#spinner2").hide();
	invoiceUnitList();
	$('#invoiceDetailsContainer').hide();
	$("#invoiceUnitList").select2({
		placeholder: "Select invoicing unit"
	});
});

function invoiceUnitList() {
	$("#invoiceUnitList").empty();
	$("#invoiceContainer").hide();
	$("#spinner2").hide();
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceUnitList"
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		result = JSON.parse(result);

		$("#invoiceUnitList").append(`<option></option>`);
		$.each( result, function( index, unit ) {
			$("#invoiceUnitList").append(`
				<option value='` + unit.invUnitId + `' data-fiscalatorKey='` + unit.fiscalatorKey + `'>` + unit.name + `</option>
			`);
		});
	});
}

function invoiceAnalysis() {
	$("#spinner2").hide();
	$("#spinner").show();
	$("#invoiceContainer").hide();
	$('#invoiceAnalysisContainer').empty();
	$('#invoiceAnalysisContainer').hide();
	$("#invoiceList").empty();
	$("#invoiceDetails").empty();
	$('#invoiceDetailsContainer').hide();
	$("#invoiceDetails").hide();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceAnalysis",
			invUnitId: $("#invoiceUnitList").find(":selected").val(),
			fiscalatorKey: $("#invoiceUnitList :selected").data("fiscalatorkey")
		}
	})
	.done(function(result) {
		result = JSON.parse(result);
		let analysisDisplay = '<table id="tblInvoiceList" class="uk-table uk-table-hover uk-padding-remove uk-margin-remove">';
		analysisDisplay += '<tr style="background-color: #eeeeee;"><th class="uk-padding-remove-horizontal">Fiscal prefix</th><th>IU</th><th class="uk-padding-remove-horizontal">count</th><th></th></tr>';
		$.each( result, function( index, analysis ) {
			let InvPrefix = analysis.Fiscal_prefix;
			let merchant = typeof invoiceIpList[InvPrefix] !== 'undefined' ? invoiceIpList[InvPrefix].merchant : 'Error';
			analysisDisplay += '<tr><td style="cursor: pointer;" onclick="invoiceList(\''+ analysis.pr_business_id + '\',\'' + analysis.Fiscal_prefix.trim() +'\');">' + analysis.Fiscal_prefix + '</td>';
			analysisDisplay += '<td style="cursor: pointer;" onclick="invoiceList(\''+ analysis.pr_business_id + '\',\'' + analysis.Fiscal_prefix.trim() +'\');">' + merchant + '</td>';
			analysisDisplay += '<td style="cursor: pointer;" onclick="invoiceList(\''+ analysis.pr_business_id + '\',\'' + analysis.Fiscal_prefix.trim() +'\');">' + analysis.Invoices + '</td>';
			analysisDisplay += '<td style="cursor: pointer;" onclick="invoiceList(\''+ analysis.pr_business_id + '\',\'' + analysis.Fiscal_prefix.trim() +'\');"><button >View</button></td></tr>';	
		});
		analysisDisplay += '</table>';
		$("#spinner").hide();
		$('#invoiceAnalysisContainer').show();
		$('#invoiceAnalysisContainer').html(analysisDisplay);
	});
}

function invoiceList(invUnitId, Fiscal_prefix) {
	invoiceListArray = [];
	$("#spinner").show();
	$("#spinner2").hide();
	$("#invoiceContainer").hide();
	$("#invoiceContainer").empty();
	$("#invoiceList").empty();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceList",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").data('fiscalatorKey'),
			invUnitId: invUnitId,
			invoicePrefix: Fiscal_prefix
		}
	})
	.done(function(result) {
		result = JSON.parse(result);
		$("#spinner").hide();
		$("#invoiceContainer").show();
		let fixButton = Fiscal_prefix !== "000000000" ? "" : `&nbsp;<button class="uk-button-small uk-float-right" onclick="fixFalseZeroInvoices();">Fix</button>`;
		$("#invoiceList").show();
		let invoiceList = `<table class="uk-table-hover uk-width-1-1" id='tblInvoiceList'><tr><th>Invoice</th><th>Fiscal</th><th>Created</th></tr>`;
		$.each( result, function( index, invoice ) {
			invoiceList+= `<tr onclick="fetchInvoice(event,'`+invoice.Invoice+`', '` + invoice.Fiscal_Doc + `', '` + Fiscal_prefix + `')">
				<td class='uk-padding-small uk-padding-horizontal-remove' style='cursor: pointer;'>`+invoice.Invoice+`</td>
				<td class='uk-padding-small uk-padding-horizontal-remove' style='cursor: pointer;'>`+invoice.Fiscal_Doc+`</td>
				<td class='uk-padding-small uk-padding-horizontal-remove' style='cursor: pointer;'>`+invoice.Created+`</td>
				</tr>`;
				invoiceListArray.push(invoice.Invoice);
		});
		invoiceList += `</table>`;
		$("#invoiceDetails").empty();
		$("#invoiceDetails").hide();
		$("#invoiceList").html(invoiceList);
		$("#invoiceContainer").prepend(`
			Invoice Unit: ` + invoiceIpList[Fiscal_prefix].merchant + `<br>
			Fiscal prefix: ` + Fiscal_prefix + fixButton + `<br>
		`);
		if (!fixButton) {
			$("#invoiceContainer").append(`
				ZFP url: <input id='ZFP_labs_url' title='Only change if the ZFP server is different.' value='` + invoiceIpList[Fiscal_prefix].ZFP_url + `'><br>
			`);
		}
		$("#invoiceContainer").append(`
			Device ip address: <input id='device_ip_address' title='Only change if the device ip address is different.' value='` + invoiceIpList[Fiscal_prefix].ip_address + `'><br>
		`);
	});
}

function fetchInvoice(e, invoice_id, fiscal_doc, Fiscal_prefix) {
	$("#spinner2").show();
	$(e.target).closest('tr').css('font-weight', 'bold');
	$("table#invoiceDetails").empty();
	$("#invoiceDetailsContainer").empty();
	$("#invoiceDetailsContainer").hide();

	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceQuery",
			fiscalatorKey: $("#invoiceUnitList :selected").data("fiscalatorkey"),
			invoice: invoice_id
		}
	})
	.done(function(result) {
		$("#spinner2").hide();
		$("table#invoiceDetails").show();
		result = JSON.parse(result);
		$.each( result.transaction, function( index, transaction ) {
			let type = "";
			switch (transaction.type) {
				case 1:
					type = "Invoice";
					break;
				case 2:
					type = "Credit";
					break;
			}

			let status = '';
			switch (transaction.processing_status) {
				case 0:
					status = 'Not processed';
					break;
				case 1:
					status = 'Completed';
					break;
				case 2:
					status = 'Retrying';
					break;
				case 3:
					status = 'Failed';
					break;
			}

			if (typeof transaction.response_data == "object") {
				JSON.stringify(JSON.parse(transaction.response_data))
			}
			else {
				transaction.response_data.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
			}
			if (typeof transaction.post_data == "object") {
				postData = JSON.stringify(JSON.parse(transaction.post_data))
			}
			else {
				postData = transaction.post_data.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
			}
			tableAppend("invoiceDetails", "<strong>Transaction " + index + "</strong>", "");
			tableAppend("invoiceDetails", "Invoice ID", transaction.invoice_id);
			tableAppend("invoiceDetails", "Type", type);
			tableAppend("invoiceDetails", "Processing status", status);
			tableAppend("invoiceDetails", "ZFP", $("#ZFP_labs_url").val());
			tableAppend("invoiceDetails", "IP", $("#device_ip_address").val());
			tableAppend("invoiceDetails", "Action", "<button id='btnInvReverse' onclick='fixFiscalInvoice(\""+transaction.invoice_id+"\", \"" + fiscal_doc + "\", \"" + Fiscal_prefix + "\", \"" + type + "\");'>Fix " + transaction.invoice_id + " : " + fiscal_doc + "</button>");
			tableAppend("invoiceDetails", "Post data", "<pre>" + JSON.stringify(JSON.parse(transaction.post_data), undefined, 2) + "</pre>");
			tableAppend("invoiceDetails", "&nbsp;", "");
		});
		tableAppend("invoiceDetails", "&nbsp;", "");	
	});
}

function getInvoiceDetails(invoice_id) {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceQuery",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val(),
			invoice: invoice_id
		}
	})
	.done(function(result) {
		return JSON.parse(result);
	});
}

function fixFiscalInvoice(invoiceId, originalInvoiceId, Fiscal_prefix, type) {
	if (originalInvoiceId === "0000000000000000000" || originalInvoiceId == 0) {
		fixFalseZeroInvoices(invoiceId, Fiscal_prefix);
	}
	else {
		reverseFiscalInvoice(invoiceId, originalInvoiceId, Fiscal_prefix, type);
	}
}

function reverseFiscalInvoice(invoiceId, originalInvoiceId, Fiscal_prefix, type) {
	if (!confirm("This will reverse invoice " + invoiceId + ".\n\nAre you sure?")) {
		return false;
	}
	$("#spinner2").show();
	let resultSpan = " ";
	let resultColour = "#666666";
	let zfpUrl = $("#ZFP_labs_url").val() ?? invoiceIpList[Fiscal_prefix].ZFP_url;
	let deviceIpAddress = $("#device_ip_address").val() ?? invoiceIpList[Fiscal_prefix].ZFP_url;
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "reverseFiscalInvoice",
			fiscalatorKey: $("#invoiceUnitList :selected").data("fiscalatorkey"),
			invoiceId: invoiceId,
			originalInvoiceId: originalInvoiceId,
			type: type,
			postData: postData,
			zfpUrl: zfpUrl,
			ipAddress: deviceIpAddress
		}
	})
	.done(function(result) {
		$("#spinner2").hide();
		$('#btnInvReverse').prop('disabled', 'disabled');
		$("#invoiceDetailsContainer").empty();
		$("#invoiceDetailsContainer").show();
		if (result.indexOf("rror") !== -1) {
			$("#invoiceDetailsContainer").html("There was an error<br>");
			$("#invoiceDetailsContainer").append(result);
			$("#invoiceDetailsContainer").append("<br>Please select the invoice again to retry.");
			resultSpan = " <span style='color: white; background-color: red;'>&nbsp;&nbsp;Error&nbsp;&nbsp;</span>";
			resultColour = "red";
		}
		else {
			$("#invoiceDetailsContainer").text(`Fixed:`);
			$("#invoiceDetailsContainer").append().text(result);
			resultSpan = " <span style='color: white; background-color: green;'>&nbsp;&nbsp;Fixed&nbsp;&nbsp;</span>";
			resultColour = "green";
		}
		$("#tblInvoiceList tr").find("td:contains('" + invoiceId + "')").next("td").append(resultSpan);
		$("#tblInvoiceList tr").find("td:contains('" + invoiceId + "')").css("color", resultColour);
	}).then(function(result) {
		if (confirm("Click OK to clear and refresh the screen.")) {
			invoiceList($("#invoiceUnitList").find(":selected").val(),Fiscal_prefix);
		}
	});
}

function tableAppend(tableId, col1, col2) 
{
	$("#" + tableId).append(`
		<tr>
			<td valign="top" style="width: 150px;">` + col1 + `</td>
			<td valign="top">` + col2 + `</td>
		</tr>
	`);
}

function fixFalseZeroInvoices(invoiceId="", Fiscal_prefix="000000000") {
	$("#spinner2").show();
	let invoiceIdArray = !invoiceId ? invoiceListArray : [invoiceId];
	let message= "";
	console.log(invoiceIdArray);
	if (invoiceIdArray.length == 0) {
		alert("Please select an invoice.");
		return false;
	}
	else if (invoiceIdArray.length == 1) {
		message = "This will fix false zero invoices for invoice " + invoiceIdArray[0] + ".";
	}
	else {
		message = "This will fix false zero invoices for all affected invoices.";
	}
	if (!confirm(message)) {
		return false;
	}
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "fixFalseZeroInvoices",
			invoiceListArray: JSON.stringify(invoiceIdArray)
		}
	})
	.done(function(result) {
		$("#spinner2").hide();
		fixedInvoices = JSON.parse(result);
		$.each( fixedInvoices, function( index, invoiceId ) {
			$("#tblInvoiceList tr").find("td:contains('" + invoiceId + "')").next("td").append(" <span style='color: white; background-color: green;'>&nbsp;&nbsp;Fixed&nbsp;&nbsp;</span>");
		});
		$("table#invoiceDetails").empty();
		$("#invoiceDetailsContainer").empty();
		$("#invoiceDetailsContainer").show();
		$("#invoiceDetailsContainer").append(`&nbsp;Fixed:&nbsp;` + JSON.stringify(fixedInvoices));
		$("#spinner2").hide();
		invoiceList($("#invoiceUnitList").find(":selected").val(),Fiscal_prefix);
	});
}