<?php
	if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
		header('Location: /utils/');
		exit;
	}
	
	// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
	require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../functions.system.php");
	require_once(__DIR__ . "/../../functions.php");
	require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
	require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
	require_once(__DIR__ . "/../../db.rv_reservation.php");
	require_once(__DIR__ . "/../../db.rv_reservation_item.php");
	require_once(__DIR__ . "/../../db.rv_extra.php");
	require_once(__DIR__ . "/../../db.fn_folio.php");
	require_once(__DIR__ . "/../../db.rv_res_item_group.php");
	require_once(__DIR__ . "/../../db.rv_payment.php");
	require_once(__DIR__ . "/../../db.rv_payment_item.php");
	require_once(__DIR__ . "/../../functions.reservation.php");
	require_once(__DIR__ . "/../../functions.financial.php");
	require_once(__DIR__ . "/../../functions.rates.php");
	require_once(__DIR__ . "/../../db.tc_sequence.php");

	include("header.php");
?>

<div id="mainContainer" class="uk-padding">
	<div class="uk-margin-small-top uk-width-1-3">
		<div>Invoice Unit:</div>
		<select id="invoiceUnitList" class="uk-select uk-width-1-1" onchange="invoiceAnalysis();"></select>
	</div>
	<div class="uk-width-1-1 uk-child-width-expand uk-flex">

		<div class="uk-margin-small">
			<div class="uk-margin-small-right uk-margin-small-top" id="invoiceAnalysisContainer" style="display: none;"></div>
			<div class="uk-margin-small" id="productCacheContainer" style="display: none;"></div>
		</div>
		<div class="uk-margin-small uk-margin-right">
			<div class="uk-padding-small" id="invoiceContainer" style="display: none; background-color:#eeeeee; color:grey; outline: 1px solid grey;"></div>
			<div id="invoiceList"></div>
		</div>
		<div class="uk-margin-small">
			<div id="invoiceDetailsContainer" class="uk-padding-small" style="background-color:#ffffe0; color:#f08080; outline: 1px solid #f08080;"></div>
			<div class="">
				<div id="spinner2" uk-spinner></div>
				<table id="invoiceDetails"></table>
			</div>
		</div>
	</div>
	<div id="spinner" uk-spinner></div>
</div>

</body>
</html>
