$(document).ready(function() {
	fetchPendingProcessingInvoices();
});

function fetchPendingProcessingInvoices() {
	$("#listContainer").hide();
	$("#spinner").show();
	$("#invoiceDetailsHeading").empty();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "fetchPendingProcessingInvoices"
		}
	})
	.done(function(result) {
		result = JSON.parse(result);
		$("#invoiceList").empty();
		$("#invoiceListHeading").html(result.length + " Invoices. <button class='uk-button-danger' onclick='resetAllPendingInvoices()'>Clear All</button>");
		$("#invoiceList").append("<tr class='uk-text-left'><th>Invoice ID</th><th>Date</th><th>Reservation</th><th>Amount</th><th>Status</th></tr>");
		$.each(result, function(key, value) {
			$("#invoiceList").append("<tr>" 
				+ "<td>" + value.fn_invoice_ix + "</td>"
				+ "<td>" + value.fn_inv_date + "</td>"
				+ "<td>" + value.rv_reservation_id + "</td>"
				+ "<td>" + value.fn_inv_amt_payable + "</td>"
				+ "<td><button class='uk-button-rounded' onclick='resetPendingInvoice(\"" + value.fn_invoice_ix + "\")'>"
				+ "Clear status"
				+ "</button>"
				+ "</td></tr>");
		});
		$("#spinner").hide();
		$("#listContainer").show();
	});
}

function resetPendingInvoice(invoiceId) {
	$("#listContainer").hide();
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "resetPendingInvoice",
			invoiceId: invoiceId
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		fetchPendingProcessingInvoices();
	});
}

function resetAllPendingInvoices() {
	$("#listContainer").hide();
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "resetAllPendingInvoices"
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		fetchPendingProcessingInvoices();
	});
}