<?php

// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
require_once(__DIR__ . "/../../functions.system.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
require_once(__DIR__ . "/../../db.rv_reservation.php");
require_once(__DIR__ . "/../../db.rv_reservation_item.php");
require_once(__DIR__ . "/../../db.rv_extra.php");
require_once(__DIR__ . "/../../db.fn_folio.php");
require_once(__DIR__ . "/../../db.rv_res_item_group.php");
require_once(__DIR__ . "/../../db.rv_payment.php");
require_once(__DIR__ . "/../../db.rv_payment_item.php");
require_once(__DIR__ . "/../../functions.reservation.php");
require_once(__DIR__ . "/../../functions.financial.php");
require_once(__DIR__ . "/../../functions.rates.php");
require_once(__DIR__ . "/../../db.tc_sequence.php");
require_once(__DIR__ . "/../../class.fiscalator.php");

if (isset($_POST) && isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'invoiceUnitList':
            echo invoiceUnitList();
            break;
        case 'invoiceQuery':
            echo invoiceQuery($_POST['fiscalatorKey'], $_POST['invoice']);
            break;
        case 'uploadedProductCacheQuery':
            echo uploadedProductCacheQuery($_POST['fiscalatorKey']);
            break;
        case 'uploadedProductCacheClear':
            echo uploadedProductCacheClear($_POST['fiscalatorKey']);
            break;
        case 'creditNoteRepair':
            echo creditNoteRepair($_POST['creditNoteId'], $_POST['originalInvoiceId']);
            break;
        default:
            echo 'No action specified';
            break;
    }
}

function invoiceUnitList() {
    global $lDB;

    $invoicingUnits = $lDB->get("
        SELECT
            TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as name,
            pr_business.fiscalator_key as fiscalatorKey
        FROM
            pr_business
            LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
        WHERE
            pr_business.fiscalator_key != ''
            AND pr_business.fiscalator_key IS NOT NULL
    ", 2);

    return json_encode($invoicingUnits);
}

function invoiceQuery($fiscalatorKey, $invoice) {
    $fiscalator = new Fiscalator();
    return $fiscalator->fiscalatorApiCall($fiscalatorKey, "GET", "invoicequery/" . $invoice);
}

function uploadedProductCacheQuery($fiscalatorKey) {
    $fiscalator = new Fiscalator();
    return $fiscalator->fiscalatorApiCall($fiscalatorKey, "GET", "productcache/");
}

function uploadedProductCacheClear($fiscalatorKey) {
    $fiscalator = new Fiscalator();
    return $fiscalator->fiscalatorApiCall($fiscalatorKey, "POST", "clearproductcache/");
}

function creditNoteRepair($creditNoteId, $originalInvoiceId) {
    global $lDB;
    $creditNoteDetails = json_decode($lDB->get("
                    SELECT
                        fn_api_post_rr
                    FROM
                        fn_invoice_fiscal_api
                    WHERE
                        fn_invoice_id = '" . $creditNoteId . "'
                    ORDER BY
                        fn_api_time_post DESC
                    LIMIT 1
                ", 4), true);
    $originalInvoiceDetails = json_decode($lDB->get("
                    SELECT
                        fn_api_post_rr
                    FROM
                        fn_invoice_fiscal_api
                    WHERE
                        fn_invoice_id = '" . $originalInvoiceId . "'
                    ORDER BY
                        fn_api_time_post DESC
                    LIMIT 1
                ", 4), true);

    if (
        $creditNoteDetails['original_invoice_id'] == $originalInvoiceDetails['invoice_id'] &&
        $creditNoteDetails['invoice_to_id'] == $originalInvoiceDetails['invoice_to_id'] && 
        $creditNoteDetails['amount'] == $originalInvoiceDetails['amount'] &&
        $creditNoteDetails['invoice_currency'] == $originalInvoiceDetails['invoice_currency'] &&
        $creditNoteDetails['gl_currency'] == $originalInvoiceDetails['gl_currency'] &&
        $creditNoteDetails['fn_inv_exch_rate'] == $originalInvoiceDetails['fn_inv_exch_rate'] &&
        $creditNoteDetails['pr_business_id'] == $originalInvoiceDetails['pr_business_id'] &&
        empty($creditNoteDetails['items'])
    ) {
        $newCreditNoteDetails = $creditNoteDetails;
        $newCreditNoteDetails['items'] = $originalInvoiceDetails['items'];
        $newCreditNoteDetails['repairMessage'] = "Credit note repaired from invoice $originalInvoiceId";

        $fiscalator = new Fiscalator();
        $initiateCallTime = date("Y-m-d H:i:s");
        if ($fiscalator->logFnFiscalApi(array($newCreditNoteDetails), array(), $initiateCallTime, "")) {
            return json_encode($newCreditNoteDetails);
        }
        else {
            return "Error inserting record. Please try again later";
        }
    }
    else {
        return "Error - already fixed. Refresh screen or check after resubmit.";
    }
}