$(document).ready(function() {
	invoiceUnitList();
	$("#invoiceUnitList").select2({
		placeholder: "Select invoicing unit"
	});
	$("#invoiceList").select2({
		placeholder: "Select invoice"
	});
});

function invoiceUnitList() {
	$("#invoiceUnitList").empty();
	$("#invoiceContainer").hide();
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceUnitList"
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		result = JSON.parse(result);
		console.log(result);

		$("#invoiceUnitList").append(`<option></option>`);
		$.each( result, function( index, unit ) {
			$("#invoiceUnitList").append(`
				<option value='` + unit.fiscalatorKey + `'>` + unit.name + `</option>
			`);
		});
	});
}

function invoiceList() {
	$("#spinner").show();
	$("#invoiceContainer").hide();
	$("#invoiceList").empty();
	$("#productCacheContainer").hide();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceQuery",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val(),
			invoice: ""
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		result = JSON.parse(result);
		if (!result.status) {
			UIkit.notification(result.responseMessage, "danger");
		} else {
			$("#invoiceContainer").show();
			$("#invoiceList").append(`<option></option>`);
			$.each( result.responseMessage, function( index, invoice ) {
				var type = "";
				switch (invoice.type) {
					case 1:
						var type = "Invoice";
						break;
					case 2:
						var type = "Credit";
						break;
					case 1:
						var type = "Void";
						break;
				}

				var status = '';
				switch (invoice.processing_status) {
					case 0:
						var status = 'Not processed';
						break;
					case 1:
						var status = 'Processing completed';
						break;
					case 2:
						var status = 'Processing retrying';
						break;
					case 3:
						var status = 'Processing failed';
						break;
				}
				$("#invoiceList").append(`
					<option value='` + invoice.invoice_id + `'>` + invoice.invoice_id + ` - ` + type + ` (` + invoice.created_at + `, ` + status + `)</option>
				`);
			});
		}
		fetchProductUploadCacheList();
	});
}

function fetchInvoice() {
	$("#spinner").show();
	$("#invoiceDetailsHeading").empty();
	$("#invoiceDetails").empty();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceQuery",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val(),
			invoice: $("#invoiceList").find(":selected").val()
		}
	})
	.done(function(result) {
		$("#spinner").hide();
		$("#invoiceDetailsHeading").html("Results for document " + $("#invoiceList").find(":selected").val());
		result = JSON.parse(result);
		console.log(result);
		$("#invoiceDetails").append(`<tr><td></td><td></td></tr>`);
		
		$.each( result.transaction, function( index, transaction ) {
			var type = "";
			let post_data = JSON.parse(transaction.post_data);
			let originalInvoiceId = false;
			let creditInvoiceId = transaction.invoice_id;
			let itemList = false;
			switch (transaction.type) {
				case 1:
					type = "Invoice";
					break;
				case 2:
					type = "Credit";
					originalInvoiceId = typeof post_data.original_invoice_id != undefined ? post_data.original_invoice_id : false;
					if (typeof post_data.items !== undefined) itemList = post_data.items;
					break;
				case 1:
					type = "Void";
					break;
			}

			var status = '';
			switch (transaction.processing_status) {
				case 0:
					status = 'Not processed';
					break;
				case 1:
					status = 'Processing completed';
					break;
				case 2:
					status = 'Processing retrying';
					break;
				case 3:
					status = 'Processing failed';
					break;
			}

			var queryStatus = transaction.query_status == 1 ? "queried" : "not queried";
			if (typeof transaction.response_data == "object") {
				responseData = JSON.stringify(JSON.parse(transaction.response_data))
			}
			else {
				responseData = transaction.response_data.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
			}
			tableAppend("invoiceDetails", "<strong>Transaction " + index + "</strong>", "");
			tableAppend("invoiceDetails", "Invoice ID", transaction.invoice_id);
			tableAppend("invoiceDetails", "Type", type);
			tableAppend("invoiceDetails", "Processing status", status);
			tableAppend("invoiceDetails", "Query status", queryStatus);

			if (transaction.processing_status == 0 && transaction.type == 2 && !itemList) {
					let originalInvoiceDetails = getInvoiceDetails(originalInvoiceId);
					tableAppend("invoiceDetails", "CN Missing Items", "<button id='btnDoCNRepair' onclick='repairCreditNote(\""+creditInvoiceId+"\", \""+originalInvoiceId+"\");'>Repair with items from "+originalInvoiceId+"</button>");
				}

			tableAppend("invoiceDetails", "Post data", "<pre>" + JSON.stringify(JSON.parse(transaction.post_data), undefined, 2) + "</pre>");
			tableAppend("invoiceDetails", "Response code", transaction.response_code);
			tableAppend("invoiceDetails", "Response message", transaction.response_message);
			tableAppend("invoiceDetails", "Response data", "<pre>" + responseData + "</pre>");
			tableAppend("invoiceDetails", "Error data", transaction.error_data);
			tableAppend("invoiceDetails", "Time posted", transaction.time_post);
			tableAppend("invoiceDetails", "Time of response", transaction.time_response);
			tableAppend("invoiceDetails", "Created time", transaction.created_at);
			tableAppend("invoiceDetails", "&nbsp;", "");
		});

		tableAppend("invoiceDetails", "&nbsp;", "");
		
		$.each( result.api_log, function( index, log ) {
			tableAppend("invoiceDetails", "<strong>API log " + index + "</strong>", "");
			tableAppend("invoiceDetails", "Endpoint", log.endpoint);
			tableAppend("invoiceDetails", "Payload", "<pre>" + JSON.stringify(JSON.parse(log.payload), undefined, 2) + "</pre>");
			tableAppend("invoiceDetails", "Created time", log.created_at);
			tableAppend("invoiceDetails", "&nbsp;", "");
		});
	});
}

function getInvoiceDetails(invoice_id) {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "invoiceQuery",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val(),
			invoice: invoice_id
		}
	})
	.done(function(result) {
		return JSON.parse(result);
	});
}

function tableAppend(tableId, col1, col2) {
	$("#" + tableId).append(`
		<tr>
			<td valign="top" style="width: 150px;">` + col1 + `</td>
			<td valign="top">` + col2 + `</td>
		</tr>
	`);
}

function fetchProductUploadCacheList() {
	$("#spinner").show();
	$("#productCacheContainer").hide();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "uploadedProductCacheQuery",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val()
		}
	})
	.done(function(result) {
		result = JSON.parse(result);
		if (!result.status) {
			UIkit.notification(result.responseMessage, "danger");
		} else {
			$cacheCount = result.responseMessage ? result.responseMessage.length : '0';
			if (result.integrator_id == "1") {
				$("#productCacheContainer").show();
				$("#productCacheContainer").html(
					"Uploaded product cache contains " +
					$cacheCount +
					" items"
				);
				if ($cacheCount != '0') {
					$("#productCacheContainer").append("  <button onclick='clearUploadedProductCache()'>Clear</button>");
				}
			}
		}
	});
	$("#spinner").hide();
}

function clearUploadedProductCache() {
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "uploadedProductCacheClear",
			fiscalatorKey: $("#invoiceUnitList").find(":selected").val()
		}
	})
	.done(function(result) {
		fetchProductUploadCacheList();
		$("#spinner").hide();
	});
}

function repairCreditNote(creditNoteId, originalInvoiceId) {
	$("#spinner").show();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "creditNoteRepair",
			creditNoteId: creditNoteId,
			originalInvoiceId: originalInvoiceId,
		}
	})
	.done(function(result) {
		$('#btnDoCNRepair').prop('disabled', 'disabled');
		var table = $('#invoiceDetails');
		var targetTd = table.find('td:contains("Post data")');
		var nextTd = targetTd.next('td');
		nextTd.text(result);
	});
	$("#spinner").hide();
}