<?php
	if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
		header('Location: /utils/');
		exit;
	}
	
	// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
	require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../functions.system.php");
	require_once(__DIR__ . "/../../functions.php");
	require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
	require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
	require_once(__DIR__ . "/../../db.rv_reservation.php");
	require_once(__DIR__ . "/../../db.rv_reservation_item.php");
	require_once(__DIR__ . "/../../db.rv_extra.php");
	require_once(__DIR__ . "/../../db.fn_folio.php");
	require_once(__DIR__ . "/../../db.rv_res_item_group.php");
	require_once(__DIR__ . "/../../db.rv_payment.php");
	require_once(__DIR__ . "/../../db.rv_payment_item.php");
	require_once(__DIR__ . "/../../functions.reservation.php");
	require_once(__DIR__ . "/../../functions.financial.php");
	require_once(__DIR__ . "/../../functions.rates.php");
	require_once(__DIR__ . "/../../db.tc_sequence.php");

	include("header.php");
?>

<div id="mainContainer" class="uk-container">
	<div class="uk-margin-small-top">
		<div>Invoice Unit:</div>
		<select id="invoiceUnitList" style="width: 550px;" onchange="invoiceList();"></select>
	</div>
	<div class="uk-margin-small-top" id="productCacheContainer" style="display: none;"></div>

	<div class="uk-margin-small-top" id="invoiceContainer" style="display: none;">
		<div>Invoice:</div>
		<select id="invoiceList" style="width: 550px;" onchange="fetchInvoice();"></select>
	</div>

	<div id="spinner" uk-spinner></div>

	<div class="uk-margin-large-top">
		<h4 id="invoiceDetailsHeading"></h4>
		<table id="invoiceDetails" width="100%"></table>
	</div>
</div>

</body>
</html>
