<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

$content = '';

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../../functions.system.php');
require_once(__DIR__ . '/../../../functions.php');
require_once(__DIR__ . '/../../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../../ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/../../../functions.transfer.common.php');
require_once(__DIR__ . '/../../../db.pf_object.php');
require_once(__DIR__ . '/../../../db.pf_field.php');
define("PROFILE_DIR_FIX","profilefix");

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

function redirect($url){
	redirectTo("".$url);
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master

if (!isset($_GET['step'])) {
	$content .= "<h2>Step 1</h2>";
	$content .= "<form method='POST' action='index.php?step=2'>";
	$content .= "<h3>What profile related problem do you want to fix?</h3>";
	$content .= "<table class='tableFullWidth tableFullMain'>";
	$content .= "	<thead>";
	$content .= "		<tr>";
	$content .= "			<th>Problem</th>";
	$content .= "			<th>Issue #</th>";
	$content .= "			<th><p title='Check if this problem exists for this client'>Check</p></th>";
	$content .= "		</tr>";
	$content .= "	</thead>";
	$content .= "	<tbody>";
	$content .= "		<tr>";
	$content .= "			<td>Guest History Report profiles do not display all data since the upgrade to 6.9.1</td>";
	$content .= "			<td><a target='_blank' href='https://resrequest.atlassian.net/browse/RRDEV-334'>RRDEV-334</a></td>";
	$content .= "			<td><button type='submit' name='btnAction' value='1'>Check</button></td>";
	$content .= "		</tr>";
	$content .= "	</tbody>";
	$content .= "</table>";
	$content .= "</form>";
}

if (isset($_GET['step'])) {
	if ($_GET['step'] == 2) {
		$action = (isset($_POST['btnAction'])) ? $_POST['btnAction'] : "";
		if (empty($action)) {
			$content = "<div class='errorDiv'>Select a problem to check for</div>";
			$content .= "<button onclick='toStep(1);'>Back</button><br>";
		} else {
			switch ($action) {
				case '1':
					$totalRecords = 0; //count($pfFields);
					$pf_object_id = db_pf_object_by_name("guest_history");
					$pfFields = $lDB->get("
						SELECT
							pf_field.pf_field_ix,
							pf_field.pf_field_contents
						FROM
							pf_field
							INNER JOIN pf_option ON pf_option.pf_option_ix = pf_field.pf_option_id
						WHERE
							pf_option.pf_object_id = '$pf_object_id'
							AND pf_field.pf_field_name IN ('guestDetailsCols','travelHistoryCols')
					",6);
					$rfObjGuestIds = $lDB->get("
						SELECT
							rf_obj_guest.rf_obj_guest_ix
						FROM
							rf_obj_guest
					",3);
					foreach ($pfFields as $pfField) {
						$columns = explode(":", $pfField['pf_field_contents']);
						$hasProblem = false;
						foreach ($columns as $column) { 
							$columnItems = explode(",", $column);
							// if the sort asc/desc field is inserted in the wrong place
							if (count($columnItems) > 10 && is_numeric($columnItems[4])) {
								$hasProblem = true;
								// If the rf_obj_guest_type_ind is set to the rf_obj_guest_ix
								// and the sort asc/desc field is inserver in the wrong place
								if (in_array($columnItems[8], $rfObjGuestIds)) {
									$hasProblem = true;
								}
							}
							// If the rf_obj_guest_type_ind is set to the rf_obj_guest_ix
							if (in_array($columnItems[7], $rfObjGuestIds)) {
								$hasProblem = true;
							}
						}
						if ($hasProblem) { $totalRecords += 1; }
					}
					$problemDescription = "Guest History Report profiles do not display all data since the upgrade to 6.9.1";
					if ($totalRecords > 0) {
						$problemFoundText = "YES";
						$problemFoundAction = "<button type='submit' name='btnAction' value='".$action."'>Fix</button>";
					} else {
						$problemFoundText = "NO";
						$problemFoundAction = "";
					}
					break;
				default:
					$content = "<div class='errorDiv'>Select a problem to check for</div>";
					break;
			}
			$content .= "<h2>Step 2</h2>";
			$content .= "<h3>PROBLEM: $problemDescription</h3>";
			$content .= "<form method='POST' action='index.php?step=3'>";
			$content .= "<table class='tableFullWidth tableActions'>";
			$content .= "	<thead>";
			$content .= "		<tr>";
			$content .= "			<th>Result</th>";
			$content .= "			<th>Fix required</th>";
			$content .= "			<th><p title='Action to perform for this problem'>Action</p></th>";
			$content .= "		</tr>";
			$content .= "	</thead>";
			$content .= "	<tbody>";
			$content .= "		<tr>";
			$content .= "			<td>Total records found with this problem: $totalRecords</td>";
			$content .= "			<td class='".($problemFoundText == 'YES' ? 'error' : 'valid')."'>$problemFoundText</td>";
			$content .= "			<td>".$problemFoundAction."</td>";
			$content .= "		</tr>";
			$content .= "	</tbody>";
			$content .= "</table>";
			$content .= "";
			$content .= "</form>";
			$content .= "<button onclick='toStep(1);'>Cancel</button><br>";
		}
	}

	if ($_GET['step'] == 3) {
		$log = '';
		$action = (isset($_POST['btnAction'])) ? $_POST['btnAction'] : "";
		if (empty($action)) {
			$content = "<div class='errorDiv'>Select a problem to check for</div>";
			$content .= "<button onclick='toStep(1);'>Back</button><br>";
		} else {
			switch ($action) {
				case '1':
					$totalRecords = 0; //count($pfFields);
					$pf_object_id = db_pf_object_by_name("guest_history");
					$pfFields = $lDB->get("
						SELECT
							pf_field.pf_field_ix,
							pf_field.pf_field_contents
						FROM
							pf_field
							INNER JOIN pf_option ON pf_option.pf_option_ix = pf_field.pf_option_id
						WHERE
							pf_option.pf_object_id = '$pf_object_id'
							AND pf_field.pf_field_name IN ('guestDetailsCols','travelHistoryCols')
					",6);
					$rfObjGuests = $lDB->get("
						SELECT
							rf_obj_guest.rf_obj_guest_ix,
							rf_obj_guest.rf_obj_guest_type_ind
						FROM
							rf_obj_guest
					",6);
					$rfObjGuestValues = array();
					foreach ($rfObjGuests as $rfObjGuest) {
						$rfObjGuestValues[$rfObjGuest['rf_obj_guest_ix']] = $rfObjGuest['rf_obj_guest_type_ind'];
					}
					$rfObjGuestIds = $lDB->get("
						SELECT
							rf_obj_guest.rf_obj_guest_ix
						FROM
							rf_obj_guest
					",3);
					foreach ($pfFields as $pfField) {
						$columns = explode(":", $pfField['pf_field_contents']);
						$fixedFieldContents = array();
						$hasProblem = false;
						foreach ($columns as $column) { 
							$columnItems = explode(",", $column);
							if (count($columnItems) > 10 && is_numeric($columnItems[4])) {
								$hasProblem = true;
								$columnMove = $columnItems[3];
								unset($columnItems[3]);
								$columnItems[] = $columnMove;
								if (in_array($columnItems[8], $rfObjGuestIds)) {
									$hasProblem = true;
									$columnItems[8] = $rfObjGuestValues[$columnItems[8]];
								}
							}
							if (in_array($columnItems[7], $rfObjGuestIds)) {
								$hasProblem = true;
								$columnItems[7] = $rfObjGuestValues[$columnItems[7]];
							}
							$fixedFieldContents[] = implode(",", $columnItems);
						}
						if ($hasProblem) { 
							$now = new DateTime();
							$now = $now->format("Y-m-d h:i:s");
							$log .= "$now: Fixed pf_field.pf_field_ix = $pfField[pf_field_ix] (from value '$pfField[pf_field_contents]')\n";
							$fixedFieldContents = implode(":", $fixedFieldContents);
							$lDB->put("
								UPDATE
									pf_field
								SET
									pf_field_contents = '$fixedFieldContents'
								WHERE
									pf_field.pf_field_ix = '$pfField[pf_field_ix]'
							");
						}
					}
					$problemDescription = "Guest History Report profiles do not display all data since the upgrade to 6.9.1";
					if ($totalRecords > 0) {
						$problemFoundText = "YES";
						$problemFoundAction = "<button type='submit' name='btnAction' value='".$action."'>Fix</button>";
					} else {
						$problemFoundText = "NO";
						$problemFoundAction = "";
					}
					break;
				default:
					$content = "<div class='errorDiv'>Select a problem to check for</div>";
					break;
			}
			$content .= "<h2>Step 3</h2>";
			$content .= "<h3>PROBLEM: $problemDescription</h3>";
			$content .= "<br><button onclick='toStep(1);'>Done</button><br>";

			$logFileName = $principal_id."_1_".str_replace(" ","_",str_replace(":","-",date("Y-m-d H:i:s")))."_".$dbcode."_".$userid;
			$logStash = getTransferDirDT37($logFileName,PROFILE_DIR_FIX,'../../../');
			$logFile = fopen(__DIR__ . "/" . $logStash.$logFileName.".log","a+");
			fwrite($logFile,$log);
			fclose($logFile);
		}

	}
}


?>
<html>
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8">
	<title>Profle fixer</title>

	<style>
		.errorDiv { 
			padding: 5px;
			text-align: center;
			color: #5e1212;
			border: 1px;
			border-color: red;
			background-color: #ffc0c0;
			width: 99%;
			float: middle;
			font-size: 14px
		}
		.tableFullWidth { width: 99%; }
		.tableFullMain thead {
			background-color: #e0e0ff;
		}
		.tableFullMain tbody {
			background-color: #f2f2ff;
		}
		.tableActions thead {
			background-color: #ffcd7d;
		}
		.tableActions tbody {
			background-color: #ffecce;
		}
		.tableActions tbody td {
			height: 2em;
		}
		.error { background-color: red; }
		.valid { background-color: green; }
		.footer { font-size: 10px; }
	</style>

	<script>

		function toStep(step) {
			url = "";
			switch (step) {
				case 1:
					url = "index.php";
					break;
				default:
					url = "index.php";
					break;
			}
			location.href = url;
		}

	</script>

</head>
<body>
<table width="100%">
<tr>
	<td valign="top">		
		<table>
		<tr>
			<td rowspan="3"><img width=100 height=80 src="profile.png"></td>
		</tr>
		<tr>
			<td><h1>Profile fixer</h1></td>
		</tr>
		<tr>
			<td>This tool fixes profile related problems</td>
		</tr>
		</table>
	</td>
</tr>
</table>
<hr/>
<br />
<?php echo $content ?>
<br/>
<br/>
<hr/>
<div class="footer">
© 2015 by ResRequest All rights reserved.
</div>
</body>
</html>

