<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

$content = '';

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../../functions.system.php');
require_once(__DIR__ . '/../../../functions.php');
require_once(__DIR__ . '/../../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../../ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/../../../functions.transfer.common.php');
require_once(__DIR__ . '/../../../db.rv_reservation.php');
define("PROFILE_DIR_FIX","profilefix");

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

function redirect($url){
	redirectTo("".$url);
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master

if (!empty($_POST)) {
	foreach ($_POST as $rv_reservation_id => $value) {
		echo "Processing res ".$rv_reservation_id."<br>";
		db_rv_reservation_update_notes($rv_reservation_id);
	}
}

$data = array();
$output = "";

// Get all notes from a certain date
$notes = $GLOBALS['lDB']->get("
	SELECT
		rv_note.rv_note_ix,
		rv_note.rv_reservation_id,
		rv_note.rv_note_general,
		rv_note.ad_create_date
	FROM
		rv_note
	WHERE
		rv_note.ad_create_date > '2017-01-01'
	ORDER BY
		rv_note.ad_create_date DESC
",2);

// Place notes into a nice array
foreach ($notes as $note) {
	$data[$note['rv_reservation_id']][] = $note;
}
unset($notes);

// Find reservations for these notes, mismatched on the latest note per res
foreach ($data as $resID => $item) {
	$reservation = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_note_general,
			rv_reservation.rv_res_name,
			CONCAT('Travel ',rv_reservation.rv_date_arrive,' to ', rv_reservation.rv_date_depart) AS dates
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '".$resID."'
			AND rv_reservation.rv_note_general != '".$GLOBALS['lDB']->escape($item[0]['rv_note_general'])."'
	",2);
	$data[$resID]['res'] = $reservation;
	if (empty($reservation)) {
		// No mismatch, remove from array
		unset($data[$resID]);
	}
}


$output.="<h2>Reservation Notes Fixer</h2>
<p>Transferred general reservation notes are not displaying on the reservation details since the upgrade to 7.3.x<br>
<a target='_blank' href='https://resrequest.atlassian.net/browse/RRDEV-1201'>RRDEV-1201 {137109}</a></p>
<p>These are the mismatched notes. Please check all the ones to fix, then click Submit at the bottom.</p>
<p></p>
<form name='fix' action='index.php' method='POST'>
<table>";
$output.="<tr>
	<td><strong>Res ID</strong></td>
	<td><strong>Res Name</strong></td>
	<td><strong>Res Note</strong></td>
	<td><strong>Notes Note</strong></td>
	<td><strong>Fix</strong></td>
	</tr>
	";
foreach ($data as $resID => $item) {
	$output.="<tr>
	<td title='".$item['res'][0]['dates']."'>".$resID."</td>
	<td title='".$item['res'][0]['dates']."'>".$item['res'][0]['rv_res_name']."</td>
	<td><textarea>".$item['res'][0]['rv_note_general']."</textarea></td>
	<td><textarea>".$item[0]['rv_note_general']."</textarea></td>
	<td><input type='checkbox' id='".$resID."' name='".$resID."'></td>
	</tr>
	";
}
$output.="</table>
<input type='submit' value='Submit for fixes'>
</form>";

echo $output;