<?php
	if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
		header('Location: /utils/');
		exit;
	}
	
	// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
	require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../functions.system.php");
	require_once(__DIR__ . "/../../functions.php");
	require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
	require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
	require_once(__DIR__ . "/../../db.rv_reservation.php");
	require_once(__DIR__ . "/../../db.rv_reservation_item.php");
	require_once(__DIR__ . "/../../db.rv_extra.php");
	require_once(__DIR__ . "/../../db.fn_folio.php");
	require_once(__DIR__ . "/../../db.rv_res_item_group.php");
	require_once(__DIR__ . "/../../db.rv_payment.php");
	require_once(__DIR__ . "/../../db.rv_payment_item.php");
	require_once(__DIR__ . "/../../functions.reservation.php");
	require_once(__DIR__ . "/../../functions.financial.php");
	require_once(__DIR__ . "/../../functions.rates.php");
	require_once(__DIR__ . "/../../db.tc_sequence.php");

	include("header.php");

	$invoicingUnits = $lDB->get("
		SELECT
			pr_business.pr_business_id as invId,
			TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as name,
			pr_business.pr_bus_billing_yn as invRes,
			pr_business.pr_bus_billing_prop_yn as invProp,
			pr_business.pr_bus_home_curr_id as glCurrId,
			rf_currency.rf_currency_name as glCurrName,
			rf_currency.rf_currency_symbol as glCurrSymbol
		FROM
			pr_business
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
		WHERE
			pr_business.pr_bus_billing_yn = '1'
			OR pr_business.pr_bus_billing_prop_yn = '1'
	", 2);

	$currencies = $lDB->get("
		SELECT
			rf_currency_ix as currId,
			rf_currency_name as currName,
			rf_currency_symbol as currSymbol
		FROM
			rf_currency
		WHERE
			rf_currency_inactive_yn = '0'
	", 2);

	$invoiceUnitTable = "
		<table id='invoiceUnitTable' class='uk-table uk-table-striped uk-table-hover uk-table-small uk-table-middle' width='100%'>
			<thead>
				<tr>
					<th>Invcoicing Unit</th>
					<th>GL Currency</th>
					<th>New GL Currency</th>
					<th>Change GL Currency</th>
				</tr>
			</thead>
			<tbody>
	";
	foreach ($invoicingUnits as $invoicingUnit) {
		$invRes = $invoicingUnit['invRes'] == '1' ? "yes" : "no";
		$invProp = $invoicingUnit['invProp'] == '1' ? "yes" : "no";
		$invoiceUnitTable .= "
			<tr>
				<td title=\"Invoiving for: Reservations: " . $invRes . ", Property: " . $invProp . "\">" . $invoicingUnit['name'] . "</td>
				<td>" . $invoicingUnit['glCurrName'] . " (" . $invoicingUnit['glCurrSymbol'] . ")</td>
				<td>
					<select
						id='currency_" . $invoicingUnit['invId'] . "'
						class=\"uk-select\"
						style='width: 200px;'
						invoiceUnitName='" . $invoicingUnit['name'] . "'
						oldCurrency='" . $invoicingUnit['glCurrName'] . "'
					>
						<option value='0' selected disabled>Select new currency</option>
		";

		foreach ($currencies as $currency) {
			if ($currency['currId'] != $invoicingUnit['glCurrId']) {
				$invoiceUnitTable .= "<option value='" . $currency['currId'] . "'>" . $currency['currName'] . " (" . $currency['currSymbol'] . ")</option>";
			}
		}

		$invoiceUnitTable .= "
					</select>
				</td>
				<td>
					<button class='uk-button uk-button-small uk-button-primary' onclick='changeCurrency(\"" . $invoicingUnit['invId'] . "\");'>
						Change GL currency
					</button>
				</td>
			</tr>
		";
	}
	$invoiceUnitTable .= "
			</tbody>
		</table>
	";

?>
	<!-- The content, with the above PHP injected -->
	<div id="mainContainer" class="uk-container">
		<div class="uk-margin-top">
			<?php echo $invoiceUnitTable; ?>
		</div>
	</div>

	<!-- Confirmation modal -->
	<div id="modal-confirm" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Confirm</h2>
			<p>Are you sure you want to change the GL Currency for "<span id="invUnitName" class="uk-text-bold"></span>" from "<span id="oldCurrencyName" class="uk-text-bold"></span>" to "<span id="newCurrencyName" class="uk-text-bold"></span>" ?</p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
				<button class="uk-button uk-button-primary" type="button" onclick="changeCurrencyConfirmed()">Confirm</button>
			</p>
		</div>
	</div>

	<!-- Select currency modal -->
	<div id="modal-select-currency" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Error</h2>
			<p>Please select a new GL currency</p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
			</p>
		</div>
	</div>

	<!-- Success modal -->
	<div id="modal-result" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Result</h2>
			<p id="changeResult"></p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
			</p>
		</div>
	</div>

	<!-- Hidden values to keep track of the currently selected invoicing unit & currency -->
	<input type="hidden" id="invoicingUnitId" value="">
	<input type="hidden" id="newCurrencyId" value="">

	<!-- The Javascript magic -->
	<script type="text/javascript">
		// When GL currency is changed successfully, reload the page to refresh the table
		$("#modal-result").on('hidden.bs.modal', function(){
			location.reload();
		});

		function changeCurrency(invId) {
			$("#invoicingUnitId").val(invId);
			$("#invUnitName").text($("#currency_" + invId).attr("invoiceUnitName"));
			$("#oldCurrency").text($("#currency_" + invId).attr("oldCurrency"));
			$("#newCurrency").text($("#currency_" + invId + " option:selected").text());
			$("#newCurrencyId").val($("#currency_" + invId).val());
			
			$("#oldCurrencyName").text($("#currency_" + invId).attr("oldCurrency"));
			$("#newCurrencyName").text($("#currency_" + invId + " option:selected").text());

			if ($("#newCurrencyId").val() == 0) {
				UIkit.modal("#modal-select-currency").show();
				return;
			}

			UIkit.modal("#modal-confirm").show();
		}

		function changeCurrencyConfirmed() {
			var invoicingUnitId = $("#invoicingUnitId").val();
			var newCurrencyId = $("#newCurrencyId").val();		

			$.ajax({
				url: "ajax.php",
				type: "POST",
				data: {
					action: "changeCurrency",
					invoicingUnitId: invoicingUnitId,
					newCurrencyId: newCurrencyId
				},
				success: function(response) {
					$("#changeResult").text(response);
					UIkit.modal("#modal-result").show();
				}
			});
		}	
	</script>

</body>
</html>
