<?php

use MaglLegacyApplication\Application\MaglLegacy;

ob_start();

require_once(__DIR__ . '/../class.mysqldb.php');			// MySQL DB Class  # obvious
require_once(__DIR__ . '/../functions.system.php');
require_once(__DIR__ . '/../functions.php');
require_once(__DIR__ . '/../inc.setup.php');				// Database Connection, customised setup and config file
require_once(__DIR__ . '/../ac_logon.php');					// Access Control Results

$utils = array(
	array(
		"name" => "Agent Rate Type Tool",
		"desc" => "For setting up rate types for agents",
		"link" => "agent_rate_types/index.php",
		"tags" => "tagRate"
	),
	array(
		"name" => "Bulk Regeneration",
		"desc" => "Bulk Regeneration of folios, itineraries and payment plans",
		"link" => "bulk_regeneration/index.php",
		"tags" => "tagOther"
	),
	array(
		"name" => "CC Setup",
		"desc" => "Setting up CC emails",
		"link" => "cc_setup/index.php",
		"tags" => "tagSetup"
	),
	array(
		"name" => "Childless Tran Fix",
		"desc" => "For fixing childless transactions, related to HS226534",
		"link" => "childless_tran_HS_226534/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Contact Import",
		"desc" => "For bulk importing of contacts",
		"link" => "contact_import/index.php",
		"tags" => "tagImport"
	),
	array(
		"name" => "FAR Travel Date Grouping",
		"desc" => "Changes all occurances of folio date grouping to travel date grouping, related to RRDEV-1858 and HS229380",
		"link" => "far_travel_date_grouping_RRDEV-1858_HS229380/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "GL Currency change",
		"desc" => "Changes the GL currency for a specified property or invoicing unit",
		"link" => "gl_currency_change/index.php",
		"tags" => "tagOther"
	),
	array(
		"name" => "Password Hash Fix",
		"desc" => "Fixing of insecure (non-hashed) passwords",
		"link" => "password_hash_fix/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Period Fix",
		"desc" => "Fixing of rate periods",
		"link" => "period_fix/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Profile Fix",
		"desc" => "This tool fixes profile-related problems",
		"link" => "fix/profile/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Rate Edit Tool",
		"desc" => "Rates edit tool (generic)",
		"link" => "rate_edit_gen/index.php",
		"tags" => "tagRate"
	),
	array(
		"name" => "Rate Fix",
		"desc" => "Suite of rate tests and fixes",
		"link" => "rate_fix/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Res Notes Fix",
		"desc" => "Transferred general reservation notes are not displaying on the reservation details, RRDEV-1201 HS137109",
		"link" => "fix/res_notes/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Reservation Guest duplicates",
		"desc" => "Remove duplicate reservation guests that block data transfers",
		"link" => "reservation_guest_duplicates/index.php",
		"tags" => "tagOther"
	),
	array(
		"name" => "Reservation Import and Export",
		"desc" => "For bulk importing and exporting of reservations",
		"link" => "reservation_import/index.php",
		"tags" => "tagImport"
	),
	array(
		"name" => "Room Fix",
		"desc" => "Room creation fixing tool",
		"link" => "room_fix/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Transfer Fix",
		"desc" => "For generating data transfer fix scripts",
		"link" => "transfer_fix/index.php",
		"tags" => "tagFix"
	),
	array(
		"name" => "Fiscal Query",
		"desc" => "For querying details on fiscalised invoices (Loads all invoices.)",
		"link" => "fiscal_query/index.php",
		"tags" => "tagFiscalator"
	),
	array(
		"name" => "Fiscal Invoice Check",
		"desc" => "Compare details of single fiscalised invoices by invoice #",
		"link" => "fiscal_check/index.php",
		"tags" => "tagFiscalator"
	),
	array(
		"name" => "Fiscal Invoice Query",
		"desc" => "For querying and correcting fiscalised ZFP labs false positive and cross postings. ONCE OFF UTIL DO NOT RUN. {HS 383093}",
		"link" => "fiscal_invoice/index.php",
		"tags" => "tagFiscalator"
	),
	array(
		"name" => "Fiscal Pending Processing",
		"desc" => "For querying and clearing Pending Processing invoices",
		"link" => "fiscal_pending/index.php",
		"tags" => "tagFiscalator"
	)
);

if (isset($_GET['logout'])) {
	$username = $GLOBALS['lDB']->get("SELECT pr_user_name FROM pr_user WHERE pr_user_id = '".$GLOBALS['userid']."'",4);
	$application = MaglLegacy::getInstance()->getApplication();
	$authService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Authenticate');
	$authService->logout($username);
	header("Location: /utils/");
}

if (
	isset($_POST['login']) &&
	isset($_POST['pr_user_name']) &&
	isset($_POST['pr_user_password'])
) {
	$application = MaglLegacy::getInstance()->getApplication();
	$enterpriseSetup = $application->getServiceManager()->get('Resrequest\Setup\Service\Enterprise');
	$authenticateService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Authenticate');
	$authenticated = $authenticateService->login($_POST['pr_user_name'], $_POST['pr_user_password']);
	$enterpriseSetup->onLogin();
	$sc_group_id = $enterpriseSetup->accessGroupId;

	$link = "";
	if (isset($_POST['page']) && !empty($_POST['page'])) {
		foreach ($utils as $util) {
			if ($util['name'] == $_POST['page']) {
				$link = $util['link'];
			}
		}
	}

	echo json_encode(
		array(
			"authenticated" => $authenticated,
			"link" => $link
		)
	);
	die;
}

$page = isset($_GET['page']) && !empty($_GET['page']) ? $_GET['page'] : "";

$loginMessage = "";
$needToLogin = false;

if (!isset($_SESSION['userName'])) {		// Not logged in
	$loginMessage = "You need to be logged in to access this page";
	$needToLogin = true;
}

if (isset($_SESSION['userName']) && strtolower($_SESSION['userName']) != 'censysad') {		// Not censys user
	$loginMessage = "You need to be logged in as a ResRequest administrator to access this page";
	$needToLogin = true;
}

$link = "";
if (!$needToLogin && !empty($page)) {
	foreach ($utils as $util) {
		if ($util['name'] == $page) {
			$link = "window.location = '" . $util['link'] . "';";
		}
	}
}

?>
<!DOCTYPE html>
<html>
    <head>
        <title>ResRequest Utilities</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="stylesheet" href="/resource/Resrequest/Application/public/css/ui-kit/uikit.min.css" />
        <link rel="stylesheet" href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/style.css" />
        <script src="/resource/Resrequest/Application/public/include/js/jquery.js"></script>
        <script src="/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js"></script>
        <script src="/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js"></script>

		<script language="javascript">
			function openUtil(link) {
				window.location = link;
			}

			function showFilter(type) {
				$(".subnavPill").removeClass('uk-active');
				if (type == '') {
					$(".utilRow").show();
					$(".allSubnav").addClass('uk-active');
				} else {
					$(".utilRow").hide();
					$("." + type).show();
					$("." + type + "Subnav").addClass('uk-active');
				}
			}

			function utilsLogin() {
				$("#loginError").html("<div uk-spinner></div>");
				var data = {
					login: "login",
					pr_user_name: $("#pr_user_name").val(),
					pr_user_password: $("#pr_user_password").val(),
					page: '<?php echo $page; ?>'
				};
				$.post("index.php", data)
					.done(function(result) {
						result = JSON.parse(result);
						if (result.authenticated) {
							$("#loginError").html("");
							if (result.link != "") {
								window.location.href = result.link;
							} else {
								location.reload();
							}
						} else {
							$("#loginError").html('<div class="uk-alert-danger" uk-alert><p>Incorrect username and/or password</p></div>');							
						}
				});
			}

			function checkEnterKey(event) {
				if (event.keyCode === 13) {
					event.preventDefault();
					utilsLogin();
				}
			}

			function utilsLogout() {
				window.location.href = "/utils/index.php?logout";
			}

			$(document).ready(function() {
				<?php echo $link; ?>
			});
		</script>
    </head>
    <body>

        <div id="headerWhiteBar"></div>
        <div id="headerGreyBar">
            <div id="headerContainer" class="uk-container">
                <h1 class="uk-heading-primary" style="font-size: 36px;">
					ResRequest Utilities
                </h1>
                <img id="headerResRequestLogo" src="/resource/Resrequest/Application/public/img/resrequest-logo.png">
            </div>
        </div>

		<div class="uk-container uk-padding-large-bottom">

<?php
	if ($needToLogin) {			// start of login section
?>

			<div class="uk-text-center">
				<h4 class="uk-margin-large-top">
					<?php echo $loginMessage; ?>
				</h4>
			</div>
			<div uk-grid>
				<div class="uk-width-1-3"></div>
				<div id="loginSection" class="uk-vertical-align uk-text-center uk-height-1-1 uk-width-1-3">
					<div id="loginSectionOuterContainer" class="uk-panel uk-panel-box uk-vertical-align-middle" style="width: 350px;">
						<div class="uk-form-row">
							<input class="uk-width-1-1 uk-form-large" type="text" name="pr_user_name" id="pr_user_name" placeholder="Username" onkeyup="checkEnterKey(event);">
						</div>
						<div class="uk-form-row">
							<input class="uk-width-1-1 uk-form-large" type="password" name="pr_user_password" id="pr_user_password" placeholder="Password"  onkeyup="checkEnterKey(event);">
						</div>
						<div class="uk-form-row">
							<input type="button" class="uk-width-1-1 uk-button uk-button-primary uk-button-large" value="Login" onclick="utilsLogin();">
						</div>
						<div id="loginError" class="uk-margin-top uk-text-center"></div>
					</div>
				</div>
				<div class="uk-width-1-3"></div>
			</div>
		</div>

		<script language="javascript">
			$(document).ready(function() {
				document.getElementById("pr_user_name").focus();
			});
		</script>
	</body>
</html>

<?php
	die;
	}		// end of login section
?>
			<div class="uk-margin-small-top">
				<div id="logoutLink" class="subnavPill uk-align-right" onclick="utilsLogout();"><a href="#">Log Out</a></div>
				<ul class="uk-subnav uk-subnav-pill">
					<li id="filterLabel">Filter: </li>
					<li class="subnavPill allSubnav uk-active" onclick="showFilter('');"><a href="#">All</a></li>
					<li class="subnavPill tagFixSubnav" onclick="showFilter('tagFix');"><a href="#">Fix</a></li>
					<li class="subnavPill tagImportSubnav" onclick="showFilter('tagImport');"><a href="#">Import</a></li>
					<li class="subnavPill tagRateSubnav" onclick="showFilter('tagRate');"><a href="#">Rates</a></li>
					<li class="subnavPill tagSetupSubnav" onclick="showFilter('tagSetup');"><a href="#">Setup</a></li>
					<li class="subnavPill tagFiscalatorSubnav" onclick="showFilter('tagFiscalator');"><a href="#">Fiscalator</a></li>
					<li class="subnavPill tagOtherSubnav" onclick="showFilter('tagOther');"><a href="#">Other</a></li>
				</ul>
				
				<table class="uk-table uk-table-striped uk-table-hover uk-table-small uk-margin-large-top">
					<?php
						foreach ($utils as $util) {
							echo '<tr onclick="openUtil(\'' . $util['link'] . '\')" class="utilRow ' . $util['tags'] . '">
								<td>
								' . $util['name'] . '
								</td>
								<td>
								' . $util['desc'] . '
								</td>
							</tr>';
						}
					?>
				</table>
			</div>

		</div>
	</body>
</html>