<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/../../db.pr_user.php');
$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

function redirect($url){
	redirectTo("".$url);
}

/* Deny access to non-internal users */
if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die("Access denied");
}

/* Deny access to all but the censysad user */
if($GLOBALS['userid'] != $lDB->get("
	SELECT
		pr_user_id
	FROM
		pr_user
	WHERE 
		pr_user_name = 'censysad'
",4)) {
	redirect("/reservation.php");
	die("Access denied");
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master

$title = "Password hashing tool";
$content = "";

$insecure = $lDB->get("
	SELECT
		pr_user.pr_user_id,
		pr_user.pr_user_password
	FROM
		pr_user
	WHERE
		pr_user.pr_auth_password_type_ind = '".$lDB->escape(DB_PR_USER_PASSWORD_TYPE_INSECURE)."'
",2);

if(!isset($_POST['action'])) {
	$content = "<p>Found " . sizeof($insecure) . " users with insecure (non-hashed) passwords. Click the button below to convert them.</p>";
	$content .= "<input type=\"hidden\" name=\"action\" value=\"convert\" />";
	$content .= "<button>Secure all insecure user passwords</button>";
} elseif($_POST['action'] == "convert") {
	foreach($insecure as $user) {
		db_pr_user_set_password($user['pr_user_id'], $user['pr_user_password'], false, true);
	}
	$content = "<p>Converted " . sizeof($insecure) . " users to secure (hashed) passwords.</p>";
	$content .= "<button>Back</button>";
} else {
	redirect("/reservation.php");
	die("Access denied");
}

?>
<!DOCTYPE html>
<html>
<head>

<title><?php echo $title; ?></title>
<link rel="stylesheet" href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/password_hash_fix/styles/main.css" type="text/css" />
</head>
<body onload="initialisePage();">
<table>
<tr>
	<td valign="top">		
		<table>
		<tr>
			<td><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/password_hash_fix/hashbrowns.jpg"></td>
			<td><h2><?php echo $title; ?></h2></td>
		</tr>
		</table>
	</td>
</tr>
</table>
<br />
<form method="POST" id="mainForm">
<br/>
<?php echo $content ?>
</form>

<br/><br/>
</body>
</html>
