<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

function redirect($url){
	redirectTo("".$url);
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master

$content = "";


if(isset($_POST['action']) && $_POST['action'] == "fix") {

	$content .= "
		<table border=\"2\" cellpadding=\"2\" class=\"periodTable\">
		<thead>
			<th class=\"periodCell\">Result</th>
		</thead>
		<tr>
			<td class=\"periodCell\">
	";
	$error = false;

	$rt_period_id = trim($_POST['rt_period_ix']);
	$rt_period_date_from = trim($_POST['rt_period_date_from']);
	$rt_period_date_to = trim($_POST['rt_period_date_to']);

	$count = $lDB->get("SELECT COUNT(*) FROM rt_period WHERE rt_period_ix = '$rt_period_id'",4);
	if($count < 1) {
		$content .= "<b>ERROR:</b> rt_period not found!<br />";
		$error = true;
	}

	if(!preg_match("/^\d{4}-\d{2}-\d{2}$/",$rt_period_date_from) || strtotime($rt_period_date_from) == -1) {
		$content .= "<b>ERROR:</b> Invalid from date \"$rt_period_date_from\".<br />";
		$error = true;
	}

	if(!preg_match("/^\d{4}-\d{2}-\d{2}$/",$rt_period_date_to) || strtotime($rt_period_date_to) == -1) {
		$content .= "<b>ERROR:</b> Invalid to date \"$rt_period_date_to\".<br />";
		$error = true;
	}

	if($rt_period_date_from > $rt_period_date_to) {
		$content .= "<b>ERROR:</b> From date must be before To<br />";
		$error = true;
	}

	$period = $lDB->get("
			SELECT DISTINCT
				rt_period.rt_period_ix,
				rt_period.rt_period_desc,
				rt_period.rt_period_date_from,
				rt_period.rt_period_date_to
			FROM
				rt_period
			WHERE
				rt_period.rt_period_ix = '$rt_period_id'
	",1);
	if($period['rt_period_date_from'] == $rt_period_date_from && $period['rt_period_date_to'] == $rt_period_date_to) {
		$content .= "<b>ERROR:</b> From and To unchanged.<br />";
		$error = true;
	}

	$rates = $lDB->get("
		SELECT DISTINCT
			rt_rate.ac_accomm_type_id,
			rt_rate.rt_rate_type_id
		FROM
			rt_rate
		WHERE
			rt_rate.rt_period_id = '$rt_period_id'
	",2);
//	echo "<pre>"; print_r($rates); echo "</pre>";
	$periods = array();
	foreach($rates as $rateItem) {
		$periods = array_merge($periods,$lDB->get("
			SELECT DISTINCT
				rt_period.rt_period_ix,
				rt_period.rt_period_desc,
				rt_period.rt_period_date_from,
				rt_period.rt_period_date_to,
				rt_rate.ac_accomm_type_id,
				ac_accomm_type.ac_accomm_desc,
				pr_persona.pr_name_last,
				rt_rate.rt_rate_type_id,
				rt_rate_type.rt_rate_type_desc
			FROM
				rt_rate
				INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
				LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
			WHERE
				rt_rate.ac_accomm_type_id = '$rateItem[ac_accomm_type_id]'
				AND rt_rate.rt_rate_type_id = '$rateItem[rt_rate_type_id]'
				AND rt_rate.rt_period_id != '$rt_period_id'
				AND rt_period.rt_period_date_to >= '$rt_period_date_from'
				AND rt_period.rt_period_date_from <= '$rt_period_date_to'
		",2));
	}

	$newPeriods = array();
	$hashes = array();
	foreach($periods as $item) {
		$found = false;
		$hash = $item['rt_period_ix'] . "_" . $item['ac_accomm_type_id'] . "_" . $item['rt_rate_type_id'];
		if(isset($hashes[$hash])) {
			$found = true;
		}
		if(!$found) {
			array_push($newPeriods,$item);
			$hashes[$hash] = true;
		}
	}
	$periods = $newPeriods;
	$newPeriods = null;
//	echo "<pre>"; print_r($periods); echo "</pre>";

	foreach($periods as $item) {
		if(
			(
				$item['rt_period_date_from'] >= $rt_period_date_from
				&& $item['rt_period_date_from'] <= $rt_period_date_to
			) || (
				$item['rt_period_date_to'] >= $rt_period_date_from
				&& $item['rt_period_date_to'] <= $rt_period_date_to
			) || (
				$item['rt_period_date_from'] <= $rt_period_date_from
				&& $item['rt_period_date_to'] >= $rt_period_date_to
			)
		) {
			$content .= "<b>ERROR:</b> Overlap at '$item[pr_name_last] - $item[ac_accomm_desc]' for rate '$item[rt_rate_type_desc]' with '$item[rt_period_desc]' ($item[rt_period_date_from] to $item[rt_period_date_to])<br />";
			$error = true;
		}
	}

	if($error) {
		$content .= "<br/> <b><i>Change not applied due to above errors.</i></b><br />";
	} else {
		$lDB->put("
			UPDATE rt_period SET
				rt_period.rt_period_date_from = '$rt_period_date_from',
				rt_period.rt_period_date_to = '$rt_period_date_to'
			WHERE
				rt_period.rt_period_ix = '$rt_period_id'
		");
		$content .= "<b>Change applied</b>.<br />";
	}

	$content .= "
			</td>
		</tr>
		</table>
		<br />
	";
}



$content .= "
	<table border=\"2\" cellpadding=\"2\" class=\"periodTable\">
	<thead>
		<th class=\"periodCell\">Name</th>
		<th class=\"periodCell\">From</th>
		<th class=\"periodCell\">To</th>
	</thead>
";

$periods = $lDB->get("
	SELECT
		rt_period.rt_period_ix,
		rt_period.rt_period_desc,
		rt_period.rt_period_date_from,
		rt_period.rt_period_date_to
	FROM
		rt_period
	WHERE
		rt_period_inactive_yn = '0'
	ORDER BY
		rt_period.rt_period_desc
",2);
foreach($periods as $item) {
	$content .= "
		<form method=\"POST\">
		<tr>
			<th align=\"left\" class=\"periodCell\">$item[rt_period_desc]</th>
			<td class=\"periodCell\"><input type=\"text\" name=\"rt_period_date_from\" value=\"$item[rt_period_date_from]\" /></td>
			<td class=\"periodCell\"><input type=\"text\" name=\"rt_period_date_to\" value=\"$item[rt_period_date_to]\" /></td>
			<td>
				<input type=\"submit\" value=\"Update\" />
				<input type=\"hidden\" name=\"action\" value=\"fix\" />
				<input type=\"hidden\" name=\"rt_period_ix\" value=\"$item[rt_period_ix]\" />
		</tr>
		</form>
	";
}

$content .= "
	</table>
";

?>
<html>
<head>

<style>
	.periodTable { background-color: #e0e0ff; }
	.periodCell { font-family: arial; font-size: 12px}
	.date { font-weight: bolder; background-color: #5050ff; }
	.client { font-weight: bold; background-color: #8080ff; }
	.property { font-weight: bold; background-color: #b0b0ff; }
</style> 

</head>
<body>
<table>
<tr>
	<td valign="top">		
		<table>
		<tr>
			<td><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/period_fix/bell.jpg"></td>
			<td><h2>Period fixer</h2></td>
		</tr>
		</table>
	</td>
</tr>
</table>
<br />
<br />
<?php echo $content ?>
</body>
</html>
