<?php

require_once(__DIR__ . "/../../class.rate.abstract.php");
require_once(__DIR__ . "/../../class.rate.standard.php");
require_once(__DIR__ . "/../../db.rt_rate_grp_amt.php");
require_once(__DIR__ . "/../../db.rt_rate_component.php");
require_once(__DIR__ . "/../../db.rt_rate_comp_grp.php");


if (!function_exists('json_encode')) {
	function json_encode($a=false) {
		if (is_null($a)) return 'null';
		if ($a === false) return 'false';
		if ($a === true) return 'true';
		if (is_scalar($a)) {
			if (is_float($a)) {
				// Always use "." for floats.
				return floatval(str_replace(",", ".", strval($a)));
			}
			if (is_string($a)) {
				static $jsonReplaces = array(array("\\", "/", "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
				return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
			} else {
				return $a;
			}
		}
		$isList = true;
		for ($i = 0, reset($a); $i < count($a); $i++, next($a)) {
			if (key($a) !== $i) {
				$isList = false;
				break;
			}
		}
		$result = array();
		if ($isList) {
			foreach ($a as $v) $result[] = json_encode($v);
			return '[' . join(',', $result) . ']';
		} else {
			foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
			return '{' . join(',', $result) . '}';
		}
	}
}

function createlogfile($filename){
	$handle = fopen(__DIR__ . "/" . $filename, 'w');

	fclose($handle);
}

function writelog($filename, $message){
	$timestamp = date("Y-m-d H:i:s");
	$handle = fopen(__DIR__ . "/" . $filename, 'a');
	fwrite($handle, "[$timestamp] ".$message ."\n");
	fclose($handle);

}

function flush_buffers(){ 
	ob_end_flush(); 
	ob_flush(); 
	flush(); 
	ob_start(); 
} 


function add_component(){

	global $lDB, $dataset;
	$count = 0;

	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();

		// Check if rate component already exists
		$rt_rate_component_id = $lDB->get("
			SELECT 
				rt_rate_component_ix
			FROM 
				rt_rate_component 
			WHERE 
				rt_rate_id = '".$rt_rate_id."' AND rt_component_id = '".$dataset['input_new_component_id']."'
		",4);

		if (empty($rt_rate_component_id)){
			$rt_rate_component_id = rt_rate_component_insert(
				$rt_rate_id, 
				$dataset['input_new_component_id'], 
				$dataset['input_new_component_optional'], 
				$dataset['input_new_component_default'], 
				$dataset['input_new_component_commissionable'], 
				$dataset['input_new_component_frequency'], 
				$dataset['input_new_component_hash'], 
				$dataset['input_new_component_separate'], 
				$dataset['input_new_component_tax_ind'], 
				$dataset['input_new_component_tax_id']
			);


			writelog("output.txt", "Rate: $rt_rate_id - Added component");
		} else {
			writelog("output.txt", "Rate: $rt_rate_id - New component already exists.");
		}


		// Now add the component splits


		// Get one of the other components to base the new component split on
		$baseComponentID = $lDB->get("
			SELECT 
				DISTINCT(rt_rate_component.rt_component_id)
			FROM
				rt_rate_component
				INNER JOIN rt_rate_comp_grp ON rt_rate_comp_grp.rt_rate_component_id = rt_rate_component.rt_rate_component_ix
			WHERE
				rt_rate_component.rt_rate_id = '$rt_rate_id'
			LIMIT 1;
		",4);

		// Now update the component splits
		$rateCompSplits = array();
		$rateComponents = getRateComponents($rt_rate_id);
		$rateCompGroupHeaders = getRateComponentGroupHeaders($rt_rate_id);
		foreach ($rateComponents as $rc) {
			foreach ($rateCompGroupHeaders as $key => $rateCompGroupHeader){
				$rateCompSplits[$rc['rt_component_id']][$rateCompGroupHeader['rt_rate_group_ix']] = getRateComponentSplit($rc['rt_rate_component_ix'], $rateCompGroupHeader['rt_rate_group_ix']);
				$rateCompSplits[$rc['rt_component_id']][$rateCompGroupHeader['rt_rate_group_ix']]['rt_rate_component_ix'] = $rc['rt_rate_component_ix'];
				
			}

			// Delete all old ones
			$oldRateCompGroups = $GLOBALS['lDB']->get("
				SELECT rt_rate_comp_grp_ix FROM rt_rate_comp_grp WHERE rt_rate_component_id = '".$rc['rt_rate_component_ix']."'
			",2);
			foreach($oldRateCompGroups as $oldRateCompGroup){
				rt_rate_comp_grp_delete($oldRateCompGroup['rt_rate_comp_grp_ix']);
			}

		}

		if (empty($baseComponentID) || !array_key_exists($baseComponentID,$rateCompSplits)){
			debug("Oops ".$rt_rate_id);
		}

		if (!empty($rateCompSplits[$baseComponentID])) {
			foreach ($rateCompSplits[$baseComponentID] as $baseRateGroupID => $baseRateGroup){
				if (in_array($baseRateGroupID,$dataset['input_new_component_rate_groups'])){
					if ($dataset['input_new_component_split_sel'] == "fixed"){
						$amount = $dataset['input_new_component_split_amt'];
						$percentage = 0.00;
					} else {
						$amount = 0.00;
						$percentage = $dataset['input_new_component_split_perc'];;
					}
					
				} else {
					if (isset($rateCompSplits[$dataset['input_new_component_id']][$baseRateGroupID]['rt_rate_comp_amt']) && $rateCompSplits[$dataset['input_new_component_id']][$baseRateGroupID]['rt_rate_comp_amt'] != 0){
						$amount = $rateCompSplits[$dataset['input_new_component_id']][$baseRateGroupID]['rt_rate_comp_amt'];
						$percentage = $rateCompSplits[$dataset['input_new_component_id']][$baseRateGroupID]['rt_rate_comp_perc'];
					} else {
						$amount = 0;
						$percentage = 0.00;
					}
					
				}
				$rateCompSplits[$dataset['input_new_component_id']][$baseRateGroupID] = array(
					"rt_rate_comp_amt" => $amount,
					"rt_rate_comp_perc" => $percentage,
					"rt_rate_comp_grp_comm_yn" => $baseRateGroup['rt_rate_comp_grp_comm_yn'],
					"rt_rate_comp_grp_seq" => $baseRateGroup['rt_rate_comp_grp_seq'],
					"rt_rate_component_ix" => $rt_rate_component_id
				);

			}
		}

		foreach ($rateCompSplits as $componentID => $rateCompSplit){
			foreach($rateCompSplit as $rateGroupID => $item){
				// rt_rate_comp_grp_insert($rt_rate_component_id, $rt_rate_group_id, $rt_rate_comp_amt=0, $rt_rate_comp_perc=0, $rt_rate_comp_grp_comm_yn=false, $rt_rate_comp_grp_seq=0) {
				rt_rate_comp_grp_insert($item['rt_rate_component_ix'], $rateGroupID, $item['rt_rate_comp_amt'], $item['rt_rate_comp_perc'], $item['rt_rate_comp_grp_comm_yn'], $item['rt_rate_comp_grp_seq']);
			}
			
		}	

		writelog("output.txt", "Rate: $rt_rate_id - Component splits updated.");

		$count++;

	
	}

}

function del_component(){

	global $lDB, $dataset;
	$count = 0;

	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();
		$safe_to_delete = true;
		// Check if rate component already exists
		$rt_rate_component_id = $lDB->get("
			SELECT 
				rt_rate_component_ix
			FROM 
				rt_rate_component 
			WHERE 
				rt_rate_id = '".$rt_rate_id."' AND rt_component_id = '".$dataset['input_del_component_id']."'
		",4);

		if (empty($rt_rate_component_id)){
			writelog("output.txt", "Rate: $rt_rate_id - Component doesn't exist.  Cannot delete.");
		} else {


			// Check that this isn't the last component on the rate
			$total_comps = $lDB->get("
				SELECT 
					rt_rate_component_ix
				FROM 
					rt_rate_component 
				WHERE 
					rt_rate_id = '".$rt_rate_id."'
			",3);

			if (count($total_comps) == 1){
					writelog("output.txt", "Rate: $rt_rate_id - Cannot delete this component as it is the only component on the rate.");
					$safe_to_delete = false;
			}


			// Make sure we're not dealing with a percentage split.  Deleting these would break the rate integrity.
			// UPDATE: We're allowing this now
			// foreach ($oldRateCompGroups as $oldRateCompGroup){
			// 	if ($oldRateCompGroup['rt_rate_comp_perc'] > 0){
			// 		writelog("output.txt", "Rate: $rt_rate_id - Cannot delete this component as it has percentage split.");
			// 		$safe_to_delete = false;
			// 		break;
			// 	}
			// }

			if ($safe_to_delete === true){

				// First delete the component splits
				$oldRateCompGroups = $lDB->get("
					SELECT 
						rt_rate_comp_grp_ix,
						rt_rate_comp_amt,
						rt_rate_comp_perc
					FROM 
						rt_rate_comp_grp 
					WHERE 
						rt_rate_component_id = '".$rt_rate_component_id."'
				",2);
				
				foreach($oldRateCompGroups as $oldRateCompGroup){
					rt_rate_comp_grp_delete($oldRateCompGroup['rt_rate_comp_grp_ix']);
				}
				writelog("output.txt", "Rate: $rt_rate_id - Deleted component rate group splits.");

				// Now delete the component
				rt_rate_component_delete($rt_rate_component_id);
				writelog("output.txt", "Rate: $rt_rate_id - Deleted component.");
			}
			
		}

		$count++;
	
	}

}

function edit_components() {
	$component_columuns = array(
		0 => "rt_comp_opt_yn",
		1 => "rt_comp_opt_def_yn",
		2 => "rt_comp_comm_yn",
		3 => "rt_comp_freq_ind",
		4 => "rt_comp_freq_factor",
		5 => "rt_comp_separate_yn",
		6 => "rt_tax_id",
		7 => "rt_tax_id"
	);
	global $lDB, $dataset;

	foreach ($dataset['rates'] as $rt_rate_id) {
		flush_buffers();
		$counter = 0;
		foreach ($dataset['input_edit_component_id'] as $component_id) {
			// Check if rate component already exists
			$rt_rate_component = $lDB->get("
				SELECT 
					rt_rate_component.rt_tax_ind,
					rt_rate_component.rt_tax_id,
					rt_rate_component.rt_rate_component_ix,
					rt_rate_component.rt_component_id,
					rt_rate_component.rt_comp_opt_yn,
					rt_rate_component.rt_comp_opt_def_yn,
					rt_rate_component.rt_comp_comm_yn,
					rt_rate_component.rt_comp_freq_ind,
					rt_rate_component.rt_comp_freq_factor,
					rt_rate_component.rt_comp_separate_yn,
					rt_component.rt_component_desc
				FROM 
					rt_rate_component
			   INNER JOIN rt_component ON rt_component.rt_component_ix = rt_rate_component.rt_component_id
			 WHERE 
					rt_rate_id = '".$rt_rate_id."' AND rt_rate_component.rt_component_id = '$component_id'
				",1);

			if (empty($rt_rate_component)){
				writelog("output.txt", "Rate: $rt_rate_id - Component doesn't exist.  Cannot edit.");
			} else {
				$can_update_component = true;
				$field_column = $component_columuns[$dataset['input_edit_component_field'][$counter]];
				$filter_value = $dataset['input_edit_component_filter_value'][$counter];
				$new_value = $dataset['input_edit_component_new_value'][$counter];
				if (in_array($dataset['input_edit_component_field'][$counter], array("6", "7"))) {
					$rt_tax_ind = ($dataset['input_edit_component_field'][$counter] == "6" ? "10" : "20");
				} else {
					$rt_tax_ind = $rt_rate_component["rt_tax_ind"];
				}
				// If the filter value is set, check to see if the rate component's currenty
				// value is equal to it, if not - it can be updated
				if ($dataset['input_edit_component_filter_value'][$counter] != "-1") {
					// For tax fields compare both rt_tax_ind and rt_tax_id fields
					if (in_array($dataset['input_edit_component_field'][$counter], array("6", "7"))) {
						$rt_tax_ind = ($dataset['input_edit_component_field'][$counter] == "6" ? "10" : "20");
						if (!($rt_rate_component[$field_column] == $filter_value && $rt_tax_ind == $rt_rate_component["rt_tax_ind"])) {
							// the filter value is not the same as the current value or they aren't both of the same tax_ind type
							$can_update_component = false;
						}
					} elseif ($rt_rate_component[$field_column] != $filter_value) {
						$can_update_component = false;
					}
				}
				if ($can_update_component) {
					/*
					print_r("<pre>");
					var_dump($field_column);
					var_dump($filter_value);
					var_dump($new_value);
					var_dump($rt_tax_ind);
					var_dump($rt_rate_component['rt_component_desc']);
					var_dump($rt_rate_component['rt_tax_id']);
					var_dump(($field_column == "rt_tax_id" ? $new_value : $rt_rate_component['rt_tax_id']));
					print_r("</pre>");
					 */
					rt_rate_component_update(
						$rt_rate_component['rt_rate_component_ix'], 
						$rt_rate_component['rt_component_id'],
						($field_column == "rt_comp_opt_yn" ? $new_value : $rt_rate_component['rt_comp_opt_yn']),
						($field_column == "rt_comp_opt_def_yn" ? $new_value : $rt_rate_component['rt_comp_opt_def_yn']),
						($field_column == "rt_comp_comm_yn" ? $new_value : $rt_rate_component['rt_comp_comm_yn']),
						($field_column == "rt_comp_freq_ind" ? $new_value : $rt_rate_component['rt_comp_freq_ind']),
						($field_column == "rt_comp_freq_factor" ? $new_value : $rt_rate_component['rt_comp_freq_factor']),
						($field_column == "rt_comp_separate_yn" ? $new_value : $rt_rate_component['rt_comp_separate_yn']),
						$rt_tax_ind,
						($field_column == "rt_tax_id" ? $new_value : $rt_rate_component['rt_tax_id'])
					);

					$logOutput = "Rate: $rt_rate_id - Edited component - " . $rt_rate_component['rt_rate_component_ix'] . ".";
					writelog("output.txt", $logOutput);
					unset($logOutput);
				}
			}
			$counter += 1;
		}
	}
}

function edit_components_split() {
	global $lDB, $dataset;

	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();


		$rt_component_desc = $lDB->get("
			SELECT
				rt_component.rt_component_desc
			FROM
				rt_component
			WHERE 
				rt_component.rt_component_ix = '".$dataset['input_edit_component_id_split'][0]."'
		",4);

		$rt_rate_component_ids = $lDB->get("
			SELECT
				rt_rate_component_ix
			FROM
				rt_rate_component
				LEFT JOIN rt_rate ON rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix
			WHERE
				rt_component_id = '".$dataset['input_edit_component_id_split'][0]."'
				AND rt_rate.rt_rate_ix = '".$rt_rate_id."'
		",3);

		$rt_rate_comp_grp_ids = $lDB->get("
			SELECT
				rt_rate_comp_grp.rt_rate_comp_grp_ix,
				rt_rate_comp_grp.rt_rate_group_id
			FROM
				rt_rate_comp_grp
				LEFT JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
				LEFT JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
				LEFT JOIN rt_rate ON rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix
			WHERE
				rt_rate_comp_grp.rt_rate_component_id IN ('".join("','",$rt_rate_component_ids)."')
				AND rt_rate_comp_grp.rt_rate_group_id IN ('".join("','",$dataset['input_amounts_rate_groups_split'])."')
				AND rt_rate.rt_rate_ix = '".$rt_rate_id."'
		",2);

		foreach ($rt_rate_comp_grp_ids as $rt_rate_comp_grp) {
			$rate_details = $lDB->get("
				SELECT
					rt_rate_group.rt_rate_group_desc,
					ac_accomm_type.ac_accomm_desc,
					rt_period.rt_period_desc,
					rt_rate_type.rt_rate_type_desc
				FROM
					rt_rate_comp_grp
					LEFT JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
					LEFT JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
					LEFT JOIN rt_rate ON rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix
					LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
					LEFT JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
					LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
				WHERE
					rt_rate_comp_grp.rt_rate_comp_grp_ix = '".$rt_rate_comp_grp['rt_rate_comp_grp_ix']."'
			",1);

			if ($dataset['input_amounts_sel_split'] == "fixed"){
				$lDB->put("
					UPDATE
						rt_rate_comp_grp
					SET
						rt_rate_comp_amt = '".$dataset['input_amounts_fixed_split']."',
						rt_rate_comp_perc = '0',
						rt_rate_comp_val_ind = '1'
					WHERE
						rt_rate_comp_grp.rt_rate_comp_grp_ix = '".$rt_rate_comp_grp['rt_rate_comp_grp_ix']."';
				");
				writelog("output.txt", "Component '".$rt_component_desc."', Rate group '".$rate_details['rt_rate_group_desc']."' (".$rate_details['ac_accomm_desc'].", ".$rate_details['rt_period_desc'].", ".$rate_details['rt_rate_type_desc']."): Rate split amount set to ".$dataset['input_amounts_fixed_split']);
			} else {
				$lDB->put("
					UPDATE
						rt_rate_comp_grp
					SET
						rt_rate_comp_amt = '0',
						rt_rate_comp_perc = '".$dataset['input_amounts_percentage_split']."',
						rt_rate_comp_val_ind = '2'
					WHERE
						rt_rate_comp_grp.rt_rate_comp_grp_ix = '".$rt_rate_comp_grp['rt_rate_comp_grp_ix']."';
				");
				writelog("output.txt", "Component '".$rt_component_desc."', Rate group '".$rate_details['rt_rate_group_desc']."' (".$rate_details['ac_accomm_desc'].", ".$rate_details['rt_period_desc'].", ".$rate_details['rt_rate_type_desc']."): Rate split percentage set to ".$dataset['input_amounts_percentage_split']."%");
			}
		}
	}

}

function adjust_amounts(){

	global $lDB, $dataset;
	$count = 0;
	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();

		//$dataset['input_amounts_rate_group_quantity'];
		$rateGroupAmts = getRateGroupAmts($rt_rate_id);
		$amountRateGroupQuantities = array();
		if ($dataset['input_amounts_rate_group_quantity'] == "all") {
			foreach ($rateGroupAmts as $rateGroupAmt){
				$amountRateGroupQuantities[] = $rateGroupAmt['rt_rate_grp_amt_qty'];
			}
		} else {
			$amountRateGroupQuantities[] = $dataset['input_amounts_rate_group_quantity'];
		}

		$inputs = array();
		foreach ($rateGroupAmts as $rateGroupAmt){
			if ($rateGroupAmt['rt_rate_grp_amt_qty'] == 0){
				$actual_qty = 1;
			} else {
				$actual_qty = $rateGroupAmt['rt_rate_grp_amt_qty'];
			}

			if (in_array($rateGroupAmt['rt_rate_group_ix'],$dataset['input_amounts_rate_groups']) && in_array($rateGroupAmt['rt_rate_grp_amt_qty'],$amountRateGroupQuantities)){
				if ($dataset['input_amounts_sel'] == "fixed"){
					$inputs[$rateGroupAmt['rt_rate_grp_amt_qty']][$rateGroupAmt['rt_rate_group_ix']] = $rateGroupAmt['rateGroupTotal'] + ($actual_qty * $dataset['input_amounts_fixed']);	
				} else {
					$inputs[$rateGroupAmt['rt_rate_grp_amt_qty']][$rateGroupAmt['rt_rate_group_ix']] = $rateGroupAmt['rateGroupTotal'] * ((100 + $dataset['input_amounts_percentage']) / 100);
				}
				
			} else {
				// Keep the same
				$inputs[$rateGroupAmt['rt_rate_grp_amt_qty']][$rateGroupAmt['rt_rate_group_ix']] = $rateGroupAmt['rateGroupTotal'];	
			}
		}

		if (sizeof($inputs) > 0){
			foreach ($inputs as $rt_rate_grp_amt_qty => $input){ 
				rt_rate_grp_amt_delete_by_rate($rt_rate_id, $rt_rate_grp_amt_qty);
				foreach ($input as $rt_rate_group_id => $rt_rate_grp_amt_amount){
					if (is_numeric($rt_rate_grp_amt_amount)){
						rt_rate_grp_amt_insert($rt_rate_id, $rt_rate_group_id, $rt_rate_grp_amt_qty, $rt_rate_grp_amt_amount);
					}
				}						
			}

			writelog("output.txt", "Rate: $rt_rate_id - Rate amounts adjusted.");
		}


	}
}

function round_amounts(){

	global $lDB, $dataset;
	$count = 0;
	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();

		$rateGroupAmts = getRateGroupAmts($rt_rate_id);

		if ($dataset['input_round_direction'] == "Up"){
			$rnddir = 1;
		} else {
			$rnddir = 2;
		}

		$inputs = array();
		foreach ($rateGroupAmts as $rateGroupAmt){
			if ($rateGroupAmt['rt_rate_grp_amt_qty'] == 0){
				$actual_qty = 1;
			} else {
				$actual_qty = $rateGroupAmt['rt_rate_grp_amt_qty'];
			}

			if (in_array($rateGroupAmt['rt_rate_group_ix'],$dataset['input_round_rate_groups'])){
				$inputs[$rateGroupAmt['rt_rate_grp_amt_qty']][$rateGroupAmt['rt_rate_group_ix']] = calculateRoundedValue($rateGroupAmt['rateGroupTotal'], $rnddir, $dataset['input_round_precision']);	
				// writelog("output.txt", $rateGroupAmt['rateGroupTotal']." becomes ".$inputs[$rateGroupAmt['rt_rate_grp_amt_qty']][$rateGroupAmt['rt_rate_group_ix']]);
			} else {
				// Keep the same
				$inputs[$rateGroupAmt['rt_rate_grp_amt_qty']][$rateGroupAmt['rt_rate_group_ix']] = $rateGroupAmt['rateGroupTotal'];	
			}

			
		}

	

		if (sizeof($inputs) > 0){
			foreach ($inputs as $rt_rate_grp_amt_qty => $input){ 
				rt_rate_grp_amt_delete_by_rate($rt_rate_id, $rt_rate_grp_amt_qty);
				foreach ($input as $rt_rate_group_id => $rt_rate_grp_amt_amount){
					if (is_numeric($rt_rate_grp_amt_amount)){
						rt_rate_grp_amt_insert($rt_rate_id, $rt_rate_group_id, $rt_rate_grp_amt_qty, $rt_rate_grp_amt_amount);
					}
				}						
			}

			writelog("output.txt", "Rate: $rt_rate_id - Rate amounts rounded.");
		}


	}
}

function copy_amounts() {
	global $lDB, $dataset;
	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();
		$counter = 0;
		foreach ($dataset['input_copy_rate_group_dest_id'] as $rate_group_dest_id) {
			$rt_rate_grp_amt = $lDB->get("
				SELECT
					rt_rate_grp_amt.*
				FROM
					rt_rate_grp_amt
				WHERE
					rt_rate_grp_amt.rt_rate_id = '" . $rt_rate_id . "'
					AND rt_rate_grp_amt.rt_rate_group_id = '" . $dataset['input_copy_rate_group_source_id'] . "'
					AND rt_rate_grp_amt.rt_rate_grp_amt_qty = '" . $dataset['input_copy_rate_group_source_quantity'] . "'
			",1);
			$rate_group_dest_quantity = $dataset['input_copy_rate_group_dest_quantity'][$counter];
			$rt_rate_group_exists = $lDB->get("
				SELECT
					rt_rate_comp_grp.rt_rate_comp_grp_ix
				FROM
					rt_rate_component
					INNER JOIN rt_rate_comp_grp ON rt_rate_comp_grp.rt_rate_component_id = rt_rate_component.rt_rate_component_ix
					INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
				WHERE
					rt_rate_component.rt_rate_id = '$rt_rate_id'
					AND rt_rate_comp_grp.rt_rate_group_id = '$rate_group_dest_id'
			",4);
			if ($rt_rate_group_exists) {
				$rt_rate_grp_amt_dest_ix =  $lDB->get("
					SELECT
						rt_rate_grp_amt_ix
					FROM
						rt_rate_grp_amt
					WHERE
						rt_rate_id = '$rt_rate_id'
						AND rt_rate_group_id = '$rate_group_dest_id'
						AND rt_rate_grp_amt_qty = '$rate_group_dest_quantity'
				",4);
				rt_rate_grp_amt_delete($rt_rate_grp_amt_dest_ix);
				rt_rate_grp_amt_insert($rt_rate_id, $rate_group_dest_id, $rate_group_dest_quantity, $rt_rate_grp_amt['rt_rate_grp_amt_amount']);
			}
			$counter += 1;
		}

		writelog("output.txt", "Rate: $rt_rate_id - Rate amounts copied.");
	}
}

function add_rate_group() {
	global $lDB, $dataset;
	foreach ($dataset['rates'] as $rt_rate_id){
		flush_buffers();
		$rt_rate_components = $lDB->get("
			SELECT
				rt_rate_component.rt_rate_component_ix
			FROM
				rt_rate_component
			WHERE
				rt_rate_component.rt_rate_id = '$rt_rate_id'
			ORDER BY
				rt_rate_component.rt_rate_component_id ASC
		",2);
		foreach ($rt_rate_components as $rt_rate_component) {
			$rt_rate_group_exists = $lDB->get("
				SELECT
					rt_rate_comp_grp.rt_rate_comp_grp_ix
				FROM
					rt_rate_component
					INNER JOIN rt_rate_comp_grp ON rt_rate_comp_grp.rt_rate_component_id = rt_rate_component.rt_rate_component_ix
					INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
				WHERE
					rt_rate_component.rt_rate_id = '$rt_rate_id'
					AND rt_rate_comp_grp.rt_rate_group_id = '".$dataset['input_add_rate_group_id']."'
			",4);
			if (empty($rt_rate_group_exists)) {
				// Add new component
				$max_rt_rate_comp_grp_sequence =  $lDB->get("
					SELECT
						MAX(rt_rate_comp_grp_seq)
					FROM
						rt_rate_comp_grp
					WHERE
						rt_rate_component_id = '".$rt_rate_component['rt_rate_component_ix']."'
				",4);
				$sequence_number = $dataset['input_add_rate_group_position'] == "" || empty($dataset['input_add_rate_group_position']) ? $max_rt_rate_comp_grp_sequence + 1 : $dataset['input_add_rate_group_position'];
				$rt_rate_comp_grp_id = rt_rate_comp_grp_insert(
					$rt_rate_component['rt_rate_component_ix'], 
					$dataset['input_add_rate_group_id'], 
					0, 
					0, 
					false, 
					$sequence_number
				);
				writelog("output.txt", "Rate: $rt_rate_id - Rate group ". $dataset['input_add_rate_group_id'] ." added.");
			}
		}

		// Fix the sequence
		if ($dataset['input_add_rate_group_position'] > 0 && !empty($dataset['input_add_rate_group_position'])) {
			foreach ($rt_rate_components as $rt_rate_component) {
				$rt_rate_group_exists = $lDB->get("
					SELECT
						rt_rate_comp_grp.rt_rate_comp_grp_ix
					FROM
						rt_rate_component
						INNER JOIN rt_rate_comp_grp ON rt_rate_comp_grp.rt_rate_component_id = rt_rate_component.rt_rate_component_ix
						INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id
					WHERE
						rt_rate_component.rt_rate_id = '$rt_rate_id'
						AND rt_rate_comp_grp.rt_rate_group_id = '".$dataset['input_add_rate_group_id']."'
				",4);
				if ($rt_rate_group_exists) {
					$max_rt_rate_comp_grp_sequence =  $lDB->get("
						SELECT
							MAX(rt_rate_comp_grp_seq)
						FROM
							rt_rate_comp_grp
						WHERE
							rt_rate_component_id = '".$rt_rate_component['rt_rate_component_ix']."'
					",4);
					$sequence_components = $lDB->get("
						SELECT 
							rt_rate_comp_grp.rt_rate_comp_grp_ix,
							rt_rate_comp_grp.rt_rate_comp_grp_seq
						FROM
							rt_rate_comp_grp
						WHERE 
							rt_rate_comp_grp.rt_rate_component_id = '".$rt_rate_component['rt_rate_component_ix']."'
							AND rt_rate_comp_grp.rt_rate_comp_grp_seq >= ".$dataset['input_add_rate_group_position']."
							AND rt_rate_comp_grp.rt_rate_group_id != '".$dataset['input_add_rate_group_id']."'
					",2);
					foreach ($sequence_components as $sequence_component) {
						$new_sequence = $sequence_component['rt_rate_comp_grp_seq'] + 1;
						$lDB->put("
							UPDATE
								rt_rate_comp_grp
							SET
								rt_rate_comp_grp.rt_rate_comp_grp_seq = $new_sequence
							WHERE
								rt_rate_comp_grp.rt_rate_comp_grp_ix = '".$sequence_component['rt_rate_comp_grp_ix']."'
						");	
					}
				}
			}
		}
	}
}

function calculateRoundedValue($value,$rnddir,$scale){

	switch($rnddir){
	case 0; // Default
		$value = ((int) (ceil($value/$scale))) * $scale;
		break;
	case 1: // Up
		$value = ((int) (ceil($value/$scale))) * $scale;
		break;
	case 2: // Down
		$value = ((int) ($value/$scale)) * $scale;
		break;
	}

	return $value;

}
