<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();
// Disable PHP time limit
set_time_limit(0);

$versionDir = "../.."; // Override the location to look for the .ver file


require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/functions.php'); 

if (!isset($_SESSION['ratetoolloggedin'])) {
	redirect("/utils/rate_edit_gen/login.php");
}

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

function redirect($url){
	redirectTo("".$url);
}

/* Test if user is internal */
if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

$loggedInUserId = $lDB->get("
			SELECT
				pr_user_id
			FROM
				pr_user
			WHERE 
				pr_user_name = 'censysad'
		",4);
if($GLOBALS['userid'] != $loggedInUserId) {
	redirect("/reservation.php");
	die();
}

// Set to master
$GLOBALS['lDB']->isMaster = "1";
$GLOBALS['debugEcho'] = true;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing

function printComponentFieldValue($fieldId, $fieldValue) {
	$fieldText = "";
	switch ($fieldId){
	case "0":
		$fieldText = ($fieldValue == 1) ? "Yes" : "No";
		break;
	case "1":
		$fieldText = ($fieldValue == 1) ? "Yes" : "No";
		break;
	case "2":
		switch ($fieldValue){
		case "0":
			$fieldText = "Not Commissionable";
			break;
		case "1":
			$fieldText = "Calculate";
			break;
		case "2":
			$fieldText = "Calc & deduct";
			break;
		case "3":
			$fieldText = "Calc & deduct All";
			break;
		}
		break;
	case "3":
		$fieldText = ($fieldValue == 1) ? "Per Night" : "Per Stay";
		break;
	case "4":
		$fieldText = $fieldValue;
		break;
	case "5":
		$fieldText = ($fieldValue == 1) ? "Yes" : "No";
		break;
	case "6":
		$tax_desc = $GLOBALS['lDB']->get("
			SELECT
				rf_tax_rate.rf_tax_rate_desc
			FROM
				rf_tax_rate
			WHERE 
				rf_tax_rate.rf_tax_rate_ix = '$fieldValue'
		",4);
		$fieldText = $tax_desc;
		break;
	case "7":
		$tax_desc = $GLOBALS['lDB']->get("
			SELECT
				rt_tax_group.rt_tax_group_desc
			FROM
				rt_tax_group
			WHERE 
				rt_tax_group.rt_tax_group_ix = '$fieldValue'
		",4);
		$fieldText = $tax_desc;
		break;
	}
	return $fieldText;
}


// Period list
$periods = $lDB->get("
	SELECT
		rt_period.rt_period_ix,
		rt_period.rt_period_desc,
		rt_period.rt_period_inactive_yn
	FROM
		rt_period
	ORDER BY
		rt_period.rt_period_desc ASC
",2);

$periods_html = "";
foreach ($periods as $period){
	if ($period['rt_period_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$periods_html .= "<option $style value=\"".$period['rt_period_ix']."\">".$period['rt_period_desc'].$active."</option>";
}


// Accommodation type list
$accomm_types = $lDB->get("
	SELECT
		ac_accomm_type.ac_accomm_type_ix,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_type.ac_accomm_type_inactive_yn,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	ORDER BY
		pr_persona.pr_name_last ASC,
		ac_accomm_type.ac_accomm_desc ASC
",2);

$accomm_types_html = "";
foreach ($accomm_types as $accomm_type){
	if ($accomm_type['ac_accomm_type_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$accomm_types_html .= "<option $style value=\"".$accomm_type['ac_accomm_type_ix']."\">".$accomm_type['pr_name_last']." - ".$accomm_type['ac_accomm_desc'].$active."</option>";
}

// Rate type list
$rate_types = $lDB->get("
	SELECT
		rt_rate_type.rt_rate_type_ix,
		rt_rate_type.rt_rate_type_desc,
		rt_rate_type.rt_rate_type_inactive_yn
	FROM
		rt_rate_type
	ORDER BY
		rt_rate_type.rt_rate_type_desc ASC
",2);

$rate_types_html = "";
foreach ($rate_types as $rate_type){
	if ($rate_type['rt_rate_type_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$rate_types_html .= "<option $style value=\"".$rate_type['rt_rate_type_ix']."\">".$rate_type['rt_rate_type_desc'].$active."</option>";
}

// Components
$components = $lDB->get("
	SELECT
		rt_component.rt_component_ix,
		rt_component.rt_component_desc,
		rt_component.rt_component_inactive_yn
	FROM
		rt_component
	ORDER BY
		rt_component.rt_component_desc ASC
",2);

$components_html = "";
foreach ($components as $component){
	if ($component['rt_component_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$components_html .= "<option $style value=\"".$component['rt_component_ix']."\">".$component['rt_component_desc'].$active."</option>";
}

// Tax rates
$tax_rates = $lDB->get("
	SELECT
		rf_tax_rate.rf_tax_rate_ix,
		rf_tax_rate.rf_tax_rate_desc,
		rf_tax_rate.rf_tax_rate_inactive_yn
	FROM
		rf_tax_rate
	ORDER BY
		rf_tax_rate.rf_tax_rate_desc ASC
",2);

$tax_rates_html = "";
foreach ($tax_rates as $tax_rate){
	if ($tax_rate['rf_tax_rate_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$tax_rates_html .= "<option $style value=\"".$tax_rate['rf_tax_rate_ix']."\">".$tax_rate['rf_tax_rate_desc'].$active."</option>";
}

// Tax groups
$tax_groups = $lDB->get("
	SELECT
		rt_tax_group.rt_tax_group_ix,
		rt_tax_group.rt_tax_group_desc,
		rt_tax_group.rt_tax_group_inactive_yn
	FROM
		rt_tax_group
	ORDER BY
		rt_tax_group.rt_tax_group_desc ASC
",2);

$tax_groups_html = "";
foreach ($tax_groups as $tax_group){
	if ($tax_group['rt_tax_group_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$tax_groups_html .= "<option $style value=\"".$tax_group['rt_tax_group_ix']."\">".$tax_group['rt_tax_group_desc'].$active."</option>";
}

// Rate groups
$rate_groups = $lDB->get("
	SELECT
		rt_rate_group.rt_rate_group_ix,
		rt_rate_group.rt_rate_group_desc,
		rt_rate_group.rt_rate_group_inactive_yn
	FROM
		rt_rate_group
	ORDER BY
		rt_rate_group.rt_rate_group_desc ASC
",2);

$rate_groups_html = "";
foreach ($rate_groups as $rate_group){
	if ($rate_group['rt_rate_group_inactive_yn'] != 0){
		$active = " *";
		$style = " style='font-style: italic; color: silver;'";
	} else {
		$active = "";
		$style = "";
	}
	$rate_groups_html .= "<option $style value=\"".$rate_group['rt_rate_group_ix']."\">".$rate_group['rt_rate_group_desc'].$active."</option>";
}

// Rate group amounts
$rate_group_amounts = $lDB->get("
	SELECT DISTINCT
		rt_rate_grp_amt.rt_rate_grp_amt_qty,
		CASE rt_rate_grp_amt.rt_rate_grp_amt_qty
			WHEN '0' THEN '1 Sharing'
			WHEN '1' THEN '1 Single'
			ELSE rt_rate_grp_amt.rt_rate_grp_amt_qty
		END AS quantity_label
	FROM
		rt_rate_grp_amt
	ORDER BY
		rt_rate_grp_amt.rt_rate_grp_amt_qty ASC
",2);

$rate_group_amounts_html = "";
foreach ($rate_group_amounts as $rate_group_amount){
	$active = "";
	$style = "";
	$rate_group_amounts_html .= "<option $style value=\"".$rate_group_amount['rt_rate_grp_amt_qty']."\">".$rate_group_amount['quantity_label'].$active."</option>";
}

// Component edit
$component_fields = array(
	0 => "Optional",
	1 => "Default",
	2 => "Commissionable",
	3 => "Frequency",
	4 => "#",
	5 => "Seperate",
	6 => "Tax rate",
	7 => "Tax group"
);
$component_fields_html = "";
foreach ($component_fields as $key=>$component_field){
	$active = "";
	$style = "";
	$component_fields_html .= "<option $style value=\"".$key."\">".$component_field.$active."</option>";
}

if (!empty($_POST)){
	
	$output_log = array();

	switch ($_POST['action']){
	case "1":  // Staging
		// First, lets get all the rates we're changing
		if ((isset($_POST['input_from_date']) && preg_match("/\d{4}-\d{2}-\d{2}/",$_POST['input_from_date']) || !empty($_POST['input_periods'])) && !empty($_POST['input_accomm_types']) && !empty($_POST['input_rate_types'])){
			if (isset($_POST['input_from_date'])){
				$_SESSION['rate_edit_data']['input_from_date'] = $_POST['input_from_date'];	
				$date_where = "
					( 
						(
							rt_period_dates.rt_period_from >= '".$_SESSION['rate_edit_data']['input_from_date']."'
							AND rt_period_dates.rt_period_from <= '2030-12-31'
						) OR (
							rt_period_dates.rt_period_to >= '".$_SESSION['rate_edit_data']['input_from_date']."'
							AND rt_period_dates.rt_period_to <= '2030-12-31'
						) OR (
							rt_period_dates.rt_period_from <= '".$_SESSION['rate_edit_data']['input_from_date']."'
							AND rt_period_dates.rt_period_to >= '2030-12-31'
						)
					)
				";
			} else {
				$_SESSION['rate_edit_data']['input_periods'] = $_POST['input_periods'];
				$date_where = "
					rt_rate.rt_period_id IN ('".join("','",$_POST['input_periods'])."')
				";				
			}
			
			$_SESSION['rate_edit_data']['rates'] = $lDB->get("
				SELECT
					DISTINCT rt_rate.rt_rate_ix
				FROM
					rt_rate
					INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
					INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
				WHERE
					$date_where
					AND rt_rate.rt_rate_type_id IN ('".join("','",$_POST['input_rate_types'])."')
					AND rt_rate.ac_accomm_type_id IN ('".join("','",$_POST['input_accomm_types'])."')
			",3);

			$_SESSION['rate_edit_data']['input_accomm_types'] = $_POST['input_accomm_types'];
			$_SESSION['rate_edit_data']['input_rate_types'] = $_POST['input_rate_types'];


			if (isset($_POST['input_flag_for_transfer'])){
				$_SESSION['rate_edit_data']['input_flag_for_transfer'] = $_POST['input_flag_for_transfer'];
			};

			// New component
			if (isset($_POST['input_add_component'])){
				$_SESSION['rate_edit_data']['input_add_component'] = $_POST['input_add_component'];
				$_SESSION['rate_edit_data']['input_new_component_id'] = $_POST['input_new_component_id'];
				$_SESSION['rate_edit_data']['input_new_component_optional'] = $_POST['input_new_component_optional'];
				$_SESSION['rate_edit_data']['input_new_component_default'] = $_POST['input_new_component_default'];
				$_SESSION['rate_edit_data']['input_new_component_commissionable'] = $_POST['input_new_component_commissionable'];
				$_SESSION['rate_edit_data']['input_new_component_frequency'] = $_POST['input_new_component_frequency'];
				$_SESSION['rate_edit_data']['input_new_component_hash'] = $_POST['input_new_component_hash'];
				$_SESSION['rate_edit_data']['input_new_component_separate'] = $_POST['input_new_component_separate'];
				if ($_POST['input_new_component_tax_type_sel'] == "tax_rate"){
					$_SESSION['rate_edit_data']['input_new_component_tax_ind'] = "10";
					$_SESSION['rate_edit_data']['input_new_component_tax_id'] = $_POST['input_new_component_taxrate'];

				} else {
					$_SESSION['rate_edit_data']['input_new_component_tax_ind'] = "20";
					$_SESSION['rate_edit_data']['input_new_component_tax_id'] = $_POST['input_new_component_taxgroup'];
				}

				if ($_POST['input_new_component_split_sel'] == "fixed"){
					$_SESSION['rate_edit_data']['input_new_component_split_amt'] = ($_POST['input_new_component_split_amt'] > 0) ? $_POST['input_new_component_split_amt'] : 0;
				} else {
					$_SESSION['rate_edit_data']['input_new_component_split_perc'] = ($_POST['input_new_component_split_perc'] > 0) ? $_POST['input_new_component_split_perc'] : 0;
				}
				$_SESSION['rate_edit_data']['input_new_component_split_sel'] = $_POST['input_new_component_split_sel'];
				$_SESSION['rate_edit_data']['input_new_component_rate_groups'] = empty($_POST['input_new_component_rate_groups']) ? array() : $_POST['input_new_component_rate_groups'];
			}

			// Delete component
			if (isset($_POST['input_del_component'])){
				$_SESSION['rate_edit_data']['input_del_component'] = $_POST['input_del_component'];
				$_SESSION['rate_edit_data']['input_del_component_id'] = $_POST['input_del_component_id'];
			}

			// Edit components
			if (isset($_POST['input_edit_component'])){
				$_SESSION['rate_edit_data']['input_edit_component'] = $_POST['input_edit_component'];
				$_SESSION['rate_edit_data']['input_edit_component_id'] = $_POST['input_edit_component_id'];
				$_SESSION['rate_edit_data']['input_edit_component_field'] = $_POST['input_edit_component_field'];
				$_SESSION['rate_edit_data']['input_edit_component_filter_value'] = $_POST['input_edit_component_filter_value'];
				$_SESSION['rate_edit_data']['input_edit_component_new_value'] = $_POST['input_edit_component_new_value'];
			}

			// Edit component splits
			if (isset($_POST['input_edit_component_split'])){
				$_SESSION['rate_edit_data']['input_edit_component_split'] = $_POST['input_edit_component_split'];
				$_SESSION['rate_edit_data']['input_edit_component_id_split'] = $_POST['input_edit_component_id_split'];
				$_SESSION['rate_edit_data']['input_amounts_rate_groups_split'] = empty($_POST['input_amounts_rate_groups_split']) ? array() : $_POST['input_amounts_rate_groups_split'];
				$_SESSION['rate_edit_data']['input_amounts_sel_split'] = $_POST['input_amounts_sel_split'];
				if ($_POST['input_amounts_sel_split'] == "fixed"){
					$_SESSION['rate_edit_data']['input_amounts_fixed_split'] = $_POST['input_amounts_fixed_split'];
				} else {
					$_SESSION['rate_edit_data']['input_amounts_percentage_split'] = $_POST['input_amounts_percentage_split'];
				}
			}

			// Adjust amounts
			if (isset($_POST['input_adjust_amounts'])){
				$_SESSION['rate_edit_data']['input_adjust_amounts'] = $_POST['input_adjust_amounts'];
				$_SESSION['rate_edit_data']['input_amounts_sel'] = $_POST['input_amounts_sel'];
				if ($_POST['input_amounts_sel'] == "fixed"){
					$_SESSION['rate_edit_data']['input_amounts_fixed'] = $_POST['input_amounts_fixed'];
				} else {
					$_SESSION['rate_edit_data']['input_amounts_percentage'] = $_POST['input_amounts_percentage'];
				}
				$_SESSION['rate_edit_data']['input_amounts_rate_groups'] = empty($_POST['input_amounts_rate_groups']) ? array() : $_POST['input_amounts_rate_groups'];
				$_SESSION['rate_edit_data']['input_amounts_rate_group_quantity'] = empty($_POST['input_amounts_rate_group_quantity']) && $_POST['input_amounts_rate_group_quantity'] != "0" ? "all" : $_POST['input_amounts_rate_group_quantity'];
			}		

			// Round amounts
			if (isset($_POST['input_round_amounts'])){
				$_SESSION['rate_edit_data']['input_round_amounts'] = $_POST['input_round_amounts'];
				$_SESSION['rate_edit_data']['input_round_precision'] = $_POST['input_round_precision'];
				$_SESSION['rate_edit_data']['input_round_direction'] = $_POST['input_round_direction'];
				$_SESSION['rate_edit_data']['input_round_rate_groups'] = empty($_POST['input_round_rate_groups']) ? array() : $_POST['input_round_rate_groups'];
			}	

			// Copy amounts
			if (isset($_POST['input_copy_amounts'])){
				$_SESSION['rate_edit_data']['input_copy_amounts'] = $_POST['input_copy_amounts'];
				$_SESSION['rate_edit_data']['input_copy_rate_group_dest_id'] = $_POST['input_copy_rate_group_dest_id'];
				$_SESSION['rate_edit_data']['input_copy_rate_group_dest_quantity'] = $_POST['input_copy_rate_group_dest_quantity'];
				//$_SESSION['rate_edit_data']['input_copy_accomm_type_source_id'] = $_POST['input_copy_accomm_type_source_id'];
				//$_SESSION['rate_edit_data']['input_copy_rate_type_source_id'] = $_POST['input_copy_rate_type_source_id'];
				//$_SESSION['rate_edit_data']['input_copy_rate_period_source_id'] = $_POST['input_copy_rate_period_source_id'];
				$_SESSION['rate_edit_data']['input_copy_rate_group_source_id'] = $_POST['input_copy_rate_group_source_id'];
				$_SESSION['rate_edit_data']['input_copy_rate_group_source_quantity'] = $_POST['input_copy_rate_group_source_quantity'];
				/*
				$_SESSION['rate_edit_data']['input_copy_amount_id'] = $lDB->get("
						SELECT
							rt_rate_grp_amt.rt_rate_grp_amt_ix
						FROM
							rt_rate_grp_amt
							INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_grp_amt.rt_rate_group_id
							INNER JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_grp_amt.rt_rate_id
							INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
							INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
							INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
						WHERE
							rt_rate.ac_accomm_type_id = '" . $_POST['input_copy_accomm_type_source_id'] . "'
							AND rt_rate.rt_rate_type_id = '" . $_POST['input_copy_rate_type_source_id'] . "'
							AND rt_rate.rt_period_id = '" . $_POST['input_copy_rate_period_source_id'] . "'
							AND rt_rate_grp_amt.rt_rate_group_id = '" . $_POST['input_copy_rate_group_source_id'] . "'
							AND rt_rate_grp_amt.rt_rate_grp_amt_qty = '" . $_POST['input_copy_rate_group_source_quantity'] . "'
				",4);
				 */
			}

			// Add rate group
			if (isset($_POST['input_add_rate_group'])){
				$_SESSION['rate_edit_data']['input_add_rate_group'] = $_POST['input_add_rate_group'];
				$_SESSION['rate_edit_data']['input_add_rate_group_id'] = $_POST['input_add_rate_group_id'];
				$_SESSION['rate_edit_data']['input_add_rate_group_position'] = $_POST['input_add_rate_group_position'];
			}
			
		} else {
			$output_log[] = 'Insufficient rate filters selected.';
			include(__DIR__ ."/start.php");
			break;
		}

		include(__DIR__ ."/staging.php");	
		break;
	case "2": // We're in business

		include(__DIR__ ."/output.php");
        set_time_limit(99999);		

		$GLOBALS['dataset'] = $_SESSION['rate_edit_data'];
		session_write_close(); 
		global $dataset;

		createlogfile("output.txt");

		// Do we want to flag these changes for transfer?
		if (isset($dataset['input_flag_for_transfer']) && $dataset['input_flag_for_transfer'] == 1){

			$GLOBALS['flagChngs'] = "1";
			$GLOBALS['flagDels'] = "1";

			writelog("output.txt", "Data transfer flags ENABLED");

		} else {
			$GLOBALS['flagChngs'] = "0";
			$GLOBALS['flagDels'] = "0";

			writelog("output.txt", "Data transfer flags DISABLED");
		}

		if (isset($dataset['input_add_component']) && $dataset['input_add_component'] == 1){
			add_component();
		}

		if (isset($dataset['input_del_component']) && $dataset['input_del_component'] == 1){
			del_component();
		}

		if (isset($dataset['input_edit_component']) && $dataset['input_edit_component'] == 1){
			edit_components();
		}

		if (isset($dataset['input_edit_component_split']) && $dataset['input_edit_component_split'] == 1){
			edit_components_split();
		}

		if (isset($dataset['input_adjust_amounts']) && $dataset['input_adjust_amounts'] == 1){
			adjust_amounts();
		}		

		if (isset($dataset['input_round_amounts']) && $dataset['input_round_amounts'] == 1){
			round_amounts();
		}	

		if (isset($dataset['input_copy_amounts']) && $dataset['input_copy_amounts'] == 1){
			copy_amounts();
		}

		if (isset($dataset['input_add_rate_group']) && $dataset['input_add_rate_group'] == 1){
			add_rate_group();
		}

		break;		
	default:
		$output_log[] = 'There was a problem.';
		include(__DIR__ ."/start.php");	
	}

} else {
	include(__DIR__ ."/start.php");
}


