<!DOCTYPE html>
<html lang="en">
	<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="author" content="">
	<!-- <link rel="shortcut icon" href="../../assets/ico/favicon.png"> -->

	<title>Rate Edit Tool (Generic)</title>

	<!-- Bootstrap core CSS -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/css/bootstrap.css" rel="stylesheet">

	<!-- Custom styles for this template -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/rate-edit-gen.css" rel="stylesheet">

	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/css/datepicker.css" rel="stylesheet">
	

	<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!--[if lt IE 9]>
		<script src="../../assets/js/html5shiv.js"></script>
		<script src="../../assets/js/respond.min.js"></script>
	<![endif]-->
	</head>

	<body>

	<div class="navbar navbar-inverse navbar-fixed-top">
		<div class="container">
		<div class="navbar-header">
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			</button>
			<a class="navbar-brand" href="#">Rate Edit Tool (Generic)</a>
		</div>
		<div class="collapse navbar-collapse">
			<ul class="nav navbar-nav">
			<li class="active"><a href="index.php">Start</a></li>
			<li><a href="login.php?logout">Log Out</a></li>
<!-- 			<li><a href="#about">About</a></li>
			<li><a href="#contact">Contact</a></li> -->
			</ul>
		</div><!--/.nav-collapse -->
		</div>
	</div>

	<div class="container">

		<h2>Summary</h2>
		<p class="lead">Please read this summary carefully before proceeding.  All changes are FINAL!</p>
		<br />

		<h3>You are about to change <strong><?php echo count($_SESSION['rate_edit_data']['rates']) ?></strong> rates in total.</h3><hr>
		<?php
			if (isset($_SESSION['rate_edit_data']['input_flag_for_transfer'])){
			
				echo "<h3>Changes WILL be flagged for transfer.</h3><hr>";

			} else {
				echo "<h3>Changes will NOT be flagged for transfer.</h3><hr>";
			}
		?>

		<?php
			if (isset($_SESSION['rate_edit_data']['input_from_date'])){
				echo "<h3>Date</h3>";
				echo "<p>".$_SESSION['rate_edit_data']['input_from_date']."</p>";
			} else {
				echo "<h3>Periods</h3>";
				$periods = $lDB->get("
					SELECT
						rt_period.rt_period_desc
					FROM
						rt_period
					WHERE
						rt_period.rt_period_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_periods'])."')
					ORDER BY
						rt_period.rt_period_desc
				",3);
				foreach ($periods as $period){
					echo "<p>$period</p>";
				}
			}
		?>
		

		<h3>Accommodation types selected:</h3>
		<?php 

			$accomm_types = $lDB->get("
				SELECT
					CONCAT(ac_accomm_type.ac_accomm_desc, \" - \", pr_persona.pr_name_last)
				FROM
					ac_accomm_type
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
				WHERE
					ac_accomm_type.ac_accomm_type_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_accomm_types'])."')
				ORDER BY
					pr_persona.pr_persona_ix
			",3);
			foreach ($accomm_types as $accomm_type){
				echo "<p>$accomm_type</p>";
			}
		?>
		<h3>Rate types selected:</h3>
		<?php 
			$rate_types = $lDB->get("
				SELECT
					rt_rate_type.rt_rate_type_desc
				FROM
					rt_rate_type
				WHERE
					rt_rate_type.rt_rate_type_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_rate_types'])."')
				ORDER BY
					rt_rate_type.rt_rate_type_desc ASC
			",3);

			foreach ($rate_types as $rate_type){
				echo "<p>$rate_type</p>";
			}
		?>		
		<?php
			if (isset($_SESSION['rate_edit_data']['input_add_component'])){
			
		?>
			<hr>
			<h3>A new component will be added to each rate.</h3>
			<p>Component : 
			<?php 
				$input_new_component_name = $lDB->get("
					SELECT
						rt_component.rt_component_desc
					FROM
						rt_component
					WHERE 
						rt_component.rt_component_ix = '".$_SESSION['rate_edit_data']['input_new_component_id']."'
				",4);
				echo $input_new_component_name;
			?>
			</p>
			<p>Optional : <?php echo ($_SESSION['rate_edit_data']['input_new_component_optional'] == 1) ? "Yes" : "No" ?> </p>
			<p>Default : <?php echo ($_SESSION['rate_edit_data']['input_new_component_default'] == 1) ? "Yes" : "No" ?> </p>
			<p>Commissionable : 
			<?php 

				switch ($_SESSION['rate_edit_data']['input_new_component_commissionable']){
				case "0":
					echo "Not Commissionable";
					break;
				case "1":
					echo "Calculate";
					break;
				case "2":
					echo "Calc & deduct";
					break;
				case "3":
					echo "Calc & deduct All";
					break;
				}
			?>
			</p>
			<p>Frequency : <?php echo ($_SESSION['rate_edit_data']['input_new_component_frequency'] == 1) ? "Per Night" : "Per Stay" ?> </p>
			<p># : <?php echo $_SESSION['rate_edit_data']['input_new_component_hash'] ?> </p>
			<p>Separate : <?php echo ($_SESSION['rate_edit_data']['input_new_component_separate'] == 1) ? "Yes" : "No" ?> </p>
			<?php 
				if ($_SESSION['rate_edit_data']['input_new_component_tax_ind'] == "10"){
					$tax_desc = $lDB->get("
						SELECT
							rf_tax_rate.rf_tax_rate_desc
						FROM
							rf_tax_rate
						WHERE 
							rf_tax_rate.rf_tax_rate_ix = '".$_SESSION['rate_edit_data']['input_new_component_tax_id']."'
					",4);
					echo "<p>Tax rate : ".$tax_desc."</p>";
				} else {
					$tax_desc = $lDB->get("
						SELECT
							rt_tax_group.rt_tax_group_desc
						FROM
							rt_tax_group
						WHERE 
							rt_tax_group.rt_tax_group_ix = '".$_SESSION['rate_edit_data']['input_new_component_tax_id']."'
					",4);
					echo "<p>Tax group : ".$tax_desc."</p>";
				}

			?> 
			</p>
			<!-- input_new_component_split_sel -->
			<p><strong>Component Rate Group Splits</strong></p>
			<?php
				if ($_SESSION['rate_edit_data']['input_new_component_split_sel'] == "fixed"){
					echo "<p>Fixed amount : ".$_SESSION['rate_edit_data']['input_new_component_split_amt']."</p>";
				} else {
					echo "<p>Percentage split : ".$_SESSION['rate_edit_data']['input_new_component_split_perc']."</p>";
				}
			?>
			
			<?php 
				$input_new_component_rate_group_names = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE 
						rt_rate_group.rt_rate_group_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_new_component_rate_groups'])."')
					ORDER BY
						rt_rate_group.rt_rate_group_desc ASC
				",3);			
				if (count($input_new_component_rate_group_names) > 0){
					echo "<p>Rate groups : ".join (", ",$input_new_component_rate_group_names);
				} else {
					echo "<p class=\"error_text\">Rate groups : No rate groups affected.";
				}
			?>
			</p>


		<?php		
			}
		?>
		<?php
			if (isset($_SESSION['rate_edit_data']['input_del_component'])){
			
		?>
			<hr>
			<h3>A component will be deleted from each rate.</h3>
			<p>Component : 
			<?php 
				$input_del_component_name = $lDB->get("
					SELECT
						rt_component.rt_component_desc
					FROM
						rt_component
					WHERE 
						rt_component.rt_component_ix = '".$_SESSION['rate_edit_data']['input_del_component_id']."'
				",4);
				echo $input_del_component_name;
			?>
			</p>
		<?php
			}
		?>
		<?php if (isset($_SESSION['rate_edit_data']['input_edit_component'])){ ?>
			<hr>
			<h3>The following edits will be made to components:</h3>
			<?php 
				$input_edit_component_ids = is_array($_SESSION['rate_edit_data']['input_edit_component_id']) ? $_SESSION['rate_edit_data']['input_edit_component_id'] : array($_SESSION['rate_edit_data']['input_edit_component_id']); 
				$input_edit_component_fields = is_array($_SESSION['rate_edit_data']['input_edit_component_field']) ? $_SESSION['rate_edit_data']['input_edit_component_field'] : array($_SESSION['rate_edit_data']['input_edit_component_field']); 
				$input_edit_component_filter_values = is_array($_SESSION['rate_edit_data']['input_edit_component_filter_value']) ? $_SESSION['rate_edit_data']['input_edit_component_filter_value'] : array($_SESSION['rate_edit_data']['input_edit_component_filter_value']); 
				$input_edit_component_new_values = is_array($_SESSION['rate_edit_data']['input_edit_component_new_value']) ? $_SESSION['rate_edit_data']['input_edit_component_new_value'] : array($_SESSION['rate_edit_data']['input_edit_component_new_value']); 
				$counter = 0;
				foreach($input_edit_component_ids as $input_edit_component_id) { ?>
					<p>Component "<?php 
					$input_edit_component_name = $lDB->get("
						SELECT
							rt_component.rt_component_desc
						FROM
							rt_component
						WHERE 
							rt_component.rt_component_ix = '$input_edit_component_id'
					",4);
					echo $input_edit_component_name;
					?>" will have the field "<?php echo $component_fields[$input_edit_component_fields[$counter]]; ?>" set to "<?php
					echo printComponentFieldValue($input_edit_component_fields[$counter], $input_edit_component_new_values[$counter]);?>"
					<?php if ($input_edit_component_filter_values[$counter] != "-1") { ?>
						<strong>ONLY</strong> if "<?php echo $component_fields[$input_edit_component_fields[$counter]]; ?>" is currently set to "<?php
						echo printComponentFieldValue($input_edit_component_fields[$counter], $input_edit_component_filter_values[$counter]) . "\"";
					} 
					$counter += 1;
					?>
				<?php } ?>
			</p>
		<?php } ?>

		<?php if (isset($_SESSION['rate_edit_data']['input_edit_component_split'])){ ?>
			<hr>
			<h3>The following edits will be made to component splits:</h3>
			<?php 
				$input_edit_component_id_split = $_SESSION['rate_edit_data']['input_edit_component_id_split'][0];

				$input_edit_component_name_split = $lDB->get("
					SELECT
						rt_component.rt_component_desc
					FROM
						rt_component
					WHERE 
						rt_component.rt_component_ix = '$input_edit_component_id_split'
				",4);
				echo "<p>Component : ".$input_edit_component_name_split."</p>";

				$input_amounts_rate_groups_names_split = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE 
						rt_rate_group.rt_rate_group_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_amounts_rate_groups_split'])."')
					ORDER BY
						rt_rate_group.rt_rate_group_desc ASC
				",3);

				if (count($input_amounts_rate_groups_names_split) > 0){
					echo "<p>Rate groups : ".join (", ",$input_amounts_rate_groups_names_split)."</p>";
				} else {
					echo "<p class=\"error_text\">Rate groups : No rate groups affected.</p>";
				}

				if ($_SESSION['rate_edit_data']['input_amounts_sel_split'] == "fixed"){
					echo "<p>Fixed amount : ".$_SESSION['rate_edit_data']['input_amounts_fixed_split']."</p>";
				} else {
					echo "<p>Percentage : ".$_SESSION['rate_edit_data']['input_amounts_percentage_split']."</p>";
				}
			?>
			</p>
		<?php } ?>

		<?php
			if (isset($_SESSION['rate_edit_data']['input_adjust_amounts'])){
			
		?>
			<hr>
			<h3>Adjustments will be made to the amounts.</h3>
			<?php
				if ($_SESSION['rate_edit_data']['input_amounts_sel'] == "fixed"){
					echo "<p>Fixed amount : ".$_SESSION['rate_edit_data']['input_amounts_fixed']."</p>";
				} else {
					echo "<p>Percentage : ".$_SESSION['rate_edit_data']['input_amounts_percentage']."</p>";
				}
				if ($_SESSION['rate_edit_data']['input_amounts_rate_group_quantity'] == "0") {
					$input_amounts_rate_group_quantity_name = "1 Sharing";
				} elseif ($_SESSION['rate_edit_data']['input_amounts_rate_group_quantity'] == "1") {
					$input_amounts_rate_group_quantity_name = "1 Single";
				} else {
					$input_amounts_rate_group_quantity_name = $_SESSION['rate_edit_data']['input_amounts_rate_group_quantity'];
				}
				$input_amounts_rate_groups_names = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE 
						rt_rate_group.rt_rate_group_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_amounts_rate_groups'])."')
					ORDER BY
						rt_rate_group.rt_rate_group_desc ASC
				",3);			
				if (count($input_amounts_rate_groups_names) > 0){
					echo "<p>Rate groups : ".join (", ",$input_amounts_rate_groups_names);
					echo "<p>Quantity : ".$input_amounts_rate_group_quantity_name;
				} else {
					echo "<p class=\"error_text\">Rate groups : No rate groups affected.";
				}
	
			}
		?>
		<?php
			if (isset($_SESSION['rate_edit_data']['input_round_amounts'])){
			
		?>
			<hr>
			<h3>Amounts will be rounded.</h3>
			<?php
					echo "<p>Precision : ".$_SESSION['rate_edit_data']['input_round_precision']."</p>";
					echo "<p>Direction : ".$_SESSION['rate_edit_data']['input_round_direction']."</p>";

				$input_round_rate_groups_names = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE 
						rt_rate_group.rt_rate_group_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_round_rate_groups'])."')
					ORDER BY
						rt_rate_group.rt_rate_group_desc ASC
				",3);			
				if (count($input_round_rate_groups_names) > 0){
					echo "<p>Rate groups : ".join (", ",$input_round_rate_groups_names);
				} else {
					echo "<p class=\"error_text\">Rate groups : No rate groups affected.";
				}
	
			}
		?>		
		<?php if (isset($_SESSION['rate_edit_data']['input_copy_amounts'])){ ?>
			<hr>
			<h3>Amounts will be copied.</h3>
			<?php
				$rate_group_source_desc = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE
						rt_rate_group.rt_rate_group_ix = '" . $_SESSION['rate_edit_data']['input_copy_rate_group_source_id'] . "'
						",4);

				$rate_group_quantity_source_desc = "";
				if ($_SESSION['rate_edit_data']['input_copy_rate_group_source_quantity'] == "0") {
					$rate_group_quantity_source_desc = "1 Sharing";
				} elseif ($_SESSION['rate_edit_data']['input_copy_rate_group_source_quantity'] == "1") {
					$rate_group_quantity_source_desc = "1 Single";
				} else {
					$rate_group_quantity_source_desc = $_SESSION['rate_edit_data']['input_copy_rate_group_source_quantity'];
				}
				?>
			The amounts for the following rate group and quantity:<br/>
			<label>Rate group:</label>&nbsp&nbsp<?php echo $rate_group_source_desc; ?></br>
			<label>Quantity:</label>&nbsp&nbsp<?php echo $rate_group_quantity_source_desc; ?></br>
			...will be copied to the following rate group/quantity combinations (for the rates by specified date, accommodation types and rate types):
			<br/>
			<table>
				<tr>
					<td width="200px"><label>Rate group</label></td>
					<td width="200px"><label>Quantity</label></td>
				<tr>
			<?php 
			$rate_groups = $_SESSION['rate_edit_data']['input_copy_rate_group_dest_id'];
			$quantities = $_SESSION['rate_edit_data']['input_copy_rate_group_dest_quantity'];
			$counter = 0;
			foreach ($rate_groups as $rate_group) {
				$rate_group_desc = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE
						rt_rate_group.rt_rate_group_ix = '$rate_group'
			",4);
				$rate_group_quantity_desc = "";
				if ($quantities[$counter] == "0") {
					$rate_group_quantity_desc = "1 Sharing";
				} elseif ($quantities[$counter] == "1") {
					$rate_group_quantity_desc = "1 Single";
				} else {
					$rate_group_quantity_desc = $quantities[$counter];
				}

				echo "<tr><td>$rate_group_desc</td><td>$rate_group_quantity_desc</td></tr>";
				$counter += 1;
			} ?>
			</table>
		<?php } ?>		
		<?php if (!empty($_SESSION['rate_edit_data']['input_add_rate_group']) && isset($_SESSION['rate_edit_data']['input_add_rate_group'])){ ?>
			<hr>
			<h3>Rate group will be added</h3>
			<?php
				$rate_group_desc = $lDB->get("
					SELECT
						rt_rate_group.rt_rate_group_desc
					FROM
						rt_rate_group
					WHERE
						rt_rate_group.rt_rate_group_ix = '" . $_SESSION['rate_edit_data']['input_add_rate_group_id'] . "'
						",4);

				?>
			The following rate group will be added to the selected rates:<br/>
			<label>Rate group:</label>&nbsp&nbsp<?php echo $rate_group_desc; ?></br>
			And placed at position <?php echo $_SESSION['rate_edit_data']['input_add_rate_group_position'];?>.
			<br/>
		<?php } ?>		
		<br /><br />
		<button class="btn btn-lg btn-primary btn-warning" type="button" onclick="cancel();">I've changed my mind!</button>
		<button class="btn btn-lg btn-primary btn-danger" type="button" onclick="execute();">Here goes nothing!</button>

		<form method="POST" id="mainForm">
			<input value="2" name="action" type="hidden" />
		</form>

	</div><!-- /.container -->


	<!-- Bootstrap core JavaScript
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/jquery.js"></script>
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/bootstrap-datepicker.js"></script>
	<script>
		$(document).ready(function() {
		    $('.datepicker').datepicker({
				format: 'yyyy-mm-dd',
				weekStart: 1
			});
		});


		function execute(){
			$('#mainForm').submit();
		}

		function cancel(){
			window.location = window.location;
		}

	</script>
	</body>
</html>
