<?php
	$_SESSION['rate_edit_data'] = array();
?>

<!DOCTYPE html>
<html lang="en">
	<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="author" content="">
	<!-- <link rel="shortcut icon" href="../../assets/ico/favicon.png"> -->

	<title>Rate Edit Tool (Generic)</title>

	<!-- Bootstrap core CSS -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/css/bootstrap.css" rel="stylesheet">

	<!-- Custom styles for this template -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/rate-edit-gen.css" rel="stylesheet">

	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/css/datepicker.css" rel="stylesheet">
	

	<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!--[if lt IE 9]>
		<script src="../../assets/js/html5shiv.js"></script>
		<script src="../../assets/js/respond.min.js"></script>
	<![endif]-->
	</head>

	<body>

	<div class="navbar navbar-inverse navbar-fixed-top">
		<div class="container">
		<div class="navbar-header">
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			</button>
			<a class="navbar-brand" href="#">Rate Edit Tool (Generic)</a>
		</div>
		<div class="collapse navbar-collapse">
			<ul class="nav navbar-nav">
			<li class="active"><a href="index.php">Start</a></li>
			<li><a href="login.php?logout">Log Out</a></li>
<!-- 			<li><a href="#about">About</a></li>
			<li><a href="#contact">Contact</a></li> -->
			</ul>
		</div><!--/.nav-collapse -->
		</div>
	</div>

	<div class="container">

		<h1>Rate Edit Tool (Generic)</h1>
		<p class="lead">Use this tool with caution. Changes made with this tool are FINAL!</p>
		<p class="lead">Have you made a backup?</p>
		
		<?php
			// Error log
			if (!empty($output_log)){
				foreach($output_log as $error){
					echo "<p class=\"error_text\">$error</p>";
				}	
			}

		?>


		<form class="form-edits" method="POST" id="mainForm">
			<h3>Select rates</h3>
			<p>Filter out the rates that you would like to make changes to.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_from_date"><input type="radio" name="input_date_sel" id="input_date_sel_from_date" value="from_date" checked="checked" \> From date </label>
					<input type="text" class="datepicker form-control" id="input_from_date" name="input_from_date" placeholder="YYYY-MM-DD"/>
				</div>
				<div class="form-edits-row">
					<label for="input_periods"><input type="radio" name="input_date_sel" id="input_date_sel_periods" value="periods" \> Periods </label>
					<select class="form-control" id="input_periods" name="input_periods[]" size="15" multiple disabled="disabled">
						<?php echo $periods_html; ?>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_accomm_types">Accommodation Types </label>
					<select class="form-control" id="input_accomm_types" name="input_accomm_types[]" size="15" multiple>
						<?php echo $accomm_types_html; ?>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_rate_types">Rate types </label>
					<select class="form-control" id="input_rate_types" name="input_rate_types[]" size="15" multiple>
						<?php echo $rate_types_html; ?>
					</select>
				</div>

			</div>
			<hr>
			<h3><input type="checkbox" value="1" id="input_flag_for_transfer" name="input_flag_for_transfer"> Flag for transfer</h3>
			<p>Selecting the checkbox above will flag any changes made by this tool for data transfer.  If you do not enable this option, then a DB replace on all environments will be required.</p>
			<hr>			
			<h3><input type="checkbox" value="1" id="input_add_component" name="input_add_component"> Add a new component</h3>
			<p>Selecting the checkbox above will add a new component to each rate, and create the relevant component splits.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_new_component_id">Component </label>
					<select class="form-control" id="input_new_component_id" name="input_new_component_id">
						<?php echo $components_html; ?>
					</select>
					
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_optional">Optional </label>
					<select class="form-control" id="input_new_component_optional" name="input_new_component_optional">
						<option value="0">No</option>
						<option value="1">Yes</option>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_default">Default </label>
					<select class="form-control" id="input_new_component_default" name="input_new_component_default">
						<option value="0">No</option>
						<option value="1">Yes</option>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_commissionable">Commissionable </label>
					<select class="form-control" id="input_new_component_commissionable" name="input_new_component_commissionable">
						<option value="0">Not Commissionable</option>
						<option value="1">Calculate</option>
						<option value="2">Calc & deduct</option>
						<option value="3">Calc & deduct All</option>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_frequency">Frequency </label>
					<select class="form-control" id="input_new_component_frequency" name="input_new_component_frequency">
						<option value="1">Per Night</option>
						<option value="2">Per Stay</option>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_hash"># </label>
					<select class="form-control" id="input_new_component_hash" name="input_new_component_hash">
						<option value="1">1</option>
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_separate">Separate </label>
					<select class="form-control" id="input_new_component_separate" name="input_new_component_separate">
						<option value="0">No</option>
						<option value="1">Yes</option>
					</select>
				</div>
				<div class="form-edits-row">

					<label for="input_new_component_taxrate"><input type="radio" name="input_new_component_tax_type_sel" id="input_new_component_tax_type_sel_tax_rate" value="tax_rate" checked="checked" \> Tax rate </label>
					<select class="form-control" id="input_new_component_taxrate" name="input_new_component_taxrate">
						<?php echo $tax_rates_html; ?>
					</select>
				</div>
				<?php
				// Gross - sorry coding-gods!
				if (!empty($tax_groups_html)){
					echo "<div class=\"form-edits-row\">\n";
					echo "<label for=\"input_new_component_taxgroup\"><input type=\"radio\" name=\"input_new_component_tax_type_sel\" id=\"input_new_component_tax_type_sel_tax_group\" value=\"tax_group\"\> Tax group </label>\n";
					echo "<select class=\"form-control\" id=\"input_new_component_taxgroup\" name=\"input_new_component_taxgroup\" disabled=\"disabled\">\n";
					echo $tax_groups_html;
					echo "</select>\n";
					echo "</div>\n";
				}
				?>
				<br />
				<p>Component rate group splits:</p>
				<div class="form-edits-row">
					<label for="input_new_component_split_amt"><input type="radio" name="input_new_component_split_sel" id="input_new_component_split_sel_fixed" value="fixed" checked="checked" \> Fixed amount </label>
					<input type="text" class="form-control" id="input_new_component_split_amt" name="input_new_component_split_amt" />
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_split_perc"><input type="radio" name="input_new_component_split_sel" id="input_new_component_split_sel_percentage" value="percentage" \> Percentage split </label>
					<input type="text" class="form-control" placeholder="CAUTION: Can break rate integrity!" id="input_new_component_split_perc" name="input_new_component_split_perc" disabled="disabled"/>
				</div>
				<div class="form-edits-row">
					<label for="input_new_component_rate_groups">Rate groups </label>
					<select class="form-control" id="input_new_component_rate_groups" name="input_new_component_rate_groups[]" size="15" multiple>
						<?php echo $rate_groups_html; ?>
					</select>
				</div>				

			</div>
			<hr>
			<h3><input type="checkbox" value="1" id="input_del_component" name="input_del_component"> Delete a component</h3>
			<p>Selecting the checkbox above will delete an existing component from each rate, as well as the associated component rate group splits.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_del_component_id">Component </label>
					<select class="form-control" id="input_del_component_id" name="input_del_component_id">
						<?php echo $components_html; ?>
					</select>
					
				</div>
							

			</div>			
			<hr>
			<h3><input type="checkbox" value="1" id="input_edit_component" name="input_edit_component"> Edit components</h3>
			<p>Selecting the checkbox above will edit the selected components so they will have the appropriate "New value" below. Optionally, the component will only be set to the "New value" if it currently is set to "Value filter"</p>
			<div class="row">
				<div class="form-edits-row">
					<table id="tblComponentsEdit">
						<tr>
							<td>
								<label for="input_edit_component_id_from">Component </label>
							</td>
							<td>
								<label for="input_edit_component_value_from">Field</label>
							</td>
							<td>
								<label for="input_edit_component_value_from">Value filter</label>
							</td>
							<td>
								<label for="input_edit_component_value_to">New value </label>
							</td>
							<td>
							</td>
						</tr>
						<tr rownum="1">
							<td>
								<select class="form-control" id="input_edit_component_id" style="width:150px; margin: 0px;" name="input_edit_component_id[]" rownum="1">
									<?php echo $components_html; ?>
								</select>
							</td>
							<td>
								<select class="form-control" id="input_edit_component_field" style="width:150px; margin: 0px;" name="input_edit_component_field[]" rownum="1">
									<?php echo $component_fields_html; ?>
								</select>
							</td>
							<td>
								<select class="form-control" id="input_edit_component_filter_value" style="width:150px; margin: 0px;" name="input_edit_component_filter_value[]" rownum="1">
								</select>
							</td>
							<td>
								<select class="form-control" id="input_edit_component_new_value" style="width:150px; margin: 0px;" name="input_edit_component_new_value[]" rownum="1">
								</select>
							</td>
							<td><button id="input_button_add_edit_component_row" name="input_button_add_edit_component_row" type="button" class="btn btn-mini btn-success add-row-button" title="Add another row" rownum="1">+</button></td>
						</tr>
					</table>
					
				</div>
							

			</div>
			
			<hr>
			<h3><input type="checkbox" value="1" id="input_edit_component_split" name="input_edit_component_split"> Edit component split values</h3>
			<p>Selecting the checkbox above will edit the selected component splits so they will have the new value below. Specify either value or percentage. Only existing component splits will be updated.<br><br><i>Tip: CTRL+click to select multiple rate groups</i></p>
			
			<div class="row">
				<div class="form-edits-row">
					<label for="input_edit_component_id_split">Component</label>
					<select class="form-control" id="input_edit_component_split_id_split" style="width:150px; margin: 0px;" name="input_edit_component_id_split[]" rownum="1">
						<?php echo $components_html; ?>
					</select>
				</div>
				<br>
				<div class="form-edits-row">
					<label for="input_amounts_rate_groups_split">Rate groups</label>
					<select class="form-control" id="input_amounts_rate_groups_split" name="input_amounts_rate_groups_split[]" size="15" multiple>
						<?php echo $rate_groups_html; ?>
					</select>
				</div>
				<br>
				<div class="form-edits-row">
					<label for="input_amounts_fixed_split"><input type="radio" name="input_amounts_sel_split" id="input_amounts_sel_fixed_split" value="fixed" checked="checked" \> Fixed amount</label>
					<input type="text" class="form-control" id="input_amounts_fixed_split" name="input_amounts_fixed_split" />
				</div>
				<div class="form-edits-row">
					<label for="input_amounts_percentage_split"><input type="radio" name="input_amounts_sel_split" id="input_amounts_sel_percentage_split" value="percentage" placeholder="CAUTION: Can break rate integrity!"\> Percentage</label>
					<input type="text" class="form-control" id="input_amounts_percentage_split" name="input_amounts_percentage_split" disabled="disabled" placeholder="CAUTION: Can break rate integrity!" />
				</div>
			</div>

			<hr>
			<h3><input type="checkbox" value="1" id="input_adjust_amounts" name="input_adjust_amounts"> Adjust amounts</h3>
			<p>Selecting the checkbox above will adjust all the amounts on the rates by a certain amount or percentage.</p>
			<div class="row">
				<div class="form-edits-row">

					<label for="input_amounts_fixed"><input type="radio" name="input_amounts_sel" id="input_amounts_sel_fixed" value="fixed" checked="checked" \> Fixed amount</label>
					<input type="text" class="form-control" id="input_amounts_fixed" name="input_amounts_fixed" />
				</div>
				<div class="form-edits-row">
					<label for="input_amounts_percentage"><input type="radio" name="input_amounts_sel" id="input_amounts_sel_percentage" value="percentage"\> Percentage</label>
					<input type="text" class="form-control" id="input_amounts_percentage" name="input_amounts_percentage" disabled="disabled" />
				</div>
				<br />
				<div class="form-edits-row">
					<label for="input_amounts_rate_groups">Rate groups </label>
					<select class="form-control" id="input_amounts_rate_groups" name="input_amounts_rate_groups[]" size="15" multiple>
						<?php echo $rate_groups_html; ?>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_amounts_rate_group_quantity">Quantity</label>
					<select class="form-control" id="input_amounts_rate_group_quantity" rownum="1" name="input_amounts_rate_group_quantity">
						<option value="all">All quantities</option>
						<?php echo $rate_group_amounts_html; ?>
					</select>
				</div>
			</div>
			<hr>
			<h3><input type="checkbox" value="1" id="input_round_amounts" name="input_round_amounts"> Round amounts</h3>
			<p>Selecting the checkbox above will round all the amounts on the rates.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_round_precision">Precision</label>
					<select class="form-control" id="input_round_precision" name="input_round_precision">
						<option value="1">1</option>
						<option value="10">10</option>
						<option value="100">100</option>
						<option value="1000">1000</option>
					</select>
				</div>

				<div class="form-edits-row">
					<label for="input_round_direction">Direction</label>
					<select class="form-control" id="input_round_direction" name="input_round_direction">
						<option value="Up">Up</option>
						<option value="Down">Down</option>
					</select>
				</div>

				<br />

				<div class="form-edits-row">
					<label for="input_round_rate_groups">Rate groups </label>
					<select class="form-control" id="input_round_rate_groups" name="input_round_rate_groups[]" size="15" multiple>
						<?php echo $rate_groups_html; ?>
					</select>
				</div>				

			</div>
			<hr>
			<h3><input type="checkbox" value="1" id="input_copy_amounts" name="input_copy_amounts"> Copy amounts</h3>
			<p>Selecting the checkbox above will copy all the amounts from "Select values to use" selection to one or more "Select rate group quantities to update" rate group and quantities.</p>
			<div class="row">
				<div class="form-edits-row">
					<table id="tblAmountCopy">
						<tr>
							<td colspan="3">
								<h4>Select rate group quantities to update</h4>
							</td>
						</tr>
						<tr>
							<td>
								<label for="input_copy_rate_group_dest_id">Rate group </label>
							</td>
							<td>
								<label for="input_copy_rate_group_dest_quantity">Quantity </label>
							</td>
							<td>
							</td>
						</tr>
						<tr>
							<td>
								<select class="form-control" id="input_copy_rate_group_dest_id" style="width:150px; margin: 0px;" rownum="1" name="input_copy_rate_group_dest_id[]">
									<?php echo $rate_groups_html; ?>
								</select>
							</td>
							<td>
								<select class="form-control" id="input_copy_rate_group_dest_quantity" style="width:150px; margin: 0px;" rownum="1"  name="input_copy_rate_group_dest_quantity[]">
									<?php echo $rate_group_amounts_html; ?>
								</select>
							</td>
							<td><button id="input_button_add_copy_amount_row" name="input_button_add_copy_amount_row" type="button" class="btn btn-mini btn-success add-row-button" title="Add another row" rownum="1">+</button></td>
						</tr>
					</table>
				</div>				
				<br />
				<div class="form-edits-row">
					<h4>Select values to use</h4>
				</div>
				<div class="form-edits-row">
					<label for="input_copy_rate_group_source_id">Rate group</label>
					<select class="form-control" id="input_copy_rate_group_source_id" rownum="1" name="input_copy_rate_group_source_id">
						<?php echo $rate_groups_html; ?>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_copy_rate_group_source_quantity">Quantity</label>
					<select class="form-control" id="input_copy_rate_group_source_quantity" rownum="1" name="input_copy_rate_group_source_quantity">
						<?php echo $rate_group_amounts_html; ?>
					</select>
				</div>
			<hr>
			<h3><input type="checkbox" value="1" id="input_add_rate_group" name="input_add_rate_group"> Add rate group</h3>
			<p>Selecting the checkbox above will add a rate group to the selected rates.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_add_rate_group_id">Rate group</label>
					<select class="form-control" id="input_add_rate_group_id" rownum="1" name="input_add_rate_group_id">
						<?php echo $rate_groups_html; ?>
					</select>
				</div>
				<div class="form-edits-row">
					<label for="input_add_rate_group_position">Position/Sequence</label>
					<input type="text" class="form-control" placeholder="Empty or 0 means append to end" id="input_add_rate_group_position" name="input_add_rate_group_position" />
				</div>
				<input value="1" name="action" type="hidden" />
		</form>
			<hr>
		<button class="btn btn-lg btn-primary btn-warning" type="submit" onclick="stage();">Preview changes</button>

	</div><!-- /.container -->


	<!-- Bootstrap core JavaScript
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/jquery.js"></script>
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/bootstrap-datepicker.js"></script>
	<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/Start.js"> </script>
	<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_edit_gen/js/StartAction.js"> </script>

	<script type="text/javascript">
		var start = new Start();
	</script>
	<script>
		function stage(){
			$('#mainForm').submit();
		}

	</script>
	</body>
</html>
