<?php
	require_once(__DIR__ . "/../../db.rt_rate.php");
	require_once(__DIR__ . "/../../db.rv_res_item_rate_grp.php");
	require_once(__DIR__ . "/../../db.rv_res_item_comp_tax.php");
	require_once(__DIR__ . "/../../db.rv_res_item_comp.php");
	require_once(__DIR__ . "/../../db.rv_res_item_comp_rate_grp.php");
	/*
		This function will do the following:
		1.) Delete any duplicate and/or zero rv_res_item_rate_grp records
		2.) Delete any duplicate rv_res_item_comp_rate_grp records
		3.) Check for missing or extra rv_res_item_rate_grp records and insert new ones where needed.
			Note: In the case of Units, all existing unit rate groups are deleted, and replaced with a single new record.
		4.) Create 1:1 relationship between itinerary rate groups and component rate groups (by deleting or inserting where required)
		5.) Where the component rate groups do not add up to the component, do the following:
			*	Zero all component rate groups
			*	Work out a per-person amount
			*	Apply per-person amount to each component
			NOTE: 	This process will result in component rate group amounts that are not correct according to the rate.
					However, this will ensure that a Recalc Totals does not affect the itinerary amount.
					Regenerating the reservation is still the only 100% correct way to fix these reservations.
	*/	

	function fix_1($records){
		global $lDB;

		$log = array();
		$log[] = "Results Log for Fix 1\n=====================\n";
		if (is_array($records)){
		
		
			$sysCodeUnit = $lDB->get("
				SELECT
					rt_rate_group_ix 
				FROM
					rt_rate_group
				WHERE
					rt_rate_group.rt_rate_group_sys_code = 1
			",4);

			$sysCodeAdult = $lDB->get("
				SELECT
					rt_rate_group_ix 
				FROM
					rt_rate_group
				WHERE
					rt_rate_group.rt_rate_group_sys_code = 2
			",4);

			$sysCodeChild = $lDB->get("
				SELECT
					rt_rate_group_ix 
				FROM
					rt_rate_group
				WHERE
					rt_rate_group.rt_rate_group_sys_code = 3
			",4);			
			
			$adultRateGroups = $lDB->get("
				SELECT
					rt_rate_group_ix 
				FROM
					rt_rate_group
				WHERE
					rt_rate_group.rt_rate_group_class = 1
			",3);	

			$childRateGroups = $lDB->get("
				SELECT
					rt_rate_group_ix 
				FROM
					rt_rate_group
				WHERE
					rt_rate_group.rt_rate_group_class = 2
			",3);					

			// START STEP 1
			foreach($records as $reservation){
			
				$itineraries = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix					
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '$reservation'
				",3);			
			
				foreach($itineraries as $itinerary){
				
					$itinRateGroups = $lDB->get("
						SELECT
							rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
							rv_res_item_rate_grp.rt_rate_group_id,
							rv_res_item_rate_grp.rv_res_item_rate_grp_count
						FROM
							rv_res_item_rate_grp
						WHERE
							rv_res_item_rate_grp.rv_reservation_item_id = '$itinerary'
					",2);					

					$dupCheck = array();
					foreach($itinRateGroups as $itinRateGroup){
						if (in_array($itinRateGroup['rt_rate_group_id'],$dupCheck)){
							// delete duplicate
							db_rv_res_item_rate_grp_delete($itinRateGroup['rv_res_item_rate_grp_ix']);
							$log[] = "[$reservation] Deleted duplicate rv_res_item_rate_grp record (".$itinRateGroup['rv_res_item_rate_grp_ix'].")";
						} elseif ($itinRateGroup['rv_res_item_rate_grp_count'] == 0) {
							// delete zero record
							db_rv_res_item_rate_grp_delete($itinRateGroup['rv_res_item_rate_grp_ix']);
							$log[] = "[$reservation] Deleted zero rv_res_item_rate_grp record (".$itinRateGroup['rv_res_item_rate_grp_ix'].")";
						} else {
							$dupCheck[] = $itinRateGroup['rt_rate_group_id'];
						}						
					}					
	
				}
			}
			
			// END STEP 1
			
			// START STEP 2
			
			foreach($records as $reservation){

				$components =  $lDB->get("
					SELECT
						rv_res_item_comp.rv_res_item_comp_ix
					FROM
						rv_res_item_comp
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
					WHERE
						rv_reservation_item.rv_reservation_id = '".$reservation."'
				",2);

				foreach($components as $component){
					$compRateGroups = $lDB->get("
						SELECT
							rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
							rv_res_item_comp_rate_grp.rt_rate_group_id
							
						FROM
							rv_res_item_comp_rate_grp
						WHERE
							rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
					",2);				
					
					$rateGroups = array();
					foreach($compRateGroups as $compRateGroup){
						if (in_array($compRateGroup['rt_rate_group_id'],$rateGroups)){
							// delete
							db_rv_res_item_comp_rate_grp_delete($compRateGroup['rv_res_item_comp_rate_grp_ix']);
							$log[] = "[$reservation] Deleted duplicate rv_res_item_comp_rate_grp record (".$compRateGroup['rv_res_item_comp_rate_grp_ix'].")";
						} else {
							$rateGroups[] = $compRateGroup['rt_rate_group_id'];
						}
					}
				}
			}					
			
			// END STEP 2			
			
			// START STEP 3
			
			$whereSQL = "
				WHERE
					rv_reservation.rv_reservation_ix IN ('".join("','",$records)."')
			";
		
			$allItineraries = $lDB->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix,
					rv_reservation_item.rv_reservation_id,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_adult_count,
					rv_reservation_item.rv_item_child_count
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				$whereSQL				
			",2);
			

			
			foreach ($allItineraries as $itinerary){
				$unitRateGroupRecord = array();
				$adultRateGroupRecord = array();
				$childRateGroupRecord = array();
				$reservation = $itinerary['rv_reservation_id'];
				
				$unitRateGroupRecords = $lDB->get("
					SELECT
						rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
						rv_res_item_rate_grp.rv_res_item_rate_grp_count
					FROM 
						rv_res_item_rate_grp
					WHERE 
						rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
						AND rv_res_item_rate_grp.rt_rate_group_id = '$sysCodeUnit'
				",2);
				
				$totalUnits = 0;
				foreach($unitRateGroupRecords as $unitRateGroupRecord){
					$totalUnits += $unitRateGroupRecord['rv_res_item_rate_grp_count'];
				}

				if($totalUnits != $itinerary['rv_item_accomm_count']){
					if (count($unitRateGroupRecords) > 0){
						// Delete all existing records
						foreach($unitRateGroupRecords as $unitRateGroupRecord){
							$lDB->put("DELETE FROM rv_res_item_rate_grp WHERE rv_res_item_rate_grp_ix = '".$unitRateGroupRecord['rv_res_item_rate_grp_ix']."'");					
							$log[] = "[$reservation] Deleted unit rate group record (".$unitRateGroupRecord['rv_res_item_rate_grp_ix'].")";
						}
					}	
					if ($itinerary['rv_item_accomm_count'] > 0){
						// Insert new record
						db_rv_res_item_rate_grp_insert($itinerary['rv_item_accomm_count'], $sysCodeUnit, $itinerary['rv_reservation_item_ix']);
						$log[] = "[$reservation] Inserted new unit rate group record";
					}
				}


				$adultRateGroupRecords = $lDB->get("
					SELECT
						rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
						rv_res_item_rate_grp.rv_res_item_rate_grp_count,
						rv_res_item_rate_grp.rt_rate_group_id
					FROM 
						rv_res_item_rate_grp
					WHERE 
						rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
						AND rv_res_item_rate_grp.rt_rate_group_id IN ('".join("','",$adultRateGroups)."')
				",2);
				
				$totalAdults = 0;
				$itinSysCodeAdultGroup = "";
				foreach($adultRateGroupRecords as $adultRateGroupRecord){
					// Check if we have a syscode Adult group already
					if ($adultRateGroupRecord['rt_rate_group_id'] == $sysCodeAdult){
						$itinSysCodeAdultGroup = $adultRateGroupRecord['rv_res_item_rate_grp_ix'];
						$itinSysCodeAdultCount = $adultRateGroupRecord['rv_res_item_rate_grp_count'];
					}	
					$totalAdults += $adultRateGroupRecord['rv_res_item_rate_grp_count'];
				}					
				
				if($totalAdults != $itinerary['rv_item_adult_count']){
					if ($itinerary['rv_item_adult_count'] > 0){
						if ($itinSysCodeAdultGroup == ""){
							// Insert new record
							$qty = $itinerary['rv_item_adult_count'] - $totalAdults;
							db_rv_res_item_rate_grp_insert($qty, $sysCodeAdult, $itinerary['rv_reservation_item_ix']);
							$log[] = "[$reservation] Inserted new adult rv_res_item_rate_grp record (itinerary - ".$itinerary['rv_reservation_item_ix'].")";
						} else {
							// Update existing record
							$qty = $itinSysCodeAdultCount + ($itinerary['rv_item_adult_count'] - $totalAdults);
							$lDB->put("
								UPDATE 
									rv_res_item_rate_grp
								SET 
									rv_res_item_rate_grp_count = $qty 
								WHERE 
									rv_res_item_rate_grp_ix = '$itinSysCodeAdultGroup'
							");
							$log[] = "[$reservation] Updated syscode adult rv_res_item_rate_grp record (itinerary - ".$itinerary['rv_reservation_item_ix'].")";
						}
					} else {
						if (count($adultRateGroupRecords) > 0){
							// Delete all existing records
							foreach($adultRateGroupRecords as $adultRateGroupRecord){
								$lDB->put("DELETE FROM rv_res_item_rate_grp WHERE rv_res_item_rate_grp_ix = '".$adultRateGroupRecord['rv_res_item_rate_grp_ix']."'");					
								$log[] = "[$reservation] Deleted adult rate group record (".$adultRateGroupRecord['rv_res_item_rate_grp_ix'].")";
							}
						}							
					}
				}	
				
				$childRateGroupRecords = $lDB->get("
					SELECT
						rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
						rv_res_item_rate_grp.rv_res_item_rate_grp_count,
						rv_res_item_rate_grp.rt_rate_group_id
					FROM 
						rv_res_item_rate_grp
					WHERE 
						rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
						AND rv_res_item_rate_grp.rt_rate_group_id IN ('".join("','",$childRateGroups)."')
				",2);
				
				$totalChildren = 0;
				$itinSysCodeChildGroup = "";
				foreach($childRateGroupRecords as $childRateGroupRecord){
					// Check if we have a syscode Child group already
					if ($childRateGroupRecord['rt_rate_group_id'] == $sysCodeChild){
						$itinSysCodeChildGroup = $childRateGroupRecord['rv_res_item_rate_grp_ix'];
						$itinSysCodeChildCount = $childRateGroupRecord['rv_res_item_rate_grp_count'];
					}						
					$totalChildren += $childRateGroupRecord['rv_res_item_rate_grp_count'];
				}					
				
				if($totalChildren != $itinerary['rv_item_child_count']){
					if ($itinerary['rv_item_child_count'] > 0){				
						if ($itinSysCodeChildGroup == ""){
							// Insert new record
							$qty = $itinerary['rv_item_child_count'] - $totalChildren;
							db_rv_res_item_rate_grp_insert($qty, $sysCodeChild, $itinerary['rv_reservation_item_ix']);
							$log[] = "[$reservation] Inserted new child rv_res_item_rate_grp record (itinerary - ".$itinerary['rv_reservation_item_ix'].")";
						} else {
							$qty = $itinSysCodeChildCount + ($itinerary['rv_item_child_count'] - $totalChildren);
							// Update existing record
							$lDB->put("
								UPDATE 
									rv_res_item_rate_grp
								SET 
									rv_res_item_rate_grp_count = $qty 
								WHERE 
									rv_res_item_rate_grp_ix = '$itinSysCodeChildGroup'
							");
							$log[] = "[$reservation] Updated syscode child rv_res_item_rate_grp record (itinerary - ".$itinerary['rv_reservation_item_ix'].")";
						}
					} else {
						if (count($childRateGroupRecords) > 0){
							// Delete all existing records
							foreach($childRateGroupRecords as $childRateGroupRecord){
								$lDB->put("DELETE FROM rv_res_item_rate_grp WHERE rv_res_item_rate_grp_ix = '".$childRateGroupRecord['rv_res_item_rate_grp_ix']."'");					
								$log[] = "[$reservation] Deleted child rate group record (".$childRateGroupRecord['rv_res_item_rate_grp_ix'].")";
							}
						}					
					}
				}	
			}
			
			// END STEP 3
			
			// START STEP 4
			
			foreach ($records as $reservation){

				$itineraries = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix					
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '$reservation'
				",3);

				foreach($itineraries as $itinerary){
				
					$itinRateGroups = $lDB->get("
						SELECT
							rv_res_item_rate_grp.rt_rate_group_id
						FROM
							rv_res_item_rate_grp
						WHERE
							rv_res_item_rate_grp.rv_reservation_item_id = '$itinerary'
							AND rv_res_item_rate_grp.rv_res_item_rate_grp_count > 0
					",3);				
			
					$components = $lDB->get("
						SELECT
							rv_res_item_comp.rv_res_item_comp_ix,
							rv_res_item_comp.rv_item_comp_rate,
							rv_res_item_comp.rv_item_comp_amt_gross,
							rv_res_item_comp.rv_item_comp_amt_nett,
							rv_res_item_comp.rv_item_comp_amt_comm,
							rv_res_item_comp.rv_item_comp_amt_tax,
							rv_res_item_comp.rv_item_comp_amt_payable,
							rv_res_item_comp.rv_item_comp_var,
							rv_reservation_item.rv_reservation_item_ix,
							rv_reservation_item.rv_item_accomm_count,
							rv_reservation_item.rv_item_adult_count,
							rv_reservation_item.rv_item_child_count						
						FROM
							rv_res_item_comp
							INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
						WHERE
							rv_res_item_comp.rv_reservation_item_id = '$itinerary'
					",2);

					foreach ($components as $component){
					
						// Delete comp rate groups for rate groups that don't exist on the itinerary
						$compRateGroups = $lDB->get("
							SELECT
								rv_res_item_comp_rate_grp_ix
							FROM
								rv_res_item_comp_rate_grp
							WHERE
								rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
								AND rv_res_item_comp_rate_grp.rt_rate_group_id NOT IN ('".join("','",$itinRateGroups)."')
						",3);
						
						foreach($compRateGroups as $compRategroup){
							db_rv_res_item_comp_rate_grp_delete($compRategroup);
							$log[] = "[$reservation] Deleted rv_res_item_comp_rate_grp record (".$compRategroup.")";
						}
						
						// Create missing rv_res_item_comp_rate_grp records
						foreach($itinRateGroups as $itinRateGroup){
							$compRateGroup = $lDB->get("
								SELECT
									rv_res_item_comp_rate_grp_ix
								FROM
									rv_res_item_comp_rate_grp
								WHERE
									rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
									AND rv_res_item_comp_rate_grp.rt_rate_group_id = '$itinRateGroup'
							",4);

							if(empty($compRateGroup)){
								db_rv_res_item_comp_rate_grp_insert($component['rv_res_item_comp_ix'], $itinRateGroup, "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", "0.00", false);
								$log[] = "[$reservation] Inserted rv_res_item_comp_rate_grp record (rate group - ".$itinRateGroup.")";
							}
						}
						
				
					}
				}
				
				
			}			
			
			// END STEP 4
			
			// START STEP 5
			
			foreach ($records as $reservation){

				$itineraries = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix					
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '$reservation'
				",3);

				foreach($itineraries as $itinerary){
				
					$itinRateGroups = $lDB->get("
						SELECT
							rv_res_item_rate_grp.rt_rate_group_id
						FROM
							rv_res_item_rate_grp
						WHERE
							rv_res_item_rate_grp.rv_reservation_item_id = '$itinerary'
							AND rv_res_item_rate_grp.rv_res_item_rate_grp_count > 0
					",3);				
			
					$components = $lDB->get("
						SELECT
							rv_reservation_item.rv_reservation_id,
							rv_res_item_comp.rv_res_item_comp_ix,
							rv_res_item_comp.rv_reservation_item_id,
							rv_item_comp_rate,
							rv_item_comp_rate_comm,
							rv_item_comp_amt_gross,
							rv_item_comp_amt_nett,
							rv_item_comp_amt_comm,
							rv_item_comp_amt_tax,
							rv_item_comp_amt_payable,
							rv_item_comp_var, 	
							ROUND(rv_item_comp_rate,2) as rate1,
							ROUND(SUM(rv_item_comp_rate_grp_rate),2) AS rate2,
							ROUND(rv_item_comp_amt_payable,2) as payable1,
							ROUND(SUM(rv_item_comp_rate_grp_amt_payable),2) AS payable2,							
							rv_reservation_item.rv_item_accomm_count,
							rv_reservation_item.rv_item_adult_count,
							rv_reservation_item.rv_item_child_count
						FROM
							rv_res_item_comp
							INNER JOIN rv_res_item_comp_rate_grp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
							INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
							INNER JOIN rv_reservation ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
						WHERE
							rv_res_item_comp.rv_reservation_item_id = '$itinerary'							
						GROUP BY
							rv_res_item_comp.rv_res_item_comp_ix
					",2);

					foreach ($components as $component){
					
						if ($component['rate1'] != $component['rate2'] || $component['payable1'] != $component['payable2']){

							$pax = $component['rv_item_adult_count'] + $component['rv_item_child_count'];
							
							$compRateAmt = $component['rv_item_comp_rate'];
							$compRateCommAmt = $component['rv_item_comp_rate_comm'];
							$compGrossAmt = $component['rv_item_comp_amt_gross'];
							$compNettAmt = $component['rv_item_comp_amt_nett'];
							$compCommAmt = $component['rv_item_comp_amt_comm'];
							$compTaxAmt = $component['rv_item_comp_amt_tax'];
							$compPayableAmt = $component['rv_item_comp_amt_payable'];
							$compVarAmt = $component['rv_item_comp_var'];
						
							$compRateGroups = $lDB->get("
								SELECT
									rv_res_item_rate_grp.rv_res_item_rate_grp_count,
									rv_res_item_comp_rate_grp.*
								FROM
									rv_res_item_comp_rate_grp
									INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
									INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
									INNER JOIN rv_res_item_rate_grp ON rv_res_item_rate_grp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
										AND rv_res_item_rate_grp.rt_rate_group_id = rv_res_item_comp_rate_grp.rt_rate_group_id
								WHERE
									rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
							",2);

							// Do we have a units amount?  Subtract that from the component amount before we calculate the per-person amount
							foreach($compRateGroups as $compRateGroup){
								if ($compRateGroup['rt_rate_group_id'] == $sysCodeUnit){
									$compRateAmt = $compRateAmt - $compRateGroup['rv_item_comp_rate_grp_rate'];
									$compRateCommAmt = $compRateCommAmt - $compRateGroup['rv_item_comp_rate_grp_rate_comm'];
									$compGrossAmt = $compGrossAmt - $compRateGroup['rv_item_comp_rate_grp_amt_gross'];
									$compNettAmt = $compNettAmt - $compRateGroup['rv_item_comp_rate_grp_amt_nett'];
									$compCommAmt = $compCommAmt - $compRateGroup['rv_item_comp_rate_grp_amt_comm'];
									$compTaxAmt = $compTaxAmt - $compRateGroup['rv_item_comp_rate_grp_amt_tax'];
									$compPayableAmt = $compPayableAmt - $compRateGroup['rv_item_comp_rate_grp_amt_payable'];
									$compVarAmt = $compVarAmt - $compRateGroup['rv_item_comp_rate_grp_amt_var'];
								}
							}							
							
							$ppRateAmt = $compRateAmt / $pax;
							$ppRateCommAmt = $compRateCommAmt / $pax;
							$ppGrossAmt = $compGrossAmt / $pax;
							$ppNettAmt = $compNettAmt / $pax;
							$ppCommAmt = $compCommAmt / $pax;
							$ppTaxAmt = $compTaxAmt / $pax;
							$ppPayableAmt = $compPayableAmt / $pax;
							$ppVarAmt = $compVarAmt / $pax;
							
							foreach($compRateGroups as $compRateGroup){
								if ($compRateGroup['rt_rate_group_id'] != $sysCodeUnit){
									db_rv_res_item_comp_rate_grp_update(
										$compRateGroup['rv_res_item_comp_rate_grp_ix'], 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppRateAmt, 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppRateCommAmt, 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppGrossAmt, 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppNettAmt, 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppCommAmt,
										"0.00",
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppTaxAmt, 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppPayableAmt, 
										$compRateGroup['rv_res_item_rate_grp_count'] * $ppVarAmt
									);
									$log[] = "[$reservation] Updated rv_res_item_comp_rate_grp record (".$compRateGroup['rv_res_item_comp_rate_grp_ix'].")";
								}
							}
							
						}
						
					}
				}
			}
			// END STEP 5
		
			return $log;
		} else {
			return "No records to fix.";
		}
	}
	
/*
		This function will do the following:
		1.)	Delete orphaned records in:
			*	rv_res_item_rate_grp
			*	rv_res_item_comp_rate_grp
			*	rv_res_item_comp
			*	rv_res_item_comp_tax
		

*/	
	
	
	function fix_2(){
		global $lDB;

		$log = array();
		$log[] = "Results Log for Fix 2\n=====================\n";
		
		// rv_res_item_rate_grp
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
				rv_res_item_rate_grp.rv_reservation_item_id
			FROM
				rv_res_item_rate_grp
				LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_rate_grp.rv_reservation_item_id
			WHERE 
				rv_reservation_item.rv_reservation_item_ix IS NULL
		",2);		
	
		foreach($orphanedRecords as $orphanedRecords){
			db_rv_res_item_rate_grp_delete($orphanedRecords['rv_res_item_rate_grp_ix']);
			$log[] = "[orphan] Deleted rv_res_item_rate_grp record (".$orphanedRecords['rv_res_item_rate_grp_ix'].")";	
		}
		
		// rv_res_item_comp_rate_grp
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
				rv_res_item_comp_rate_grp.rv_res_item_comp_id
			FROM
				rv_res_item_comp_rate_grp
				LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
			WHERE 
				rv_res_item_comp.rv_res_item_comp_ix IS NULL
		",2);		
	
		foreach($orphanedRecords as $orphanedRecords){
			db_rv_res_item_comp_rate_grp_delete($orphanedRecords['rv_res_item_comp_rate_grp_ix']);
			$log[] = "[orphan] Deleted rv_res_item_comp_rate record (".$orphanedRecords['rv_res_item_comp_rate_grp_ix'].")";	
		}

		// rv_res_item_comp
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rv_reservation_item_id
			FROM
				rv_res_item_comp
				LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
			WHERE 
				rv_reservation_item.rv_reservation_item_ix IS NULL
		",2);			
	
		foreach($orphanedRecords as $orphanedRecords){
			db_rv_res_item_comp_delete($orphanedRecords['rv_res_item_comp_ix']);
			$log[] = "[orphan] Deleted rv_res_item_comp record (".$orphanedRecords['rv_res_item_comp_ix'].")";	
		}	
		
		//rv_res_item_comp_tax
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_comp_tax.rv_res_item_comp_tax_ix,
				rv_res_item_comp_tax.rv_res_item_comp_id
			FROM
				rv_res_item_comp_tax
				LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
			WHERE 
				rv_res_item_comp.rv_res_item_comp_ix IS NULL
		",2);		

		foreach($orphanedRecords as $orphanedRecords){
			db_rv_res_item_comp_tax_delete($orphanedRecords['rv_res_item_comp_tax_ix']);
			$log[] = "[orphan] Deleted rv_res_item_comp_tax record (".$orphanedRecords['rv_res_item_comp_tax_ix'].")";
		}			
		
		return $log;

	}
	
	
/*
		This function will do the following:
		1.)	Detele duplicates on tax id in rv_res_item_comp_tax (Bug #7610)
		2.) If the component tax totals don't add up to the total on the component and the component does not use a tax group:
			* Insert a new, or update the existing tax record to reflect the correct value
*/	
	
	function fix_3($records){	
		global $lDB;

		$log = array();
		$log[] = "Results Log for Fix 3\n=====================\n";		

		if (is_array($records)){		
			
			foreach($records as $reservation){

				$components =  $lDB->get("
					SELECT
						rv_res_item_comp.rv_res_item_comp_ix,
						rv_res_item_comp.rv_item_comp_amt_tax,
						rv_res_item_comp.rv_item_comp_tax_perc,
						rv_res_item_comp.rt_tax_ind,
						rv_res_item_comp.rt_tax_id
					FROM
						rv_res_item_comp
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
					WHERE
						rv_reservation_item.rv_reservation_id = '".$reservation."'
				",2);

				// Delete duplicates
				foreach($components as $component){
					$compTaxRecords =  $lDB->get("
						SELECT
							rv_res_item_comp_tax.rv_res_item_comp_tax_ix,
							rv_res_item_comp_tax.rf_tax_rate_id
						FROM
							rv_res_item_comp_tax
						WHERE
							rv_res_item_comp_tax.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
					",2);					
					
					$taxRates = array();
					foreach($compTaxRecords as $compTaxRecord){
						if (in_array($compTaxRecord['rf_tax_rate_id'],$taxRates)){
							db_rv_res_item_comp_tax_delete($compTaxRecord['rv_res_item_comp_tax_ix']);
							$log[] = "[$reservation] Deleted rv_res_item_comp_tax record (".$compTaxRecord['rv_res_item_comp_tax_ix'].")";	
						} else {
							$taxRates[] = $compTaxRecord['rf_tax_rate_id'];
						}
					}
				}

				// Try to balance
				foreach($components as $component){
					if ($component['rv_item_comp_amt_tax'] > 0 && $component['rt_tax_ind'] == "10"){  // Has tax amount and is not a tax group
						$compTaxRecord =  $lDB->get("
							SELECT
								rv_res_item_comp_tax.rv_res_item_comp_tax_ix,
								rv_res_item_comp_tax.rf_tax_rate_id
							FROM
								rv_res_item_comp_tax
							WHERE
								rv_res_item_comp_tax.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
								AND rv_res_item_comp_tax.rf_tax_rate_id = '".$component['rt_tax_id']."'
						",1);					
						
						if (!empty($compTaxRecord)){
							db_rv_res_item_comp_tax_update_amt($component['rt_tax_id'], $component['rv_res_item_comp_ix'], $component['rv_item_comp_amt_tax'], $component['rv_item_comp_tax_perc']);
							$log[] = "[$reservation] Updated existing rv_res_item_comp_tax record (".$compTaxRecord['rv_res_item_comp_tax_ix'].")";
						} else {
							db_rv_res_item_comp_tax_insert($component['rv_item_comp_amt_tax'], $component['rv_item_comp_tax_perc'], $component['rt_tax_id'], $component['rv_res_item_comp_ix']);
							$log[] = "[$reservation] Inserted new rv_res_item_comp_tax record (component - ".$component['rv_res_item_comp_ix'].")";	
						}
					}
				}				
			}			
			
			return $log;
		} else {
			return "No records to fix.";
		}

	}
	
/*
		This function will do the following:
		1.)	Delete duplicates on component id in rv_res_item_comp (test 12)
*/	
	
	function fix_4($records){	
		global $lDB;

		$log = array();
		$log[] = "Results Log for Fix 4\n=====================\n";		

		if (is_array($records)){		
			
			foreach($records as $reservation){

				$itineraries = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix					
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '$reservation'
				",3);

				foreach($itineraries as $itinerary){
			
					$components = $lDB->get("
						SELECT
							rv_res_item_comp.rv_res_item_comp_ix,
							rv_res_item_comp.rt_component_id
						FROM
							rv_res_item_comp
						WHERE
							rv_res_item_comp.rv_reservation_item_id = '$itinerary'							
					",2);
					
					$componentIds = array();
					foreach($components as $component){
						if (in_array($component['rt_component_id'],$componentIds)){
							db_rv_res_item_comp_delete($component['rv_res_item_comp_ix']);
							$log[] = "[$reservation] Deleted rv_res_item_comp record (".$component['rv_res_item_comp_ix'].")";	
						} else {
							$componentIds[] = $component['rt_component_id'];
						}
					}
				}
			
			}			
			
			return $log;
		} else {
			return "No records to fix.";
		}

	}	

	function fix_5($records){	
		global $lDB;

		$log = array();
		$log[] = "Results Log for Fix 5\n=====================\n";		

		$rate_orphans = $lDB->get("
			SELECT
				rt_rate.rt_rate_ix
			FROM
				rt_rate
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
				LEFT JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
				LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
			WHERE
				rt_rate_type.rt_rate_type_ix IS NULL
				OR rt_period.rt_period_ix IS NULL
				OR ac_accomm_type.ac_accomm_type_ix IS NULL
		",3);
		foreach($rate_orphans as $item) {
			rt_rate_delete($item);
			$log[] = "[".$item."] Deleted rt_rate record";
		}
	
			
		$rate_component_orphans = $lDB->get("
			SELECT
				rt_rate_component.rt_rate_component_ix
			FROM
				rt_rate_component
				LEFT JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
			WHERE 
				rt_rate.rt_rate_ix IS NULL
		",2);
		
		foreach($rate_component_orphans as $item){
			rt_rate_component_delete($item['rt_rate_component_ix']);
			$log[] = "[".$item['rt_rate_component_ix']."] Deleted rt_rate_component record";	
		}			
		
		// Get all rate component group records linked to rate components that are orphans
		$rate_component_group_related_orphans = $lDB->get("
			SELECT
				rt_rate_comp_grp.rt_rate_comp_grp_ix
			FROM
				rt_rate_comp_grp
				INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
				LEFT JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
			WHERE 
				rt_rate.rt_rate_ix IS NULL
		",2);
		
		foreach($rate_component_group_related_orphans as $item){
			rt_rate_comp_grp_delete($item['rt_rate_comp_grp_ix']);
			$log[] = "[".$item['rt_rate_comp_grp_ix']."] Deleted rt_rate_comp_grp record";	
		}	

		// Get all rt_rate_grp_amt records that are orphans
		$rate_grp_amt_orphans = $lDB->get("
			SELECT
				rt_rate_grp_amt.rt_rate_grp_amt_ix
			FROM
				rt_rate_grp_amt
				LEFT JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_grp_amt.rt_rate_id
			WHERE 
				rt_rate.rt_rate_ix IS NULL
		",2);
		
		foreach($rate_grp_amt_orphans as $item){
			rt_rate_grp_amt_delete($item['rt_rate_grp_amt_ix']);
			$log[] = "[".$item['rt_rate_grp_amt_ix']."] Deleted rt_rate_grp_amt record";	
		}

		// Get all rate component group orphan records
		$rate_component_group_orphans = $lDB->get("
			SELECT
				rt_rate_comp_grp.rt_rate_comp_grp_ix
			FROM
				rt_rate_comp_grp
				LEFT JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			WHERE 
				rt_rate_component.rt_rate_component_ix IS NULL
		",2);
		
		foreach($rate_component_group_orphans as $item){
			rt_rate_comp_grp_delete($item['rt_rate_comp_grp_ix']);
			$log[] = "[".$item['rt_rate_comp_grp_ix']."] Deleted rt_rate_comp_grp record";	
		}			


		if (count($log) > 0){				
			return $log;
		} else {
			return "No records to fix.";
		}

	}		

?>
