<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/test_functions.php'); 
require_once(__DIR__ . '/fix_functions.php'); 

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

function redirect($url){
	redirectTo("".$url);
}

/* Test if user is internal */
if($GLOBALS['userStatusId'] < "2") {
	redirect("/reservation.php");
	die();
}

/* TODO: Test if user is censysad */
$loggedInUserId = $lDB->get("
			SELECT
				pr_user_id
			FROM
				pr_user
			WHERE 
				pr_user_name = 'censysad'
		",4);
if($GLOBALS['userid'] != $loggedInUserId) {
	redirect("/reservation.php");
	die();
}


$GLOBALS['lDB']->isMaster = "1"; // Set to master

$title = "Rate test / fix tool";
$content = "";

$testGroupDescs = array(
	1 => array(
		"name" => "TEST GROUP 1: Rate group tests (1, 3, 4, 5). CRITICAL Rate Group issues only",
		"desc" => "This battery of tests will list all CRITICAL problems on reservations that will be directly affected by regenerates and recalcs."
		),
	2 => array(
		"name" => "TEST GROUP 2: Rate group tests (1, 2, 3, 4, 5). All Rate Group issues",
		"desc" => "Same as TEST GROUP 1, but includes Test 2 which is not critical. These reservations must be fixed, but it should be noted that many of the reservations listed here are not going to be affected by regenerates and recals and are therefore not a priority to be fixed."
		),
	3 => array(
		"name" => "TEST GROUP 3: Orphaned records (6, 7, 8 and 9)",
		"desc" => "Checks for orphaned records in the following tables: <br>
			rv_res_item_rate_grp<br>
			rv_res_item_comp<br>
			rv_res_item_comp_tax<br>
			rv_res_item_comp_rate_grp"
		),
	4 => array(
		"name" => "TEST GROUP 4: Tax tests (10 and 11)",
		"desc" => "Tests for problems with the tax tables.  Please note that this tool can only fix these problems where there are no tax-groups in use."
		)
);

$testDescs = array(
	1 => "TEST 1: Test for missing or unbalanced rv_res_item_rate_grp records",
	2 => "TEST 2: Test for 1:1 relationship between itinerary rate groups and component rate groups",
	3 => "TEST 3: Test that the totals at the component rate group level add up to the total at the component level",
	4 => "TEST 4: Test for duplicates in rv_res_item_comp_rate_grp",
	5 => "TEST 5: Test for duplicates in rv_res_item_rate_grp",
	6 => "TEST 6: Test for orphaned records in rv_res_item_rate_grp",
	7 => "TEST 7: Test for orphaned records in rv_res_item_comp",
	8 => "TEST 8: Test for orphaned records in rv_res_item_comp_tax",
	9 => "TEST 9: Test for orphaned records in rv_res_item_comp_rate_grp",
	10 => "TEST 10: Test for duplicates on tax id in rv_res_item_comp_tax",
	11 => "TEST 11: Test that the component tax totals add up to the total on the component",
	12 => "TEST 12: Test for duplicates on component id in rv_res_item_comp",
	13 => "TEST 13: Test that the component totals add up to the total at the itinerary level",
	14 => "TEST 14: Test for orphaned rate records",
	15 => "TEST 15: Test that the totals at the component rate group level add up to the total at the itinerary level"
);

$fixDescs = array(
	1 => "FIX 1: Fix for test 1, 2, 3, 4 and 5",
	2 => "FIX 2: Delete orphaned records (tests 6, 7, 8, and 9)",
	3 => "FIX 3: Fix tax records where possible (tests 10 and 11)",
	4 => "FIX 4: Delete duplicates on component id in rv_res_item_comp (test 12)",
	5 => "FIX 5: Fix orphaned rate records (test 14)"
);

$backButton = "";
$thisFixButton = "";
$header = "";
$noProblemsHTML = "
	<div class=\"noProblemsDiv\">
		<p>No problems detected.  Now we so happy, we do the dance of joy! </p> <img src=\"/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_fix/danceofjoy-1.gif\">
	</div>
";

if (isset($_POST['action'])){
	switch($_POST['action']) {
	case "tests":
		$content .= "<br/>";
		foreach($testGroupDescs as $key => $testGroupDesc){
			$content .= "
				<div class=\"testGroupDiv\">
					<button class=\"testGroupButton\" id=\"test_group_".$key."\" onclick=\"do_action(this)\"/>".$testGroupDescs[$key]['name']."</button><br/>
					<p class=\"testDesc\">".$testGroupDescs[$key]['desc']."</p>
				</div>
				<br/>
			";
		}
		$content .= "<div class=\"testDiv\">";
		foreach($testDescs as $key => $testDesc){
			$content .= "
				<button class=\"testButton\" id=\"test_".$key."\" onclick=\"do_action(this)\"/>$testDescs[$key]</button><br/>			
			";
		}
		break;
		$content .= "</div>";	
	case "fixes":
		$content .= "<br/>";
		$content .= "<div class=\"fixDiv\">";
		foreach($fixDescs as $key => $fixDesc){
			$content .= "
				<button class=\"fixButton\"  id=\"prep_fix_".$key."\" onclick=\"do_action(this)\"/>$fixDescs[$key]</button><br/>
			";
		}
		break;	
		$content .= "</div>";
	case "test_1":
		$header = $testDescs[1];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Res ID", "Unit Rate Group Count", "Unit Itinerary Count", "Adult Rate Group Count", "Adult Itinerary Count", "Child Rate Group Count", "Child Itinerary Count");
		$results = test_1();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_2":
		$header = $testDescs[2];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Res ID", "Orphan Comp Rate Groups", "Mising Comp Rate Groups");
		$results = test_2();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;
	case "test_3":
		$header = $testDescs[3];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";	
		$headers = array("Res ID", "# Unbalanced Components");
		$results = test_3();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;		
	case "test_4":
		$header = $testDescs[4];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";		
		$headers = array("Reservation ID");
		$results = test_4();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;		
	case "test_5":
		$header = $testDescs[5];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";		
		$headers = array("Reservation ID");
		$results = test_5();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_6":
		$header = $testDescs[6];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$headers = array("ID","Dead Parent ID");
		$results = test_6();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;		
	case "test_7":
		$header = $testDescs[7];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$headers = array("ID","Dead Parent ID");
		$results = test_7();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_8":
		$header = $testDescs[8];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$headers = array("ID","Dead Parent ID");
		$results = test_8();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;		
	case "test_9":
		$header = $testDescs[9];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$headers = array("ID","Dead Parent ID");
		$results = test_9();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_10":
		$header = $testDescs[10];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_3\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Reservation ID");
		$results = test_10();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_11":
		$header = $testDescs[11];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_3\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Res ID", "Problematic Itinerary Components");
		$results = test_11();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;
	case "test_12":
		$header = $testDescs[12];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_4\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Reservation ID");
		$results = test_12();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_13":
		$header = $testDescs[13];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$headers = array("Res ID", "Problematic Itineraries");
		$results = test_13();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_14":
		$header = $testDescs[14];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$thisFixButton = "<button class=\"menuButton\"  id=\"fix_5\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";	
		$headers = array("Table", "Number of records");
		$results = test_14();
		$found = false;
		foreach ($results as $table){
			if ($table[1] > 0){
				$found = true;
			}
		}
		if ($found){
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_15":
		$header = $testDescs[15];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";	
		// $thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";	
		$headers = array("Res ID", "# Unbalanced Itineraries");
		$results = test_15();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;			
	case "test_group_1":
		$header = $testGroupDescs[1]['name'];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Reservation ID", "Test 1", "Test 3", "Test 4", "Test 5");
		$results = test_group_1();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;		
	case "test_group_2":
		$header = $testGroupDescs[2]['name'];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_1\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Reservation ID", "Test 1", "Test 2", "Test 3", "Test 4", "Test 5");
		$results = test_group_2();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_group_3":
		$header = $testGroupDescs[3]['name'];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$thisFixButton = "<button class=\"menuButton\"  id=\"fix_2\" onclick=\"do_fix(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Test 6", "Test 7", "Test 8", "Test 9");
		$results = test_group_3();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers, TRUE);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "test_group_4":
		$header = $testGroupDescs[4]['name'];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_tests()\"/> << Tests</button>";
		$thisFixButton = "<button class=\"menuButton\"  id=\"prep_fix_3\" onclick=\"do_action(this)\"/>>> Goto Fix</button><br/>";
		$headers = array("Reservation ID","Test 10", "Test 11");
		$results = test_group_4();
		if (is_array($results) && count($results) > 0){
			$content .= "<p>Total : ".count($results)."</p>";
			$content .= tabulate($results, $headers);
		} else {
			$content .= $noProblemsHTML;
		}
		break;	
	case "prep_fix_1":
		$header = $fixDescs[1];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		if ($_POST['records']){
			$records = $_POST['records'];
		} else {
			$records = "";
		}
		$content .= "
			<div class=\"fixPrepDiv\">
				<button id=\"fix_1\" onclick=\"do_fix(this)\"/>Fix These Records</button>&nbsp;&nbsp;<input readonly type=\"text\" id=\"recordCount\" size=25 maxlength=25 value=\"\"> <br/>	
				<textarea id=\"idList\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"11\"onKeyDown=\"RecordCount(this.form.text,this.form.left,50);\" onKeyUp=\"RecordCount(this.form.text,this.form.left,50);\">$records</textarea><br/>
			</div>
		";
		break;	
	case "fix_1":
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		$header = $fixDescs[1];
		if ($_POST['records']){
			$records = explode("\n",str_replace("\r","",$_POST['records']));
			$log = fix_1($records);
			$content .= "
				<textarea id=\"resultLog\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"70\">".trim(implode("\n", $log))."</textarea><br/>
			";
		} else {
			$content .= "No records to fix.";
		}
		break;			
	case "fix_2":
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		$header = $fixDescs[2];

		$log = fix_2();
		$content .= "
			<textarea id=\"resultLog\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"70\">".trim(implode("\n", $log))."</textarea><br/>
		";

		break;		
	case "prep_fix_3":
		$header = $fixDescs[3];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		if ($_POST['records']){
			$records = $_POST['records'];
		} else {
			$records = "";
		}
		$content .= "
			<button id=\"fix_3\" onclick=\"do_fix(this)\"/>Fix These Records</button>&nbsp;&nbsp;<input readonly type=\"text\" id=\"recordCount\" size=25 maxlength=25 value=\"\"> <br/>
			<textarea id=\"idList\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"11\"onKeyDown=\"RecordCount(this.form.text,this.form.left,50);\" onKeyUp=\"RecordCount(this.form.text,this.form.left,50);\">$records</textarea><br/>
		";
		break;		
	case "fix_3":
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		$header = $fixDescs[3];
		if ($_POST['records']){
			$records = explode("\n",str_replace("\r","",$_POST['records']));
			$log = fix_3($records);
			$content .= "
				<textarea id=\"resultLog\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"70\">".trim(implode("\n", $log))."</textarea><br/>
			";
		} else {
			$content .= "No records to fix.";
		}
		break;	
	case "prep_fix_4":
		$header = $fixDescs[4];
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		if ($_POST['records']){
			$records = $_POST['records'];
		} else {
			$records = "";
		}
		$content .= "
			<button id=\"fix_4\" onclick=\"do_fix(this)\"/>Fix These Records</button>&nbsp;&nbsp;<input readonly type=\"text\" id=\"recordCount\" size=25 maxlength=25 value=\"\"> <br/>
			<textarea id=\"idList\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"11\"onKeyDown=\"RecordCount(this.form.text,this.form.left,50);\" onKeyUp=\"RecordCount(this.form.text,this.form.left,50);\">$records</textarea><br/>
		";
		break;		
	case "fix_4":
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		$header = $fixDescs[4];
		if ($_POST['records']){
			$records = explode("\n",str_replace("\r","",$_POST['records']));
			$log = fix_4($records);
			$content .= "
				<textarea id=\"resultLog\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"70\">".trim(implode("\n", $log))."</textarea><br/>
			";
		} else {
			$content .= "No records to fix.";
		}
		break;
	case "fix_5":
		$backButton = "<button class=\"menuButton\" id=\"backButton\" onclick=\"menu_fixes()\"/> << Fixes</button>";
		$header = $fixDescs[5];
		if ($_POST['records']){
			$records = explode("\n",str_replace("\r","",$_POST['records']));
			$log = fix_5($records);
			$content .= "
				<textarea id=\"resultLog\" wrap=\"off\" style=\"overflow: scroll\" rows=\"15\" cols=\"70\">".trim(implode("\n", $log))."</textarea><br/>
			";
		} else {
			$content .= "No records to fix.";
		}
		break;		
		
	default:
		$content .= "
			<button class=\"menuButton\" onclick=\"menu_tests()\"/>Tests</button><br/>
			<button class=\"menuButton\" onclick=\"menu_fixes()\"/>Fixes</button>
		";
		break;
	}
}


$content .= "

";
?>
<!DOCTYPE html>
<html>
<head>

<title><?php echo $title; ?></title>
<link rel="stylesheet" href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_fix/styles/main.css" type="text/css" />
<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_fix/js/jquery.js"></script>
<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_fix/js/rate_fix.js"></script>
</head>
<body onload="initialisePage();">
<table>
<tr>
	<td valign="top">		
		<table>
		<tr>
			<td><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/rate_fix/heart_rate.jpg"></td>
			<td><h2><?php echo $title; ?></h2></td>
		</tr>
		</table>
	</td>
</tr>
</table>
<br />
<form method="POST" id="mainForm">
	<input type="hidden" name="action" id="action" value=""/>
	<input type="hidden" name="records" id="records" value=""/>
	<button class="menuButton" onclick="menu_main()"/>Main Menu</button>
	<?php echo $backButton; ?>
	<?php echo $thisFixButton; ?>
<br/>
<?php 
if ($header != "") {

	echo "
		<h3>$header</h3>
	";
}
?>
<?php echo $content ?>
</form>

<br/><br/>
</body>
</html>
