<?php

	function tabulate($array, $headers=array(), $hidePrimary=FALSE){
		$cols = count($headers);
		$html = "<table id=\"results\">\n";
		$html .="
			<colgroup>  
		";
		if (!$hidePrimary){
			$html .="
				<col class=\"primaryIdCol\">
			";		
		}
		for($i = 0; $i < $cols; $i++){
			$html .= "<col>";
		}	
		$html .= "</colgroup>";
		$html .= "<tr>";
		for($i = 0; $i < $cols; $i++){
			$html .= "<th>".$headers[$i]."</th>";
		}
		$html .= "</tr>";
		foreach($array as $res){
			$html .= "<tr>";
			for ($k = 0; $k < $cols; $k++){
				if ($k == 0){
					$html .= "<td class=\"primaryId\">".(isset($res[$k]) ? $res[$k] : "")."</td>";
				} else {
					$html .= "<td>".(isset($res[$k]) ? $res[$k] : "")."</td>";
				}
			}
			$html .= "</tr>";
		}
		$html .= "</table>\n";
		
		return $html;
	}

	
	/*
		This function will do the following:
		1.) Find all reservations that have itineraries that are missing rv_res_item_rate_grp records.
	*/	
	function test_1(){
		global $lDB;

		$results = array();
		
		$allItineraries = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_reservation_id,
				rv_reservation_item.rv_item_accomm_count,
				rv_reservation_item.rv_item_adult_count,
				rv_reservation_item.rv_item_child_count
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		",2);
		
		$unitRateGroup = $lDB->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 1
		",4);
		
		$adultRateGroups = $lDB->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_class = 1
		",3);	

		$childRateGroups = $lDB->get("
			SELECT
				rt_rate_group_ix 
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_class = 2
		",3);			
		
		foreach ($allItineraries as $itinerary){
			$unitRateGroupRecord = array();
			$adultRateGroupRecord = array();
			$childRateGroupRecord = array();
			
			if ($itinerary['rv_item_accomm_count'] > 0){
				$unitRateGroupRecord = $lDB->get("
					SELECT
						SUM(rv_res_item_rate_grp.rv_res_item_rate_grp_count) AS count
					FROM 
						rv_res_item_rate_grp
					WHERE 
						rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
						AND rv_res_item_rate_grp.rt_rate_group_id = '$unitRateGroup'
				",2);
				
				if($unitRateGroupRecord[0]['count'] != $itinerary['rv_item_accomm_count']){
					$results[$itinerary['rv_reservation_id']][0] = $itinerary['rv_reservation_id'];
					$results[$itinerary['rv_reservation_id']][1] = ($unitRateGroupRecord[0]['count']) ? $unitRateGroupRecord[0]['count'] : "None";
					$results[$itinerary['rv_reservation_id']][2] = $itinerary['rv_item_accomm_count'];
				}
			}

			if ($itinerary['rv_item_adult_count'] > 0){
				$adultRateGroupRecord = $lDB->get("
					SELECT
						SUM(rv_res_item_rate_grp.rv_res_item_rate_grp_count) AS count
					FROM 
						rv_res_item_rate_grp
					WHERE 
						rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
						AND rv_res_item_rate_grp.rt_rate_group_id IN ('".join("','",$adultRateGroups)."')
				",2);
				
				if($adultRateGroupRecord[0]['count'] != $itinerary['rv_item_adult_count']){
					$results[$itinerary['rv_reservation_id']][0] = $itinerary['rv_reservation_id'];
					$results[$itinerary['rv_reservation_id']][3] = ($adultRateGroupRecord[0]['count']) ? $adultRateGroupRecord[0]['count'] : "None";
					$results[$itinerary['rv_reservation_id']][4] = $itinerary['rv_item_adult_count'];
				}				
				
			}
			
			if ($itinerary['rv_item_child_count'] > 0){
				$childRateGroupRecord = $lDB->get("
					SELECT
						SUM(rv_res_item_rate_grp.rv_res_item_rate_grp_count) AS count
					FROM 
						rv_res_item_rate_grp
					WHERE 
						rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
						AND rv_res_item_rate_grp.rt_rate_group_id IN ('".join("','",$childRateGroups)."')
				",2);
				
				if($childRateGroupRecord[0]['count'] != $itinerary['rv_item_child_count']){
					$results[$itinerary['rv_reservation_id']][0] = $itinerary['rv_reservation_id'];
					$results[$itinerary['rv_reservation_id']][5] = ($childRateGroupRecord[0]['count']) ? $childRateGroupRecord[0]['count'] : "None";
					$results[$itinerary['rv_reservation_id']][6] = $itinerary['rv_item_child_count'];
				}				
			}	
		}
		
		// Now check in the other direction (where we have rate groups but itinerary says there should not be)
		// Units
		$unitRateGroupRecords = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_reservation_item.rv_item_accomm_count,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count
			FROM
				rv_res_item_rate_grp
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_rate_grp.rv_reservation_item_id
			WHERE
				rt_rate_group.rt_rate_group_class = 0
				AND rv_res_item_rate_grp.rv_res_item_rate_grp_count > 0
				AND rv_reservation_item.rv_item_accomm_count = 0	
		",2);
		
		if (count($unitRateGroupRecords) > 0){
			foreach($unitRateGroupRecords as $unitRateGroupRecord){
				$results[$unitRateGroupRecord['rv_reservation_id']][0] = $unitRateGroupRecord['rv_reservation_id'];
				$results[$unitRateGroupRecord['rv_reservation_id']][1] = $unitRateGroupRecord['rv_res_item_rate_grp_count'];
				$results[$unitRateGroupRecord['rv_reservation_id']][2] = $unitRateGroupRecord['rv_item_accomm_count'];
			}
		}		
		
		// Adults
		$adultRateGroupRecords = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_reservation_item.rv_item_adult_count,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count
			FROM
				rv_res_item_rate_grp
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_rate_grp.rv_reservation_item_id
			WHERE
				rt_rate_group.rt_rate_group_class = 1
				AND rv_res_item_rate_grp.rv_res_item_rate_grp_count > 0
				AND rv_reservation_item.rv_item_adult_count = 0	
		",2);
		
		if (count($adultRateGroupRecords) > 0){
			foreach($adultRateGroupRecords as $adultRateGroupRecord){
				$results[$adultRateGroupRecord['rv_reservation_id']][0] = $adultRateGroupRecord['rv_reservation_id'];
				$results[$adultRateGroupRecord['rv_reservation_id']][3] = $adultRateGroupRecord['rv_res_item_rate_grp_count'];
				$results[$adultRateGroupRecord['rv_reservation_id']][4] = $adultRateGroupRecord['rv_item_adult_count'];
			}
		}		
		
		// Children
		$childRateGroupRecords = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_reservation_item.rv_item_child_count,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count
			FROM
				rv_res_item_rate_grp
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_rate_grp.rv_reservation_item_id
			WHERE
				rt_rate_group.rt_rate_group_class = 2
				AND rv_res_item_rate_grp.rv_res_item_rate_grp_count > 0
				AND rv_reservation_item.rv_item_child_count = 0	
		",2);
		
		if (count($childRateGroupRecords) > 0){
			foreach($childRateGroupRecords as $childRateGroupRecord){
				$results[$childRateGroupRecord['rv_reservation_id']][0] = $childRateGroupRecord['rv_reservation_id'];
				$results[$childRateGroupRecord['rv_reservation_id']][5] = $childRateGroupRecord['rv_res_item_rate_grp_count'];
				$results[$childRateGroupRecord['rv_reservation_id']][6] = $childRateGroupRecord['rv_item_child_count'];
			}
		}
		
		return $results;
		
	}

	/*
		This function will do the following:
		1.) Test for 1:1 relationship between itinerary rate groups and component rate groups

	*/
	
	function test_2(){	
		global $lDB;

		$result = array();


		$itineraries = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_reservation_id
			FROM
				rv_reservation_item
		",2);

		foreach($itineraries as $itinerary){
		
			$itinRateGroups = $lDB->get("
				SELECT
					rv_res_item_rate_grp.rt_rate_group_id
				FROM
					rv_res_item_rate_grp
				WHERE
					rv_res_item_rate_grp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
					AND rv_res_item_rate_grp.rv_res_item_rate_grp_count > 0
			",3);				
	
			$components = $lDB->get("
				SELECT
					rv_res_item_comp.rv_res_item_comp_ix,
					rv_res_item_comp.rv_item_comp_rate,
					rv_res_item_comp.rv_item_comp_amt_gross,
					rv_res_item_comp.rv_item_comp_amt_nett,
					rv_res_item_comp.rv_item_comp_amt_comm,
					rv_res_item_comp.rv_item_comp_amt_tax,
					rv_res_item_comp.rv_item_comp_amt_payable,
					rv_res_item_comp.rv_item_comp_var,
					rv_reservation_item.rv_reservation_item_ix,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_adult_count,
					rv_reservation_item.rv_item_child_count						
				FROM
					rv_res_item_comp
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				WHERE
					rv_res_item_comp.rv_reservation_item_id = '".$itinerary['rv_reservation_item_ix']."'
			",2);

			foreach ($components as $component){
			
				// Comp rate groups where rate groups don't exist on the itinerary
				$compRateGroups = $lDB->get("
					SELECT
						rv_res_item_comp_rate_grp_ix
					FROM
						rv_res_item_comp_rate_grp
					WHERE
						rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
						AND rv_res_item_comp_rate_grp.rt_rate_group_id NOT IN ('".join("','",$itinRateGroups)."')
				",3);
				
				foreach($compRateGroups as $compRategroup){
					$result[$itinerary['rv_reservation_id']][0] = $itinerary['rv_reservation_id'];
					$result[$itinerary['rv_reservation_id']][1] = $result[$itinerary['rv_reservation_id']][1]+1;
				}
				
				// Missing rv_res_item_comp_rate_grp records
				foreach($itinRateGroups as $itinRateGroup){
					$compRateGroup = $lDB->get("
						SELECT
							rv_res_item_comp_rate_grp_ix
						FROM
							rv_res_item_comp_rate_grp
						WHERE
							rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_ix']."'
							AND rv_res_item_comp_rate_grp.rt_rate_group_id = '$itinRateGroup'
					",4);

					if(empty($compRateGroup)){
						$result[$itinerary['rv_reservation_id']][0] = $itinerary['rv_reservation_id'];
						$result[$itinerary['rv_reservation_id']][2] = $result[$itinerary['rv_reservation_id']][2]+1;
					}
				}
			}
		}

		
		return $result;
		
	}
	
	/*
		This function will do the following:
		1.) Test that the totals at the component rate group level add up to the total at the component level
	*/
	
	function test_3(){	
		global $lDB;

		$result = array();
		
		$unbalancedRecords = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rv_reservation_item_id,
				rv_item_comp_rate,
				rv_item_comp_amt_gross,
				rv_item_comp_amt_nett,
				rv_item_comp_amt_comm,
				rv_item_comp_amt_tax,
				rv_item_comp_amt_payable,
				rv_item_comp_var, 	
				ROUND(rv_item_comp_rate,2) as rate1,
				ROUND(SUM(rv_item_comp_rate_grp_rate),2) AS rate2,
				ROUND(rv_item_comp_amt_payable,2) as payable1,
				ROUND(SUM(rv_item_comp_rate_grp_amt_payable),2) AS payable2				
			FROM
				rv_res_item_comp
				INNER JOIN rv_res_item_comp_rate_grp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			GROUP BY
				rv_res_item_comp.rv_res_item_comp_ix
			HAVING
				(rate1 <> rate2) OR (payable1 <> payable2);		
		",2);


		
		foreach($unbalancedRecords as $item){
			// Check that the difference is more than a single cent to cater for rounding problems arising from a previous fix
			$rate_diff = round(abs($item['rate1'] - $item['rate2']),2);
			$payable_diff = round(abs($item['payable1'] - $item['payable2']),2);
			if ($rate_diff > 0.01 || $payable_diff > 0.01){
				$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
				if (isset($result[$item['rv_reservation_id']][1])){
					$result[$item['rv_reservation_id']][1] = $result[$item['rv_reservation_id']][1]+1;
				} else {
					$result[$item['rv_reservation_id']][1] = 1;
				}
				
			}
		}			
		
		return $result;
		
	}
	
	/*
		This function will do the following:
		1.) Test for duplicates on rate group id in rv_res_item_comp_rate_grp
	*/	
	
	function test_4(){	
		global $lDB;
	
		$result = array();
	
		$duplicateRecords = $lDB->get("
			SELECT 
				rv_reservation_item.rv_reservation_id,
				rv_res_item_comp_rate_grp.rv_res_item_comp_id,
				rv_res_item_comp_rate_grp.rt_rate_group_id,
				COUNT(rv_res_item_comp_rate_grp_ix) as total,
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix
			FROM
				rv_res_item_comp_rate_grp
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id	
			GROUP BY 
				rv_res_item_comp_rate_grp.rv_res_item_comp_id, rv_res_item_comp_rate_grp.rt_rate_group_id
			HAVING
				total > 1;
		",2);		
		
		foreach($duplicateRecords as $item){
			$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
		}	
		
		return $result;
	}		
	
	/*
		This function will do the following:
		1.) Test for duplicates on rate group id in rv_res_item_rate_grp
	*/	
	
	function test_5(){	
		global $lDB;
	
		$result = array();
	
		$duplicateRecords = $lDB->get("
			SELECT 
				rv_reservation_item.rv_reservation_id,
				rv_res_item_rate_grp.rv_reservation_item_id,
				rv_res_item_rate_grp.rt_rate_group_id,
				COUNT(rv_res_item_rate_grp_ix) as total,
				rv_res_item_rate_grp.rv_res_item_rate_grp_ix
			FROM
				rv_res_item_rate_grp
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_rate_grp.rv_reservation_item_id	
			GROUP BY 
				rv_res_item_rate_grp.rv_reservation_item_id, rv_res_item_rate_grp.rt_rate_group_id
			HAVING
				total > 1;
		",2);		
		
		foreach($duplicateRecords as $item){
			$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
		}	
		
		return $result;
	}	
	
	/*
		This function will do the following:
		1.) Test for orphaned records in rv_res_item_rate_grp
	*/	
	
	function test_6(){	
		global $lDB;
	
		$result = array();
	
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
				rv_res_item_rate_grp.rv_reservation_item_id
			FROM
				rv_res_item_rate_grp
				LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_rate_grp.rv_reservation_item_id
			WHERE 
				rv_reservation_item.rv_reservation_item_ix IS NULL
		",2);

		foreach($orphanedRecords as $item){
			$result[$item['rv_res_item_rate_grp_ix']][0] = $item['rv_res_item_rate_grp_ix'];
			$result[$item['rv_res_item_rate_grp_ix']][1] = $item['rv_reservation_item_id'];
		}		
		
		return $result;
		
	}		

	/*
		This function will do the following:
		1.) Test for orphaned records in rv_res_item_comp
	*/	
	
	function test_7(){	
		global $lDB;
	
		$result = array();
	
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rv_reservation_item_id
			FROM
				rv_res_item_comp
				LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
			WHERE 
				rv_reservation_item.rv_reservation_item_ix IS NULL
		",2);		
		
		foreach($orphanedRecords as $item){
			$result[$item['rv_res_item_comp_ix']][0] = $item['rv_res_item_comp_ix'];
			$result[$item['rv_res_item_comp_ix']][1] = $item['rv_reservation_item_id'];
		}	
		
		return $result;
		
	}
	
	/*
		This function will do the following:
		1.) Test for orphaned records in rv_res_item_comp_tax
	*/	
	
	function test_8(){	
		global $lDB;
	
		$result = array();
	
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_comp_tax.rv_res_item_comp_tax_ix,
				rv_res_item_comp_tax.rv_res_item_comp_id
			FROM
				rv_res_item_comp_tax
				LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
			WHERE 
				rv_res_item_comp.rv_res_item_comp_ix IS NULL
		",2);		
		
		foreach($orphanedRecords as $item){
			$result[$item['rv_res_item_comp_tax_ix']][0] = $item['rv_res_item_comp_tax_ix'];
			$result[$item['rv_res_item_comp_tax_ix']][1] = $item['rv_res_item_comp_id'];
		}	
		
		return $result;
		
	}	
	
	/*
		This function will do the following:
		1.) Test for orphaned records in rv_res_item_comp_rate_grp
	*/	
	
	function test_9(){	
		global $lDB;
	
		$result = array();
	
		$orphanedRecords = $lDB->get("
			SELECT
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
				rv_res_item_comp_rate_grp.rv_res_item_comp_id
			FROM
				rv_res_item_comp_rate_grp
				LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
			WHERE 
				rv_res_item_comp.rv_res_item_comp_ix IS NULL
		",2);		
		
		foreach($orphanedRecords as $item){
			$result[$item['rv_res_item_comp_rate_grp_ix']][0] = $item['rv_res_item_comp_rate_grp_ix'];
			$result[$item['rv_res_item_comp_rate_grp_ix']][1] = $item['rv_res_item_comp_id'];
		}	
		
		return $result;
		
	}	

	/*
		This function will do the following:
		1.) Test for duplicates on tax id in rv_res_item_comp_tax
	*/	
	
	function test_10(){	
		global $lDB;
	
		$result = array();
	
		$duplicateRecords = $lDB->get("
			SELECT 
				rv_reservation_item.rv_reservation_id,
				rv_res_item_comp_tax.rv_res_item_comp_tax_ix,
				rv_res_item_comp_tax.rf_tax_rate_id,
				COUNT(rv_res_item_comp_tax.rv_res_item_comp_tax_ix) as total
			FROM
				rv_res_item_comp_tax
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id	
			GROUP BY 
				rv_res_item_comp_tax.rv_res_item_comp_id, rv_res_item_comp_tax.rf_tax_rate_id
			HAVING
				total > 1;
		",2);		
		
		foreach($duplicateRecords as $item){
			$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
		}	
		
		return $result;
	}	
	
	/*
		This function will do the following:
		1.) Test that the component tax totals add up to the total on the component
	*/	
	
	function test_11(){	
		global $lDB;

		$result = array();
		
		$unbalancedRecords = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_id,
			rv_res_item_comp.rv_res_item_comp_ix,
			ROUND(rv_res_item_comp.rv_item_comp_amt_tax,2) as tax1,
			ROUND(SUM(rv_res_item_comp_tax.rv_res_item_comp_tax_amt),2) AS tax2
		FROM
			rv_res_item_comp
			INNER JOIN rv_res_item_comp_tax ON rv_res_item_comp_tax.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
		GROUP BY
			rv_res_item_comp.rv_res_item_comp_ix
		HAVING
			tax1 <> tax2;		
		",2);
		
		foreach($unbalancedRecords as $item){
			$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
			$result[$item['rv_reservation_id']][1] = $result[$item['rv_reservation_id']][1]+1;
		}			
		
		return $result;
		
	}	
	
	/*
		This function will do the following:
		1.) Check for duplicates on component id in rv_res_item_comp
	*/	
	
	function test_12(){	
		global $lDB;
	
		$result = array();
	
		$duplicateRecords = $lDB->get("
			SELECT 
				rv_reservation_item.rv_reservation_id,
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rt_component_id,
				COUNT(rv_res_item_comp.rv_res_item_comp_ix) as total
			FROM
				rv_res_item_comp
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id	
			GROUP BY 
				rv_res_item_comp.rv_reservation_item_id, rv_res_item_comp.rt_component_id
			HAVING
				total > 1;
		",2);		
		
		foreach($duplicateRecords as $item){
			$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
		}	
		
		return $result;
	}		

	/*
		This function will do the following:
		1.) Test that the component totals add up to the total at the itinerary level
	*/	
	
	function test_13(){	
		global $lDB;

		$result = array();
		
		$unbalancedRecords = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_reservation_item.rv_reservation_item_id,
				ROUND(rv_reservation_item.rv_item_amt_payable,2) as rate1,
				ROUND(SUM(rv_res_item_comp.rv_item_comp_amt_payable),2) AS rate2
			FROM
				rv_reservation_item
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			GROUP BY
				rv_reservation_item.rv_reservation_item_ix
			HAVING
				rate1 <> rate2;		
		",2);
		
		foreach($unbalancedRecords as $item){
			$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
			$result[$item['rv_reservation_id']][1] = $result[$item['rv_reservation_id']][1]+1;
		}			
		
		return $result;
		
	}		

	function test_14(){	
		global $lDB;

		$result = array();

		$rate_orphans = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rt_rate
				LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id
				LEFT JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id
				LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id
			WHERE
				rt_rate_type.rt_rate_type_ix IS NULL
				OR rt_period.rt_period_ix IS NULL
				OR ac_accomm_type.ac_accomm_type_ix IS NULL
		",4);
		$result[0][0] = "rt_rate";
		$result[0][1] = $rate_orphans;
		
		$rate_component_orphans = $lDB->get("
			SELECT
				COUNT(rt_rate_component.rt_rate_component_ix)
			FROM
				rt_rate_component
				LEFT JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
			WHERE 
				rt_rate.rt_rate_ix IS NULL
		",2);
		
		foreach($rate_component_orphans as $item){
			$result[1][0] = "rt_rate_component";
			$result[1][1] = $item[0];
		}			
		
		// Get all rate component group records linked to rate components that are orphans
		$rate_component_group_related_orphans = $lDB->get("
			SELECT
				COUNT(rt_rate_comp_grp.rt_rate_comp_grp_ix)
			FROM
				rt_rate_comp_grp
				INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
				LEFT JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_component.rt_rate_id
			WHERE 
				rt_rate.rt_rate_ix IS NULL
		",2);
		
		foreach($rate_component_group_related_orphans as $item){
			$result[2][0] = "rt_rate_comp_group (where parent is orphan)";
			$result[2][1] = $item[0];
		}	

		// Get all rt_rate_grp_amt records that are orphans
		$rate_grp_amt_orphans = $lDB->get("
			SELECT
				COUNT(rt_rate_grp_amt.rt_rate_grp_amt_ix)
			FROM
				rt_rate_grp_amt
				LEFT JOIN rt_rate ON rt_rate.rt_rate_ix = rt_rate_grp_amt.rt_rate_id
			WHERE 
				rt_rate.rt_rate_ix IS NULL
		",2);
		
		foreach($rate_grp_amt_orphans as $item){
			$result[3][0] = "rt_rate_grp_amt";
			$result[3][1] = $item[0];
		}

		// Get all rate component group orphan records
		$rate_component_group_orphans = $lDB->get("
			SELECT
				COUNT(rt_rate_comp_grp.rt_rate_comp_grp_ix)
			FROM
				rt_rate_comp_grp
				LEFT JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			WHERE 
				rt_rate_component.rt_rate_component_ix IS NULL
		",2);
		
		foreach($rate_component_group_orphans as $item){
			$result[4][0] = "rt_rate_comp_group";
			$result[4][1] = $item[0];
		}	

		return $result;
		
	}		

	/*
		This function will do the following:
		1.) Test that the totals at the component rate group level add up to the total at the itinerary level
	*/
	
	function test_15(){	
		global $lDB;

		$result = array();
		
		$unbalancedRecords = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_reservation_item.rv_reservation_item_ix,
				ROUND(rv_reservation_item.rv_item_amt_gross,2) as itin_total,
				ROUND(SUM(rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_rate),2) AS rate2,
				ROUND(SUM(rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_var),2) AS var2,
				ROUND(SUM(rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_rate) + SUM(rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_var),2) AS expected_total
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				INNER JOIN rv_res_item_comp_rate_grp ON rv_res_item_comp_rate_grp.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
			GROUP BY
				rv_reservation_item.rv_reservation_item_ix
			HAVING
				itin_total <> (rate2+var2)
			ORDER BY rv_reservation_id	
		",2);
		
		foreach($unbalancedRecords as $item){
			// Check that the difference is more than a single cent to cater for rounding problems arising from a previous fix
			$rate_diff = round(abs($item['expected_total'] - $item['itin_total']),2);
			if ($rate_diff > 0.01){
				$result[$item['rv_reservation_id']][0] = $item['rv_reservation_id'];
				$result[$item['rv_reservation_id']][1] = $result[$item['rv_reservation_id']][1]+1;
			}
		}			
		
		return $result;
		
	}

	function test_group_1(){
		global $lDB;
	
		$result = array();
	
		$testResult = test_1();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][1] = "x";
		}		
		
		$testResult = test_3();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][2] = "x";
		}	

		$testResult = test_4();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][3] = "x";
		}	

		$testResult = test_5();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][4] = "x";
		}			
		
		asort($result);
		
		return $result;
	}
	
	function test_group_2(){
		global $lDB;
	
		$result = array();
	
		$testResult = test_1();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][1] = "x";
		}		
		
		$testResult = test_2();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][2] = "x";
		}
		
		$testResult = test_3();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][3] = "x";
		}	

		$testResult = test_4();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][4] = "x";
		}	

		$testResult = test_5();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][5] = "x";
		}			
		
		asort($result);
		
		return $result;
	}
	
	function test_group_3(){
		global $lDB;
	
		$result = array();
	
		$testResult = test_6();
		foreach($testResult as $key => $item){
			$result[$key][0] = "x";
		}		
		
		$testResult = test_7();
		foreach($testResult as $key => $item){
			$result[$key][1] = "x";
		}
		
		$testResult = test_8();
		foreach($testResult as $key => $item){
			$result[$key][2] = "x";
		}	

		$testResult = test_9();
		foreach($testResult as $key => $item){
			$result[$key][3] = "x";
		}	
		
		asort($result);
		
		return $result;
	}
	
	function test_group_4(){
		global $lDB;
	
		$result = array();
	
		$testResult = test_10();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][1] = "x";
		}		
		
		$testResult = test_11();
		foreach($testResult as $key => $item){
			$result[$key][0] = $key;
			$result[$key][2] = "x";
		}
		
		asort($result);
		
		return $result;
	}

	
?>
