<?php
class pr_persona {
	/**
	* Draw an ajax enabled user search box
	*/
	static function drawSearchField($id, $name, $text="", $value="", $notify=null){
		$list = array(
			'id'=>$id,
			'name'=>$name,
			'style'=>($notify == NT_SCRIPT ? " style=\"display:none;\" " : ""),
			'text'=>t_encodeOverlib($text),
			'value'=>t_encodeOverlib($value)
		);

		return showpage($list,join("",file(__DIR__ . "/pr_persona.htm")));
	}

	/**
	* Loads the ajax script for the drawSearchFiled()
	*/
	static function loadScript(){
		return join("",file(__DIR__ . "/pr_persona_script.htm"));
	}

	/**
	* Searches for all users where the USER_SEARCH_FIELD
	* starts with the search string
	*/
	function doSearch(){
		global $lDB;

		ob_clean();
		$resultHTML = join("",file(__DIR__ . "/pr_persona_result.htm"));
		$resultRowHTML = join("",file(__DIR__ . "/pr_persona_result_row.htm"));
		if ($_GET["searchstr"]){
			$cnt = 0;
			$userList = $lDB->get("
				SELECT ".USER_SEARCH_FIELD." as result, ".USER_IX." FROM ".USER_TABLE." WHERE ".USER_SEARCH_FIELD." LIKE '$_GET[searchstr]%' LIMIT ".USER_SEARCH_LIMIT."
			",2);
			$rows = "";
			foreach($userList as $row) {
				$list = array(
					'nameJS'=>t_encodeOverlib($row['result']),
					'nameHTML'=>t_encodeHTML($row['result']),
					'id'=>$row[USER_IX],
					'sid'=>$_GET['sid']
				);

				$rows .= showpage($list,$resultRowHTML);
				$cnt++;
			}

			if (!$cnt){
				$rows = "
					<tr>
						<td>No Search Results!</td>
					</tr>
				";
			}
			echo showpage(array('sid'=>$_GET['sid'],'rows'=>$rows),$resultHTML);
		}
		exit;
	}
}
