<?php
	require_once(__DIR__ . "/../../db.zs_task_log.php");
	require_once(__DIR__ . "/../../db.zs_queue.php");
//:~{
	require_once(__DIR__ . "/class.pr_persona.php");
	require_once(__DIR__ . "/class.zs_task_notify.php");
	require_once(__DIR__ . "/class.zs_task_log.php");
	
	class zs_queue {
		/**
		* Display a form which allows the user to search and purge
		* entries from the zs_queue table
		*/
		function taskLogForm() {
			global $lDB;

			$conf = isset($_POST['conf'])?$_POST["conf"]:"";
			$queueHTML = join("",file(__DIR__ . "/zs_queue.htm"));
			$queueRowHTML = join("",file(__DIR__ . "/zs_queue_row.htm"));
			
			$conf['persona_script'] = pr_persona::loadScript();
			$conf['user'] = pr_persona::drawSearchField("user", "conf[userid]");
			if(!isset($conf['limit'])) { $conf['limit'] = "100"; }
			if(!isset($conf['dateloggedfrom'])) { $conf['dateloggedfrom'] = ""; }
			if(!isset($conf['dateloggedto'])) { $conf['dateloggedto'] = ""; }
			if(isset($conf['showdeleted'])) { $conf['showdeleted_checked'] = "checked"; }

			$queueList = $lDB->get("
				SELECT
					DISTINCT(zs_queue_task_title) as zs_queue_task_title
				FROM
					zs_queue
					LEFT JOIN zs_task ON zs_queue.zs_task_id = zs_task.zs_task_ix
			",2);
			$conf['title_options'] = "";
			foreach($queueList as $row) {
				$sel = "";
				if(isset($conf['tasktitle']) && $conf['tasktitle']) {
					$sel = in_array($row["zs_queue_task_title"], $conf["tasktitle"]) ? "selected" : "";
				}
				$conf['title_options'] .= "<option value='".$row["zs_queue_task_title"]."' $sel>".$row["zs_queue_task_title"]."</option>";
			}

			$errorlist = zs_task_notify::getErrorStatus();
			$conf['error_options'] = "";
			foreach ($errorlist as $key=>$val) {
				$checked = "";
				if(isset($conf['errorcode']) && isset($conf['errorcode'][$key]) && $conf['errorcode'][$key]) {
					$checked = "checked";
				}
				$conf['error_options'] .= "<input type='checkbox' name=conf[errorcode][".$key."] $checked>".$val."<br>";
			}
			
			$conf['list_display'] = "none";
			$conf['rows'] = "";
			if(isset($conf['getlist']) && $conf["getlist"]) {
				$conf['list_display'] = "";
				$list = $this->searchQueue($conf);
				foreach ($list as $key=>$val) {
					$val["zs_queue_date_sched"] = ($val["zs_queue_date_sched"] != "0000-00-00 00:00:00" ? date("Y-m-d H:i:s", strtotime($val["zs_queue_date_sched"])) : "");
					$val["zs_queue_date_start"] = ($val["zs_queue_date_start"] != "0000-00-00 00:00:00" ? date("Y-m-d H:i:s", strtotime($val["zs_queue_date_start"])) : "");
					$val["zs_queue_date_end"] = ($val["zs_queue_date_end"] != "0000-00-00 00:00:00" ? date("Y-m-d H:i:s", strtotime($val["zs_queue_date_end"])) : "");
					$val['error_status'] = zs_task_notify::getErrorStatus($val["zs_queue_status_ind"]);
					$conf['rows'] .= showpage($val,$queueRowHTML);
				}
			}
			unset($conf['errorcode']);
			echo showpage($conf,$queueHTML);
		}
		
		/**
		* Returns results for the criteria selected
		* in the taskLogForm() function
		*/
		function searchQueue($config=null) {
			global $lDB;

			$where = "";	
			
			if($config["userid"]) {
				$where . "ad_create_user_id = '$config[userid]'";
			}
			if($config["dateloggedfrom"]) {
				$where .= $where ? " AND " : "";
				$where .= "zs_queue_date_sched >= '".date("Y-m-d", strtotime($config["dateloggedfrom"]))." 00:00:00'";
			}
			if($config["dateloggedto"]) {
				$where .= $where ? " AND " : "";
				$where .= "zs_queue_date_sched <= '".date("Y-m-d", strtotime($config["dateloggedto"]))." 23:59:59'";
			}
			
			$title = "";
			if(isset($config['tasktitle']) && $config["tasktitle"]) {
				foreach ($config["tasktitle"] as $key=>$val) {
					$title .= $title ? " OR " : "";
					$title .= "zs_queue_task_title = '".$val."'";
				}
				$where .= $where ? " AND " : "";
				$where .= "(".$title.")";;
			}

			$error = "";
			if(isset($config['errorcode']) && $config["errorcode"]) {
				foreach ($config["errorcode"] as $key=>$val) {
					$error .= $error ? " OR " : "";
					$error .= "zs_queue_status_ind = '".$key."'";
				}
				$where .= $where ? " AND " : "";
				$where .= "(".$error.")";
			}
			
			$limit = "";
			if($config['limit']) {
				$limit = "LIMIT $config[limit]";
			}
			
			$return = array();
			$cnt = 0;
			if($where) { $where = "WHERE $where"; }
			$queueList = $lDB->get("
				SELECT
					zs_queue.*
				FROM
					zs_queue
					LEFT join zs_task ON zs_task.zs_task_ix = zs_queue.zs_task_id
				$where
				ORDER BY
					zs_queue_date_sched desc,
					zs_queue_ix desc
				$limit
			",2);
			foreach($queueList as $row) {
				$return[] = $row;
				$cnt++;
				if($config['limit'] && $cnt >= $config['limit']) {
					break;
				}
			}
			return $return;
		}
		
		/**
		*	Permanently removes records from zs_queue using the criteria from taskLogForm()
		*/
		function purgeTasks() {
			$conf = $_POST["conf"];
			
			$list = $this->searchQueue($conf);
			foreach ($list as $val) {
				db_zs_queue_delete($val['zs_queue_ix']);
			}
			redirect("index.php?zs_queue.taskLogForm");
		}
	}
//:~}
