<?php
	require_once(__DIR__ . "/../../db.zs_schedule.php");
//:~{
	class zs_schedule {
		/**
		* add's the HMTL for a schedule linked to a task
		* can be called with AJAX to add extra lines to a existing page
		* or be called in PHP to display existing schedules
		*/
		static function scheduleLine($config=null, $passcnt=null) {
			$ajax = false;
			if(!isset($config)) {
				$ajax = true;
				$config = array(
					'zs_schedule_id'=>"",
					'zs_schedule_ix'=>"",
					'zs_sched_sch_minute'=>"",
					'zs_sched_sch_hour'=>"",
					'zs_sched_sch_dom'=>"",
					'zs_sched_sch_month'=>"",
					'zs_sched_sch_dow'=>"",
					'zs_sched_type_ind'=>""
				);
				ob_clean();
			}
			
			if(isset($_GET["cnt"]) && $_GET['cnt']) {
				$cnt = $_GET["cnt"];
			} else {
				$cnt = $passcnt ? $passcnt : 0;
			}
			$config['count'] = $cnt;
			
			$load["min"] = explode(",", $config["zs_sched_sch_minute"]);
			$load["hour"] = explode(",", $config["zs_sched_sch_hour"]);
			$load["dom"] = explode(",", $config["zs_sched_sch_dom"]);
			$load["month"] = explode(",", $config["zs_sched_sch_month"]);
			$load["dow"] = explode(",", $config["zs_sched_sch_dow"]);
			
			$scheduleHTML = join("",file(__DIR__ . "/zs_schedule.htm"));

			$config['minute_options'] = "";
			for($min=0; $min<=59; $min++) {
				$sel = in_array((string)$min, $load["min"], true) ? "selected" : "";
				$config['minute_options'] .= "<option value='$min' $sel>$min</option>";
			}
			$config['hour_options'] = "";
			for($hour=0; $hour<=23; $hour++) {
				$sel = in_array((string)$hour, $load["hour"], true) ? "selected" : "";
				$config['hour_options'] .= "<option value='$hour' $sel>$hour</option>";
			}
			$config['day_options'] = "";
			for($day=1; $day<=31; $day++) {
				$sel = in_array((string)$day, $load["dom"], true) ? "selected" : "";
				$config['day_options'] .= "<option value='$day' $sel>$day</option>";
			}
			$config['month_options'] = "";
			for($month=1; $month<=12; $month++) {
				$sel = in_array((string)$month, $load["month"], true) ? "selected" : "";
				$config['month_options'] .= "<option value='$month' $sel>".date("F", mktime(0,0,0,$month,1,date("Y")))."</option>";
			}
			$config['week_options'] = "";
			for($week=0; $week<=6; $week++) {
				$sel = in_array((string)$week, $load["dow"], true) ? "selected" : "";
				$config['week_options'] .= "<option value='$week' $sel>".getDayName($week)."</option>";
			}
			
			$sel = array($config["zs_sched_type_ind"]=>"selected");
			$config['zs_sched_type_ind_' . $config['zs_sched_type_ind'] . '_selected'] = "selected";

			if($ajax) {
				echo showpage($config,$scheduleHTML);
				exit;
			}
			return showpage($config,$scheduleHTML);
			
		}
		
		/**
		* saves a schedule linked to a task.
		*/
		function saveSchedule($config) {
			if($config["zs_schedule_ix"]) {
				$config['zs_sched_sch_minute'] = isset($config['zs_sched_sch_minute'])?$config['zs_sched_sch_minute']:"";
				$config['zs_sched_sch_hour'] = isset($config['zs_sched_sch_hour'])?$config['zs_sched_sch_hour']:"";
				$config['zs_sched_sch_dom'] = isset($config['zs_sched_sch_dom'])?$config['zs_sched_sch_dom']:"";
				$config['zs_sched_sch_month'] = isset($config['zs_sched_sch_month'])?$config['zs_sched_sch_month']:"";
				$config['zs_sched_sch_dow'] = isset($config['zs_sched_sch_dow'])?$config['zs_sched_sch_dow']:"";
				db_zs_schedule_update($config['zs_schedule_ix'],$config['zs_sched_type_ind'],$config['zs_sched_sch_minute'],$config['zs_sched_sch_hour'],$config['zs_sched_sch_dom'],$config['zs_sched_sch_month'],$config['zs_sched_sch_dow']);
			}else{
				db_zs_schedule_insert($config['zs_task_id'],$config['zs_sched_type_ind'],$config['zs_sched_sch_minute'],$config['zs_sched_sch_hour'],$config['zs_sched_sch_dom'],$config['zs_sched_sch_month'],$config['zs_sched_sch_dow']);
			}
		}
		
		/**
		* called with AJAX to flag a record as deleted
		*/
		function deleteSchedule() {
			db_zs_schedule_delete($_GET['id']);
			ob_clean();
			exit;
		}
	}

	/**
	* Returns the day of the week as fulltext or
	* a list of all days if day is not specified
	*/
	function getDayName($day=null) {
		$name = array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
		if(isset($day)) {
			return $name[$day];
		}else{
			return $name;
		}
	}

//:~}
