<?php
//:~{
	require_once(__DIR__ . "/../../db.zs_task.php");
	require_once(__DIR__ . "/../../db.zs_queue.php");
	require_once(__DIR__ . "/class.zs_queue.php");
	require_once(__DIR__ . "/class.zs_schedule.php");
	require_once(__DIR__ . "/class.zs_task_notify.php");
	require_once(__DIR__ . "/class.pr_persona.php");
	
	class zs_task {
		/**
		* Main task screen allowing the user to create, edit and delete tasks
		*/
		function taskAdmin(){
			global $lDB;
			
			$taskAdminHTML = join("",file(__DIR__ . "/zs_task_admin.htm"));
			$taskAdminRowHTML = join("",file(__DIR__ . "/zs_task_admin_row.htm"));

			$taskList = $lDB->get("SELECT * FROM zs_task",2);
			$rows = "";
			foreach($taskList as $row) {
				if(!$row["zs_task_last_execution"] || ($row["zs_task_last_execution"] == "0000-00-00 00:00:00")) {
					$row['runstr'] = "Not run yet";
				} else {
					$row['runstr'] = $row["zs_task_last_execution"];
					$hasrun = true;
				}
				
				if ($row["zs_task_inactive_yn"]) {
					$row['status'] = "Inactive";
					$row['color'] = "#CCFFCC";
				} else if ($row["zs_task_suspend_yn"]) {
					$row['status'] = "Suspended";
					$row['color'] = "#FFCCCC";
				} else {
					$row['status'] = "Active";
					$row['color'] = "#FFFFFF";
				}
				$rows .= showpage($row,$taskAdminRowHTML);
			}
			echo showpage(array("rows"=>$rows),$taskAdminHTML);			
		}
		
		/**
		* Task Add/Edit Form
		*/
		function taskForm(){
			global $lDB;

			$id = isset($_GET['id'])?$_GET['id']:"";
			$taskEditHTML = join("",file(__DIR__ . "/zs_task_edit.htm"));
			
			if($id) {
				$task = $lDB->get("SELECT * FROM zs_task WHERE zs_task_ix = '$id'",1);
				$task['zs_task_title'] = t_encodeHTML($task['zs_task_title']);
				$task['zs_task_command'] = t_encodeHTML($task['zs_task_command']);
			} else {
				$task = array(
					'zs_task_ix'=>"",
					'zs_task_title'=>"",
					'zs_task_command'=>"",
					'zs_task_target_db'=>"",
					'zs_task_retries'=>"",
					'zs_task_retry_delay'=>"",
					'zs_task_recover_all_yn'=>"",
					'zs_task_inactive_yn'=>"",
					'zs_task_suspend_yn'=>""
				);
			}
			
			$task['persona_script'] = pr_persona::loadScript();

			$dbActive = explode(",", $task["zs_task_target_db"]);			
			$dbList = $lDB->get("SELECT * FROM rf_database",2);
			$dbOptions = "";
			foreach($dbList as $row) {
				$sel = in_array(trim((string)$row["rf_db_code"]), $dbActive, true) ? "selected" : "";
				$dbOptions .= "<option value=\"$row[rf_db_code]\" $sel>$row[rf_db_description] ($row[rf_db_code])</option>";
			}
			$task['db_options'] = $dbOptions;

			if(!$task['zs_task_retries']) { $task['zs_task_retries'] = TASK_RETRIES; }
			if(!$task['zs_task_retry_delay']) { $task['zs_task_retry_delay'] = TASK_RETRY_DELAY; }
			if($task['zs_task_recover_all_yn']) { $task['zs_task_recover_all_yn_checked'] = "checked"; }
			if($task['zs_task_inactive_yn']) { $task['zs_task_inactive_yn_checked'] = "checked"; }
			$task['zs_task_suspend_yn_display'] = "none";
			if($task['zs_task_suspend_yn']) {
				$task['zs_task_suspend_yn_checked'] = "checked";
				$task['zs_task_suspend_yn_display'] = "";
			}

			$cnt = 0;
			$task['schedules'] = "";
			if($id) {
				$schedList = $lDB->get("SELECT * FROM zs_schedule WHERE zs_task_id = '$task[zs_task_ix]'",2);
				foreach($schedList as $row) {
					$task['schedules'] .= "
						<tr class='table_main'>
							<td align='center'>
								".zs_schedule::scheduleLine($row, $cnt)."
							</td>
						</tr>
					";
					$cnt++;
				}
			}
			$task['count'] = $cnt;
			$errorcnt = 0;
			$task['notify'] = "";
			if($id) {
				$errorList = $lDB->get("SELECT * FROM zs_task_notify WHERE zs_task_id = '$task[zs_task_ix]'",2);
				foreach($errorList as $row) {
					$task['notify'] .= "
						<tr class='table_main'>
							<td align='center'>
								" . zs_task_notify::errorNotifyLine($row, $errorcnt) . "
							</td>
						</tr>
					";
					$errorcnt++;
				}
			}
			$task['error_count'] = $errorcnt;
			$task['button_title'] = $id ? "Save" : "Create New";
			$task['nt_email'] = NT_EMAIL;
			$task['nt_sms'] = NT_SMS;
			$task['nt_script'] = NT_SCRIPT;
			echo showpage($task,$taskEditHTML);
		}
		
		/**
		* Handles post data from taskForm()
		*/
		function saveTask() {
			global $dbcode;
			global $lDB;
			
			$task = $_POST["task"];
			$task["zs_task_recover_all_yn"] = isset($task["zs_task_recover_all_yn"]) ? "1" : "0";
			$task["zs_task_suspend_yn"] = isset($task["zs_task_suspend_yn"]) ? "1" : "0";
			$task["zs_task_inactive_yn"] = isset($task["zs_task_inactive_yn"]) ? "1" : "0";
			$task["zs_task_target_db"] = is_array($task["zs_task_target_db"]) ? implode(",", $task["zs_task_target_db"]) : "";
			
			if ($task["zs_task_ix"]) {
				if($task["zs_task_suspend_yn"] == "0") {
					$queueList = $lDB->get("
						SELECT
							zs_queue.zs_queue_ix
						FROM
							zs_queue
							INNER JOIN zs_schedule ON zs_schedule.zs_schedule_ix = zs_queue.zs_schedule_id
						WHERE
							zs_schedule.zs_task_id = '$task[zs_task_ix]'
							AND zs_queue.zs_queue_status_ind NOT IN (".STATUS_SUCCESS.", ".STATUS_EXECUTING.")
							AND zs_queue.zs_queue_inactive_yn = '0'
						ORDER BY 
							zs_queue.zs_queue_date_sched
					",3,1);
					$oldSuspend = $lDB->get("SELECT zs_task_suspend_yn FROM zs_task WHERE zs_task_ix = '$task[zs_task_ix]'",4);
					if($oldSuspend == "1" && $task["zs_task_recover_all_yn"] != "1" && sizeof($queueList) > 1) {
						$queueKeep = array_pop($queueList);
						foreach($queueList as $queueItem) {
							db_zs_queue_set_inactive($queueItem);
						}
						$queueList = array($queueKeep);
					}
					foreach($queueList as $queueItem) {
						db_zs_queue_update($queueItem,STATUS_PENDING,false,0,$task['zs_task_command']);
					}
				}
				db_zs_task_update($task['zs_task_ix'],$task['zs_task_title'],$task['zs_task_command'],$task['zs_task_target_db'],$task['zs_task_retries'],$task['zs_task_retry_delay'],$task['zs_task_recover_all_yn'],$task['zs_task_inactive_yn'],$task['zs_task_suspend_yn']);
			} else {
				$task["zs_task_ix"] = db_zs_task_insert($task['zs_task_title'],$task['zs_task_command'],$task['zs_task_target_db'],$task['zs_task_retries'],$task['zs_task_retry_delay'],$task['zs_task_recover_all_yn'],$task['zs_task_inactive_yn']);
			}
			
			$schedulelist = isset($_POST['schedule'])?$_POST['schedule']:false;
			if($schedulelist) {
				$sched = new zs_schedule();
				foreach ($schedulelist as $key=>$val) {
					$val["zs_task_id"] = $task["zs_task_ix"];		//link the schedule to the tasks ix, not id
					$sched->saveSchedule($val);
				}
			}
			
			$errorlist = isset($_POST['error'])?$_POST['error']:false;
			if($errorlist) {
				$error = new zs_task_notify();
				foreach ($errorlist as $key=>$val) {
					$val["zs_task_id"] = $task["zs_task_ix"];	//link the error notification to the tasks ix, not id
					$error->saveErrorNotify($val);
				}
			}
			redirect("index.php?zs_task.taskAdmin");
		}
		
		function deleteTask(){
			db_zs_task_delete($_GET["id"]);
			redirect("index.php?zs_task.taskAdmin");
		}
	}
//:~}
