<?php
	require_once(__DIR__ . "/../../db.zs_task.php");
	require_once(__DIR__ . "/../../db.zs_task_notify.php");
	require_once(__DIR__ . "/../../db.zs_queue.php");
//:~{
	require_once(__DIR__ . "/class.pr_persona.php");
	
	class zs_task_notify {
		/**
		* Add's the HMTL for a error notification linked to a task
		* can be called with AJAX to add extra lines to a existing page
		* or be called in PHP to display existing error notifications
		*/
		static function errorNotifyLine($config=null, $passcnt=null) {
			global $lDB;

			$cnt = isset($_GET['cnt'])?$_GET['cnt']:0;
			
			$ajax = false;
			if(!isset($config)) {
				$ajax = true;
				$config = array(
					'zs_task_notify_id'=>"",
					'zs_task_notify_ix'=>"",
					'zs_task_notify_cmd'=>"",
					'zs_task_notify_status'=>"",
					'zs_task_notify_delay'=>"",
					'zs_task_notify_method'=>"",
					'pr_user_id'=>""
				);
				ob_clean();
			} else {
				$config['zs_task_notify_cmd'] = t_encodeHTML($config['zs_task_notify_cmd']);
			}
			
			if(isset($passcnt)) {
				$cnt = $passcnt;
			}
			
			$cnt = $cnt ? $cnt : 0;

			$config['count'] = $cnt;

			$taskNotifyHTML = join("",file(__DIR__ . "/zs_task_notify.htm"));
			
			$status = zs_task_notify::getErrorStatus();
			$config['status_options'] = "";
			if($status) {
				foreach ($status as $key=>$val) {
					$sel = $config["zs_task_notify_status"] == $key ? "selected" : "";
					$config['status_options'] .= "<option value='".$key."' $sel>".$val."</option>";
				}
			}
			
			if(!$config['zs_task_notify_delay']) { $config['zs_task_notify_delay'] = TASK_RETRY_DELAY; }
			$type = zs_task_notify::getNotifyType();
			$config['type_options'] = "";
			if($type) {
				foreach ($type as $key=>$val) {
					$sel = $config["zs_task_notify_method"] == $key ? "selected" : "";
					$config['type_options'] .= "<option value='".$key."' $sel>".$val."</option>";
				}
			}
			
			$show = array();
			if($config) {
				if($config["zs_task_notify_method"] == NT_SCRIPT) {
					$show["usr"] = "none";
					$config['command_display'] = "";
				}else{
					$show["usr"] = "inline";
					$config['command_display'] = "none";
				}
			}else{
				$show["usr"] = "inline";
				$config['command_display'] = "none";
			}
			
			
			$usr = $lDB->get("SELECT ".USER_SEARCH_FIELD." as result FROM ".USER_TABLE." WHERE ".USER_IX." = '$config[pr_user_id]'",1);
			$config['user'] = pr_persona::drawSearchField("error_usr_$cnt", "error[$cnt][pr_user_id]", $usr["result"], $config["pr_user_id"], $config["zs_task_notify_method"]);

			if($ajax) {
				print showpage($config,$taskNotifyHTML);
				exit;
			}
			
			return showpage($config,$taskNotifyHTML);
		}

		function saveErrorNotify($config) {
			global $dbcode;

			if($config["zs_task_notify_ix"]) {
				db_zs_task_notify_update($config['zs_task_notify_ix'],$config['zs_task_notify_status'],$config['zs_task_notify_delay'],$config['zs_task_notify_method'],$config['zs_task_notify_cmd'],$config['pr_user_id']);
			}else{
				db_zs_task_notify_insert($config['zs_task_id'],$config['zs_task_notify_status'],$config['zs_task_notify_delay'],$config['zs_task_notify_method'],$config['zs_task_notify_cmd'],$config['pr_user_id']);
			}
		}
		
		function deleteErrorNotify() {
			db_zs_task_notify_delete($_GET['id']);
			ob_clean();
			exit; // For AJAX
		}
		
		static function getErrorStatus($error=null) {
			$status = array();
			$status[STATUS_SUCCESS] = "Success";
			$status[STATUS_PENDING] = "Pending";
			$status[STATUS_EXECUTING] = "Executing";
			$status[STATUS_ERROR] = "Error";
			$status[STATUS_FATAL_ERROR] = "Fatal Error";
			
			if(isset($error)) {
				return $status[$error];
			}else{
				return $status;
			}
		}

		static function getNotifyType($type=null) {
			$notify = array();
			$notify[NT_EMAIL] = "Email";
			$notify[NT_SMS] = "SMS";
			$notify[NT_SCRIPT] = "Script";
			
			if(isset($type)) {
				return $notify[$type];
			}else{
				return $notify;
			}
		}
	}
//:~}
