<?php

if(isset($_SERVER['argv'][1]) && $_SERVER['argv'][1] == "debug") {
	define("DEBUG_CRON",true);
} else {
	//define("DEBUG_CRON",false);
	//TODO REMOVE - testing
	define("DEBUG_CRON",true);
}

if(php_sapi_name() != "cli") {
	redirect("/reservation.php");
	die();
}

set_time_limit(0);
ignore_user_abort(true);

$path = pathinfo(__FILE__);
$path = str_replace("//", "/", $path["dirname"]."/");
define("PWD", $path);

require_once(PWD."config.php");
$GLOBALS['dbHost'] = DB_HOST;
$GLOBALS['dbIgnore'] = array("training","test","demo");

require_once(PWD."../../class.mysqldb.php");
require_once(PWD."../../inc.ixfields.php");
require_once(PWD."../../functions.php");
require_once(PWD."../../db.zs_queue.php");

require_once(PWD."class.zs_queue.php");
require_once(PWD."class.zs_task_notify.php");
require_once(PWD."class.zs_schedule.php");
require_once(PWD."class.zs_task.php");

$GLOBALS['debugEcho'] = true;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing
$GLOBALS['flagChngs'] = "1";
$GLOBALS['flagDels'] = "1";



class task_process {
	var $dbcode;
	var $dblist;
	var $dbpointer;

	/**
	* Runs the task schedules for all the databases
	*/
	function run() {
		global $lDB;

		$f = fopen(PWD."debug.txt", "w");
		fclose($f);
		chmod(PWD."debug.txt", 0777);

		$this->debugCron("Starting. . .");
		$this->dblist = getDbList();
		$this->dbpointer = 0;
		$firstrun = true;
		while (true){
			$starttime = floor(time()/60)*60;

			if(isset($this->dblist[$this->dbpointer])) {
				$this->debugCron("Connecting to database : ".$this->dblist[$this->dbpointer]["database"]);
				$this->debugCron("Environment : ".$this->dblist[$this->dbpointer]['code']);
				$this->dbcode = $this->dblist[$this->dbpointer]["code"];
				$GLOBALS['dbcode'] = $this->dbcode;
				$lDB = new MySQLDB($this->dblist[$this->dbpointer]["database"],"root","",$GLOBALS['dbHost']);
				$this->debugCron("Timezone : ".$this->dblist[$this->dbpointer]['timezone']);
				set_timezone($this->dblist[$this->dbpointer]['timezone']);
				require_once(PWD."../../functions.mail.php");
				email_reset();
				$GLOBALS['trTables'] = $lDB->get("SELECT tc_table_name FROM tc_table",3);

				if ($firstrun){
					$this->debugCron("Resetting queue");
					db_zs_queue_reset();
				}

				$this->handleErrors();
				$this->loadTasks();
				while ($task = $this->getNextTask()){
					$this->processTask($task);
				}

				$lDB->close();
			}

			$this->debugCron("No tasks left");

			$this->dbpointer++;
			if ($this->dbpointer >= count($this->dblist)) {
				$this->dblist = getDbList();
				$this->dbpointer = 0;
				$firstrun = false;
				$endtime = time();
				$diff = $endtime - $starttime;

				if ($diff < 60){
					$sleep = 60 - $diff;
					$this->debugCron("Sleep for ".$sleep." seconds");
					sleep($sleep);
				}
			}
		}
	}

	/**
	* Processes any error notifications for the current queue
	*/
	function handleErrors() {
		global $lDB;
		$this->debugCron("Checking for any error notifications that need to be sent");

		$queueList = $lDB->get("
			SELECT
				zs_queue.zs_queue_ix,
				zs_queue.zs_queue_task_title,
				zs_queue.zs_queue_status_ind,
				zs_queue.zs_queue_details,
				zs_queue.zs_queue_date_end,
				zs_queue.zs_queue_attempt_next,
				zs_schedule.zs_schedule_ix,
				zs_task.zs_task_ix,
				zs_task.zs_task_suspend_yn,
				zs_task_notify.zs_task_notify_ix,
				zs_task_notify.pr_user_id,
				zs_task_notify.zs_task_notify_method,
				zs_task_notify.zs_task_notify_delay,
				zs_task_notify.zs_task_notify_cmd
			FROM
				zs_queue
				INNER JOIN zs_schedule ON zs_schedule.zs_schedule_ix = zs_queue.zs_schedule_id
				INNER JOIN zs_task ON zs_task.zs_task_ix = zs_queue.zs_task_id
				INNER JOIN zs_task_notify ON zs_task_notify.zs_task_id = zs_schedule.zs_task_id
			WHERE
				zs_queue.zs_queue_status_ind = zs_task_notify.zs_task_notify_status
				AND zs_queue.zs_queue_date_sched >= zs_task_notify.ad_create_date
				AND DATE_ADD(zs_queue.ad_modify_date, INTERVAL zs_task_notify.zs_task_notify_delay MINUTE) <= '".date("Y-m-d H:i:s")."'
				AND zs_queue.zs_queue_inactive_yn = '0'
			ORDER BY
				zs_queue.zs_queue_attempt_next ASC
		",2,1);
		$list = array();
		$queueList = empty($queueList) ? array() : $queueList;
		foreach($queueList as $task) {
			$errorCheck = $lDB->get("
				SELECT
					COUNT(*)
				FROM
					zs_queue
				WHERE
					zs_queue_parent_id = '$task[zs_queue_ix]'
					AND zs_task_notify_id = '$task[zs_task_notify_ix]'
					AND zs_queue_parent_attempt_next = '$task[zs_queue_attempt_next]'
			",4);
			if($errorCheck < 1) {
				$list[] = $task;
			}
		}

		$this->debugCron(count($list)." Error notifications found");

		foreach ($list as $key=>$val){
			$user = $lDB->get("
				SELECT
					".USER_FIRSTNAME.",
					".USER_LASTNAME.",
					".USER_EMAIL."
					/*".USER_TEL." this must be readded to fix sms support */
				FROM
					".USER_TABLE."
				WHERE
					".USER_IX." = '$val[pr_user_id]'
			",1);

			$notify = $val["zs_task_notify_method"];
			$delay = $val["zs_task_notify_delay"]*60;

			$FIRST_NAME = $user[USER_FIRSTNAME];
			$LAST_NAME = $user[USER_LASTNAME];
			$TASK_NAME = $val["zs_queue_task_title"];
			$TASK_ERROR_CODE = $val["zs_queue_status_ind"];
			$TASK_ERROR_DETAILS = $val["zs_queue_details"];
			$TASK_SUSPENDED = $val["zs_task_suspend_yn"];
			$DATETIME_OF_EVENT = $val["zs_queue_date_end"];
			$CLIENT_ID = $this->dblist[$this->dbpointer]["client"];
			$ENVIRONMENT_ID = $this->dbcode;

			$FULL_NAME = trim($FIRST_NAME . " " . $LAST_NAME);

			$TASK_ERROR_DETAILS_FORMATTED = preg_replace("/^/m", "> ", wordwrap($TASK_ERROR_DETAILS, 78));

			$EMAIL_SUBJECT = "Task '";
			if(strlen($TASK_NAME) < 39) {
				$EMAIL_SUBJECT .= $TASK_NAME . "' - ";
			} else {
				$EMAIL_SUBJECT .= substr($TASK_NAME,0,36) . "...' - ";
			}
			switch($TASK_ERROR_CODE) {
			case 0:
				$EMAIL_SUBJECT .= "Successful";
				break;
			case 10:
				$EMAIL_SUBJECT .= "Pending";
				break;
			case 20:
				$EMAIL_SUBJECT .= "Executing";
				break;
			case 30:
				$EMAIL_SUBJECT .= "ERROR";
				break;
			case 40:
				$EMAIL_SUBJECT .= "FATAL ERROR";
				break;
			}

			$EMAIL_SUBJECT .= " [$CLIENT_ID-$ENVIRONMENT_ID]";
			if($TASK_SUSPENDED) {
				$EMAIL_SUBJECT .= " SUSPENDED";
			}

			$EMAIL_TEXT = "Attention $FULL_NAME\n\n";

			$INTRO_LINE = "At $DATETIME_OF_EVENT, the task named '$TASK_NAME' on $CLIENT_ID-$ENVIRONMENT_ID ";
			switch($TASK_ERROR_CODE) {
			case 0:
				$INTRO_LINE .= "ran successfully";
				break;
			case 10:
				$INTRO_LINE .= "is pending";
				break;
			case 20:
				$INTRO_LINE .= "is executing";
				break;
			case 30:
				$INTRO_LINE .= "returned an error";
				break;
			case 40:
				$INTRO_LINE .= "returned a fatal error";
				break;
			}

			if(trim($TASK_ERROR_DETAILS) != "") {
				$INTRO_LINE .= " with the following details:\n\n";
				$DETAIL_LINE = $TASK_ERROR_DETAILS_FORMATTED;
			} else {
				$INTRO_LINE .= ".";
				$DETAIL_LINE;
			}
			$EMAIL_TEXT .= $INTRO_LINE;
			$EMAIL_TEXT .= $DETAIL_LINE;

			if($TASK_SUSPENDED) {
				$EMAIL_TEXT .= "\n\nThe task has been suspended!";
			}

			$EMAIL_TEXT .= "\n";

			$SMS_TEXT = "ResRequest " . $EMAIL_SUBJECT . " @ " . $DATETIME_OF_EVENT;

			$fromEmail = $lDB->get("
				SELECT
					pr_persona.pr_email
				FROM
					rf_sys_admin
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_sys_admin.pr_persona_id
				WHERE
					rf_sys_admin_primary = 1
				LiMIT 1
			",4);
			$fromName = "ResRequest Scheduler";
			$action = zs_task_notify::getNotifyType($notify).":";
			if ($notify == NT_EMAIL){
				$action .= "\"".$user[USER_FIRSTNAME]." ".$user[USER_LASTNAME]."\" <".$user[USER_EMAIL].">";
				email($fromEmail,$user[USER_EMAIL],$EMAIL_SUBJECT,"",$EMAIL_TEXT,0,0,$fromName);
			}else if ($notify == NT_SMS){
				$action .= "\"".$user[USER_FIRSTNAME]." ".$user[USER_LASTNAME]."\" <".$user[USER_TEL].">";
				$message = "user:".SMS_USERNAME."\r\npassword:".SMS_PASSWORD."\r\napi_id:".SMS_API_ID."\r\n";
				$message .= "to:".$user[USER_TEL]."\r\n";
				$message .= "data:Problems occured!";
				email($fromEmail,"sms@messaging.clickatell.com","ResRequest Task Schedule Error","",$SMS_TEXT,0,0,$fromName);
			}else if ($notify == NT_SCRIPT){
				$cmd = $this->parseCommand($val["zs_task_notify_cmd"], $val);
				$action .= $cmd;
				exec($cmd, $out, $err);
			}
			$this->debugCron("Error Notification - ".$action);

			$sched_date = date("Y-m-d H:i:00", strtotime($val["zs_queue_date_end"])+$delay);

			db_zs_queue_insert($val['zs_schedule_ix'],$sched_date,STATUS_SUCCESS,"Error Notification : ".$val["zs_queue_task_title"],"Error Notification - ".$val["zs_queue_ix"].".".$val["zs_task_notify_ix"]." (".$val["zs_queue_attempt_next"].")",$val['zs_queue_ix'],$val['zs_task_notify_ix']);
		}

	}

	/**
	* Loads all the tasks that need to be run into the queue
	*/
	function loadTasks(){
		global $lDB;

		$this->debugCron("Loading tasks into queue");
		$dbcode = $this->dbcode;

		$cnt = 0;
		if ($dbcode){
			$schedules = $lDB->get("
				SELECT
					zs_schedule.zs_schedule_ix,
					zs_schedule.zs_sched_sch_minute,
					zs_schedule.zs_sched_sch_hour,
					zs_schedule.zs_sched_sch_dom,
					zs_schedule.zs_sched_sch_month,
					zs_schedule.zs_sched_sch_dow,
					zs_schedule.zs_sched_last_execution,
					zs_task.zs_task_title,
					zs_task.zs_task_recover_all_yn
				FROM
					zs_schedule
					INNER JOIN zs_task ON zs_task.zs_task_ix = zs_schedule.zs_task_id
				WHERE
					zs_task.zs_task_suspend_yn = 0
					AND zs_task.zs_task_inactive_yn = 0
					AND CONCAT(',', zs_task.zs_task_target_db, ',') LIKE '%,$dbcode,%'
					AND (
						zs_schedule.zs_sched_type_ind <> ".DB_ZS_SCHEDULE_SUSPEND."
					)
			",2);
			foreach($schedules as $schedule) {
				$times = $this->getExecutionTimes($schedule);
				foreach ($times as $time){
					db_zs_queue_insert($schedule['zs_schedule_ix'],$time);
					$cnt++;
				}
			}
		}
		$this->debugCron("Loaded ".$cnt." tasks");
	}

	/**
	* Parses a command and replaces variables
	*/
	function parseCommand($cmd, $param){
		$cmd = str_replace("\\", "\\\\", $cmd);

		preg_match_all("/(\\\$[^&]*)/i", $cmd, $matches);
		foreach ($matches[0] as $key){
			$val = substr($key, 1);
			$val = explode("[", preg_replace("/[\\]\"']/", "", $val));

			$out = "";
			foreach ($val as $var){
				$out = $out ? $out[$var] : $$var;
			}

			$cmd = str_replace($key, $out, $cmd);
		}

		return $cmd;
	}

	/**
	* Gets all the execution times for a task between last execution and now
	*/
	function getExecutionTimes($schedule) {
		global $lDB;

		$this->debugCron("Calculating execution times for task '$schedule[zs_task_title]'");
		$queueCount = $lDB->get("SELECT COUNT(*) FROM zs_queue WHERE zs_schedule_id = '$schedule[zs_schedule_ix]'",4);
		if($queueCount > 0) {
			$startdate = strtotime($lDB->get("SELECT zs_queue_date_sched FROM zs_queue WHERE zs_schedule_id = '$schedule[zs_schedule_ix]' ORDER BY zs_queue_date_sched DESC",4))+60;
		} else {
			$startdate = strtotime(substr($schedule["zs_sched_last_execution"],0,17)."00")+60;
		}

		$enddate = strtotime(date("Y-m-d H:i:00"));

		$this->debugCron("Start Date - ".date("Y-m-d H:i:s", $startdate)." <-> End Date - ".date("Y-m-d H:i:s", $enddate));

		$min = explode(",", $schedule["zs_sched_sch_minute"]);
		$hrs = explode(",", $schedule["zs_sched_sch_hour"]);
		$dom = explode(",", $schedule["zs_sched_sch_dom"]);
		$mth = explode(",", $schedule["zs_sched_sch_month"]);
		$dow = explode(",", $schedule["zs_sched_sch_dow"]);

		$times = array();
		for ($time = $startdate; $time <= $enddate; $time+=60){
			$date = explode(",", date("i,G,j,n,w", $time));

			if(!in_array($date[0],$min) && trim($schedule["zs_sched_sch_minute"]) != "") { continue; }
			if(!in_array($date[1],$hrs) && trim($schedule["zs_sched_sch_hour"]) != "") { continue; }
			if(!in_array($date[2],$dom) && trim($schedule["zs_sched_sch_dom"]) != "") { continue; }
			if(!in_array($date[3],$mth) && trim($schedule["zs_sched_sch_month"]) != "") { continue; }
			if(!in_array($date[4],$dow) && trim($schedule["zs_sched_sch_dow"]) != "") { continue; }

			$times[] = date("Y-m-d H:i:00", $time);
		}

		if (!$schedule["zs_task_recover_all_yn"] && $times) {
			$times = array(array_pop($times));
		}

		return $times;
	}

	/**
	* Returns the next task to be run. False is returned if there are no more tasks.
	*/
	function getNextTask(){
		// TODO: Possibly change this to a get type 1 again
		global $lDB;

		$this->debugCron("Getting next task to be run");
		$dbcode = $this->dbcode;

		$queueItem = $lDB->get("
			SELECT
				zs_queue.zs_queue_ix,
				zs_queue.zs_queue_task_title,
				zs_queue.zs_queue_command,
				zs_queue.zs_queue_date_sched,
				zs_queue.zs_queue_attempt_next,
				zs_schedule.zs_schedule_ix,
				zs_schedule.zs_sched_type_ind,
				zs_task.zs_task_ix
			FROM
				zs_queue
				LEFT JOIN zs_schedule on zs_queue.zs_schedule_id = zs_schedule.zs_schedule_ix
				LEFT JOIN zs_task on zs_schedule.zs_task_id = zs_task.zs_task_ix
			WHERE
				zs_task_suspend_yn = 0
				AND zs_task_inactive_yn = 0
				AND (
					zs_queue_status_ind = ".STATUS_PENDING."
					OR zs_queue_status_ind = ".STATUS_ERROR.")
				AND zs_queue_attempt_next <= '".date("Y-m-d H:i:s")."'
				AND zs_queue.zs_queue_inactive_yn = '0'
				AND zs_queue.zs_queue_db = '$dbcode'
			ORDER BY
				zs_queue_attempt_next ASC
			LIMIT 1
		",2);
		if(sizeof($queueItem) > 0) {
			return $queueItem[0];
		} else {
			return false;
		}

		return $queueItem;
	}

	/**
	* Executes the task
	*/
	function processTask($task){
		$this->debugCron("Running task '".$task["zs_queue_task_title"]." - ".$task["zs_queue_ix"]."' : Schedule time ".$task["zs_queue_date_sched"]." , Next Attempt ".$task["zs_queue_attempt_next"]);

		db_zs_queue_update($task['zs_queue_ix'],STATUS_EXECUTING);
		db_zs_schedule_set_last_execution($task['zs_schedule_ix']);
		db_zs_task_set_last_execution($task['zs_task_ix']);

		$err = 0;
		$command = $task["zs_queue_command"];
		if (substr(strtolower($command), 0, 7) == "http://" || substr(strtolower($command), 0, 7) == "https://"){
			$r = @fopen($command, "r");
			$http_response_headers = stream_get_meta_data($r);
			$http_response_headers = $http_response_headers["wrapper_data"];
			if (!$http_response_headers){
				$out = "30|No Route To Host!";
			}else{
				$out = "";
				while (!feof($r)){
					$out .= fgets($r);
				}
			}
		}else{
			exec($command, $out, $err);
			$out = implode("\r\n", $out);
		}

		$rc = $this->getResultCode($out, $http_response_headers, $err);
		db_zs_queue_update($task['zs_queue_ix'],$rc,addslashes($out));
		if($task['zs_sched_type_ind'] == DB_ZS_SCHEDULE_ONCE && $rc == STATUS_SUCCESS) {
			db_zs_schedule_set_type_ind($task['zs_schedule_ix'],DB_ZS_SCHEDULE_SUSPEND);
		}
	}

	/**
	* Determines the result code from the output of a task execution
	*/
	function getResultCode(&$out, $response, $err){
		$this->debugCron("Determining the result code from the execution of the task");

		$lastline = explode("\n", $out);
		$lastline = $lastline[count($lastline)-1];

		list($version, $status_code, $msg) = explode(" ", $response[0], 3);
		if ($status_code >= 400 && $status_code <= 600){
			return STATUS_FATAL_ERROR;
		}else if($err){
			if (is_array($out)){
				$out = implode($out);
			}

			$out = "Error Level: ".$err.($out ? " - ".$out : "");
			return STATUS_FATAL_ERROR;
		}else if(strpos($lastline, "40|") !== false){
			$out = substr($lastline, 3);
			return STATUS_FATAL_ERROR;
		}else if(strpos($lastline, "30|") !== false){
			$out = substr($lastline, 3);
			return STATUS_ERROR;
		}else if(strpos($lastline, "0|") !== false){
			$out = substr($lastline, 2);
			return STATUS_SUCCESS;
		} else {
			return STATUS_SUCCESS;
		}
	}

	/**
	* Outputs debug info into debug.txt if DEBUG_CRON is set to true
	*/
	function debugCron($str){
		if (DEBUG_CRON) {
			$f = fopen(PWD."debug.txt", "a");
			$out = date("Y-m-d H:i:s")." - ".$str."\r\n";
			fputs($f, $out);
			fclose($f);
			print($out);
		}
	}
}

/**
 * Get a list of all the databases on the current server
 */
function getDbList(){
	// Keep trying to connect as the database may not be ready immediately on startup
	$first = true;
	while(!isset($cDB) || !$cDB->conn) {
		if(!$first) {
			sleep(2);
		}
		$cDB = new MySQLDB("censys","root","",$GLOBALS['dbHost']);
		$first = false;
	}

	$dbList = array();

	$principalList = $cDB->get("SELECT DISTINCT(cn_principal_id) FROM cn_principal WHERE cn_prn_name_short NOT IN ('".join("','",$GLOBALS['dbIgnore'])."')",3);
	$systemId = $cDB->get("SELECT cn_sys_db_me_id FROM cn_system",4);
	$cDB->close();
	foreach($principalList as $id) {
			$cDB = new MySQLDB("censys","root","",$GLOBALS['dbHost']);
			$dbId = $cDB->get("SELECT cn_prn_db_me_id FROM cn_principal WHERE cn_principal_id = '$id'",4);
			$cDB->close();
			if($dbId == "0" || trim($dbId) == "") {
				$dbId = $systemId;
			}
			$client = str_pad($id, 4, "0", STR_PAD_LEFT);
			$dbname = "cn_live_".$client;
			$lDB = new MySQLDB($dbname,"root","",$GLOBALS['dbHost']);
			list($dbcode,$timezone) = $lDB->get("
				SELECT
					rf_db_code,
					rf_db_time_zone
				FROM
					rf_database
				WHERE
					rf_database_id = '$dbId'
			",1);
			$lDB->close();

			array_push($dbList,array(
				'database'=>$dbname,
				'code'=>$dbcode,
				'client'=>$client,
				'timezone'=>$timezone
			));
	}

	return $dbList;
}

/**
 * Redirects to the specified url
 */
function redirect($url){
	redirectTo("".$url);
}

function myErrorHandler($errno, $errstr, $errfile, $errline){
	switch ($errno) {
	case       1 : $level = "E_ERROR"; break;
	case       2 : $level = "E_WARNING"; break;
	case       4 : $level = "E_PARSE"; break;
//	case       8 : $level = "E_NOTICE"; break;
	case      16 : $level = "E_CORE_ERROR"; break;
	case      32 : $level = "E_CORE_WARNING"; break;
	case      64 : $level = "E_COMPILE_ERROR"; break;
	case     128 : $level = "E_COMPILE_WARNING"; break;
	case     256 : $level = "E_USER_ERROR"; break;
	case     512 : $level = "E_USER_WARNING"; break;
	case    1024 : $level = "E_USER_NOTICE"; break;
	default      : return;
	}

	print(date("Y-m-d H:i:s")." - ".$level." : ".strip_tags($errstr)." in file \"".$errfile."\" on line ".$errline."\r\n");
}

set_error_handler("myErrorHandler");
$ps = new task_process();
$ps->run();
