<?php

// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
require_once(__DIR__ . "/../../functions.system.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
require_once(__DIR__ . "/../../db.rv_reservation.php");
require_once(__DIR__ . "/../../db.rv_reservation_item.php");
require_once(__DIR__ . "/../../db.rv_extra.php");
require_once(__DIR__ . "/../../db.fn_folio.php");
require_once(__DIR__ . "/../../db.rv_res_item_group.php");
require_once(__DIR__ . "/../../db.rv_payment.php");
require_once(__DIR__ . "/../../db.rv_payment_item.php");
require_once(__DIR__ . "/../../functions.reservation.php");
require_once(__DIR__ . "/../../functions.financial.php");
require_once(__DIR__ . "/../../functions.rates.php");
require_once(__DIR__ . "/../../db.tc_sequence.php");
require_once(__DIR__ . "/../../class.fiscalator.php");

if (isset($_POST) && isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'search':
            echo search($_POST);
            break;
        case 'deleteRecord':
            echo deleteRecord($_POST);
            break;
        default:
            echo 'No action specified';
            break;
    }
}

function search($post) {
    global $lDB;

    $result = $lDB->get("
        SELECT
            rv_reservation_guest.rv_reservation_id as resId,
            rv_reservation.rv_res_name as resName,
            rv_reservation.rv_date_arrive as resArrival,
            rv_reservation.rv_date_depart as resDeparture,
            rv_reservation_guest.rv_reservation_guest_ix as resGuestId,
            TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as guestName
        FROM
            rv_reservation_guest
            LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_guest.rv_reservation_id
            LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_guest.pr_guest_id
        WHERE
            rv_reservation_guest.rv_reservation_id = '" . $post['resId'] . "'
            AND rv_reservation_guest.pr_guest_id = '" . $post['guestId'] . "'
    ", 1);

    return empty($result) ? '' : json_encode($result);
}

function deleteRecord($post) {
    global $lDB;

    $lDB->put("
        DELETE FROM
            rv_reservation_guest
        WHERE
            rv_reservation_guest_ix = '" . $post['resGuestId'] . "'
    ");

    return "rv_reservation_guest record deleted successfully";
}