<?php
	if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
		header('Location: /utils/');
		exit;
	}
	
	// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
	require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../functions.system.php");
	require_once(__DIR__ . "/../../functions.php");
	require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
	require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
	require_once(__DIR__ . "/../../db.rv_reservation.php");
	require_once(__DIR__ . "/../../db.rv_reservation_item.php");
	require_once(__DIR__ . "/../../db.rv_extra.php");
	require_once(__DIR__ . "/../../db.fn_folio.php");
	require_once(__DIR__ . "/../../db.rv_res_item_group.php");
	require_once(__DIR__ . "/../../db.rv_payment.php");
	require_once(__DIR__ . "/../../db.rv_payment_item.php");
	require_once(__DIR__ . "/../../functions.reservation.php");
	require_once(__DIR__ . "/../../functions.financial.php");
	require_once(__DIR__ . "/../../functions.rates.php");
	require_once(__DIR__ . "/../../db.tc_sequence.php");

	include("header.php");

?>
	<!-- The content, with the above PHP injected -->
	<div id="mainContainer" class="uk-container">
		<div class="uk-margin-top">
			<p>Duplicate reservation guest entries can block Data Transfers from completing successfully.</p>
			<p>Using the data from the failed DT logs, these reservation guest records can be identified and removed from the Web database. Once the duplicates have been removed, the DT can be re-run.</p>
			<p>
				<strong>How do these happen in the first place?</strong><br>
				The guest record consists of a reservation ID, and a guest ID, and duplicates of these pairing are not allowed. When a guest is added to the web, and also to the offline, the causes a conflict when the offline record is transferred to the web, as the web already contains a record with the same reservation/guest ID pair. Our solution is to then delete this pair from the web database, re-run the data transfer, and allow the offline's record to be created on the web.
			</p>
			<p>
				In the DT logs, the problematic records are listed as such:<br>
				rv_reservation_guest<br>
				PA','0','11ee2fb887ff84c6b0ae8851fb285a4d','<span class="descId">RS12009</span>','<span class="descId">RS13190</span>','|null|','1|eol|<br>
				PA','0','11ee3026abdae552b0ae8851fb285a4d','<span class="descId">WB3670</span>','<span class="descId">PA5230</span>','|null|','1|eol|
			</p>
			<p>
				The fourth and fifth columns are the reservation and guest IDs respectively. In the above example, the reservation ID <span class="descId">RS12009</span> and guest ID <span class="descId">RS13190</span> has an entry in the offline and web databases, and the web copy need to be removed. The same for reservation <span class="descId">WB3670</span> and guest <span class="descId">PA5230</span>.<br>
				Some of these may not be duplicates, as the first record could be blocking the following records, thus each record need to be searched for and delete individually.
			</p>
			<p>
				<strong>Important:</strong> This will only work for errors on the <strong>rv_reservation_guest</strong> log.
			</p>
			<p>
				In the form below, enter the reservation and guest ID's, search, and then delete the web record if it exists. If not, move on to the next record.
			</p>

			<table id='searchTable' class='uk-table uk-table-striped uk-table-hover uk-table-small uk-table-middle' width='100%'>
				<thead>
					<tr>
						<th>Res ID (value 4)</th>
						<th>Guest ID (value 5)</th>
						<th>Search</th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>
							<input type="text" id="resId" class="uk-input" placeholder="Reservation ID">
						</td>
						<td>
							<input type="text" id="guestId" class="uk-input" placeholder="Guest ID">
						</td>
						<td>
							<button class='uk-button uk-button-small uk-button-primary' onclick='search();'>
								Search
							</button>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>

	<!-- Confirmation modal -->
	<div id="modal-confirm" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Confirm</h2>
			<p>Details found:</p>
			<p>
				<span class="detailsNameCol">Res ID:</span><span id="foundResId" class="detailsValueCol"></span><br>
				<span class="detailsNameCol">Res Name:</span><span id="foundResName" class="detailsValueCol"></span><br>
				<span class="detailsNameCol">Res Arrival:</span><span id="foundResArrival" class="detailsValueCol"></span><br>
				<span class="detailsNameCol">Res Departure:</span><span id="foundResDeparture" class="detailsValueCol"></span><br>
				<span class="detailsNameCol">Guest Name:</span><span id="foundGuestName" class="detailsValueCol"></span><br>
			</p>
			<p>Are you sure you want to delete this rv_reservation_guest record?</p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
				<button class="uk-button uk-button-primary" type="button" onclick="deleteRecord()">Confirm</button>
			</p>
		</div>
	</div>

	<!-- Enter ID's modal -->
	<div id="modal-enter-ids" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Error</h2>
			<p>Please enter reservation and guest ID's</p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
			</p>
		</div>
	</div>

	<!-- No record found modal -->
	<div id="modal-no-record" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Error</h2>
			<p>No record found for this combination of reservation and guest ID's</p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
			</p>
		</div>
	</div>

	<!-- Success modal -->
	<div id="modal-result" uk-modal>
		<div class="uk-modal-dialog uk-modal-body">
			<h2 class="uk-modal-title">Result</h2>
			<p id="deleteResult"></p>
			<p class="uk-text-right">
				<button class="uk-button uk-button-default uk-modal-close" type="button">Close</button>
			</p>
		</div>
	</div>

	<!-- Hidden value to keep track of the currently found rv_reservation_guest ID -->
	<input type="hidden" id="resGuestId" value="">

	<!-- The Javascript magic -->
	<script type="text/javascript">
		function search() {
			$("#resGuestId").val('');
			var resId = $("#resId").val();
			var guestId = $("#guestId").val();

			if (resId.trim() == '' || guestId.trim() == '') {
				UIkit.modal("#modal-enter-ids").show();
				return;
			}

			$.ajax({
				url: "ajax.php",
				type: "POST",
				data: {
					action: "search",
					resId: resId,
					guestId: guestId
				},
				success: function(response) {
					if (response == '') {
						UIkit.modal("#modal-no-record").show();
					} else {
						response = JSON.parse(response);
						$("#resGuestId").val(response.resGuestId);
						$("#foundResId").text(response.resId);
						$("#foundResName").text(response.resName);
						$("#foundResArrival").text(response.resArrival);
						$("#foundResDeparture").text(response.resDeparture);
						$("#foundGuestName").text(response.guestName);
						UIkit.modal("#modal-confirm").show();
					}
				}
			});
		}


		function deleteRecord() {
			$.ajax({
				url: "ajax.php",
				type: "POST",
				data: {
					action: "deleteRecord",
					resGuestId: $("#resGuestId").val()
				},
				success: function(response) {
					$("#deleteResult").text(response);
					$("#resId").val('');
					$("#guestId").val('');
					$("#resGuestId").val('');
					UIkit.modal("#modal-result").show();
				}
			});
		}	
	</script>

</body>
</html>
