<?php

// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
require_once(__DIR__ . "/../../functions.system.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
require_once(__DIR__ . "/../../db.rv_reservation.php");
require_once(__DIR__ . "/../../db.rv_reservation_item.php");
require_once(__DIR__ . "/../../db.rv_extra.php");
require_once(__DIR__ . "/../../db.fn_folio.php");
require_once(__DIR__ . "/../../db.rv_res_item_group.php");
require_once(__DIR__ . "/../../db.rv_payment.php");
require_once(__DIR__ . "/../../db.rv_payment_item.php");
require_once(__DIR__ . "/../../functions.reservation.php");
require_once(__DIR__ . "/../../functions.financial.php");
require_once(__DIR__ . "/../../functions.rates.php");
require_once(__DIR__ . "/../../db.tc_sequence.php");

if (isset($_POST) && isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'csvFileList':
            echo csvFileList();            
            break;
        case 'analyseCSVFile':
            echo analyseCSVFile($_POST['filename']);
            break;
        case 'doImport':
            echo analyseCSVFile($_POST['filename'], true);
            break;
        case 'getLog':
            echo file_get_contents($_POST['filename']);
            break;
        case 'deleteCsvFile':
            echo deleteCsvFile($_POST['filename']);
            break;
        case 'exportCsvFile':
            echo exportCsvFile($_POST['startDate'], $_POST['endDate']);
            break;
        default:
            echo 'No action specified';
            break;
    }
}


$errors = array();

function csvFileList() {
    if (!is_dir($GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'])) {
        return false;
    }

    $fileList = array();
    $folder = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/res_import";
    if (!is_dir($folder)) {
        mkdir($folder, 0777, true);
    }
    
    if (!is_dir($folder)) {
        return false;
    }
    $files = scandir($folder);
    
    foreach ($files as $file) {
        if (substr($file, -4) == ".csv") {
            $fileList[] = $file;
        }
    }
    return json_encode($fileList);
}

function deleteCsvFile($filename) {
    $folder = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/res_import";
    if (!is_dir($folder)) {
        return false;
    }
    if (!is_file($folder . "/" . $filename)) {
        return false;
    } else {
        unlink($folder . "/" . $filename);
        return true;
    }
}

function analyseCSVFile($filename, $doImport = false) {
    global $lDB, $dbcode;

    $errors = array();
    $csvData = array();
    $personaNames = array();
    $agentNames = array();
    $rateTypeNames = array();
    $statusNames = array();
    $paymentPlanNames = array();
    $sourceNames = array();
    $countryNames = array();
    $currencyNames = array();
    $accommNames = array();
    $extrasNames = array();
    $extraCategoryNames = array();
    $taxNames = array();
    $taxGroupNames = array();
    $bankNames = array();
    $paymentMethodNames = array();
    $systemUserId = $lDB->get("SELECT DISTINCT pr_user_id FROM pr_user WHERE pr_user_name = 'system' ", 4);
    $folder = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/res_import";

    $open = fopen($folder . "/" . $filename, "r");
    $data = fgetcsv($open, 1000, ",");
    
    while (($data = fgetcsv($open, 1000, ",")) !== FALSE) {
        if (count($data) < 46) {
            $errors[] = "We have not found the expected number of columns (46) in the CSV file. the last column should be AT on the spreadsheet";
            
            $result = array(
                "errors" => $errors
            );
            return json_encode($result);
        }
        if (!is_numeric($data[0])) {
            continue;
        }
        $dataRowRes = array(
            "resNumber" => $data[0],
            "createdBy" => $data[3],
            "agent" => $data[4],
            "invoiceContact" => $data[5],
            "billingContact" => $data[6],
            "originator" => $data[7],
            "internalConsultant" => $data[8],
            "paymentPlan" => $data[9],
            "reservationName" => $data[10],
            "appliedRate" => trim($data[19]),
            "commission" => $data[20],
            "invoiceCurrency" => $data[21],
            "voucherRef" => $data[23],
            "source" => $data[24],
            "createdDate" => dateFormat($data[25]),
            "status" => $data[26],
            "provisionalExpiryDate" => dateFormat($data[27]),
            "resNotes" => $data[33],
            "intNotes" => $data[34],
            "guestInformation" => $data[35],
            "nationality" => $data[36],
            "itineraries" => array(),
            "extras" => array()
        );
        $dataRowItin = array(
            "dateArrive" => dateFormat($data[1]),
            "dateDepart" => dateFormat($data[2]),
            "adults" => $data[11],
            "children" => $data[12],
            "nights" => $data[13],
            "accommodationTotalCharge" => $data[14],
            "override" => $data[15],
            "property" => $data[16],
            "roomName" => $data[17],
            "roomQty" => $data[18],
            "appliedRate" => trim($data[19]),
            "nett" => $data[22]
        );
        $dataRowPayment = array(
            "payment" => $data[28],
            "paidDate" => dateFormat($data[29]),
            "paymentMethod" => $data[30],
            "paymentNote" => $data[31],
            "bankAccount" => $data[32]
        );
        $dataRowExtra = array(
            "extraServiceDate" => dateFormat($data[37]),
            "extraDescription" => $data[38],
            "propertySpecificName" => $data[39],
            "extraInvoicingUnit" => $data[40],
            "extraQty" => $data[41],
            "extraTax" => $data[42],
            "extraTaxGroup" => $data[43],
            "extraCharge" => $data[44],
            "extraCategory" => $data[45]
        );
        if (!isset($csvData[$data[0]])) {
            $csvData[$data[0]] = $dataRowRes;
        }
        if ($dataRowItin['property'] != "") {
            $csvData[$data[0]]['itineraries'][] = $dataRowItin;
        }
        if (paymentValuesPopulated($dataRowPayment)) {
            $csvData[$data[0]]['payments'][] = $dataRowPayment;
        }
        if (extraValuesPopulated($dataRowExtra)) {
            $csvData[$data[0]]['extras'][] = $dataRowExtra;
        }
        // Gather a list of names of different types, which we'll then look up in the DB in the next step
        $userNames[] = trim($data[3]);
        $userNames[] = trim($data[8]);
        $personaNames[] = trim($data[5]);
        $personaNames[] = trim($data[6]);
        $personaNames[] = trim($data[7]);
        $personaNames[] = trim($data[40]);
        $agentNames[] = trim($data[4]);
        $propertyNames[] = trim($data[16]);
        $invoiceUnitNames[] = trim($data[39]);
        $rateTypeNames[] = trim($data[19]);
        $statusNames[] = trim($data[26]);
        $paymentPlanNames[] = trim($data[9]);
        $sourceNames[] = trim($data[24]);
        $countryNames[] = trim($data[36]);
        $currencyNames[] = trim($data[21]);
        $accommNames[] = trim($data[17]);
        $extrasNames[] = trim($data[38]);
        $extraCategoryNames[] = trim($data[45]);
        $extrasPlusCategoriesNames[] = trim($data[38]) . "|||" . trim($data[45]);
        $taxNames[] = trim($data[42]);
        $taxGroupNames[] = trim($data[43]);
        $bankNames[] = trim($data[32]);
        $paymentMethodNames[] = trim($data[30]);
    }
    fclose($open);

    // Look up ID's of names for each type
    $rates = idsFromNames(
        $rateTypeNames,
        $lDB->get("
            SELECT
                TRIM(rt_rate_type_desc) as name,
                rt_rate_type_ix as id
            FROM
                rt_rate_type
            WHERE
                rt_rate_type_desc IN ('" . join("', '", array_unique($rateTypeNames)) . "')
        ", 2)
    );

    foreach ($personaNames as $key => $personaName) {
        if (strtolower($personaName) == "direct") {
            unset($personaNames[$key]);
        }
    }

    $escapedPersonaNames = $personaNames;
    foreach ($escapedPersonaNames as $key => $name) {
        $escapedPersonaNames[$key] = str_replace("'", "\'", $name);
    }
	$persona = idsFromNames(
        $personaNames,
        $lDB->get("
            SELECT
                TRIM(CONCAT(pr_name_first, ' ', pr_name_last)) as name,
                pr_persona_ix as id
            FROM
                pr_persona
            WHERE
                TRIM(CONCAT(pr_name_first, ' ', pr_name_last)) IN ('" . join("', '", array_unique($escapedPersonaNames)) . "')
        ", 2)
    );

    foreach ($userNames as $key => $userName) {
        if (strtolower($userName) == "direct") {
            unset($userNames[$key]);
        }
    }

    $escapedUserNames = $userNames;
    foreach ($escapedUserNames as $key => $name) {
        $escapedUserNames[$key] = str_replace("'", "\'", $name);
    }
	$users = idsFromNames(
        $userNames,
        $lDB->get("
            SELECT
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as name,
                pr_persona.pr_persona_ix as id
            FROM
                pr_persona
                LEFT JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix
            WHERE
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) IN ('" . join("', '", array_unique($escapedUserNames)) . "')
                AND pr_user.pr_user_id IS NOT NULL
        ", 2)
    );

    foreach ($agentNames as $key => $agentName) {
        if (strtolower($agentName) == "direct") {
            unset($agentNames[$key]);
        }
    }

    $escapedAgentNames = $agentNames;
    foreach ($escapedAgentNames as $key => $name) {
        $escapedAgentNames[$key] = str_replace("'", "\'", $name);
    }
	$agents = idsFromNames(
        $agentNames,
        $lDB->get("
            SELECT
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as name,
                pr_persona_ix as id
            FROM
                pr_persona
                LEFT JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
            WHERE
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) IN ('" . join("', '", array_unique($escapedAgentNames)) . "')
                AND pr_agent.pr_agent_id IS NOT NULL
        ", 2)
    );

    $agents['found'][] = array(
        "id" => "0",
        "name" => "Direct"
    );

    $escapedPropertyNames = $propertyNames;
    foreach ($escapedPropertyNames as $key => $name) {
        $escapedPropertyNames[$key] = str_replace("'", "\'", $name);
    }
	$properties = idsFromNames(
        $propertyNames,
        $lDB->get("
            SELECT
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) as name,
                pr_persona.pr_persona_ix as id
            FROM
                pr_persona
                LEFT JOIN pr_business ON pr_business.pr_business_id = pr_persona.pr_persona_link_id
            WHERE
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) IN ('" . join("', '", array_unique($escapedPropertyNames)) . "')
        ", 2)
    );

    $escapedInvoiceUnitNames = $invoiceUnitNames;
    foreach ($escapedInvoiceUnitNames as $key => $name) {
        $escapedInvoiceUnitNames[$key] = str_replace("'", "\'", $name);
    }
	$invoiceUnits = idsFromNames(
        $invoiceUnitNames,
        $lDB->get("
            SELECT
                TRIM(CONCAT(pr_name_first, ' ', pr_name_last)) as name,
                pr_persona_ix as id
            FROM
                pr_persona
            WHERE
                TRIM(CONCAT(pr_name_first, ' ', pr_name_last)) IN ('" . join("', '", array_unique($escapedInvoiceUnitNames)) . "')
        ", 2)
    );

	$status = idsFromNames(
        $statusNames,
        $lDB->get("
            SELECT
                rf_reservation_status_desc as name,
                rf_reservation_status_id as id
            FROM
                rf_reservation_status
            WHERE
                rf_reservation_status_desc IN ('" . join("', '", array_unique($statusNames)) . "')
        ", 2)
    );

    $paymentPlans = idsFromNames(
        $paymentPlanNames,
        $lDB->get("
            SELECT
                TRIM(ac_pay_plan_desc) as name,
                ac_pay_plan_ix as id
            FROM
                ac_pay_plan
            WHERE
                ac_pay_plan_desc IN ('" . join("', '", array_unique($paymentPlanNames)) . "')
        ", 2)
    );

    $sources = idsFromNames(
        $sourceNames,
        $lDB->get("
            SELECT
                TRIM(rf_source_desc) as name,
                rf_source_ix as id
            FROM
                rf_source
            WHERE
                rf_source_desc IN ('" . join("', '", array_unique($sourceNames)) . "')
        ", 2)
    );

    $countries = idsFromNames(
        $countryNames,
        $lDB->get("
            SELECT
                TRIM(rf_country_name) as name,
                rf_country_ix as id
            FROM
                rf_country
            WHERE
                rf_country_name IN ('" . join("', '", array_unique($countryNames)) . "')
        ", 2)
    );

    $currencies = idsFromNames(
        $currencyNames,
        $lDB->get("
            SELECT
                rf_currency_symbol as name,
                rf_currency_ix as id
            FROM
                rf_currency
            WHERE
                rf_currency_symbol IN ('" . join("', '", array_unique($currencyNames)) . "')
        ", 2)
    );

    $accomms = idsFromNames(
        $accommNames,
        $lDB->get("
            SELECT
                TRIM(ac_accomm_desc) as name,
                ac_accomm_type_ix as id
            FROM
                ac_accomm_type
            WHERE
                TRIM(ac_accomm_desc) IN ('" . join("', '", array_unique($accommNames)) . "')
        ", 2)
    );

    $extraCategories = idsFromNames(
        $extraCategoryNames,
        $lDB->get("
            SELECT
                TRIM(ac_extra_cat_desc) as name,
                ac_extra_category_ix as id
            FROM
                ac_extra_category
            WHERE
                ac_extra_cat_desc IN ('" . join("', '", array_unique($extraCategoryNames)) . "')
        ", 2)
    );

    $extras = idsFromNamesExtras($extrasPlusCategoriesNames, $extraCategories);

    $taxes = idsFromNames(
        $taxNames,
        $lDB->get("
            SELECT
                TRIM(rf_tax_rate_desc) as name,
                rf_tax_rate_ix as id,
                rf_tax_rate_perc as value
            FROM
                rf_tax_rate
            WHERE
                rf_tax_rate_desc IN ('" . join("', '", array_unique($taxNames)) . "')
        ", 2)
    );

    $taxGroups = idsFromNames(
        $taxGroupNames,
        $lDB->get("
            SELECT
                TRIM(rt_tax_group_desc) as name,
                rt_tax_group_ix as id,
                SUM(rf_tax_rate.rf_tax_rate_perc) AS value
            FROM
                rt_tax_group
                LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = rt_tax_group.rt_tax_group_ix
                LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
            WHERE
                rt_tax_group_desc IN ('" . join("', '", array_unique($taxGroupNames)) . "')
            GROUP BY
                rt_tax_group.rt_tax_group_ix
        ", 2)
    );

    $banks = idsFromNames(
        $bankNames,
        $lDB->get("
            SELECT
                TRIM(rf_bank_acc_name) as name,
                rf_bank_ix as id
            FROM
                rf_bank
            WHERE
                rf_bank_acc_name IN ('" . join("', '", array_unique($bankNames)) . "')
        ", 2)
    );

    $paymentMethods = idsFromNames(
        $paymentMethodNames,
        $lDB->get("
            SELECT
                TRIM(rf_mthd_pmnt_desc) as name,
                rf_mthd_pmnt_ix as id
            FROM
            rf_mthd_pmnt
            WHERE
                rf_mthd_pmnt_desc IN ('" . join("', '", array_unique($paymentMethodNames)) . "')
        ", 2)
    );
   
    $reservationCount = 0;
    $itineraryCount = 0;
    $paymentCount = 0;
    $extraCount = 0;
    $noResNames = false;
    $noAdults = false;
    $noNights = false;
    $invalidTotals = false;
    $noQty = false;
    $invalidCommission = false;
    $noExtraTax = false;

    foreach ($csvData as $resKey => $reservation) {
        $extraCount += count($reservation['extras']);
        $itineraryCount += count($reservation['itineraries']);
        $reservationCount++;
        if (empty(trim($reservation['reservationName']))) {
            $noResNames = true;
        }
        $comm = str_replace(array(" ", "%"), "", $reservation['commission']);
        $comm = empty($comm) ? 0 : $comm;
        $csvData[$resKey]['commission'] = $comm;
        if (!is_numeric($comm) || $comm > 100) {
            $invalidCommission = true;
        }

        if (empty(trim($reservation['createdDate']))) {
            $csvData[$resKey]['createdDate'] = date("Y-m-d");
        }

        if (empty(trim($reservation['provisionalExpiryDate']))) {
            $csvData[$resKey]['provisionalExpiryDate'] = (new \DateTime())->add(new \DateInterval('P6M'))->format('Y-m-d');
        }

        if (empty(trim($reservation['status']))) {
            $csvData[$resKey]['status'] = "Confirmed";
        }
        
        foreach ($reservation['itineraries'] as $itinKey => $itin) {
            if (empty($itin['adults'])) {
                $noAdults = true;
            }
            if ($itin['nights'] == "" || $itin['nights'] == "0") {
                $noNights = true;
            }
            if ($itin['roomQty'] == "" || $itin['roomQty'] == "0") {
                $noQty = true;
            }
            if (strpos($itin['accommodationTotalCharge'], " ") !== false) {
                $csvData[$resKey]['itineraries'][$itinKey]['accommodationTotalCharge'] = str_replace(" ", "", $itin['accommodationTotalCharge']);
            }
            if (
                !empty($csvData[$resKey]['itineraries'][$itinKey]['accommodationTotalCharge']) &&
                !is_numeric($csvData[$resKey]['itineraries'][$itinKey]['accommodationTotalCharge'])
            ) {
                $invalidTotals = true;
            }
            if (empty($itin['nett'])) {
                $csvData[$resKey]['itineraries'][$itinKey]['nett'] = "nett";
            }
        }

        foreach ($reservation['extras'] as $extraKey => $extra) {
            if (empty($extra['extraTax']) && empty($extra['extraTaxGroup'])) {
                $noExtraTax = true;
            }
        }
    }

    if (count($rates['notFound']) > 0) {
        $errors[] = "Not all rate types are set up";
    }

    if (count($users['notFound']) > 0) {
        $errors[] = "Not all users are set up";
    }

    if (count($status['notFound']) > 0) {
        $errors[] = "Not all statuses are found, or spelled correctly";
    }

    if (count($properties['notFound']) > 0) {
        $errors[] = "Not all properties are found, or spelled correctly";
    }

    if (count($invoiceUnits['notFound']) > 0) {
        $errors[] = "Not all invoicing units are found, or spelled correctly";
    }

    if (count($paymentPlans['notFound']) > 0) {
        $errors[] = "Not all payment plans are set up";
    }

    if (count($sources['notFound']) > 0) {
        $errors[] = "Not all sources are found, or spelled correctly";
    }

    if (count($countries['notFound']) > 0) {
        $errors[] = "Not all countries are found, or spelled correctly";
    }

    if (count($currencies['notFound']) > 0) {
        $errors[] = "Not all currencies are found, or spelled correctly";
    }

    if (count($accomms['notFound']) > 0) {
        $errors[] = "Not all accommodation types are found, or spelled correctly";
    }

    if (count($extras['notFound']) > 0) {
        $errors[] = "Not all Extras are found, or spelled correctly";
    }

    if (count($extraCategories['notFound']) > 0) {
        $errors[] = "Not all Extra categories are found, or spelled correctly";
    }

    if (count($banks['notFound']) > 0) {
        $errors[] = "Not all banks are found, or spelled correctly";
    }

    if (count($paymentMethods['notFound']) > 0) {
        $errors[] = "Not all payment methods are found, or spelled correctly";
    }

    if ($noResNames) {
        $errors[] = "Not all reservations have names";
    }

    if ($noAdults) {
        // Commented out, as this may be reinstated in future
        // $errors[] = "Not all itineraries have adults";
    }

    if ($noNights) {
        $errors[] = "Not all itineraries have nights";
    }

    if ($invalidTotals) {
        // Commented out, as this may be reinstated in future
        // $errors[] = "Not all itineraries have valid total charges";
    }

    if ($noQty) {
        $errors[] = "Not all itineraries have valid room quantities";
    }

    if ($invalidCommission) {
        $errors[] = "Not all reservations have valid commission values";
    }

    if ($noExtraTax) {
        $errors[] = "Some Extras have no Tax or Tax Groups specified";
    }

    $propertiesFound = [];
    $duplicateProperties = [];
    foreach ($properties['found'] as $found) {
        if (in_array($found['name'], $propertiesFound)) {
            $duplicateProperties[] = $found['name'];
        } else {
            $propertiesFound[] = $found['name'];
        }
    }
    if (!empty($duplicateProperties)) {
        $errors[] = "Duplicate properties were found: " . join(', ', $duplicateProperties);
    }

    $result = array(
        "reservationCount" => $reservationCount,
        "itineraryCount" => $itineraryCount,
        "paymentCount" => $paymentCount,
        "extraCount" => $extraCount,
        "rates" => $rates,
        "persona" => $persona,
        "agents" => $agents,
        "users" => $users,
        "properties" => $properties,
        "invoiceUnits" => $invoiceUnits,
        "status" => $status,
        "paymentPlans" => $paymentPlans,
        "sources" => $sources,
        "countries" => $countries,
        "currencies" => $currencies,
        "accomms" => $accomms,
        "extras" => $extras,
        "extraCategories" => $extraCategories,
        "banks" => $banks,
        "taxes" => $taxes,
        "taxGroups" => $taxGroups,
        "paymentMethods" => $paymentMethods,
        "paymentMethods" => $paymentMethods,
        "paymentMethods" => $paymentMethods,
        "errors" => $errors
    );

    if ($doImport) {
        progressLog("Started import at " . date('Y-m-d H:i:s'));
        $importResult = array(
            "reservations" => array(
                "done" => array(),
                "skipped" => array()
            ),
            "itineraries" => array(
                "done" => array(),
                "skipped" => array()
            ),
            "extras" => array(
                "done" => array(),
                "skipped" => array()
            ),
            "payments" => array(
                "done" => array(),
                "skipped" => array()
            ),
            "persona" => array(
                "created" => array(),
                "skipped" => array()
            )
        );

        if (count($persona['notFound']) > 0) {
            foreach ($persona['notFound'] as $name) {
                if (strpos($name, " ") !== false) {
                    $nameParts = explode(" ", $name);
                    $pr_name_last = array_pop($nameParts);
                    $pr_name_first = join(" ", $nameParts);
                } else {
                    $pr_name_first = $name;
                    $pr_name_last = "";
                }
                $id = db_pr_persona_insert(false,$pr_name_last,$pr_name_first);
                if ($id) {
                    $persona['found'][] = array(
                        "id" => $id,
                        "name" => $name
                    );
                    $importResult['persona']['done'][] = $id;
                    progressLog("Created persona " . $id . " (" . $name . ")");
                } else {
                    $importResult['persona']['skipped'][] = $id;
                    progressLog("Skipped creation of persona " . $name);
                }
            }
        }

        foreach ($csvData as $reservation) {
            if (empty($reservation['paymentPlan'])) {
                $reservation['paymentPlan'] = "Contract";
            }

            $resId = db_rv_reservation_insert(
                getId($reservation['appliedRate'], $rates['found']),            // rt_rate_type_id
                false,                                                          // rv_corr_persona_id
                getId($reservation['agent'], $agents['found']),                 // rv_agent_id
                $reservation['commission'],                                     // rv_commission_perc
                false,                                                          // rv_commission_deduct_yn
                getId($reservation['invoiceCurrency'], $currencies['found']),   // rv_invoice_currency_id
                getId($reservation['billingContact'], $persona['found']),       // rv_billing_persona_id
                getId($reservation['invoiceContact'], $persona['found']),       // rv_invoice_persona_id
                $reservation['reservationName'],                                // rv_res_name
                $reservation['voucherRef'],                                     // rv_agent_ref
                $reservation['resNotes'],                                       // rv_note_general
                $reservation['guestInformation'],                               // rv_note_guests
                $reservation['intNotes'],                                       // rv_note_internal
                getId($reservation['paymentPlan'], $paymentPlans['found']),     // ac_pay_plan_id
                getId($reservation['nationality'], $countries['found']),        // rf_country_id
                getId($reservation['source'], $sources['found']),               // rf_source_ix
                getId($reservation['status'], $status['found']),                // rf_reservation_status_id
                $reservation['createdDate'],                                    // rf_reservation_status_date
                $reservation['provisionalExpiryDate'],                          // rv_provision_expiry_date
                getId($reservation['createdBy'], $users['found']),              // pr_user_id
                getId($reservation['internalConsultant'], $users['found']),     // rv_consultant_id
                $reservation['createdDate'],                                    // rv_date_recorded
                $reservation['createdDate'],                                    // rv_date_changed
                false,                                                          // rv_ref_num
                false,                                                          // db_code
                $reservation['resNumber'],                                      // rv_reservation_id
                getId($reservation['originator'], $persona['found']),           // rv_origin_agent_id
                false                                                           // ac_pos_id
            );

            if (!empty($resId)) {
                $importResult['reservations']['done'][] = $resId;
                progressLog("Created reservation " . $resId . " (" . $reservation['reservationName'] . ")");
                $lDB->put("UPDATE rv_reservation SET rv_reservation_id = '" . $reservation['resNumber'] . "' WHERE rv_reservation_ix = '" . $resId . "'");
                ammendReservation(
                    $resId,
                    "Imported from external system
Date: " . date('Y-m-d h:i:s a', time())
                );              

                $rv_origin_agent_id = getId($reservation['originator'], $persona['found']);

                if (!empty($rv_origin_agent_id)) {
                    $lDB->put("UPDATE rv_reservation SET rv_origin_agent_id = '".$rv_origin_agent_id."' WHERE rv_reservation_ix = '$resId'");
                }

                $rategroupUnitId = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_class='0' AND rt_rate_group_sys_code = '1'",4);
                $rategroupAdultId = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_class='1' AND rt_rate_group_sys_code = '2'",4);
                $rategroupChildId = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_class='2' AND rt_rate_group_sys_code = '3'",4);

                if (isset($reservation['itineraries']) && is_array($reservation['itineraries'])) {
                    foreach ($reservation['itineraries'] as $itinerary) {
                        $rateGroups = array(
                            array(
                                "rt_rate_group_ix" => $rategroupUnitId,
                                "qty" => empty($itinerary['roomQty']) ? 1 : $itinerary['roomQty']
                            ),
                            array(
                                "rt_rate_group_ix" => $rategroupAdultId,
                                "qty" => empty($itinerary['adults']) ? 0 : $itinerary['adults']
                            ),
                            array(
                                "rt_rate_group_ix" => $rategroupChildId,
                                "qty" => empty($itinerary['children']) ? 0 : $itinerary['children']
                            )
                        );

                        $override = false;
                        if (strpos(strtolower($itinerary['override']), "person") !== false) {
                            $override = array(
                                'level'=>1,
                                'amounts'=>array(
                                    'rate_group'=>array(
                                        $rategroupAdultId => $itinerary['accommodationTotalCharge']
                                    )
                                )
                            );
                        }

                        if (strpos(strtolower($itinerary['override']), "unit") !== false) {
                            $override = array(
                                'level'=>2,
                                'amounts'=>array(
                                    'rate_group'=>array(
                                        $rategroupAdultId => $itinerary['accommodationTotalCharge']
                                    )
                                )
                            );
                        }

                        if (strpos(strtolower($itinerary['override']), "stay") !== false) {
                            $override = array(
                                'level'=>3,
                                'amounts'=>array(
                                    'stay' => $itinerary['accommodationTotalCharge']
                                )
                            );
                        }
                        $accommId = findAccomm(getId($itinerary['property'], $properties['found']), $itinerary['roomName']);
                        $itemDataRaw = array(
                            "ac_accomm_type_id" => $accommId,
                            "rv_item_date_arrive" => $itinerary['dateArrive'],
                            "rv_item_date_depart" => $itinerary['dateDepart'],
                            "nights" => $itinerary['nights'],
                            "rate_groups" => $rateGroups
                        );
                        $result = calCreateItem(
                            $resId,                                                 // resId
                            $itemDataRaw,                                           // itemDataRaw
                            getId($itinerary['appliedRate'], $rates['found']),      // rate_id
                            'defaultOnly',                                          // compList
                            $override,                                              // override
                            '',                                                     // rv_item_split_yn
                            '0'                                                     // ovrdDiscAmt
                        );
                        if (!empty($result[0])) {
                            $importResult['itineraries']['done'][] = $resId;
                            progressLog("Created itinerary for reservation " . $resId . ": " . $itinerary['dateArrive'] . " to " . $itinerary['dateDepart'] . ", " . (empty($itinerary['roomQty']) ? 1 : $itinerary['roomQty']) . " rooms, " . $itinerary['roomName']);
                            if (!isset($arrivalDate)) {
                                $arrivalDate = $itinerary['dateArrive'];
                            } else {
                                if (strtotime($itinerary['dateArrive']) < strtotime($arrivalDate)) {
                                    $arrivalDate = $itinerary['dateArrive'];
                                }
                            }
                        } else {
                            $importResult['itineraries']['skipped'][] = $resId;
                            progressLog("Skipped itinerary for reservation " . $resId . ": " . $itinerary['dateArrive'] . " to " . $itinerary['dateDepart'] . ", " . (empty($itinerary['roomQty']) ? 1 : $itinerary['roomQty']) . " rooms, " . $itinerary['roomName']);
                        }
                    }
                }

                if (!isset($arrivalDate)) {
                    $arrivalDate = $reservation['createdDate'];
                }

                if (isset($reservation['extras']) && is_array($reservation['extras'])) {
                    foreach ($reservation['extras'] as $extra) {
                        $billingUnitId = db_pr_business_get_billing(getId($extra['propertySpecificName'], $persona['found']));
                        if (empty($billingUnitId)) {
                            $billingUnitId = db_pr_business_get_billing(getId($extra['extraInvoicingUnit'], $persona['found']));
                        }

                        if (!empty($extra['extraTax']) && empty($extra['extraTaxGroup'])) {
                            $taxInd = 10;
                            $taxPerc = getValue($extra['extraTax'], $taxes['found']);
                            $taxId = getId($extra['extraTax'], $taxes['found']);
                        } else {
                            $taxInd = 20;
                            $taxId = getId($extra['extraTaxGroup'], $taxGroups['found']);
                        }

                        $extraServiceDate = !empty($extra['extraServiceDate']) ? $extra['extraServiceDate'] : $arrivalDate;
                        $extraQty = !empty($extra['extraQty']) ? $extra['extraQty'] : 1;

                        // Ignore passed percentage, look up percentage from Tax Code Table
                        $taxPerc = taxPercentage($taxId, $taxInd);

                        $extraId = db_rv_extra_insert(
                            $resId,                                                         // rv_reservation_id
                            getId($extra['extraDescription'], $extras['found']),            // ac_extra_id
                            getId($extra['propertySpecificName'], $persona['found']),       // pr_business_id
                            $extraQty,                                                      // rv_extra_units
                            $extraServiceDate,                                              // rv_extra_date_serv
                            $extra['extraCharge'],                                          // rv_extra_charge
                            0,                                                              // rv_extra_discount
                            $taxPerc,                                                       // $rv_extra_tax_perc
                            0,                                                              // rv_extra_comm_rec
                            0,                                                              // rv_extra_comm_pay
                            "",                                                             // rv_extra_note
                            "
IMPORTED FROM EXTERNAL SYSTEM
Date: ".date('Y-m-d h:i:s a', time()),                                                      // rv_extra_note_internal
                            "",                                                             // rv_res_item_group_id
                            getId($reservation['invoiceCurrency'], $currencies['found']),   // rf_currency_id
                            getId($reservation['invoiceCurrency'], $currencies['found']),   // rv_extra_inv_curr_id
                            1,                                                              // rv_extra_exch_rate
                            "0000-00-00",                                                   // rv_extra_exch_expiry
                            $billingUnitId                                                  // pr_business_inv_id
                        );
                        if (!empty($extraId)) {
                            db_rv_extra_tax_insert($extraId, $taxInd, $taxId);
                            $fn_folio_to_id = $lDB->get("SELECT fn_folio_to_id FROM fn_folio WHERE rv_reservation_id = '" . $resId . "' LIMIT 1",4);
                            $fn_folio_id = db_fn_folio_insert_extra($extraId, false, $fn_folio_to_id);
                            if(!empty($fn_folio_id) && $fn_folio_id != 2) {
                                db_rv_extra_set_folio($extraId, $fn_folio_id);
                                $importResult['extras']['done'][] = $extraId;
                                progressLog("Created Extra '" . $extra['extraDescription'] . "' for reservation " . $resId . " (" . $extraId . ")");
                            }
                        } else {
                            $importResult['extras']['skipped'][] = $reservation['resNumber'];
                            progressLog("Skipped Extra '" . $extra['extraDescription'] . "' for reservation " . $resId);
                        }
                    }
                }

                if (isset($reservation['payments']) && is_array($reservation['payments'])) {
                    foreach ($reservation['payments'] as $payment) {
                        if ($payment['payment'] != 0) {
                            $fn_folio_id = $lDB->get("SELECT fn_folio_ix FROM fn_folio WHERE fn_folio.rv_reservation_id = '" . $resId . "' ORDER BY fn_folio.fn_folio_folio_num LIMIT 1", 4);
                            if(!empty($fn_folio_id)) {

                                $person = !empty($reservation['internalConsultant']) ? getId($reservation['internalConsultant'], $persona['found']) : $systemUserId;
                                $paidDate = !empty($payment['paidDate']) ? $payment['paidDate'] : date("Y-m-d");
                                $payment['paymentMethod'] = !empty($payment['paymentMethod']) ? $payment['paymentMethod'] : "Electronic transfer";

                                $rv_payment_id = db_rv_payment_insert(
                                    $person,
                                    $paidDate,
                                    getId($payment['bankAccount'], $banks['found']),
                                    getId($payment['paymentMethod'], $paymentMethods['found']),
                                    "",             // rv_pmnt_ref
                                    $payment['paymentNote']
                                );
                                if(!empty($rv_payment_id)) {
                                    $rv_payment_item_id = db_rv_payment_item_insert(
                                        $rv_payment_id,
                                        $fn_folio_id,
                                        $payment['payment'],
                                        1           // rv_pay_item_exch_rate
                                    );
                                    recalcTotals($resId);
                                    $importResult['payments']['done'][] = $rv_payment_id;
                                    progressLog("Created payment of '" . $payment['payment'] . "' for reservation " . $resId . " (payment ID: " . $rv_payment_id . ")");
                                } else {
                                    $importResult['payments']['skipped'][] = $reservation['resNumber'];
                                    progressLog("Skipped payment of '" . $payment['payment'] . "' for reservation " . $resId);
                                }
                            } else {
                                $importResult['payments']['skipped'][] = $reservation['resNumber'];
                                progressLog("Skipped payment of '" . $payment['payment'] . "' for reservation " . $resId);
                            }
                        }
                    }
                }
            } else {
                $importResult['reservations']['skipped'][] = $reservation['resNumber'];
                progressLog("Skipped creation of reservation #" . $reservation['resNumber']);
            }
        }
        progressLog("");
        progressLog("Completed import at " . date('Y-m-d H:i:s'));
        progressLog("Reservations: " . count($importResult['reservations']['done']) . " (skipped " . count($importResult['reservations']['skipped']) . ")");
        progressLog("Itineraries: " . count($importResult['itineraries']['done']) . " (skipped " . count($importResult['itineraries']['skipped']) . ")");
        progressLog("Extras: " . count($importResult['extras']['done']) . " (skipped " . count($importResult['extras']['skipped']) . ")");
        progressLog("Payments: " . count($importResult['payments']['done']) . " (skipped " . count($importResult['payments']['skipped']) . ")");
        progressLog("");
        progressLog("");
        progressLog("");
        $importResult['logfile'] = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/res_import/log/reservation_import_" . date('Y-m-d') . ".log";
        return json_encode($importResult);
    }

    return json_encode($result);
}

function getId($name, $array) {
    foreach ($array as $record) {
        if (strtolower($record['name']) == strtolower($name)) {
            return $record['id'];
        }
    }
    return "";
}

function getValue($name, $array) {
    foreach ($array as $record) {
        if (strtolower($record['name']) == strtolower($name)) {
            return $record['value'];
        }
    }
    return "";
}

function arrayValuesPopulated($array) {
    $isPopulated = false;
    foreach ($array as $value) {
        if (!empty($value)) {
            $isPopulated = true;
        }
    }
    return $isPopulated;
}

function paymentValuesPopulated($data) {
    if (
        !empty($data['payment']) &&
        !empty($data['bankAccount'])
    ) {
        return true;
    } else {
        return false;
    }
}

function extraValuesPopulated($data) {
    if (
        !empty($data['extraDescription']) &&
        !empty($data['extraCharge']) &&
        !empty($data['extraCategory'])
    ) {
        return true;
    } else {
        return false;
    }
}

function idsFromNames($names, $sqlResults) {
    $names = array_unique($names);
    sort($names);
    $results = array(
        "found" => array(),
        "notFound" => array()
    );
    foreach ($names as $name) {
        if (!empty(trim($name))) {
            $found = false;
            foreach ($sqlResults as $sqlResult) {
                if (strtolower($sqlResult['name']) == strtolower($name)) {
                    $results['found'][] = $sqlResult;
                    $found = true;
                }
            }
            if (!$found) {
                $results['notFound'][] = $name;
            }
        }
    }
    return $results;
}

function idsFromNamesExtras($names, $extraCategories) {
    global $lDB;

    if (empty($names)) {
        return $names;
    }

    $names = array_unique($names);
    sort($names);
    $results = array(
        "found" => array(),
        "notFound" => array()
    );
    foreach ($names as $name) {
        $nameParts = explode("|||", $name);
        if (!empty($nameParts[0]) && !empty($nameParts[1])) {
            $categoryId = getId($nameParts[1], $extraCategories['found']);

            $sqlResult = $lDB->get("
                SELECT
                    TRIM(ac_ext_desc) as name,
                    ac_extra_ix as id
                FROM
                    ac_extra
                WHERE
                    ac_ext_desc = '" . addslashes($nameParts[0]) . "'
                    AND ac_extra_category_id = '" . $categoryId . "'
            ", 1);

            if (!empty($sqlResult)) {
                $results['found'][] = $sqlResult;
            } else {
                $results['notFound'][] = $nameParts[0];
            }
        }
    }
    return $results;
}

function progressLog($message) {
    $folder = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'];
    if (!is_dir($folder)) {
        return false;
    }

    $folder .= "/res_import";
    if (!is_dir($folder)) {
        mkdir($folder, 0777, true);
    }

    $folder .= "/log";
    if (!is_dir($folder)) {
        mkdir($folder, 0777, true);
    }

    $fileName = $folder . "/reservation_import_" . date('Y-m-d') . '.log';
    if (!empty($message)) {
        $message = date('Y-m-d H:i:s') . ": " . $message;
    }
    file_put_contents($fileName, $message . "\n", FILE_APPEND);
}

function dateFormat($date) {
    if (empty(trim($date))) {
        return "";
    }
    $date = new DateTime($date);
    return $date->format('Y-m-d');
}

function findAccomm($propertyId, $accommName) {
    global $lDB;

    return $lDB->get("
        SELECT
            ac_accomm_type_ix
        FROM
            ac_accomm_type
        WHERE
            TRIM(LOWER(ac_accomm_desc)) = '" . trim(strtolower($accommName)) . "'
            AND pr_business_id = '" . $propertyId . "'
    ", 4);
}
    
// Export section

function exportCsvFile($startDate, $endDate) {
    global $lDB;

    $resData = array();
    $folder = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'];
    if (!is_dir($folder)) {
        return false;
    }

    $folder .= "/res_import";
    if (!is_dir($folder)) {
        mkdir($folder, 0777, true);
    }
    $filename = "Export " . date("Y-m-d h_i_s") . ".csv";
    $csvFilename = $folder .= "/" . $filename;
    $csvFileLink = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $GLOBALS['principal_id'] . "/res_import/" . $filename;    
    
    $counter = 0;
    $fileCounter = 1;
    $totalRes = 1;
    $properties = "";
    $propertywhere = !empty($properties) ? "AND pr_business_id IN ('" . join("', '", explode(',', $properties)) . "')" : "";

    $reservations = $lDB->get("
        SELECT
            rv_reservation_id
        FROM
            rv_reservation_item
        WHERE
            rv_item_date_arrive >= '" . $startDate . "'
            AND rv_item_date_depart <= '" . $endDate . "'
            " . $propertywhere . "
    ", 3);

    $reservations = array_unique($reservations);

    if (is_file($csvFilename)) {
        unlink($csvFilename);
    }
    
    $headerRow = array(array("Res Number","Arrive Date","Departure Date","Created By","Agent","Invoice Contact","Billing Contact","Originator","Internal Consultant","Payment Plan","Reservation name","Adults","Children","Nights","Accommodation Total Charge","Override","Property","Accommodation Type Name","Room QTY","Applied Rate","Commission","Invoice Currency","Nett","Voucher Ref","Source","Created Date","Status","Provisional Expiry Date","Payment","Paid Date","Payment Method","Payment Note","Bank Account","Res Notes","Int notes","Guest Information","Nationality","Extra Service Date","Extra Description","Property","Invoicing unit","Extra Qty","Extra Tax","Extra Tax Group","Extra charge","Extra Category"));
    writeExportToCSV($headerRow, $csvFilename);

    foreach ($reservations as $resId) {
        $rows = fetchReservation($resId, $properties);
        if (!empty($rows)) {
            writeExportToCSV($rows, $csvFilename);
            $totalRes++;
        }        
    }

    $result = [
        "message" => "Exported file with " . $totalRes . " reservations",
        "fileName" => $filename,
        "fileLink" => $csvFileLink
    ];
    
    return json_encode($result);
}

function writeExportToCSV($rows, $csvFilename) {
    foreach ($rows as $row) {
        $csvfile = fopen($csvFilename, "a");
        fwrite($csvfile, "\"" . join($row, "\", \"") . "\"\n");
        fclose($csvfile);
    }
}

function fetchReservation($resId, $properties) {
    global $lDB;

    $rows = array();

    $reservation = $lDB->get("
        SELECT
            rv_reservation.rv_reservation_ix as resId,
            TRIM(CONCAT(createdBy.pr_name_first, ' ', createdBy.pr_name_last)) as createdByUser,
            TRIM(CONCAT(agent.pr_name_first, ' ', agent.pr_name_last)) as agent,
            TRIM(CONCAT(invoicePersona.pr_name_first, ' ', invoicePersona.pr_name_last)) as invoicePersona,
            TRIM(CONCAT(billingPersona.pr_name_first, ' ', billingPersona.pr_name_last)) as billingPersona,
            TRIM(CONCAT(originAgent.pr_name_first, ' ', originAgent.pr_name_last)) as originAgent,
            TRIM(CONCAT(consultant.pr_name_first, ' ', consultant.pr_name_last)) as consultant,
            ac_pay_plan.ac_pay_plan_desc as payPlan,
            rv_reservation.rv_res_name as resName,
            rv_reservation.rv_commission_perc as commission,
            rf_currency.rf_currency_symbol as invoiceCurrency,
            rv_reservation.rv_agent_ref as voucher,
            rf_source.rf_source_desc as source,
            rv_reservation.rv_date_recorded as createdDate,
            rf_reservation_status.rf_reservation_status_desc as status,
            rv_reservation.rv_provision_expiry_date as provExpiryDate,
            rv_reservation.rv_note_general as resNote,
            rv_reservation.rv_note_internal as intNote,
            rv_reservation.rv_note_guests as guestNote,
            rf_country.rf_country_name as nationality
        FROM
            rv_reservation
            LEFT JOIN pr_persona createdBy ON createdBy.pr_persona_ix = rv_reservation.pr_reservation_user_id
            LEFT JOIN pr_persona agent ON agent.pr_persona_ix = rv_reservation.rv_agent_id
            LEFT JOIN pr_persona invoicePersona ON invoicePersona.pr_persona_ix = rv_reservation.rv_invoice_persona_id
            LEFT JOIN pr_persona billingPersona ON billingPersona.pr_persona_ix = rv_reservation.rv_billing_persona_id
            LEFT JOIN pr_persona originAgent ON originAgent.pr_persona_ix = rv_reservation.rv_origin_agent_id
            LEFT JOIN pr_persona consultant ON consultant.pr_persona_ix = rv_reservation.rv_consultant_id
            LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id
            LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
            LEFT JOIN rf_source ON rf_source.rf_source_ix = rv_reservation.rf_source_ix
            LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
            LEFT JOIN rf_country ON rf_country.rf_country_ix = rv_reservation.rf_country_id
         WHERE
            rv_reservation.rv_reservation_ix = '" . $resId . "'
    ", 1);

    $propertywhere = !empty($properties) ? "AND rv_reservation_item.pr_business_id IN ('" . join("', '", explode(',', $properties)) . "')" : "";
    $itineraries = $lDB->get("
        SELECT
            rv_reservation_item.rv_item_date_arrive as arrive,
            rv_reservation_item.rv_item_date_depart as depart,
            rv_reservation_item.rv_item_adult_count as adults,
            rv_item_child_count as children,
            rv_item_nights as nights,
            IF(rv_reservation_item.rv_item_overide_amt IS NOT NULL, rv_reservation_item.rv_item_overide_amt, rv_reservation_item.rv_item_amt_gross) as totalCharge,
            rv_reservation_item.rv_item_overide_level_ind as override,
            TRIM(CONCAT(property.pr_name_first, ' ', property.pr_name_last)) as property,
            ac_accomm_type.ac_accomm_desc as accomm,
            rv_reservation_item.rv_item_accomm_count as rooms,
            rt_rate_type.rt_rate_type_desc as rate,
            rv_reservation_item.rv_item_amt_nett as accommNett
        FROM
            rv_reservation_item
            LEFT JOIN pr_persona property ON property.pr_persona_ix = rv_reservation_item.pr_business_id
            LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
            LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id
        WHERE
            rv_reservation_item.rv_reservation_id = '" . $resId . "'
            " . $propertywhere . "
    ", 2);
    $lastAdults = "";
    $lastNights = "";
    $lastRooms = "";

    foreach ($itineraries as $itinerary) {
        if ($itinerary['override'] == "1") { $itinerary['override'] = "Person"; }
        if ($itinerary['override'] == "2") { $itinerary['override'] = "Unit"; }
        if ($itinerary['override'] == "3") { $itinerary['override'] = "Stay"; }
        $lastAdults = $itinerary['adults'];
        $lastNights = $itinerary['nights'];
        $lastRooms = $itinerary['rooms'];

        $rows[] = array(
            substr($resId, 2),
            $itinerary['arrive'],
            $itinerary['depart'],
            $reservation['createdByUser'],
            $reservation['agent'],
            $reservation['invoicePersona'],
            $reservation['billingPersona'],
            $reservation['originAgent'],
            $reservation['consultant'],
            $reservation['payPlan'],
            str_replace('"', '“', $reservation['resName']),
            $itinerary['adults'],
            $itinerary['children'],
            $itinerary['nights'],
            $itinerary['totalCharge'],
            $itinerary['override'],
            $itinerary['property'],
            $itinerary['accomm'],
            $itinerary['rooms'],
            trim($itinerary['rate']),
            $reservation['commission'],
            $reservation['invoiceCurrency'],
            $itinerary['accommNett'],
            $reservation['voucher'],
            $reservation['source'],
            $reservation['createdDate'],
            $reservation['status'],
            $reservation['provExpiryDate'],
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Payment field
            str_replace('"', '“', $reservation['resNote']),
            str_replace('"', '“', $reservation['intNote']),
            str_replace('"', '“', $reservation['guestNote']),
            $reservation['nationality'],
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            ""                                      // Extra field
        );
    }

    if (empty($rows)) {
        return;
    }

    $propertywhere = !empty($properties) ? "AND rv_extra.pr_business_id IN ('" . join("', '", explode(',', $properties)) . "')" : "";
    $extras = $lDB->get("
        SELECT
            rv_extra.rv_extra_date_serv as serviceDate,
            ac_extra.ac_ext_desc as extraDesc,
            TRIM(CONCAT(property.pr_name_first, ' ', property.pr_name_last)) as property,
            TRIM(CONCAT(billing.pr_name_first, ' ', billing.pr_name_last)) as billingUnit,
            rv_extra.rv_extra_units as qty,
            IF(rv_extra_tax_ind='10', rf_tax_rate.rf_tax_rate_desc, '') as taxRate,
            IF(rv_extra_tax_ind='20', rt_tax_group.rt_tax_group_desc, '') as taxGroup,
            rv_extra.rv_extra_charge as charge,
            ac_extra_category.ac_extra_cat_desc as category
        FROM
            rv_extra
            LEFT JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
            LEFT JOIN pr_persona property ON property.pr_persona_ix = rv_extra.pr_business_id
            LEFT JOIN pr_persona billing ON billing.pr_persona_ix = rv_extra.pr_business_inv_id
            LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id
            LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_extra.rf_tax_id
            LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
        WHERE
            rv_extra.rv_reservation_id = '" . $resId . "'
            " . $propertywhere . "
    ", 2);

    foreach ($extras as $extra) {
        $rows[] = array(
            substr($resId, 2),
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            $reservation['createdByUser'],
            $reservation['agent'],
            $reservation['invoicePersona'],
            $reservation['billingPersona'],
            $reservation['originAgent'],
            $reservation['consultant'],
            $reservation['payPlan'],
            $reservation['resName'],
            $lastAdults,
            "",                                     // Itinerary field
            $lastNights,
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            $lastRooms,
            trim($itinerary['rate']),
            $reservation['commission'],
            $reservation['invoiceCurrency'],
            "",                                     // Itinerary field
            $reservation['voucher'],
            $reservation['source'],
            $reservation['createdDate'],
            $reservation['status'],
            $reservation['provExpiryDate'],
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Payment field
            "",                                     // Res note
            "",                                     // Res note
            "",                                     // Res note
            $reservation['nationality'],
            $extra['serviceDate'],
            trim($extra['extraDesc']),
            $extra['property'],
            $extra['billingUnit'],
            $extra['qty'],
            trim($extra['taxRate']),
            trim($extra['taxGroup']),
            $extra['charge'],
            trim($extra['category'])
        );
    }

    if (empty($rows)) {
        return;
    }

    $payments = $lDB->get("
        SELECT
            rv_payment.rv_pmnt_amount as amount,
            rv_payment.rv_pmnt_date as paymentDate,
            rf_mthd_pmnt.rf_mthd_pmnt_desc as method,
            rv_payment.rv_pmnt_note as note,
            rf_bank.rf_bank_acc_name as bank
        FROM
            rv_payment_item
            LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
            LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
            LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
        WHERE
            rv_payment_item.rv_reservation_id = '" . $resId . "'
    ", 2);

    foreach ($payments as $payment) {
        $rows[] = array(
            substr($resId, 2),
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            $reservation['createdByUser'],
            $reservation['agent'],
            $reservation['invoicePersona'],
            $reservation['billingPersona'],
            $reservation['originAgent'],
            $reservation['consultant'],
            $reservation['payPlan'],
            $reservation['resName'],
            $lastAdults,
            "",                                     // Itinerary field
            $lastRooms,
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            "",                                     // Itinerary field
            $lastNights,
            trim($itinerary['rate']),
            $reservation['commission'],
            $reservation['invoiceCurrency'],
            "",                                     // Itinerary field
            $reservation['voucher'],
            $reservation['source'],
            $reservation['createdDate'],
            $reservation['status'],
            $reservation['provExpiryDate'],
            $payment['amount'],
            $payment['paymentDate'],
            $payment['method'],
            str_replace('"', '“', $payment['note']),
            $payment['bank'],
            "",                                     // Res note
            "",                                     // Res note
            "",                                     // Res note
            $reservation['nationality'],
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            "",                                     // Extra field
            ""                                      // Extra field
        );
    }

    return $rows;
}