$(document).ready(function() {
	
});

var importFilename = "";

function csvFileList() {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {action: "csvFileList"}
	})
	.done(function(result) {
		if (result != "") {
			$("#importFiles").empty();
			result = JSON.parse(result);
			$.each( result, function( index, value ) {
				$("#importFiles").append(`
					<div class="uk-margin-small-top">
						<a href="" uk-icon="icon: trash" class="trashIcon"></a>
						<button uk-dropdown class="uk-button uk-button-small uk-button-danger" onclick='deleteCsvFile("` + value + `")'>
							Confirm Deletion
						</button>

						<a href="" uk-icon="icon: file-text"></a>
						<a onclick='loadCSVFile("` + value + `");'>` + value + `</a>
					</div>
					<div class="uk-divider-icon"></div>
				`);
			});
		} else {
			$("#importFiles").append(`
				<div class="uk-margin-small-top">
					No files imported yet.
				</div>
			`);
		}
		
	});
}

function getLog(filename) {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {action: "getLog", filename: filename}
	})
	.done(function(result) {
		$("#log").val(result);
		$("#log").show();		
	});
}

function deleteCsvFile(filename) {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {action: "deleteCsvFile", filename: filename}
	})
	.done(function(result) {
		if (result != "") {
			UIkit.notification({
				message: 'CSV file deleted: ' + filename,
				status: 'primary',
				pos: 'top-center',
				timeout: 3000
			});
			csvFileList();
		} else {
			UIkit.notification({
				message: 'Error deleting CSV file',
				status: 'primary',
				pos: 'top-center',
				timeout: 3000
			});
			csvFileList();
		}
		
	});
}

function loadCSVFile(name) {
	UIkit.offcanvas("#offcanvas").hide();
	$("#importFilename").html("<strong>" + name + "</strong>");
	importFilename = name;
	$("#alPic").html('<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/man-detective.png" style="height: 70px;">');
	$("#alText").html("Let me have a look at the file you selected...");
	$("#alText2").html("");
	$("#importButtonContainer").hide();
	analyseCSVFile();
}

function analyseCSVFile() {
	$("#helpText").hide();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {action: "analyseCSVFile", filename: importFilename}
	})
	.done(function(result) {
		result = JSON.parse(result);

		var alText = `
			You have selected a CSV file!<br>
			I have taken the liberty of analysing your import file so long, and have found the following useful information:
		`;

		var alText2 = ``;

		alText2 += `
				<div>Reservations: ` + result.reservationCount + `</div>
				<div>Itineraries: ` + result.itineraryCount + `</div>
				<div>Payments: ` + result.paymentCount + `</div>
				<div>Extras: ` + result.extraCount + `</div>
		`;

		if (result.rates) {
			alText2 += resultsFoundFormatting(result.rates, "Rates");
		}

		if (result.agents) {
			alText2 += resultsFoundFormatting(result.agents, "Agents");
		}

		if (result.persona) {
			alText2 += resultsFoundFormatting(result.persona, "Persona");
		}

		if (result.users) {
			alText2 += resultsFoundFormatting(result.users, "Users");
		}

		if (result.properties) {
			alText2 += resultsFoundFormatting(result.properties, "Properties");
		}

		if (result.invoiceUnits) {
			alText2 += resultsFoundFormatting(result.invoiceUnits, "Invoice Units");
		}

		if (result.status) {
			alText2 += resultsFoundFormatting(result.status, "Status");
		}

		if (result.paymentPlans) {
			alText2 += resultsFoundFormatting(result.paymentPlans, "Payment Plans");
		}

		if (result.sources) {
			alText2 += resultsFoundFormatting(result.sources, "Sources");
		}

		if (result.countries) {
			alText2 += resultsFoundFormatting(result.countries, "Countries");
		}

		if (result.currencies) {
			alText2 += resultsFoundFormatting(result.currencies, "Currencies");
		}

		if (result.accomms) {
			alText2 += resultsFoundFormatting(result.accomms, "Accommodation Types");
		}

		if (result.extras) {
			alText2 += resultsFoundFormatting(result.extras, "Extras");
		}

		if (result.extraCategories) {
			alText2 += resultsFoundFormatting(result.extraCategories, "Extras Categories");
		}

		if (result.banks) {
			alText2 += resultsFoundFormatting(result.banks, "Banks");
		}

		if (result.paymentMethods) {
			alText2 += resultsFoundFormatting(result.paymentMethods, "Payment Methods");
		}

		if (result.taxes) {
			alText2 += resultsFoundFormatting(result.taxes, "Tax Rates");
		}

		if (result.taxGroups) {
			alText2 += resultsFoundFormatting(result.taxGroups, "Tax Groups");
		}

		if (result.errors && result.errors.length > 0) {
			alText2 += `
				<div class="uk-margin-large-top">We have found some concerning issues, that need to be addressed before we can do the import:</div>
				<div>` + result.errors.join('</div><div>') + `</div>
			`;
		}

		$("#alPic").html('<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/man-technologist.png" style="height: 70px;">');
		$("#alText").html(alText);
		$("#alText2").html(alText2);

		if (result.errors.length == 0) {
			$("#importButtonContainer").show();
		}
	});
}

function resultsFoundFormatting(item, label) {
	var alText2 = ``;
	if (item.found.length > 0 || item.notFound.length > 0) {
		alText2 += `<div>` + label + ` found: ` + item.found.length + `/` + (item.found.length + item.notFound.length);
		if (item.notFound.length > 0) {
			alText2 += ` (<i>not found: ` + item.notFound.join(', ') + `</i>)`;
		}
		alText2 += `</dev>`;
	}
	return alText2;
}

function doImport() {
	$("#helpText").hide();
	$("#alPic").html('<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/man-gesturing-ok.png" style="height: 70px;">');
	$("#alText").html("Please hang tight, we're doing the import now!<br><i>This may take a wee while...</i>");
	$("#alText2").html("");
	$("#importButtonContainer").hide();
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {action: "doImport", filename: importFilename}
	})
	.done(function(result) {
		result = JSON.parse(result);

		var alText = `
			The import has completed!<br>
			Here are the final results:
		`;

		var alText2 = ``;

		if (result.reservations.done.length > 0 || result.reservations.skipped.length > 0) {
			alText2 += `<div>Reservations: ` + result.reservations.done.length + ` imported`
			if (result.reservations.skipped.length > 0) {
				alText2 += ` / ` + result.reservations.skipped.length + ` skipped`;
			}
			alText2 += `</div>`;
		}

		if (result.itineraries.done.length > 0 || result.itineraries.skipped.length > 0) {
			alText2 += `<div>Itineraries: ` + result.itineraries.done.length + ` imported`
			if (result.itineraries.skipped.length > 0) {
				alText2 += ` / ` + result.itineraries.skipped.length + ` skipped`;
			}
			alText2 += `</div>`;
		}

		if (result.extras.done.length > 0 || result.extras.skipped.length > 0) {
			alText2 += `<div>Extras: ` + result.extras.done.length + ` imported`
			if (result.extras.skipped.length > 0) {
				alText2 += ` / ` + result.extras.skipped.length + ` skipped`;
			}
			alText2 += `</div>`;
		}

		if (result.payments.done.length > 0 || result.payments.skipped.length > 0) {
			alText2 += `<div>Payments: ` + result.payments.done.length + ` imported`
			if (result.payments.skipped.length > 0) {
				alText2 += ` / ` + result.payments.skipped.length + ` skipped`;
			}
			alText2 += `</div>`;
		}

		if (result.persona.created.length > 0) {
			alText2 += `<div>Persona: ` + result.persona.created.length + ` created</div>`;
			if (result.persona.skipped.length > 0) {
				alText2 += ` / ` + result.persona.skipped.length + ` skipped`;
			}
		}

		alText2 += `
			<div></div>
			<div class="uk-margin-top">
				<button class="uk-button uk-button-primary" onclick="getLog('` + result.logfile + `');">View current Logfile (today)</button>
			</div>
			<div class="uk-margin-small-top">
				<textarea id="log" class="uk-textarea" rows="15" style="display: none;"></textarea>
			</div>
		`;
		$("#alPic").html('<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/man-tipping-hand.png" style="height: 70px;">');
		$("#alText").html(alText);
		$("#alText2").html(alText2);

		$("#importButtonContainer").hide();
	});
}

function toggleHelp() {
	$("#helpText").toggle();
	if ($("#helpText").is(":visible")) {
		$([document.documentElement, document.body]).animate({
			scrollTop: $("#helpText").offset().top
		}, 500);
	}
}

function exportCsvFile() {
	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: {
			action: "exportCsvFile",
			startDate: $("#startDate").val(),
			endDate: $("#endDate").val()
		}
	})
	.done(function(result) {
		result = JSON.parse(result);
		console.log(result);

		var alText = `
			The export has completed!<br>
			Here is the link to the file:<br>
			<a href="` + result.fileLink + `">` + result.fileName + `</a>
		`;
		$("#alPic").html('<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/man-tipping-hand.png" style="height: 70px;">');
		$("#alText").html(alText);
		$("#alText2").html("");
		$("#importButtonContainer").hide();
		UIkit.notification({message: result.message, status: 'success'});
		UIkit.offcanvas("#offcanvasExport").hide();
	});
}