<?php
	if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
		header('Location: /utils/');
		exit;
	}

	// Include a bunch of Enterprise files. We may not need all of these, but they're all pretty standard inclusions for Utils
	require_once(__DIR__ . "/../../class.mysqldb.php");             // MySQL DB Class
	require_once(__DIR__ . "/../../functions.system.php");
	require_once(__DIR__ . "/../../functions.php");
	require_once(__DIR__ . "/../../inc.setup.php");                 // Database Connection, customised setup and config file
	require_once(__DIR__ . "/../../ac_logon.php");                  // Access Control Results
	require_once(__DIR__ . "/../../db.rv_reservation.php");
	require_once(__DIR__ . "/../../db.rv_reservation_item.php");
	require_once(__DIR__ . "/../../db.rv_extra.php");
	require_once(__DIR__ . "/../../db.fn_folio.php");
	require_once(__DIR__ . "/../../db.rv_res_item_group.php");
	require_once(__DIR__ . "/../../db.rv_payment.php");
	require_once(__DIR__ . "/../../db.rv_payment_item.php");
	require_once(__DIR__ . "/../../functions.reservation.php");
	require_once(__DIR__ . "/../../functions.financial.php");
	require_once(__DIR__ . "/../../functions.rates.php");
	require_once(__DIR__ . "/../../db.tc_sequence.php");

	$maxFileUploadSize = ini_get("upload_max_filesize");

	if (isset($_FILES) && !empty($_FILES)) {
		if (is_dir($GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'])) {
			$folder = $GLOBALS['images_dir_on_disk'] . "/" . $GLOBALS['principal_id'] . "/res_import";
			if (!is_dir($folder)) {
				mkdir($folder, 0777, true);
			}

			if (!file_exists($folder)) {
				mkdir($folder, 0777, true);
			}
			move_uploaded_file($_FILES["files"]["tmp_name"][0], $folder . "/" . basename($_FILES["files"]["name"][0]));
			header("Refresh:0; url=index.php");
		}
	}

	@set_time_limit(0);

	$startDate = date("Y-m-01");
	$endDate = date("Y-m-t");

	include("header.php");
?>

<div id="mainContainer" class="uk-container">
	<div class="uk-align-right uk-margin-small-top">
		<button class="uk-button uk-button-default uk-button-small" type="button" uk-toggle="target: #offcanvas" onclick="csvFileList();">Select file for Import</button>
	</div>

	<div class="uk-align-right uk-margin-small-top">
		<button class="uk-button uk-button-default uk-button-small" type="button" uk-toggle="target: #offcanvasExport">Export file</button>
	</div>

	<div class="uk-margin-top">
		Import file: <span id="importFilename">No file selected</span>
	</div>
	

	<div id="offcanvas" uk-offcanvas="overlay: true; flip: true">
		<div class="uk-offcanvas-bar">
			<button class="uk-offcanvas-close" type="button" uk-close></button>
			<h3>Select Import File</h3>
			<div id="importFiles"></div>

			<div class="uk-margin-large-top">Select new CSV file to upload:</div>
			<div class="uk-text-small">(Make sure it is smaller than <?php echo $maxFileUploadSize; ?>)</div>
			<div class="js-upload uk-placeholder uk-text-center">
				<span uk-icon="icon: cloud-upload"></span>
				<span class="uk-text-middle">Upload a CSV file by dropping it here or</span>
				<div uk-form-custom>
					<input type="file" name="csvFile">
					<span class="uk-link">Browse for a file</span>
				</div>
			</div>
			<progress id="js-progressbar" class="uk-progress" value="0" max="100" hidden></progress>
		</div>
	</div>

	<div id="offcanvasExport" uk-offcanvas="overlay: true; flip: true">
		<div class="uk-offcanvas-bar">
			<button class="uk-offcanvas-close" type="button" uk-close></button>
			<h3>You want to export data to a file?</h3>
			Based on reservation arrival & departure dates, specify a date range to export:
			<div>
				<input id="startDate" type="text" class="uk-input uk-margin-small-top" placeholder="Start date" value="<?php echo $startDate; ?>">
			</div>
			<div>
				<input id="endDate" type="text" class="uk-input uk-margin-small-top" placeholder="End date" value="<?php echo $endDate; ?>">
			</div>

			<div class="uk-align-right uk-margin-small-top">
				<button class="uk-button uk-button-default uk-button-small" type="button" onclick="exportCsvFile()">Do the Export</button>
			</div>
		</div>
	</div>

	<div class="uk-margin-large-top">
		<table width="100%">
			<tr>
				<td id="alPic" valign="middle">
				<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/man-raising-hand.png" style="height: 70px;">
				</td>
				<td id="alText" valign="middle">
					Hallo, my name is Al! I'll be helping you with this tool!<br>
					It doesn't look like you have selected an import file yet.<br>
					Click the "Select File" button above to choose an import file to work with.<br>
					Or if you'd like to export reservations from this system, click "Export File"
				</td>
				<td style="width: 200px; text-align: right; cursor: pointer; font-size: 24px;">
					<div onclick="toggleHelp();" style="display: inline-block;">
						<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/questionmark.png" style="height: 20px; position: relative; left: 20px; top: -3px;">
						<img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/reservation_import/assets/images/exclamationmark.png" style="height: 20px; position: relative; left: 5px; top: -3px;">
						Halp
					</div>
				</td>
			</tr>
		</table>
		<div id="alText2"></div>
	</div>

	<div id="importButtonContainer" class="uk-margin-top">
		<button id="proceedButton" class="uk-button uk-button-primary" onclick="doImport();">Proceed with Import</button>
		<div id="importSpinner" uk-spinner></div>
	</div>

	<div class="uk-margin-large-top">
		<div id="helpText" style="display: none;" class="uk-margin-large-top">
			<h3>Keep calm, halp is on the way!</h3>
			<div>It all starts with a CSV (Comma Separated Values) file. Click Select File at the top right of the screen, and in the sidebar, upload a CSV file. Once your file is uploaded, click Select File again, and click on your file.</div>
			<div>We will then analyse the document for you, and if there are no errors, you can click on Proceed to perform the import.</div>
			<div>The CSV file need to be in a very specific format, and with the correct number of columns, and the correct data, which I will outline below.</div>
			<div>The first line of the CSV file may be a heading row. In fact, any rows not starting with a number (the res number) will be ignored during the import process.</div>
			<div>The first column, Res Number, ties multiple lines together for each reservation. The reservation-specific information for each reservation will only be used from the first line for a reservation, but itineraries, payments and extras will be imported line-by-line.</div>
			<div>The reservation number will be used to create reservations on the current environment. so if you want WA reservations, you need to switch the Enterprise environment to WA first.</div>
			<div>If a reservation with the same number already exists on the current environment, the creation of the new reservation will be skipped, as well as any itineraries, payments and extras to be imported.</div>
			<div>Imports are intensive, especially for large amounts of data, so be patient during the import process.</div>

			<table width="100%" class="uk-table uk-table-small uk-table-divider">
				<thead>
					<tr>
						<th>Col</th>
						<th>Section</th>
						<th>Name</th>
						<th>Description</th>
					</tr>
				</thead>
				<tr>
					<td>A</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Res Number</td>
					<td>The number of the resulting reservation. If this number already exist on the current environment, the reservation creation will be skipped.</td>
				</tr>
				<tr>
					<td>B</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Arrive Date</td>
					<td>Arrival date of the itinerary</td>
				</tr>
				<tr>
					<td>C</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Departure Date</td>
					<td>Departure Date of the itinerary</td>
				</tr>
				<tr>
					<td>D</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Created By</td>
					<td>Name of the <strong>user</strong> that the reservation has been created by. <span class="red">This user must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>E</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Agent</td>
					<td>Name of the <strong>agent</strong> that the reservation is allocated to. <span class="red">This agent must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>F</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Invoice Contact</td>
					<td>This persona will be created if it doesn't exist. Empty value will fall back to agent, or correspondence contact.</td>
				</tr>
				<tr>
					<td>G</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Billing Contact</td>
					<td>This persona will be created if it doesn't exist. Empty value will fall back to agent, or correspondence contact.</td>
				</tr>
				<tr>
					<td>H</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Originator</td>
					<td>This persona will be created if it doesn't exist.</td>
				</tr>
				<tr>
					<td>I</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Internal Consultant</td>
					<td>Name of the <strong>user</strong> assigned as the internal consultant. <span class="red">This user must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>J</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Payment Plan</td>
					<td>Payment plan for the reservation, if empty the default value is "Contract". If specified, <span class="red">this payment plan must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>K</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Reservation name</td>
					<td>Name of the reservation. Compulsory.</td>
				</tr>
				<tr>
					<td>L</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Adults</td>
					<td>Number of adults on the itinerary. Compulsory.</td>
				</tr>
				<tr>
					<td>M</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Children</td>
					<td>Number of children on the itinerary. If empty, will default to zero.</td>
				</tr>
				<tr>
					<td>N</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Nights</td>
					<td>Number of nights on the itinerary. Compulsory.</td>
				</tr>
				<tr>
					<td>O</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Accommodation Total Charge</td>
					<td>Compulsory if an override is specified, otherwise will be calculated by the rate.</td>
				</tr>
				<tr>
					<td>P</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Override</td>
					<td>To override an itinerary rate. If not specified, rate will be calculated. Valid values: Stay, Person, Unit</td>
				</tr>
				<tr>
					<td>Q</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Property</td>
					<td>Property where the itinerary is booked at. Compulsory. If this is left empty, the row will be ignored as an itinerary, even if all other itinerary details are present.</td>
				</tr>
				<tr>
					<td>R</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Accommodation Type Name</td>
					<td>Accommodation type the itinerary is booked for. Compulsory.</td>
				</tr>
				<tr>
					<td>S</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Room QTY</td>
					<td>Number of rooms in the itinerary. Compulsory.</td>
				</tr>
				<tr>
					<td>T</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Applied Rate</td>
					<td>Rate to apply to the reservation, as well as the itinerary. Compulsory in all scenarios. If no override is specified in column P, the total will be calculated.</td>
				</tr>
				<tr>
					<td>U</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Commission</td>
					<td>Commission to apply to the reservation. Percentage, less than 100, no percentage sign. If not specified, defaults to zero.</td>
				</tr>
				<tr>
					<td>V</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Invoice Currency</td>
					<td>Currency to be used for invoicing. Compulsory.</td>
				</tr>
				<tr>
					<td>W</td>
					<td class="uk-text-warning">Itinerary</td>
					<td>Nett</td>
					<td>Nett</td>
				</tr>
				<tr>
					<td>X</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Voucher Ref</td>
					<td>Optional voucher reference number.</td>
				</tr>
				<tr>
					<td>Y</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Source</td>
					<td>Source, optional (can be left empty). <span class="red">If specified, this source must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>Z</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Created Date</td>
					<td>Date the reservation was created on. If empty, the current date will be used.</td>
				</tr>
				<tr>
					<td>AA</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Status</td>
					<td>Status of the reservation. Compulsory. <span class="red">This status must exist on the system.</span></td>
				</tr>
				<tr>
					<td>AB</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Provisional Expiry Date</td>
					<td>Expiry date to be used for provisional reservations. If empty, a date 6 months from the current date will be used.</td>
				</tr>
				<tr>
					<td>AC</td>
					<td class="uk-text-primary">Payment</td>
					<td>Payment</td>
					<td>Amount paid. Compulsory. No spaces, special characters, or currency symbols.</td>
				</tr>
				<tr>
					<td>AD</td>
					<td class="uk-text-primary">Payment</td>
					<td>Paid Date</td>
					<td>Date of payment. If empty, current date will be used.</td>
				</tr>
				<tr>
					<td>AE</td>
					<td class="uk-text-primary">Payment</td>
					<td>Payment Method</td>
					<td>Payment method used for payment. If empty, "Electronic transfer" will be used. If specified, <span class="red">the payment method must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AF</td>
					<td class="uk-text-primary">Payment</td>
					<td>Payment Note</td>
					<td>Note relating to the payment, optional.</td>
				</tr>
				<tr>
					<td>AG</td>
					<td class="uk-text-primary">Payment</td>
					<td>Bank Account</td>
					<td>Bank account to which payment has been made. Compulsory. <span class="red">The bank account must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AH</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Res Notes</td>
					<td>Notes relating to the reservation. Optional.</td>
				</tr>
				<tr>
					<td>AI</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Int notes</td>
					<td>Internal notes relating to the reservation. Optional.</td>
				</tr>
				<tr>
					<td>AJ</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Guest Information</td>
					<td>Information relating to the guests. Optional.</td>
				</tr>
				<tr>
					<td>AK</td>
					<td class="uk-text-danger">Reservation</td>
					<td>Nationality</td>
					<td>Nationality of the guests. Compulsory. Corresponds to the Countries code table. <span class="red">The country must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AL</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra Service Date</td>
					<td>Service date of the extra. If empty, the arrival date of the reservation will be used (earliest itinerary date).</td>
				</tr>
				<tr>
					<td>AM</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra Description</td>
					<td>Name of the extra. Compulsory. <span class="red">The extra must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AN</td>
					<td class="uk-text-success">Extra</td>
					<td>Property</td>
					<td>Property where the extra is purchased from, if the extra is property-specific. Compulsory, unless Invoicing Unit (column AO) is specified. <span class="red">The property must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AO</td>
					<td class="uk-text-success">Extra</td>
					<td>Invoicing unit</td>
					<td>Invoicing unit to use for extra, if it is not specific to a property. Compulsory, if Property (column AN) is not specified. <span class="red">The invoicing unit must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AP</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra Qty</td>
					<td>Quantity of extras purchased. If empty, defaults to 1.</td>
				</tr>
				<tr>
					<td>AQ</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra Tax</td>
					<td>Name of tax rate used for extra. Compulsory, unless tax group is specified in column AR. Name of tax rate (not the percentage). <span class="red">The tax rate must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AR</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra Tax Group</td>
					<td>Name of tax group used for extra. Compulsory, unless tax rate is specified in column AQ. Name of tax group (not the percentage). <span class="red">The tax group must be set up on the system.</span></td>
				</tr>
				<tr>
					<td>AS</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra charge</td>
					<td>Cost of the extra. Compulsory.</td>
				</tr>
				<tr>
					<td>AT</td>
					<td class="uk-text-success">Extra</td>
					<td>Extra Category</td>
					<td>Category of the extra. Compulsory. <span class="red">The extra category must be set up on the system.</span></td>
				</tr>
			</table>
		</div>
	</div>

</div>

<script type="text/javascript" src="/resource/Resrequest/Application/public/include/flatpickr/flatpickr.js"></script>
<link rel="stylesheet" href="/resource/Resrequest/Application/public/include/flatpickr/flatpickr.min.css" type="text/css" />

<script>
	var bar = document.getElementById('js-progressbar');

	UIkit.upload('.js-upload', {
		url: 'index.php',
		multiple: false,
		allow: '*.csv',
		beforeSend: function () {},
		beforeAll: function () {},
		load: function () {},
		error: function () {},
		complete: function () {},
		loadStart: function (e) {
			bar.removeAttribute('hidden');
			bar.max = e.total;
			bar.value = e.loaded;
		},
		progress: function (e) {
			bar.max = e.total;
			bar.value = e.loaded;
		},
		loadEnd: function (e) {
			bar.max = e.total;
			bar.value = e.loaded;
		},
		completeAll: function () {
			setTimeout(function () {
				bar.setAttribute('hidden', 'hidden');
			}, 1000);

			UIkit.notification({
				message: 'CSV upload completed',
				status: 'primary',
				pos: 'top-center',
				timeout: 3000
			});
			csvFileList();
		}
	});

	$("#startDate").flatpickr({
		altInput: true,
		altFormat: "j F, Y",
		dateFormat: "Y-m-d"
	});

	$("#endDate").flatpickr({
		altInput: true,
		altFormat: "j F, Y",
		dateFormat: "Y-m-d"
	});
</script>

<style>
	#mainContainer {
		min-height: 600px;
	}
</style>


</BODY>
</HTML>
