<?php
if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
    header('Location: /utils/');
    exit;
}

require_once(__DIR__ . "/functions.php");


if(isset($_POST['action']) && $_POST['action'] == "save") {
	$rooms = explode(":",$_POST['data']);
	foreach($rooms as $room) {
		list($id,$date) = explode(",",$room);
		$lDB->put("UPDATE ac_accomm_room SET ac_accomm_room_create_date = '$date' WHERE ac_accomm_room.ac_accomm_room_ix = '$id'");
	}
	echo "true";
	die();
}

$html = getHTML("main.htm");
$t = array();
$t['title'] = "Room creation fixer ($principal_name_short $principal_id)";


$rooms = $lDB->get("
	SELECT
		pr_business.pr_business_id,
		pr_persona.pr_name_last,
		ac_accomm_room.ac_accomm_type_id,
		ac_accomm_type.ac_accomm_desc,
		ac_accomm_room.ac_accomm_room_ix AS ac_accomm_room_id,
		ac_accomm_room.ac_desc,
		ac_accomm_room.ac_accomm_room_create_date
	FROM
		ac_accomm_room
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		pr_business.pr_bus_property_yn = '1'
		AND pr_business.pr_bus_inactive_yn = '0'
		AND pr_persona.pr_persona_inactive_yn = '0'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
		AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
	ORDER BY pr_business.pr_business_sequence, ac_accomm_type.ac_accomm_sequence, ac_accomm_room.ac_desc
",6);

$last = array(
	'pr_business_id' => '',
	'ac_accomm_type_id' => ''
);
$rows = "";
foreach($rooms as $room) {
	$propertyTags = "";
	if(isset($last['pr_business_id']) && $last['pr_business_id'] != $room['pr_business_id']) {
		$propertyTags = addTags(array('type'=>"property",'id'=>$room['pr_business_id']),$html['apply']);
		$propertyTags .= $room['pr_name_last'];
	}

	$accommTags = "";
	if(isset($last['pr_business_id']) && $last['ac_accomm_type_id'] != $room['ac_accomm_type_id']) {
		$accommTags = addTags(array('type'=>"accomm",'id'=>$room['ac_accomm_type_id']),$html['apply']);
		$accommTags .= $room['ac_accomm_desc'];
	}

	$roomTags = addTags(array('type'=>"room",'id'=>$room['ac_accomm_room_id']),$html['apply']);
	$roomTags .= $room['ac_desc'];

	$rows .= addTags(array(
		'property'=>$propertyTags,
		'accommodation'=>$accommTags,
		'room'=>$roomTags,
		'created'=>"
			<input type=\"text\"  name=\"room_new\" id=\"room_new_$room[ac_accomm_room_id]\" value=\"$room[ac_accomm_room_create_date]\" />
			<input type=\"hidden\"  name=\"room_old\" id=\"room_old_$room[ac_accomm_room_id]\" value=\"$room[ac_accomm_room_create_date]\" />
			<input type=\"hidden\" name=\"property_$room[pr_business_id]\" value=\"$room[ac_accomm_room_id]\" />
			<input type=\"hidden\" name=\"accomm_$room[ac_accomm_type_id]\" value=\"$room[ac_accomm_room_id]\" />
			<input type=\"hidden\" name=\"room_$room[ac_accomm_room_id]\" value=\"$room[ac_accomm_room_id]\" />
		"
	),$html['table_row']);
	$last = $room;
}

$t['content'] = $html['refresh'].$html['save'].addTags(array('id'=>"new_date",'date'=>date("Y-m-d")),$html['new_date']) . addTags(array('rows'=>$rows),$html['table']); 

echo addTags($t,$html['main']);
