#!/usr/bin/env bash

cd `dirname $0`/..

# setup
NAME=$0;
PURPOSE="Run benchmark tests on ResRequest Enterprise"
SYNOPSIS="`basename $NAME` [-hu:]"
USAGE_EXAMPLE="`basename $NAME` -u \"http://my.test.url/\""
SCRIPT_VERSION="1.0.0"
SHELL="bash"

SCRIPT_DIR=`pwd`
CONCURRENCY_LEVEL=10;
REQUESTS=100;
URL="";

REQUIRES="getopts ab"

get_options() {
	OPTIONS_FOUND=false;
	while getopts  "hu:" OPT
	do
		OPTIONS_FOUND=true;
		case "$OPT" in
			\?)
				exit 1
			;;
		esac
	done
	OPTIND=1;
	shift $((OPTIND-1))
	while getopts  "hu:" OPT
	do
		OPTIONS_FOUND=true;
		case "$OPT" in
			h) 
				usage
				exit 0;
			;;
			u) 
				URL=${OPTARG};
			;;
		esac
	done
	if [ $OPTIONS_FOUND = false ] 
	then
		echo " ERROR: No options specified";
		echo "";
		usage
		exit 1;
	fi
	if [[ -z "${URL}" ]] 
	then  
		echo " ERROR: Please provide all options";
		echo "";
		usage
		exit 1;
	fi
}

assert_requirements() {
	for REQUIRE in $REQUIRES
	do
		command -v ${REQUIRE} >/dev/null 2>&1 || { echo >&2 "'${REQUIRE}' is required, but it's not installed. Aborting."; exit 1; }
	done
}

usage() {
	echo >&2 "`basename ${NAME}` ${SCRIPT_VERSION} - ${PURPOSE}
 Usage: ${SYNOPSIS}
 Requires: ${REQUIRES}
 Example: ${USAGE_EXAMPLE}
 Options:
   -h, Usage and options (this help)
   -u, Url"
}

run() {
	get_options "$@";
	ab -n 100 -c 100 "${URL}"
}

run "$@"
