<?php
DEFINE('INSERT_COUNT', 10); // The amount of inserts for each table
DEFINE('HIDE_FAILED_TABLES', false); // Hide failed tables from results
DEFINE('EXCLUDE_FAILED_TEST_TIME', true); // Exclude failed test time from total time

$text = "";
$content = "";

// This needs to be fixed at some stage
ini_set("session.bug_compat_42","off");
ini_set("session.bug_compat_warn","off");
// End temporary fix

ob_start();

$versionDir = "../.."; // Override the location to look for the .ver file

require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/../../functions.system.php');
require_once(__DIR__ . '/../../functions.php');
require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/../../functions.transfer.common.php');
require_once(__DIR__ . '/../../db.pf_object.php');
require_once(__DIR__ . '/../../db.pf_field.php');

$userid = isset($_SESSION['userid']) && !empty($_SESSION['userid']) ? $_SESSION['userid'] : -1; // User ID (includes DBCode) to reference user information
$background = isset($_GET['background']) && $_GET['background'] == "true" ? true : false;
$deleteRecords = isset($_GET['delete']) && $_GET['delete'] == "true" ? true : false;

bootstrap($background);
// Check if user has appropriate permissions
if($GLOBALS['userStatusId'] < "2") {
    redirect("/reservation.php");
    die();
}

$GLOBALS['debug'] = -10;
// Setup variables
$helpSpotNumber = "";
$jiraNumber = "";
$toolName = "Database Table Test";
$toolDescription = "Testing the database operations to all tables";
$adhocFixDir = "adhoc-template";
global $testUUID, $date;
$testUUID = $lDB->get("SELECT GET_UUID();",4);
$date = new DateTime(date('Y-m-d'));

function redirect($url){
    redirectTo("".$url);
}

function bootstrap($background) {
    global $lDB, $dbcode, $userid;

    if ($background) {
        # Validate registered user
        $userArray = $lDB->get("
            SELECT
                pr_user.pr_user_id,
                pr_persona.pr_name_first,
                pr_persona.pr_name_last,
                pr_persona.pr_sys_code,
                pr_user.pr_user_name,
                pr_user.pr_user_password,
                pr_user.pr_user_inactive_yn
            FROM
                pr_user
                INNER JOIN pr_persona ON pr_user.pr_user_id = pr_persona.pr_persona_ix
            WHERE
                pr_user.pr_user_name='censysad'
                AND pr_user.pr_user_password='censysad1'
                AND pr_user.pr_user_inactive_yn=0
        ",1);
        $userid = $userArray[0];
        $pr_name_first = $userArray[1];
        $pr_name_last = $userArray[2];
        $pr_sys_code = $userArray[3];
        if (strlen($userid) < "3") {
            redirect("./../../login_popup.php?1");
            session_destroy();
            exit();
        } else {
            $_SESSION['calendarParms'] = "";
            $_SESSION['calPropList'] = "";
            $_SESSION['calAccommList'] = "";
            $_SESSION['calAgentId'] = "";
            $_SESSION['canCalWizard'] = "";
            $_SESSION['blockRateOverLap'] = "";
            $_SESSION['calRateList'] = "";
            $_SESSION['addedExpiry'] = "";
            $_SESSION['calStepNumber'] = "";
            $_SESSION['reportURL'] = "";
            $_SESSION['reportProfile'] = "";

            $_SESSION['calStartDate'] = "";
            $_SESSION['calEndDate'] = "";

            $_SESSION['userid'] = $userid;
            $GLOBALS['userStatusId'] = 2;
            unset($_SESSION['wizResId']);
            unset($wizResId);
            
            session_write_close();

            $userid = $userArray[0];
            $pr_name_first = $userArray[1];
            $pr_name_last = $userArray[2];
            $pr_sys_code = $userArray[3];
            $pr_business_link = idBusLink($userid);
            $pr_agent_link = idAgentLink($userid);
            $is_an_agent = isAgent($userid);
            $grpArray = $lDB->get("
                SELECT
                    sc_user.sc_group_id,
                    sc_group.sc_grp_desc
                FROM
                    sc_user
                    INNER JOIN sc_group ON sc_user.sc_group_id = sc_group.sc_group_id
                WHERE
                    sc_user.pr_user_id='$userid'
                    AND sc_group.sc_grp_inactive_yn=0
            ",1);
            #  Set up result array
            $securitygroup = $grpArray[0];
            $sc_grp_desc = $grpArray[1];

            require_once(__DIR__ . '/../../ac_logon.php'); 

            $defaultHomepages = db_pf_option_get_defaults(db_pf_object_by_name("user_preferences"));
            
            db_ad_user_log_insert();
        }
    }
}

function output($mode,$background,$text) {
    global $dbcode, $userid;
    $now = DateTime::createFromFormat('U.u', microtime(true));
    $logFileName = getcwd()."/benchmarking/TEST_LOG_".$now->format("Y_m_d_H_i_s_u")."_".$dbcode."_".$userid.".html";
    if ($mode == "cli" || $background) {
        file_put_contents($logFileName, $text);
    } else {
        echo $text;
    }
}

$GLOBALS['lDB']->isMaster = "1"; // Set to master


$tables = $GLOBALS['lDB']->get("
    SELECT DISTINCT
        information_schema.TABLES.TABLE_NAME,
        tc_table.tc_table_key_ind,
        tc_table.tc_table_user_facing_yn
    FROM
        information_schema.TABLES
        INNER JOIN information_schema.COLUMNS ON information_schema.COLUMNS.TABLE_NAME = information_schema.TABLES.TABLE_NAME
        INNER JOIN tc_table ON tc_table.tc_table_name = information_schema.TABLES.TABLE_NAME
    WHERE
        information_schema.TABLES.TABLE_SCHEMA = DATABASE()
    ORDER BY
        information_schema.TABLES.TABLE_NAME
", 6);
$content .= "<h2>Tests</h2>";
$content .= "<table class='tableFullWidth tableFullMain'>";
$content .= "<thead>";
$content .= "<tr>";
$content .= "	<th>#</th>";
$content .= "	<th>Table name</th>";
$content .= "	<th>Status</th>";
$content .= "	<th>Details</th>";
$content .= "	<th>Time (ms)</th>";
$content .= "	<th>Insert count</th>";
$content .= "	<th>tc_table_key_ind</th>";
$content .= "	<th>tc_table_user_facing_yn</th>";
$content .= "</tr>";
$content .= "</thead>";
$content .= "<tbody>";
$counter = 0;
$totalTime = 0;
foreach ($tables as $table) {
    $counter++;
    $test = runTest($table['TABLE_NAME']);
    $test = empty($test) ? array('status'=>"N/A",'details'=>"N/A", 'time'=>0, 'insertCount'=>"N/A") : $test;
    
    if(HIDE_FAILED_TABLES === true) {
        if($test['status'] == "Failed") {
            continue;
        }
    }

    if(EXCLUDEFAILED_TEST_TIME === true) {
        if($test['status'] == "Success") {
            $totalTime = $totalTime + $test['time'];
        } else {
            $test['time'] = 0;
        }
    } else {
        $totalTime = $totalTime + $test['time'];
    }
    
    $content .= "<tr>";
    $content .= "	<td>";
    $content .= "		$counter";
    $content .= "	</td>";
    $content .= "	<td>";
    $content .= "		$table[TABLE_NAME]";
    $content .= "	</td>";
    $content .= "	<td style=\"background-color:" . (($test['status'] == "Success") ? "green" : "red") . ";\">";
    $content .= " 		".$test['status'];
    $content .= "	</td>";
    $content .= "	<td>";
    $content .= " 		".$test['details'];
    $content .= "	</td>";
    $content .= "	<td>";
    $content .= " 		".$test['time'];
    $content .= "	</td>";
    $content .= "	<td>";
    $content .= " 		" . INSERT_COUNT;
    $content .= "	</td>";
    $content .= "	<td>";
    $content .= " 		".$table['tc_table_key_ind'];
    $content .= "	</td>";
    $content .= "	<td>";
    $content .= " 		".(($table['tc_table_user_facing_yn'] == 1) ? "Y" : "N");
    $content .= "	</td>";
    $content .= "</tr>";
}
$content .= "</tbody>";
$content .= "<tfoot>";
$content .= "<tr>";
$content .= "	<td colspan=\"4\">";
$content .= " 		Total tests ran: <strong>$counter</strong>";
$content .= "	</td>";
$content .= "	<td colspan=\"4\">";
$content .= " 		Total time (ms): <strong>$totalTime</strong>";
$content .= "	</td>";
$content .= "</tr>";
$content .= "</tfoot>";
$content .= "</table>";

function runTest(string $tableName) {
    global $lDB;

    $testTableFunction = 'test_' . $tableName;
    if (function_exists($testTableFunction)) {
        $startTime = microtime(true);

        for($i = 1; $i <= INSERT_COUNT; $i++) {
            $lDB->insert_id = null;
            $testResult = call_user_func($testTableFunction);
        }

        $timeDifference = microtime(true) - $startTime;

        $finalTime = round($timeDifference * 1000);
        $testResult['time'] = $finalTime;
    } else {
        $testResult = testResult(false, "No test for table");
    }
    return $testResult;
}

function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function testResult($insertId, $details = false, $status = false) {
    $testResult = array();
    $testResult = array('status'=>"N/A", 'details'=>"N/A", 'time'=>0, 'insertCount'=>"N/A");

    if (!empty($insertId)) {
        $testResult['details'] = "Last insert ID: " . $insertId;
        $testResult['status'] = "Success";
    } else if ($insertId === false) {
        $testResult['details'] = "Insert rejected";
        $testResult['status'] = "Failed";
    } else if (empty($insertId)) {
        $testResult['details'] = "Failed to get insert ID";
        $testResult['status'] = "Failed";
    }

    if (!empty($lDB->error)) {
        $testResult['details'] = "Insert failed (" . $lDB->error . ")";
    }

    if($details !== false) {
        $testResult['details'] = $details;
    }
    if($status !== false) {
        $testResult['status'] = $status;
    }

    return $testResult;
}

function test_ac_accomm_block() {
    include_once(__DIR__.'/../../db.ac_accomm_block.php');
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_accomm_block_insert('WB1', $date->format("Y-m-d"), $date->add(new DateInterval('P1D'))->format("Y-m-d"), "TEST", 1);
    return testResult($insertId);
}
function test_ac_accomm_room() {
    include_once(__DIR__.'/../../db.ac_accomm_room.php');
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_accomm_room_insert('WB1', generateRandomString(15));
    return testResult($insertId);
}
function test_ac_accomm_room_attr() {
    include_once(__DIR__.'/../../db.ac_accomm_room_attr.php');
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_accomm_room_attr_insert('WB1','TEST');
    return testResult($insertId);
}
function test_ac_accomm_room_block() {
    include_once(__DIR__.'/../../db.ac_accomm_room_block.php');
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_accomm_room_block_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_ac_accomm_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_accomm_type.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO ac_accomm_type (
            ac_accomm_type_db,
            ac_accomm_type_id,
            ac_accomm_capacity,
            ac_accomm_desc,
            ac_accomm_label,
            ac_accomm_name_short,
            ac_accomm_no_of_units,
            ac_accomm_note,
            ac_accomm_sequence,
            fn_cost_centre_id,
            pr_business_id,
            ac_accomm_type_inactive_date,
            ac_accomm_type_inactive_yn,
            ac_accomm_xref_text,
            ac_accomm_max_capacity,
            ac_accomm_max_adults,
            ac_accomm_max_child_age,
            ac_accomm_day_yn
        )
        VALUES (
            'WB',
            '',
            1,
            'TEST',
            'TEST',
            'TEST',
            1,
            'TEST',
            1,
            GET_UUID(),
            GET_UUID(),
            CURDATE(),
            1,
            'TEST',
            1,
            1,
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ac_extra() {
    include_once(__DIR__.'/../../db.ac_extra.php');
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO ac_extra (
            ac_extra_db,
            ac_extra_id,
            ac_ext_amount,
            ac_ext_child_disc,
            ac_ext_colour,
            ac_ext_comm_pay,
            ac_ext_comm_rec,
            ac_ext_max,
            ac_ext_max_yn,
            ac_ext_desc,
            ac_extra_external_yn,
            ac_ext_note,
            ac_ext_note_internal,
            ac_ext_supplier_conf_yn,
            ac_ext_travel_eta,
            ac_ext_travel_etd,
            ac_ext_adult_count,
            ac_ext_child_count,
            ac_ext_nights,
            ac_extra_category_id,
            fn_cost_centre_default_id,
            fn_ledger_id,
            pr_supplier_id,
            rf_currency_id,
            rf_tax_id,
            rf_tax_ind,
            ac_inactive_yn,
            ac_extra_xref
        )
        VALUES (
            'WB',
            '',
            1.00,
            1.00,
            'A1A1',
            1.00,
            1.00,
            1,
            1,
            'TEST',
            1,
            'TEST',
            'TEST',
            1,
            'TEST',
            'TEST',
            1,
            1,
            1,
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            1,
            'TEST'
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ac_extra_category() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_extra_category.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $random = substr(uniqid(rand(),1),0,3);
    $insertId = db_ac_extra_category_insert(1, generateRandomString(4), generateRandomString(20), 'A1A1', 'TEST');
    return testResult($insertId);
}
function test_ac_extra_cat_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_extra_cat_inv.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_extra_cat_inv_insert($testUUID,$testUUID,$testUUID,$testUUID,$testUUID);
    return testResult($insertId);
}
function test_ac_extra_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_extra_inv.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_extra_inv_insert($testUUID,$testUUID,$testUUID,$testUUID,$testUUID);
    return testResult($insertId);
}
function test_ac_extra_prop() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO ac_extra_prop (
            ac_extra_prop_db,
            ac_extra_prop_id,
            ac_extra_id,
            pr_business_id
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ac_pay_plan() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_pay_plan.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO ac_pay_plan (
            ac_pay_plan_db,
            ac_pay_plan_desc,
            ac_pay_plan_inactive_yn
        )
        VALUES (
            'WB',
            UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ac_pay_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO ac_pay_item (ac_pay_item_db, ac_pay_base, ac_pay_days, ac_pay_final_base, ac_pay_final_days, ac_pay_final_agent_override_yn, ac_pay_amount_ind, ac_pay_amount, ac_pay_plan_id) VALUES ('" . generateRandomString(2) . "', '0', '0', '0', '0', '0', '0', '0.00', '0')
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ac_pos() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_pos.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO ac_pos (
            ac_pos_db,
            ac_pos_id,
            ac_pos_name,
            ac_pos_name_rr,
            ac_extra_id,
            ac_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            GET_UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ac_pos_map() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_pos_map.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_pos_map_insert('WB1','WB1', generateRandomString(4));
    return testResult($insertId);
}
function test_ac_pos_map_accomm() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ac_pos_map_accomm.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ac_pos_map_accomm_insert('WB1','WB1');
    return testResult($insertId);
}
function test_ad_batch() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_batch.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ad_batch_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_ad_db_status() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    
    $lDB->put("
        INSERT INTO ad_db_status (ad_db_status_db,  ad_db_start, ad_db_start_tz, ad_db_end, ad_db_end_tz, ad_db_function_ind, ad_db_user_id) VALUES ('" . generateRandomString(2) . "', '0000-00-00 00:00:00.000000', '', '0000-00-00 00:00:00.000000', '', NULL, NULL)
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_ad_persona() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_persona.php');
    $testResult = array('status'=>"Success",'details'=>"");
    
    $insertId = db_ad_persona_insert("WB1", generateRandomString(6));
    return testResult($insertId);
}
function test_ad_persona_detail() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_persona_detail.php');
    $testResult = array('status'=>"Success",'details'=>"");

    $randomString = generateRandomString(6);

    $insertId = db_ad_persona_detail_insert($randomString, $randomString, $randomString, $randomString, $randomString, $randomString, $randomString, 1, "WB1", $randomString);
    return testResult($insertId);
}
function test_ad_reservation() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_reservation.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ad_reservation_insert(date("Y-m-d hh:MM:ss"),'TEST',$testUUID,1,$testUUID,array());
    return testResult($insertId);
}
function test_ad_res_detail() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_res_detail.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $randomString = generateRandomString(6);
    $insertId = db_ad_res_detail_insert($randomString, $randomString, $randomString, $randomString, $randomString, $randomString, 1, $randomString, $randomString);
    return testResult($insertId);
}
function test_ad_useraccess() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_useraccess.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ad_useraccess_insert($testUUID,'TEST',array());
    return testResult($insertId);
}
function test_ad_useraccess_detail() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_useraccess_detail.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ad_useraccess_detail_insert('TEST','TEST1','TEST','TEST1',1,$testUUID,$testUUID);
    return testResult($insertId);
}
function test_ad_user_log() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.ad_user_log.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_ad_user_log_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_bl_block() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.bl_block.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_bl_block_insert(generateRandomString(15),'TEST',$testUUID,$testUUID,$testUUID,'TEST',$testUUID,1,'TEST','TEST');
    return testResult($insertId);
}
function test_bl_block_itinerary() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.bl_block_itinerary.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_bl_block_itinerary_insert($testUUID,$testUUID,$testUUID,$date->format("Y-m-d"),$date->add(new DateInterval('P1D'))->format("Y-m-d"),1,1);
    return testResult($insertId);
}
function test_bl_block_period() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.bl_block_period.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_bl_block_period_insert($testUUID,$date->format("Y-m-d"),$date->add(new DateInterval('P1D'))->format("Y-m-d"),1,1,1,1,1,1,1,1,$date->format("Y-m-d"));
    return testResult($insertId);
}
function test_em_mail() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO em_mail (
            em_mail_db,
            em_mail_id,
            em_from,
            em_to,
            em_subject,
            em_message,
            rv_reservation_id
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_em_mail_log() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO em_mail_log (
            em_mail_log_db,
            em_mail_log_id,
            em_server,
            pr_user_id,
            em_mail_id,
            em_action,
            em_action_date_time,
            em_action_log,
            em_status
        )
        VALUES (
            'WB',
            '',
            'TEST',
            GET_UUID(),
            GET_UUID(),
            1,
            CURDATE(),
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_fn_batch() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_batch.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_batch_insert("WB1",'TEST',$testUUID,'TEST');
    return testResult($insertId);
}
function test_fn_cost_centre() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_cost_centre.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_cost_centre_insert('TEST','TEST',1,$testUUID);
    return testResult($insertId);
}
function test_fn_db_business() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_db_business.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_db_business_insert('WB1', 2);
    return testResult($insertId);
}
function test_fn_debtor() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_debtor.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_debtor_insert('TEST','TEST',$testUUID,$testUUID);
    return testResult($insertId);
}
function test_fn_folio() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_folio.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_folio_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_fn_invoice() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_invoice.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $folio_id = $lDB->get("SELECT fn_folio_ix FROM fn_folio LIMIT 1",4);
    $insertId = db_fn_invoice_insert(1,$folio_id,$date->format("Y-m-d"));
    return testResult($insertId);
}
function test_fn_invoice_bank() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO fn_invoice_bank (
            fn_invoice_bank_db,
            fn_invoice_bank_id,
            fn_inv_bank_acc_name,
            fn_inv_bank_acc_no,
            fn_inv_bank_detail_1,
            fn_inv_bank_detail_2,
            fn_inv_bank_detail_3,
            fn_inv_bank_name,
            fn_inv_currency_symbol,
            fn_invoice_id
        )
        VALUES (
            'WB1',
            '',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            'TST',
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_fn_invoice_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_invoice_item.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_invoice_item_insert($testUUID,1,$date->format("Y-m-d"),'TEST',1.0,1.0,1.0,1.0,'TEST');
    return testResult($insertId);
}
function test_fn_invoice_item_tax() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_invoice_item_tax.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_invoice_item_tax_insert("WB1",$testUUID,1.0,1.0);
    return testResult($insertId);
}
function test_fn_invoice_note() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO fn_invoice_note (
            fn_invoice_note_db,
            fn_invoice_note_id,
            fn_inv_note_content,
            fn_inv_note_hdg,
            fn_invoice_id
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_fn_invoice_payment() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_invoice_payment.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_invoice_payment_insert($testUUID,1.0,'TEST','TST',$date->format("Y-m-d"),'TEST','TEST','TEST',$testUUID,$testUUID);
    return testResult($insertId);
}
function test_fn_invoice_special() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_invoice_special.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_invoice_special_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_fn_ledger() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_ledger.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_ledger_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_fn_option() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_option.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO fn_option (
            fn_option_db,
            fn_option_id,
            fn_option_name,
            fn_option_desc
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST'
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_fn_option_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_option_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO fn_option_data (
            fn_option_data_db,
            fn_option_data_id,
            pr_business_id,
            fn_option_id,
            fn_option_data_contents
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            GET_UUID(),
            'TEST'
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_fn_system() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO fn_system (
            fn_system_db,
            fn_system_id,
            fn_system_name,
            fn_system_desc,
            fn_sys_credit_note_yn,
            fn_sys_debtor_yn,
            fn_sys_invoice_yn,
            fn_sys_payment_yn,
            fn_sys_refund_yn,
            fn_sys_tran_yn,
            fn_sys_tran_summary_yn,
            fn_sys_tax_groups_yn,
            fn_system_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_fn_tran() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_tran.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_tran_insert(40,$testUUID);
    return testResult($insertId);
}
function test_fn_tran_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_tran_item.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_tran_item_insert($testUUID,10,$testUUID,$testUUID,$testUUID,1.0,1.0,1.0, 1.0);
    return testResult($insertId);
}
function test_fn_year() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.fn_year.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_fn_year_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pf_field() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pf_field.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pf_field_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pf_object() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pf_object.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pf_object (
            pf_object_db,
            pf_object_id,
            pf_object_name,
            pf_object_note,
            sc_job_id
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pf_option() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pf_option.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pf_option_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pg_account() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_account.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pg_account_insert($testUUID,'TEST',1,1,1,$testUUID,1, 1);
    return testResult($insertId);
}
function test_pg_acc_business() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_acc_business.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pg_acc_business_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pg_acc_currency() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_acc_currency.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pg_acc_currency_insert($testUUID,$testUUID,$testUUID,'TEST',1);
    return testResult($insertId);
}
function test_pg_acc_method() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_acc_method.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pg_acc_method_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pg_acc_obj_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_acc_obj_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pg_acc_obj_data_insert($testUUID,$testUUID,'TEST',$testUUID);
    return testResult($insertId);
}
function test_pg_method() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_method.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pg_method (
            pg_method_db,
            pg_method_id,
            pg_method_name,
            pg_method_note,
            pg_method_image,
            pg_method_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pg_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_type.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pg_type (
            pg_type_db,
            pg_type_id,
            pg_type_name,
            pg_type_label,
            pg_type_logo,
            pg_type_api_url,
            pg_type_site_url,
            pg_type_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pg_type_obj() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pg_type_obj.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pg_type_obj (
            pg_type_obj_db,
            pg_type_obj_id,
            pg_type_obj_name,
            pg_type_obj_label,
            pg_type_obj_sort_seq,
            pg_type_obj_type_ind,
            pg_type_id,
            pg_type_obj_mandatory_yn,
            pg_type_obj_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1,
            1,
            GET_UUID(),
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pg_type_obj_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pg_type_obj_data (
            pg_type_obj_data_db,
            pg_type_obj_data_id,
            pg_type_obj_data_content,
            pg_type_obj_data_sort_seq,
            pg_type_obj_id,
            pg_type_obj_data_default_yn,
            pg_type_obj_data_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            1,
            GET_UUID(),
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pr_agent() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pr_agent_rate (
            pr_agent_rate_db,
            pr_agent_rate_id,
            pr_agent_rate_ix,
            pr_agent_rate_default_yn,
            pr_agent_id,
            rt_rate_type_id
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            1,
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pr_agent_rate() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pr_agent_rate (
            pr_agent_rate_db,
            pr_agent_rate_id,
            pr_agent_rate_ix,
            pr_agent_rate_default_yn,
            pr_agent_id,
            rt_rate_type_id
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            1,
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pr_business() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_business.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pr_business (
            pr_business_id, pr_bus_billing_yn, pr_bus_billing_prop_yn, pr_bus_cost_ctr, pr_bus_inv_future_ind, pr_bus_inv_number, pr_bus_inv_prefix, pr_bus_opt_accomm, pr_bus_opt_bank, pr_bus_opt_cca, pr_bus_opt_date, pr_bus_opt_special, pr_bus_opt_special_note, pr_bus_opt_tax, pr_bus_opt_tax_table, pr_bus_opt_tax_table_gl, pr_bus_opt_tax_table_rate, pr_bus_opt_tax_table_total, pr_bus_opt_terms, pr_bus_opt_terms_bus, pr_bus_proforma_tax_ind, pr_bus_tax_table_align, pr_bus_property_yn, pr_bus_post_level_gl, pr_bus_post_clear_dtrs_yn, pr_bus_post_level_dtrs, pr_bus_post_pmt_yn, pr_bus_post_dep_yn, pr_bus_post_inv_yn, pr_bus_post_tax_cost_ctr_yn, pr_bus_post_source_curr_yn, pr_bus_ignore_past_pmt_yn, pr_bus_statutory_1, pr_bus_statutory_2, pr_bus_statutory_3, pr_bus_statutory_label_1, pr_bus_statutory_label_2, pr_bus_statutory_label_3, pr_bus_wetu_id, pr_bus_wetu_exclude, pr_bus_memo_cal, pr_bus_memo_info, pr_bus_name_short, pr_business_sequence, pr_business_parent, fn_cost_centre_1_default_id, fn_cost_centre_1_id, fn_cost_centre_id, fn_debtor_id_cash, fn_debtor_id_suspense, fn_debtor_id_suspense_foreign, fn_ledger_id_cash, fn_ledger_id_debtors, fn_ledger_id_suspense, fn_ledger_id_suspense_foreign, fn_ledger_id_forex, fn_system_id, fn_system_email, pr_bus_home_curr_id, pr_bus_post_env_id, pr_bus_prop_curr_id, pr_bus_prop_latitude, pr_bus_prop_longitude, pr_bus_inactive_yn, pr_bus_xref_num, dt_temp_id, pr_business_trf_yn
        ) VALUES (
            GET_UUID(), '0', '0', RAND(), '0', '0', RAND(), '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '0', '0', '1', RAND(), RAND(), RAND(), RAND(), RAND(), '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '', '', '0', '0', NULL, '0'
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_pr_bus_tax() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_bus_tax.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_bus_tax_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pr_event() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_event.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_event_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pr_event_persona() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_event_persona.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_event_persona_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pr_guest_obj_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_guest_obj_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_guest_obj_data_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pr_persona() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_persona.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_persona_insert(1,'TEST');
    return testResult($insertId);
}
function test_pr_persona_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_persona_inv.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_persona_inv_insert($testUUID,$testUUID,$testUUID);
    return testResult($insertId);
}
function test_pr_phone() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_phone.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_phone_insert($testUUID,$testUUID,'TEST');
    return testResult($insertId);
}
function test_pr_sales_obj_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_sales_obj_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_pr_sales_obj_data_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_pr_user() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.pr_user.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO pr_user (
            pr_user_id,
            pr_user_name,
            pr_user_password,
            pr_user_inactive_yn,
            pr_user_notify_yn
        )
        VALUES (
            GET_UUID(),
            RAND(),
            'TEST',
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rc_action() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rc_action.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rc_action (
            rc_action_db,
            rc_action_id,
            rc_action_colour,
            rc_action_desc,
            rc_action_icon,
            rc_action_sys_code,
            rc_action_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rc_event() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rc_event.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rc_event (
            rc_event_db,
            rc_event_id,
            rc_event_abbrv,
            rc_event_desc,
            rc_event_note,
            rc_event_colour,
            rc_event_sys_code,
            rc_event_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rc_event_tag() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rc_event_tag.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rc_event_tag_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rc_obj_sales() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rc_obj_sales.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rc_obj_sales_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rc_obj_sales_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rc_obj_sales_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rc_obj_sales_data_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rc_tag() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rc_tag.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rc_tag (
            rc_tag_db,
            rc_tag_id,
            rc_tag_colour,
            rc_tag_desc,
            rc_tag_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_bank() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_bank.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_bank_insert(1,$testUUID,'TEST','TEST','TEST','TEST','TEST','TEST','TEST');
    return testResult($insertId);
}
function test_rf_bank_env() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_bank_env (
            rf_bank_env_db,
            rf_bank_env_id,
            rf_bank_env_default_yn,
            rf_bank_id,
            rf_database_id
        )
        VALUES (
            'WB',
            '',
            1,
            GET_UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_bank_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_bank_inv.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_bank_inv_insert($testUUID,$testUUID,$testUUID,$testUUID);
    return testResult($insertId);
}
function test_rf_country() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_country.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_country (
            rf_country_db,
            rf_country_id,
            rf_country_code,
            rf_country_colour,
            rf_country_dialcode,
            rf_country_name,
            rf_currency_id,
            rf_country_inactive
        )
        VALUES (
            'WB',
            '',
            FLOOR(RAND()*1000),
            'TEST',
            'TEST',
            GET_UUID(),
            GET_UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_currency() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_currency.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_currency (
            rf_currency_db,
            rf_currency_id,
            rf_currency_exch_op,
            rf_currency_name,
            rf_currency_symbol,
            rf_currency_inactive_yn
        )
        VALUES (
            '" .  generateRandomString(2) . "',
            '',
            1,
            'TEST',
            '" .  generateRandomString(3) . "',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_currency_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_currency_inv (
            rf_currency_inv_db,
            rf_currency_inv_id,
            rf_currency_inv_code,
            rf_currency_id,
            pr_business_id
        )
        VALUES (
            'WB',
            '',
            1,
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_database() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_database.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_database (
            rf_db_code,
            rf_db_description,
            rf_db_env_type_ind,
            rf_db_env_type_name
        )
        VALUES (
            \"" . generateRandomString(2) . "\",
            'TEST',
            1,
            'TEST'
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_exchange_rate() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_exchange_rate.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_exchange_rate_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rf_guest_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_guest_type (
            rf_guest_type_db,
            rf_guest_type_name,
            rf_guest_type_abbrv,
            rf_guest_type_desc,
            rf_guest_type_inactive_yn
        )
        VALUES (
            'WB',
            GET_UUID(),
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_mthd_pmnt() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_mthd_pmnt.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_mthd_pmnt (
            rf_mthd_pmnt_db,
            rf_mthd_pmnt_id,
            rf_mthd_pmnt_desc,
            rf_mthd_pmnt_sys_code,
            rf_mthd_pmnt_inactive_yn
        )
        VALUES (
            'WB',
            '',
            \"" . generateRandomString(12) . "\",
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_name_suffix() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_name_suffix.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_name_suffix (
            rf_name_suffix_db,
            rf_name_suffix_id,
            rf_suffix_desc,
            rf_suffix_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_note() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_note (
            rf_note_db,
            rf_note_desc,
            rf_note_external,
            rf_note_internal,
            rf_note_xref,
            rf_note_guest_yn
        )
        VALUES (
            'WB',
            GET_UUID(),
            'TEST',
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_note_custom() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_note_custom (
            rf_note_custom_db,
            rf_note_custom_id,
            rf_note_custom_desc,
            rf_note_custom_hdg
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST'
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_note_cust_default() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_note_cust_default (
            rf_note_cust_default_db,
            rf_note_cust_default_id,
            rf_note_cust_def_ext_inv_yn,
            rf_note_cust_def_ext_summ_yn,
            rf_note_cust_def_ext_pro_yn,
            rf_note_cust_def_int_inv_yn,
            rf_note_cust_def_int_summ_yn,
            rf_note_cust_def_int_pro_yn,
            rf_db_env_type_ind,
            rf_db_code,
            rf_note_custom_id
        )
        VALUES (
            'WB',
            '',
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            'WB',
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_note_cust_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_note_cust_item (
            rf_note_cust_item_db,
            rf_note_cust_item_id,
            rf_note_cust_item_path,
            rf_note_cust_item_seq,
            rf_note_cust_item_text,
            rf_note_cust_pg_brk_yn,
            rf_note_custom_id
        )
        VALUES (
            'WB',
            '',
            'TEST',
            1,
            'TEST',
            1,
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_obj_guest() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_obj_guest.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_obj_guest_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rf_obj_guest_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_obj_guest_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_obj_guest_data_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rf_obj_trip() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_obj_trip.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_obj_trip_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rf_obj_trip_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_obj_trip_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_obj_trip_data_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rf_obj_trip_prop() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_obj_trip_prop.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rf_obj_trip_prop_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rf_phone_extn() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_phone_extn (
            rf_phone_extn_db,
            rf_phone_extn_id,
            ac_extra_id,
            ac_accomm_room_id,
            sy_date_rec,
            sy_date_upd,
            rf_phone_extn_inactive_yn
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            GET_UUID(),
            CURDATE(),
            CURDATE(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_phone_prop_extra() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_phone_prop_extra (
            rf_phone_prop_extra_db,
            rf_phone_prop_extra_id,
            pr_business_id,
            ac_extra_id,
            sy_date_rec,
            sy_date_upd
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            GET_UUID(),
            CURDATE(),
            CURDATE()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_phone_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_phone_type (
            rf_phone_type_db,
            rf_phone_type_id,
            rf_phone_type_desc,
            rf_phone_type_sys_code,
            rf_phone_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_source() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_source (
            rf_source_db,
            rf_source_id,
            rf_source_abbrv,
            rf_source_colour,
            rf_source_desc,
            rf_source_note,
            rf_source_sys_code,
            rf_source_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_tax_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_tax_inv (
            rf_tax_inv_db,
            rf_tax_inv_id,
            fn_ledger_id,
            pr_business_id,
            rf_tax_id,
            rf_tax_ind
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_tax_rate() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_tax_rate.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_tax_rate (
            rf_tax_rate_db,
            rf_tax_rate_id,
            rf_tax_rate_code,
            rf_tax_rate_desc,
            rf_tax_rate_perc,
            rf_tax_rate_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1.0,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rf_title() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rf_title.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rf_title (
            rf_title_db,
            rf_title_id,
            rf_title_desc,
            rf_title_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_component() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_component.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_component (
            rt_component_db,
            rt_component_id,
            rt_component_abbrv,
            rt_component_desc,
            rt_component_freq_ind,
            rt_component_room_attr_yn,
            rt_component_separate_yn,
            rt_component_separate_proforma_ind,
            rt_component_sys_code,
            rt_component_opt_yn,
            rt_component_def_yn,
            rt_component_comm,
            rt_component_freq,
            rt_component_freqfact,
            rt_component_taxrate,
            rt_component_taxgroup,
            rt_component_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            GET_UUID(),
            GET_UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_component_inv() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_component_inv.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rt_component_inv_insert($testUUID, $testUUID, $testUUID, $testUUID);
    return testResult($insertId);
}
function test_rt_period() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_period.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_period (
            rt_period_db,
            rt_period_id,
            rt_period_abbrv,
            rt_period_colour,
            rt_period_date_from,
            rt_period_date_to,
            rt_period_desc,
            rt_period_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            CURDATE(),
            CURDATE(),
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_period_dates() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_period_dates.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_period_dates (
            rt_period_dates_db,
            rt_period_dates_id,
            rt_period_from,
            rt_period_to,
            rt_period_id
        )
        VALUES (
            'WB',
            '',
            CURDATE(),
            CURDATE(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_rate() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_rate.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_rate (
            rt_rate_db,
            rt_rate_id,
            rt_rate_template_desc,
            ac_accomm_type_id,
            rt_comp_template_attr_id,
            rt_period_id,
            rt_rate_type_id,
            rt_rate_dist_yn,
            rt_rate_comm_yn,
            rt_rate_overide_level_ind,
            rt_rate_oride_comm_yn,
            rt_rate_ssupp_comm_yn,
            rt_rate_round_dir,
            rt_rate_round_scale,
            rt_rate_waive_checks_yn,
            rt_pax_rate_group_yn,
            rt_rate_status_ind,
            rt_rate_tba_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_rate_component() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_rate_component.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_rate_component (
            rt_rate_component_db,
            rt_rate_component_id,
            rt_comp_comm_yn,
            rt_comp_freq_ind,
            rt_comp_freq_factor,
            rt_comp_itin_yn,
            rt_comp_los_yn,
            rt_comp_opt_yn,
            rt_comp_opt_def_yn,
            rt_comp_round_ind,
            rt_comp_separate_yn,
            rt_tax_ind,
            rt_tax_id,
            rt_component_id,
            rt_rate_id
        )
        VALUES (
            'WB',
            '',
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            GET_UUID(),
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_rate_comp_grp() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_rate_comp_grp.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_rate_comp_grp (
            rt_rate_comp_grp_db,
            rt_rate_comp_grp_id,
            rt_rate_comp_amt,
            rt_rate_comp_perc,
            rt_rate_comp_val_ind,
            rt_rate_comp_grp_comm_yn,
            rt_rate_comp_grp_seq,
            rt_rate_group_id,
            rt_rate_component_id
        )
        VALUES (
            'WB',
            '',
            1.0,
            1.0,
            1,
            1,
            1,
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_rate_group() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_rate_group (
            rt_rate_group_db,
            rt_rate_group_id,
            rt_rate_group_abbrv,
            rt_rate_group_desc,
            rt_rate_group_sys_code,
            rt_rate_group_class,
            rt_rate_group_default_yn,
            rt_rate_group_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1,
            1,
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_rate_grp_amt() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_rate_grp_amt.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_rate_grp_amt (
            rt_rate_grp_amt_db,
            rt_rate_grp_amt_id,
            rt_rate_grp_amt_amount,
            rt_rate_grp_amt_qty,
            rt_rate_id,
            rt_rate_group_id
        )
        VALUES (
            'WB',
            '',
            1.0,
            1,
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_rate_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rt_rate_type.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_rate_type (
            rt_rate_type_db,
            rt_rate_type_id,
            rt_rate_type_abbrv,
            rt_rate_type_colour,
            rt_rate_type_desc,
            rt_rate_type_note,
            rf_currency_id,
            rt_rate_type_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            GET_UUID(),
            'TEST',
            GET_UUID(),
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_tax_group() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_tax_group (
            rt_tax_group_db,
            rt_tax_group_id,
            rt_tax_group_abbrev,
            rt_tax_group_desc,
            rt_tax_group_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rt_tax_group_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rt_tax_group_item (
            rt_tax_group_item_db,
            rt_tax_group_item_id,
            rt_tax_base_ind,
            rf_tax_rate_id,
            rt_tax_group_id
        )
        VALUES (
            'WB',
            '',
            1,
            GET_UUID(),
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rv_extra() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_extra.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_extra_insert($testUUID, $testUUID, $testUUID, 1, $date->format("Y-m-d"), 1, 1, 1, 1, 1, 'TEST', 'TEST', $testUUID, $testUUID, $testUUID, 1, $date->format("Y-m-d"), $testUUID);
    return testResult($insertId);
}
function test_rv_extra_tax() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rv_extra_tax (
            rv_extra_tax_db,
            rv_extra_tax_id,
            rv_extra_id,
            rf_tax_rate_id,
            rv_extra_tax_perc,
            rv_extra_tax_amt,
            ad_create_user_id,
            ad_create_date,
            ad_create_date_tz,
            ad_modify_user_id,
            ad_modify_date,
            ad_modify_date_tz
        )
        VALUES (
            'WB',
            GET_UUID(),
            GET_UUID(),
            GET_UUID(),
            1.0,
            1.0,
            GET_UUID(),
            CURDATE(),
            '',
            GET_UUID(),
            CURDATE(),
            ''
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rv_note() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_note.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_note_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_payment() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_payment.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_payment_insert($testUUID,$date->format('Y-m-d'),$testUUID,$testUUID);
    return testResult($insertId);
}
function test_rv_payment_gateway() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_payment_gateway.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_payment_gateway_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_payment_gateway_folio() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_payment_gateway_folio.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_payment_gateway_folio_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_payment_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_payment_item.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_payment_item_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_pay_plan_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO rv_pay_plan_item (
            rv_pay_plan_item_db,
            rv_pay_plan_item_id,
            rv_pay_plan_date,
            rv_pay_plan_amount,
            rv_reservation_id
        )
        VALUES (
            'WB',
            '',
            CURDATE(),
            1.0,
            GET_UUID()
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_rv_phone() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_phone.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_phone_insert('X', 'TEST', 'TEST', 'TEST', $date->format("Y-m-d"), 1.0, 1.0);
    return testResult($insertId);
}
function test_rv_reservation() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_reservation.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_reservation_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_reservation_item() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_reservation_item.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $rateGroups = array();
    $rateGroups[] = array(
        "rt_rate_group_ix" => 'RS1',
        "name"	=> "TEST",
        "qty"	=> 1);
    $rateGroups[] = array(
        "rt_rate_group_ix" => 'RS2',
        "name"	=> "TEST",
        "qty"	=> 2);
    $insertId = db_rv_reservation_item_insert($testUUID,$testUUID,$date->format("Y-m-d"),$date->add(new DateInterval('P1D'))->format("Y-m-d"),$rateGroups,1);
    return testResult($insertId);
}
function test_rv_res_item_comp() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_res_item_comp.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_res_item_comp_insert($testUUID, $testUUID, 10, $testUUID, 1, 1, 1.0, 1.0, 1, 1, 1, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
    return testResult($insertId);
}
function test_rv_res_item_comp_rate_grp() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_res_item_comp_rate_grp.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_res_item_comp_rate_grp_insert($testUUID, $testUUID, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
    return testResult($insertId);
}
function test_rv_res_item_comp_tax() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_res_item_comp_tax.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_res_item_comp_tax_insert(1.0, 1.0, $testUUID, $testUUID);
    return testResult($insertId);
}
function test_rv_res_item_group() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_res_item_group.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_res_item_group_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_res_item_guest() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_res_item_guest.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_res_item_guest_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_res_item_rate_grp() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_res_item_rate_grp.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_res_item_rate_grp_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_special() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_special.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_special_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_rv_trip_obj_data() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.rv_trip_obj_data.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_rv_trip_obj_data_insert($testUUID, $testUUID, $testUUID, $testUUID, 'TEST', 1);
    return testResult($insertId);
}
function test_sp_accomm_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_accomm_type.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_accomm_type_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_sp_prop_rate_group() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_prop_rate_group.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_prop_rate_group_insert($testUUID, $testUUID, $testUUID, 1, 1, 1);
    return testResult($insertId);
}
function test_sp_rate_group_benefit() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_rate_group_benefit.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_rate_group_benefit_insert($testUUID, $testUUID, $testUUID, 1, 1, 1.0, 1.0, 1);
    return testResult($insertId);
}
function test_sp_rate_group_qualify() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_rate_group_qualify.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_rate_group_qualify_insert($testUUID, $testUUID, 1, 1, 1);
    return testResult($insertId);
}
function test_sp_special() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_special.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_special_insert('TEST', $date->format("Y-m-d"), $date->add(new DateInterval('P1D'))->format("Y-m-d"), 1, 1, 1.0, 1, 1, 'TEST');
    return testResult($insertId);
}
function test_sp_special_period() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_special_period.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_special_period_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_sp_special_rate_type() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.sp_special_rate_type.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_sp_special_rate_type_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_tc_res_update() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.tc_res_update.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_tc_res_update_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_tc_sequence() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.tc_sequence.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $tc_sequence_prefix = "";
    $insertId = db_tc_sequence_insert("pr_persona", generateRandomString(2), $tc_sequence_prefix);
    return testResult($insertId);
}
function test_tc_table() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.tc_table.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO tc_table (
            tc_table_name,
            tc_table_seq,
            tc_table_sys_code,
            tc_table_key_ind,
            tc_table_user_facing_yn
        )
        VALUES (
            GET_UUID(),
            9999,
            1,
            1,
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_tc_transfer() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO tc_transfer (
            tc_transfer_db,
            tc_transfer_id,
            tc_trf_source,
            tc_trf_file_size,
            tc_trf_time_start,
            tc_trf_time_extract,
            tc_trf_time_send,
            tc_trf_time_imp_start,
            tc_trf_time_imp_end,
            tc_trf_time_close,
            tc_user_id,
            sc_transfer_id
        )
        VALUES (
            'WB',
            '',
            'WB',
            1,
            CURDATE(),
            CURDATE(),
            CURDATE(),
            CURDATE(),
            CURDATE(),
            CURDATE(),
            GET_UUID(),
            9999
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_tc_transfer_table() {
    global $lDB, $testUUID, $date, $deleteRecords;
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO tc_transfer_table (
            tc_transfer_table_db,
            tc_transfer_table_id,
            tc_trf_tbl_last_exp_rec,
            tc_trf_tbl_last_imp_rec,
            tc_trf_tbl_recs_exp,
            tc_trf_tbl_recs_imp,
            tc_transfer_id,
            tc_table_id
        )
        VALUES (
            'WB',
            '',
            GET_UUID(),
            GET_UUID(),
            1,
            1,
            9999,
            9999
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_zg_account() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zg_account.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $lDB->put("
        INSERT INTO zg_account (
            zg_account_db,
            zg_account_id,
            zg_acc_name,
            zg_acc_username,
            zg_acc_password,
            zg_acc_api_url,
            zg_acc_site_url,
            zg_account_inactive_yn
        )
        VALUES (
            'WB',
            '',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            'TEST',
            1
        )
    ");
    $insertId = $lDB->insert_id;
    return testResult($insertId);
}
function test_zg_account_prop() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zg_account_prop.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zg_account_prop_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_zg_transfer() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zg_transfer.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zg_transfer_insert($testUUID,'TEST',false);
    return testResult($insertId);
}
function test_zg_transfer_guest() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zg_transfer_guest.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zg_transfer_guest_insert($testUUID, $testUUID, $testUUID, $testUUID);
    return testResult($insertId);
}
function test_zg_transfer_guest_prop() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zg_transfer_guest_prop.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zg_transfer_guest_prop_insert($testUUID,'TEST',false);
    return testResult($insertId);
}
function test_zs_queue() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zs_queue.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zs_queue_insert('WB1','TEST',false);
    return testResult($insertId);
}
function test_zs_schedule() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zs_schedule.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zs_schedule_insert($testUUID,1,'','','','','');
    return testResult($insertId);
}
function test_zs_task() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zs_task.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zs_task_insert('TEST','TEST','WB',1,1,1,1);
    return testResult($insertId);
}
function test_zs_task_log() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zs_task_log.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zs_task_log_insert('WB1', false);
    return testResult($insertId);
}
function test_zs_task_notify() {
    global $lDB, $testUUID, $date, $deleteRecords;
    include_once(__DIR__.'/../../db.zs_task_notify.php');
    $testResult = array('status'=>"Success",'details'=>"");
    $insertId = db_zs_task_notify_insert($testUUID,1,1,1,'TEST',$testUUID);
    return testResult($insertId);
}

$text = "
<html>
<head>
    <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\">
    <title>Database Table Test</title>

    <style>
        .errorDiv {
            padding: 5px;
            text-align: center;
            color: #5e1212;
            border: 1px;
            border-color: red;
            background-color: #ffc0c0;
            width: 99%;
            float: middle;
            font-size: 14px
        }
        .tableFullWidth { width: 99%; }
        .tableFullMain thead {
            background-color: #e0e0ff;
        }
        .tableFullMain tbody {
            background-color: #f2f2ff;
        }
        .tableFullMain td {
            padding: 3px;
            padding-left: 5px;
        }
        .tableActions thead {
            background-color: #ffcd7d;
        }
        .tableActions tbody {
            background-color: #ffecce;
        }
        .tableActions tbody td {
            height: 2em;
        }
        .error { background-color: red; }
        .valid { background-color: green; }
        .footer { font-size: 10px; }
        .replace { background-color: pink; }
    </style>
</head>
<body>
<table width=\"100%\">
<tr>
    <td valign=\"top\">
        <table>
        <tr>
            <td><h1>$toolName</h1></td>
        </tr>
        <tr>
            <td>$toolDescription</td>
        </tr>
        </table>
    </td>
</tr>
</table>
<hr/>
<br />
$content
<br/>
<br/>
<hr/>
<div class=\"footer\">
© 2015 by ResRequest All rights reserved.
</div>
</body>
</html>";

output(php_sapi_name(),$background,$text);
?>
