<?php
require_once(__DIR__ . "/functions.php");

checkLogin();

$prnInfo = connectDB();

global $lDB;

$HTML = getHTML("clear.htm");

$trfTableList = array("tc_transfer","tc_transfer_table","td_deletions","tc_res_update","tc_property_trf","td_prop_deletions","tc_prop_res_update","tc_prop_stock_update");

$envList = $lDB->get("SELECT rf_db_code, rf_db_description, rf_db_env_type_ind FROM rf_database ORDER BY rf_database_id",2);
$envOptions = "";
foreach($envList as $envItem) {
	if(strtolower($envItem['rf_db_code'][0]) != "w") {
		$envOptions .= "<option selected value=\"$envItem[rf_db_code]\">$envItem[rf_db_description] ($envItem[rf_db_code])</option>";
	}
}

if(!array_key_exists("action",$_POST)) {
	printDB($prnInfo);
	echo addTags(array("envOptions"=>$envOptions),$HTML['setup']);
} else {
	$actionTaken = false;
	if($_POST['action'] == "resetFlags" && $_POST['resetConfirm'] == "1") {
		echo addTags(array("dummy"=>$_POST['confirmClear'] != "1"?"(dummy run)":""),$HTML['results_header']);
		if($_POST['resetType'] == "1") {
			$checkFlag = '1';
			$setFlag = '0';
			$title = "Setting all records to non-transferred status:";
		} else {
			$checkFlag = '0';
			$setFlag = '1';
			$title = "Setting all records to transferred status:";
		}			
		$tableList = $lDB->get("SELECT tc_table_name FROM tc_table ORDER BY tc_table_seq",3);
		$items = "";
		if($_POST['confirmClear'] == "1") {
			$lDB->masterOverride(true);
		}
		foreach($tableList as $item) {
			if (in_array($item, array("td_deletions", "tc_res_update"))) continue;
			$count = $lDB->get("SELECT COUNT(*) FROM ".$item." WHERE ".$item."_trf_yn = '$checkFlag'",4);
			$totalCount = $lDB->get("SELECT COUNT(*) FROM ".$item." ",4);
			if($_POST['confirmClear'] == "1") {
				$lDB->put("UPDATE " . $item . " SET " . $item . "_trf_yn = '$setFlag' WHERE " . $item . "_trf_yn != '$setFlag'");
			}
			$items .= "<li style=\"background-color:#ffffff;\">$item ($count/$totalCount)";
		}
		if($_POST['confirmClear'] == "1") {
			$lDB->masterOverride(false);
		}
		echo addTags(array("title"=>$title,"items"=>$items),$HTML['resetOutput']);
		$actionTaken = true;
	}
	if($_POST['action'] == "resetFlags" && $_POST['resetTransfer'] == "1") {
		?>
		<div style="height: 200; width: 700; overflow: scroll; background-color: #ffffff;" class="textbox">
		<b style="background-color:#ffffff;">Emptying transfer control tables:</b><br><br>
		<?php
		foreach($trfTableList as $tableName) {
			echo "
				<li style=\"background-color:#ffffff;\">$tableName (".emptyTable($tableName).")
			";
		}
		?>		
			<br><br>
		</div>
		<?php
		$actionTaken = true;
	}
	if($_POST['action'] == "resetFlags" && $_POST['resetEnvironment'] == "1") {
		$envSelect = join("','",explode(":",$_POST['envSelect']));
		$transferList = $lDB->get("SELECT tc_transfer_ix FROM tc_transfer WHERE tc_transfer_db IN ('$envSelect')",3);
		$transferTableList = $lDB->get("SELECT tc_transfer_table_ix FROM tc_transfer_table WHERE tc_transfer_id IN ('".join("','",$transferList)."')",3);
		$changeCount = $lDB->get("SELECT COUNT(*) FROM tc_property_trf WHERE rf_db_code IN ('$envSelect')",4);
		$deleteCount = $lDB->get("SELECT COUNT(*) FROM td_prop_deletions WHERE rf_db_code IN ('$envSelect')",4);
		$resChangeCount = $lDB->get("SELECT COUNT(*) FROM tc_prop_res_update WHERE rf_db_code IN ('$envSelect')",4);
		if($_POST['confirmClear'] == "1") {
			$lDB->transferFlagging(false); // Disable trigger transfer flagging as it records deletions to td_deletions 
			$lDB->put("DELETE FROM tc_transfer WHERE tc_transfer_ix IN ('".join("','",$transferList)."')");
			$lDB->put("DELETE FROM tc_transfer_table WHERE tc_transfer_table_ix IN ('".join("','",$transferTableList)."')");
			$lDB->put("DELETE FROM tc_property_trf WHERE rf_db_code IN ('$envSelect')",4);
			$lDB->put("DELETE FROM td_prop_deletions WHERE rf_db_code IN ('$envSelect')",4);
			$lDB->put("DELETE FROM tc_prop_res_update WHERE rf_db_code IN ('$envSelect')",4);
			$lDB->transferFlagging(true);
		}
		?>
		<div style="height: 200; width: 700; overflow: scroll; background-color: #ffffff;" class="textbox">
			tc_transfer records removed: <?=sizeof($transferList)?><br>
			tc_transfer_table records removed: <?=sizeof($transferTableList)?><br>
			tc_property_trf records removed: <?=$changeCount?><br>
			td_prop_deletions records removed: <?=$deleteCount?><br>
			tc_prop_res_update: <?=$resChangeCount?><br>
			<br>
		</div>
		<?php
		$actionTaken = true;
	}
	if(!$actionTaken) {
		echo "<i>No action requested, none taken.</i><br><form><input type=submit value=\"Retry\"></form>";
	}
	?>
	<input type=button value="Clear" onclick="clearResults();">
	<?php
}

function emptyTable($tableName) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(*) FROM $tableName",4);

	if($_POST['confirmClear'] == "1") {
		$lDB->put("DELETE FROM $tableName");
	}

	return $count;
}
