<?php
require_once(__DIR__ . "/functions.php");

checkLogin();

$prnInfo = connectDB();

global $lDB;

$HTML = getHTML("fix.htm");

if(!isset($_POST['action']) || $_POST['action'] == "") {
	$tableList = $lDB->get("
		SELECT
			tc_table_id,
			tc_table_name
		FROM
			tc_table
		ORDER BY
			tc_table_name
	",2);
	$tableOptions = "";
	foreach($tableList as $tableItem) {
		$tableOptions .= "<option value=\"$tableItem[tc_table_id]\">$tableItem[tc_table_name]</option>";
	}

	printDB($prnInfo);
	echo addTags(array("tableOptions"=>$tableOptions),$HTML['setup']);
} else {
	$actionTaken = false;
	$clearButton = "<input type=button value=\"Clear\" onclick=\"clearResult();\">";
	if($_POST['action'] == "webFix") {
		$table = getTableInfo($_POST['tableId']);
		$idList = getIdList($_POST['delimitId'],$table,$_POST['idList']);
		$dbList = $lDB->get("
			SELECT
				rf_db_code
			FROM
				rf_database
			WHERE
				rf_db_code NOT LIKE 'W%'
				AND rf_database.rf_db_inactive_yn = '0'
		",3);
		$removeKeys = "/************************
 * Remove transfer keys	*
 ************************/
ALTER TABLE tc_prop_res_update DROP PRIMARY KEY;
ALTER TABLE tc_property_trf DROP PRIMARY KEY;
ALTER TABLE td_prop_deletions DROP PRIMARY KEY;

";

$addKeys = "/*********************
 * Add transfer keys *
 *********************/
ALTER IGNORE TABLE tc_prop_res_update ADD PRIMARY KEY (tc_prop_res_update_id,rf_db_code,rv_reservation_id);
ALTER IGNORE TABLE tc_property_trf ADD PRIMARY KEY (rf_db_code,tc_prop_record_id,tc_table_id);
ALTER IGNORE TABLE td_prop_deletions ADD PRIMARY KEY (rf_db_code,tc_table_id,td_record_id);

";
		$output = "
			<table border=0 cellpadding=1 cellspacing=1 class=\"fixedTable\" width=\"900\">
			<col width=\"120\">
			<col width=\"800\">
			<tr>
				<td>" . ($_POST['outputType'] == "sql"?"SQL":"Data transfer export") . "</td>
				<td>
					<textarea readonly cols=\"100\" rows=\"20\" style=\"overflow: scroll\" wrap=off>$removeKeys";
		$output .= "/**".str_repeat("*",strlen($table['name'])) . "**\n" . " * " . $table['name'] . " *\n **" . str_repeat("*",strlen($table['name'])) . "**/\n";
		if($_POST['outputType'] == "sql") {
			foreach($idList as $id) {
				$id = trim($id);
				if($id != "") {
					if($_POST['methodId'] == "delete") {
						$output .= "DELETE FROM $table[name] WHERE $table[key] = '$id';\n";
						foreach($dbList as $dbCode) {
							$output .= "INSERT INTO td_prop_deletions (rf_db_code,tc_table_id,td_record_id) VALUES ('$dbCode','$table[id]','$id');\n";
						}
						$output .= "\n";
					}
					if($_POST['methodId'] == "update") {
						foreach($dbList as $dbCode) {
							$output .= "INSERT INTO tc_property_trf (rf_db_code,tc_table_id,tc_prop_record_id) VALUES ('$dbCode','$table[id]','$id');\n";
						}
						$output .= "\n";
					}
				}
			}
			if($_POST['delimitId'] == "sql") {
				$linkList = unserialize(stripslashes($_POST['linkList']));
				foreach($linkList as $linkItem) {
					$subOutput = "";
					$linkTable = getTableInfo($linkItem['tc_table_id']);
					if($linkItem['table_type'] == "inner") {
						$subWhere = $linkTable['name'] . "." . $table['name'] . "_id IN ('".join("','",$idList)."')";
						$subList = $lDB->get("
							SELECT
								$linkTable[key]
							FROM
								$linkTable[name]
							WHERE
								$subWhere
						",3);
					} else {
						$subWhere = $table['key'] . " IN ('".join("','",$idList)."')";
						$subList = $lDB->get("
							SELECT
								".$table['name'].".".$linkTable['name']."_id
							FROM
								$table[name]
							WHERE
								$subWhere
						",3);
					}
					$subOutput .= "\n/**".str_repeat("*",strlen($linkTable['name'])) . "**\n" . " * " . $linkTable['name'] . " *\n **" . str_repeat("*",strlen($linkTable['name'])) . "**/\n";
					foreach($subList as $id) {
						if($id != "") {
							if($_POST['methodId'] == "delete") {
								$subOutput .= "DELETE FROM $linkTable[name] WHERE $linkTable[key] = '$id';\n";
								foreach($dbList as $dbCode) {
									$subOutput .= "INSERT INTO td_prop_deletions (rf_db_code,tc_table_id,td_record_id) VALUES ('$dbCode','$linkTable[id]','$id');\n";
								}
								$subOutput .= "\n";
							}
							if($_POST['methodId'] == "update") {
								foreach($dbList as $dbCode) {
									$subOutput .= "INSERT INTO tc_property_trf (rf_db_code,tc_table_id,tc_prop_record_id) VALUES ('$dbCode','$linkTable[id]','$id');\n";
								}
								$subOutput .= "\n";
							}
						}
					}
					$output .= $subOutput;
				}
			}
		} else {
			$output .= exportTable($table['name'],$idList);
		}
		$output .= "$addKeys</textarea>
				</td>
			</tr>
			<tr>
				<td>IDs</td>
				<td>
					<textarea readonly cols=\"100\" rows=\"4\" style=\"overflow:scroll\" wrap=off>('".join("','",$idList)."')</textarea>
				</td>
			</tr>
			</table>
		";
		$output .= "<br>$clearButton";
		echo $output;
		$actionTaken = true;
	}
	if(!$actionTaken) {
		echo "<i>No action requested, none taken.</i><br>$clearButton";
	}
}

function getIdList($gId,$table,$gIdList=null) {
	global $lDB;

	switch($gId) {
	case "newline":
		return explode("\n",str_replace("\r","",$_POST['idList']));
	case "space":
		return explode(" ",$_POST['idList']);
	case "comma":
		return explode(",",$_POST['idList']);
	case "sql":
		return $lDB->get("SELECT $table[key] FROM $table[name] " . stripslashes($gIdList),3);
	}	
}

function getTableInfo($tableId) {
	global $lDB;

	$tableArray = array();
	$tableArray['id'] = $tableId;
	$tableArray['name'] = $lDB->get("SELECT tc_table_name FROM tc_table WHERE tc_table_id = '$tableId'",4);
	$tableArray['ind'] = $lDB->get("SELECT tc_table_key_ind FROM tc_table WHERE tc_table_id = '$tableId'",4);
	switch($tableArray['ind']) {
	case 0:
		$tableArray['key'] = $tableArray['name'] . "." . $tableArray['name']."_ix";
		$tableArray['count'] = array("2");
		break;
	case 1:
		$tableArray['key'] = $tableArray['name'] . "." . $tableArray['name']."_id";
		$tableArray['count'] = array("0");
		break;
	case 2:
		$tableArray['key'] = "concat(".$tableArray['name'] . "." . $tableArray['name']."_db,".$tableArray['name'] . "." . $tableArray['name']."_id)";
		$tableArray['count'] = array("0","1");
		break;
	case 3:
		$tableArray['key'] = "concat(".$tableArray['name'] . "." . $tableArray['name']."_db,".$tableArray['name'] . "." . $tableArray['name']."_prefix,".$tableArray['name'] . "." . $tableArray['name']."_id)";
		$tableArray['count'] = array("2");
		break;
	}
	return $tableArray;
}


function exportTable($table,$ids) {
	global $lDB;

	$tableId = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = '$table'",4);
	$tableInfo = getTableInfo($tableId);
	$result = $lDB->get("SELECT * FROM $table WHERE $tableInfo[key] IN ('".join("','",$ids)."')",0);

	$resultCount = @mysqli_num_rows($result);
	# Step 4 - Process each row
	$string = "";
	for($a=0;$a<$resultCount;$a++) {
		$row = mysqli_fetch_row($result);

		if (!$isDeletion && !$isResUpdate) {
			# Prepare the output string
			$cols = sizeof($row);
			for($b=0;$b<$cols;$b++) {
				if (($b+1) == $cols) {
					# If this is the last column (trf_yn), set value to 1
					$row[$b] = "1";
				} else {
					# Else remove chars that can break the import process
					if($row[$b] === null) {
						$row[$b] = "|null|";
					} else {
						$row[$b] = htmlspecialchars($row[$b], ENT_QUOTES);
						$row[$b] = str_replace("'","", $row[$b]);
						$row[$b] = str_replace('"',"", $row[$b]);
						$row[$b] = str_replace("|eol|","|/eol|", $row[$b]);
						$row[$b] = str_replace("|null|","|/null|", $row[$b]);
						$row[$b] = str_replace("|return|","|/return|", $row[$b]);
						$row[$b] = str_replace("|newline|","|/newline|", $row[$b]);
						$row[$b] = str_replace("\r","|return|",$row[$b]);
						$row[$b] = str_replace("\n","|newline|",$row[$b]);
					}
				}
			}
		}
		$string .= join("','",$row)."|eol|\r\n";
	}
	return $string;
}
