<?php

/**
* This class is used to fill an array with feedback text for each step of the process,
* which is then returned as output to the originating ajax call
*/
class DBUpgrade {
    private $text = array();
    private $returnText = array();
    private $principal = "";
    private $clientId = "";
    private $dbVersion = "";
    private $codeVersion = "";
    private $dbSize = "";
    private $vhostFile = "";
    private $saServer = "";
    private $usServer = "";
    private $toBaseVersion = "";
    private $toSpecificVersion = "";
    private $action = "";
    private $logFilename = "";
    const HAPPY_CODE_MD5 = "0f59557ccaa6e8ff8daaa026d1b980fd";
    
    /**
    * Adds text to the array that is going to be returned to the originating ajax
    * @param string $text
    * @param bool $exit
    */
    private function addReturnText($text, $exit = false) {
        $this->text[] = $text;
        $this->appendLogFile(date("Y-m-d H:i:s")." - ".$text);
        if ($exit) { $this->exitWithReturnText(); }
    }

    /**
    * Returns text array to the originating ajax, and exit this script
    */
    private function exitWithReturnText() {
    	if (isset($_GET['presentable']) && $_GET['presentable'] == "end") {
    		$this->returnText[] = "<div style=\"text-align:center; font-family: Arial, Helvetica, sans-serif;\">";
			if ($this->text[count($this->text)-1] == "success") {
				$this->returnText[] = "<div><strong>".$this->text[count($this->text)-2]."</strong></div>";
			} else {
				$this->returnText[] = "<div><strong>".$this->text[count($this->text)-1]."</strong></div>";
				$this->returnText[] = "<div>Please contact your ResRequest support representative.</div>";
			}
			$this->returnText[] = "<div>You may now close this browser window.</div>";
			$this->returnText[] = "</div>";
    	} else {
	        if ($this->action == "getinfo") {
	            $this->returnText[] = 'jsonCallback({"result":'.json_encode($this->text, true).'});';
	        } else {
	            $this->returnText[] = 'jsonCallback({"result":['.json_encode($this->text, true).']});';
	        }
	    }

	    echo implode("", $this->returnText);
	    exit();
    }

	private function appendLogFile($data) {
		if ($this->logFilename != "") {
			$newLine = is_file($this->logFilename) ? "\n" : "";
			$logFile = @fopen(__DIR__ . "/" . $this->logFilename,"a+");
			@fwrite($logFile,$newLine.$data);
			@fclose($logFile);
		}
	}

	private function generateLogFilename() {
		$logFilename = $this->clientId."_".str_replace(" ","_",str_replace(":","-",date("Y-m-d")));
		$logDir = "../../../upgrade";
		if(!is_dir($logDir)) {
			mkdir($logDir);
		}
		$this->logFilename = $logDir."/".$logFilename.".log";
	}

    /**
    * Performs a database backup on a web server
    */
    private function backupOnline() {
        $this->addReturnText("Principal: ".$this->principal);

        $this->getClientId();
        $this->addReturnText("Client database ID: ".$this->clientId);

        $hostName = exec('hostname');
        $this->addReturnText("Server: ".$hostName);

        if (!isset($_GET['tospecificversion']) || $_GET['tospecificversion'] == "") {
            $this->addReturnText("Error: No specific version specified", true);
        }
        $this->toSpecificVersion = $_GET['tospecificversion'];
        $this->addReturnText("Version to be upgraded to: ".$this->toSpecificVersion);

        $versionBits = explode(".", $this->toSpecificVersion);
        $this->toBaseVersion = $versionBits[0].".".$versionBits[1];
        $this->addReturnText("Base version to be upgraded to: ".$this->toBaseVersion);

        $this->getDBVersion();
        $this->addReturnText("Current database version: ".$this->dbVersion);

        $this->getCodeVersion();
        $this->addReturnText("Current code version: ".$this->codeVersion);

        $backupLocation = "/var/backups/mysql/upgrade/".$this->toSpecificVersion;
        
        $cmd = "ssh upgrade@".$hostName." [ -d /var/backups/mysql/upgrade/".$this->toSpecificVersion." ] && echo 'Directory found' || echo 'Directory not found'";
        $output=array();
        exec($cmd, $output, $err);

        if ($output[0] == "Directory not found") {
            $cmd = "ssh upgrade@".$hostName." sudo mkdir -p /var/backups/mysql/upgrade/".$this->toSpecificVersion;
            $output=array();
            exec($cmd, $output, $err);
            if ($err != "0") {
                $this->addReturnText("Error: Problem creating backup directory", true);
            } else {
                $this->addReturnText("Backup directory created for ".$this->toSpecificVersion);
            }

            $cmd = "ssh upgrade@".$hostName." sudo chown -R upgrade:upgrade /var/backups/mysql/upgrade/".$this->toSpecificVersion;
            $output=array();
            exec($cmd, $output, $err);
            if ($err != "0") {
                $this->addReturnText("Error: Problem setting ownership of backup directory", true);
            } else {
                $this->addReturnText("Ownership of backup directory set");
            }

            $cmd = "ssh upgrade@".$hostName." sudo chmod -R ugo+rw /var/backups/mysql/upgrade/".$this->toSpecificVersion;
            $output=array();
            exec($cmd, $output, $err);
            if ($err != "0") {
                $this->addReturnText("Error: Problem setting permissions of backup directory", true);
            } else {
                $this->addReturnText("Permissions of backup directory set");
            }
        } else {
            $this->addReturnText("Backup directory exists for ".$this->toSpecificVersion);
        }

        $cmd = 'mysqldump -uroot --add-drop-table cn_live_'.$this->clientId.' | xz -c > '.$backupLocation.'/'.date("Y-m-d").'_cn_live_'.$this->clientId.'_before.sql.xz';
        $output=array();
        exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing Backup command", true);
        } else {
            $this->addReturnText("Backup command executed");
            $this->addReturnText("success", true);
        }

        $cmd = "ssh upgrade@".$hostName." [ -f ".$backupLocation."/".date("Y-m-d")."_cn_live_".$this->clientId."_before.sql.xz ] && echo 'File Found' || echo 'File not found'";
        $output=array();
        exec($cmd, $output, $err);
        if ($output[0] == "File not found") {
            $this->addReturnText("Error: New backup file not found, verification failed for backup ".$backupLocation."/".date("Y-m-d")."_cn_live_".$this->clientId."_before.sql.xz", true);
        } else {
            $this->addReturnText("Existance of new backup file verified: ".$backupLocation."/".date("Y-m-d")."_cn_live_".$this->clientId."_before.sql.xz");
        }
    }

    /**
    * Performs a database backup on an offline server
    */
    private function backupOffline() {

        if (strtoupper(substr(php_uname('s'), 0, 3)) === 'WIN'){
            $osType = "win";
        } else {
            $osType = "nix";
        }

        if ($osType == "win") {

            $backupLocation = '..\..\..\..\backup';
            $binDirectory = '..\..\..\..\bin\\';
            
            if (!file_exists($backupLocation)) {
                $cmd = 'mkdir '.$backupLocation;
                $output=array();
                exec($cmd, $output, $err);
                if ($err != "0") {
                    $this->addReturnText("Error: Problem creating backup directory", true);
                } else {
                    $this->addReturnText("Backup directory created");
                }
            } else {
                $this->addReturnText("Backup directory already exists");
            }

            $backupLocation .= '\\'.$this->toSpecificVersion.'\\';

            if (!file_exists($backupLocation)) {
                $cmd = 'mkdir '.$backupLocation;
                $output=array();
                exec($cmd, $output, $err);
                if ($err != "0") {
                    $this->addReturnText("Error: Problem creating backup directory for ".$this->toSpecificVersion, true);
                } else {
                    $this->addReturnText("Backup directory created for ".$this->toSpecificVersion);
                }
            } else {
                $this->addReturnText("Backup directory already exists for ".$this->toSpecificVersion);
            }

            $backupLocation .= '\\';

        } else {

            $backupLocation = "/var/backups/mysql/upgrade/".$this->toSpecificVersion;
            
            $cmd = "[ -d /var/backups/mysql/upgrade/".$this->toSpecificVersion." ] && echo 'Directory found' || echo 'Directory not found'";
            $output=array();
            exec($cmd, $output, $err);

            if ($output[0] == "Directory not found") {
                $cmd = "mkdir -p /var/backups/mysql/upgrade/".$this->toSpecificVersion;
                $output=array();
                exec($cmd, $output, $err);
                if ($err != "0") {
                    $this->addReturnText("Error: Problem creating backup directory", true);
                } else {
                    $this->addReturnText("Backup directory created for ".$this->toSpecificVersion);
                }

                $cmd = "chown -R upgrade:upgrade /var/backups/mysql/upgrade/".$this->toSpecificVersion;
                $output=array();
                exec($cmd, $output, $err);
                if ($err != "0") {
                    $this->addReturnText("Error: Problem setting ownership of backup directory", true);
                } else {
                    $this->addReturnText("Ownership of backup directory set");
                }

                $cmd = "chmod -R ugo+rw /var/backups/mysql/upgrade/".$this->toSpecificVersion;
                $output=array();
                exec($cmd, $output, $err);
                if ($err != "0") {
                    $this->addReturnText("Error: Problem setting permissions of backup directory", true);
                } else {
                    $this->addReturnText("Permissions of backup directory set");
                }
            } else {
                $this->addReturnText("Backup directory exists");
            }
        }

        $backupFilename = $backupLocation.date("Y-m-d").'_cn_live_'.$this->clientId.'_before.sql.xz';
        if (file_exists($backupFilename)) {
            $backupFilename = $backupLocation.date("Y-m-d_H_i_s").'_cn_live_'.$this->clientId.'_before.sql.xz';
        }

        $cmd = ( ($osType == "win") ? $binDirectory.'mysqldump.exe' : 'mysqldump' ).' -uroot --add-drop-table cn_live_'.$this->clientId.' | '.( ($osType == "win") ? $binDirectory.'xz.exe' : 'xz' ).' -c > '.$backupFilename;
        $output=array();
        exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing Backup command", true);
        } else {
            $this->addReturnText("Backup command executed");
        }

    }

    /**
    * Performs a database upgrade on a web server (SA server only)
    */
    private function upgradeOnline() {

        $this->getClientId();
        $this->addReturnText("Client database ID: ".$this->clientId);

        if (!isset($_GET['tospecificversion']) || $_GET['tospecificversion'] == "") {
            $this->addReturnText("Error: No specific version specified", true);
        }
        $this->toSpecificVersion = $_GET['tospecificversion'];

        $versionBits = explode(".", $this->toSpecificVersion);
        $this->toBaseVersion = $versionBits[0].".".$versionBits[1];

        $this->getDBVersion();
        $versionBits = explode('.', $this->dbVersion);
        $version = $versionBits[0].'.'.$versionBits[1];
        $this->addReturnText("Database version to be upgraded from ".$version." to ".$this->toBaseVersion);

        $sqlFileNix = "../../../rr_".$this->toBaseVersion."/db/".$this->toBaseVersion.".0/".$this->toBaseVersion.".0_db_upgrade_".$version.".x.sql";

        if (!file_exists($sqlFileNix)) {
            $this->addReturnText("Error: Upgrade script file not found: ".$sqlFileNix, true);
        } else {
        	$this->addReturnText("Using upgrade script ".$sqlFileNix);
        }

        $cmd = 'mysql -f -uroot cn_live_'.$this->clientId.' < '.$sqlFileNix.'';
        $output=array();
        $output[] = exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing database upgrade command", true);
        } else {
            $this->addReturnText("Database upgrade completed");
        }

        $cmd = 'mysqlcheck -o -uroot cn_live_'.$this->clientId.';';
        $output=array();
        $output[] = exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing database optimisation command", true);
        } else {
            $this->addReturnText("Database optimisation completed");
            $this->addReturnText("success", true);
        }

    }

    /**
    * Performs a database upgrade on an offline server
    */
    private function upgradeOffline() {

        if (strtoupper(substr(php_uname('s'), 0, 3)) === 'WIN'){
            $osType = "win";
        } else {
            $osType = "nix";
        }

        $versionBits = explode('.', $this->dbVersion);
        $version = $versionBits[0].'.'.$versionBits[1];
        $binDirectory = '..\..\..\..\bin\\';

        $sqlFileWin = "..\..\db\\".$this->toBaseVersion.".0\\".$this->toBaseVersion.".0_db_upgrade_".$version.".x.sql"; // for use on Windows
        $sqlFileNix = "../../db/".$this->toBaseVersion.".0/".$this->toBaseVersion.".0_db_upgrade_".$version.".x.sql";

        if ( ($osType == "nix" && !file_exists($sqlFileNix) ) || ($osType == "win" && !file_exists($sqlFileWin) ) ) {
            $this->addReturnText("Error: Upgrade script file not found", true);
        }

        $cmd = ( ($osType == "win") ? $binDirectory : '' ).'mysql -f -u root cn_live_'.$this->clientId.' < ' . ( ($osType == "win") ? $sqlFileWin : $sqlFileNix ) . '';

        $output=array();
        $output[] = exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing database upgrade command", true);
        } else {
            $this->addReturnText("Database import completed");
        }

        $cmd = ( ($osType == "win") ? $binDirectory : '' ).'mysqlcheck -o -f -u root cn_live_'.$this->clientId.'';
        $output=array();
        $output[] = exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing database optimisation command", true);
        } else {
            $this->addReturnText("Database optimisation completed");
        }
    }

    /**
    * Fetches and returns the database version
    */
    private function getDBVersion() {
        global $cDB;

        $this->dbVersion = $cDB->get("
            SELECT
                cn_live_".$this->clientId.".rf_database.rf_db_version_db
            FROM
                cn_live_".$this->clientId.".rf_database
            LIMIT 1
        ",4);

        if ($this->dbVersion == "") {
            $this->addReturnText("Error: No database version", true);
        }
    }

    /**
    * Fetches and returns the database size
    */
    private function getDBSize() {
        global $cDB;

        $this->dbSize = round($cDB->get("
            SELECT
                SUM( data_length + index_length ) / 1024 / 1024 'Data Base Size in MB'
            FROM
                information_schema.TABLES
            WHERE
                table_schema = 'cn_live_".$this->clientId."'
        ",4));
    }

    /**
    * Fetches and returns the code version, which is located in a .ver file as the filename
    */
    private function getCodeVersion() {
        $dir = "../../";
        if (is_dir($dir)) {
            if ($dh = opendir($dir)) {  
                while (($file = readdir($dh)) !== false) {
                    if(strpos($file,".ver")) {
                        $ver = $file;
                        break;
                    }
                }
                closedir($dh);
            }
        }
        $this->codeVersion = substr($ver,0,strrpos($ver,"."));
    }

    /**
    * Fetches the client id, based on the principal shortname, and returns in correct format
    */
    private function getClientId() {
        global $cDB;

        if ($this->principal == "live") {
            $clientId = $cDB->get("
                SELECT
                    cn_principal_id
                FROM
                    cn_principal
                LIMIT 1
            ",4);
        } else {
            $clientId = $cDB->get("
                SELECT
                    cn_principal_id
                FROM
                    cn_principal
                WHERE
                    cn_prn_name_short = '".$this->principal."'
            ",4);
        }
        if ($clientId == "") {
            $this->addReturnText("Error: Client ID not found in database", true);
        } else {
            $this->clientId = str_pad($clientId, 4, "0", STR_PAD_LEFT);
        }
    }

    /**
    * Fetches and returns various bits of information about the client installation
    *
    * - Server host name
    * - Client ID
    * - Database version
    * - Code version
    * - Database size
    * - Versions available on server
    */
    private function getInfo() {

        $hostName = exec('hostname');
        //$os = exec('echo \$OSTYPE');
        $os = PHP_OS;
        
        $this->principal = $_GET['principal'];
        $this->getClientId();
        $this->getDBVersion();
        $this->getCodeVersion();
        $this->getDBSize();

        $versions = array();
        $dir = "../../../";
        if ($handle = opendir($dir)) {
            while (false !== ($file = readdir($handle))) {
                if (substr($file, 0, 3) == "rr_" && substr_count($file, '.') == 2) {
                    $versions[] = substr($file, 3);
                }
            }
            closedir($handle);
        }
        sort($versions);

        $returnText = array(
            "hostname" => $hostName,
            "client_id" => $this->clientId,
            "db_version" => $this->dbVersion,
            "code_version" => $this->codeVersion,
            "db_size" => $this->dbSize,
            "os" => $os,
            "datetime" => date("Y-m-d H:i:s"),
            "versions" => implode(",", $versions)
        );

        $this->addReturnText($returnText, true);
    }

    /**
    * Checks for and updates the vhost files on the current server
    */
    private function updateVhost() {
        $date = date("d F Y");
        $hostName = exec('hostname');

        $this->addReturnText("Editing Vhost file on ".$hostName." for ".$this->principal);

        if (!isset($_GET['tospecificversion']) || $_GET['tospecificversion'] == "") {
            $this->addReturnText("Error: No specific version specified", true);
        }
        $this->toSpecificVersion = $_GET['tospecificversion'];

        $versionBits = explode(".", $this->toSpecificVersion);
        $this->toBaseVersion = $versionBits[0].".".$versionBits[1];
        $this->addReturnText("Base version to point Vhost file to: ".$this->toBaseVersion);

        $cmd = "ssh upgrade@".$hostName." [ -f /etc/apache2/sites-available/".$this->principal.".conf ] && echo 'File Found' || echo 'File not found'";
        $output=array();
        exec($cmd, $output, $err);
        if ($output[0] == "File not found") {
            $this->addReturnText("Error: Vhost file not found; ".$this->principal.".conf", true);
        } else {
            $this->addReturnText("Vhost file found: ".$this->principal.".conf");
        }

        $cmd = "ssh upgrade@".$hostName." sudo sed -i 's,Modified.*,\"Modified:  ".$date."\",' /etc/apache2/sites-available/".$this->principal.".conf";
        $output=array();
        exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing Vhost date update command", true);
        } else {
            $this->addReturnText("Updated Vhost date with ".$date);
        }

        $cmd = "ssh upgrade@".$hostName." sudo sed -i 's,rr_.*,\"rr_".$this->toBaseVersion."\"/,' /etc/apache2/sites-available/".$this->principal.".conf";
        $output=array();
        exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem executing Vhost version update command", true);
        } else {
            $this->addReturnText("Updated Vhost version with rr_".$this->toBaseVersion);
        }

        $cmd = "ssh -t upgrade@".$hostName." 'sudo /usr/sbin/service apache2 reload'";
        $output=array();
        exec($cmd, $output, $err);
        if ($err != "0") {
            $this->addReturnText("Error: Problem reloading Apache", true);
        } else {
            $this->addReturnText("Reloaded Apache");
            $this->addReturnText("success", true);
        }

    }


    /**
    * Function for gathering information and calling backup and upgrade functions for offline server
    */
    private function performOfflineUpgrade() {

        $this->addReturnText("Principal: ".$this->principal);

        $this->addReturnText("Client database ID: ".$this->clientId);
        
        $this->getCodeVersion();
        $this->addReturnText("Current code version: ".$this->codeVersion);

        $this->toSpecificVersion = $this->codeVersion;
        $this->addReturnText("Version to be upgraded to: ".$this->toSpecificVersion);

        $versionBits = explode(".", $this->toSpecificVersion);
        $this->toBaseVersion = $versionBits[0].".".$versionBits[1];
        $this->addReturnText("Base version to be upgraded to: ".$this->toBaseVersion);

        $this->getDBVersion();
        $this->addReturnText("Current database version: ".$this->dbVersion);

        $dbVersionBits = explode(".", $this->dbVersion);
        $this->toDBBaseVersion = $dbVersionBits[0].".".$dbVersionBits[1];

        if ($this->toDBBaseVersion == $this->toBaseVersion) {
        	$this->addReturnText("Database already on latest version");
        	$this->addReturnText("success", true);
        }
        
        $this->backupOffline();
        $this->upgradeOffline();

        $this->addReturnText("Database backup, and database upgrade completed successfully.");
        $this->addReturnText("success", true);
    }

    public function initialise($happyCode) {
        /**
        * Checks for valid security code, principal and action, as passed in the URL
        */
        if ($happyCode != self::HAPPY_CODE_MD5) {
            $this->addReturnText("Error: Unauthorised Access", true);
        }

        if (empty($_GET['principal'])) {
            $this->addReturnText("Error: No Principal specified", true);
        } else {
            $this->principal = $_GET['principal'];
        }
		
		$this->getClientId();
        $this->generateLogFilename();

        if (empty($_GET['action'])) {
            $this->addReturnText("Error: No Action specified", true);
        } else {
            $this->action = $_GET['action'];
        }

        /**
        * Check for version in the URL when performing backup or upgrade
        */
        if ( ($this->action == "backup" || $this->action == "upgrade") && (!isset($_GET['tospecificversion']) || $_GET['tospecificversion'] == "") ) {
            $this->addReturnText("Error: No Version specified", true);
        }

        /**
        * Set execution time limit to 4 hours, to prevent large database upgrades from timing out.
        */
        set_time_limit(14400);

        /**
        * Route according to action specified
        */
        switch($this->action){
            case "getinfo":
                $this->getInfo();
                break;
            case "perform_update_vhost":
                $this->updateVhost();
                break;
            case "perform_online_backup":
                $this->backupOnline();
                break;
            case "perform_online_upgrade":
                $this->upgradeOnline();
                break;
            case "perform_offline_upgrade":
                $this->performOfflineUpgrade();
                break;
            default:
                $this->addReturnText("Error: Invalid Action specified", true);
        }
    }
}