<?php

require_once(__DIR__ . '/../class.queue.php');
require_once(__DIR__ . '/functions.worker.php');
require_once(__DIR__ . '/../class.rpc.php');

log_message("Starting stock worker");

$hostname = gethostname();
log_message($hostname);
if($hostname == "subarch") {
	log_message("Using subarch for RPC");
	$rpc = new RPC("http://bridge.subarch/api/","censysad","censysad1");
} elseif($hostname == "resrequestvagrant") {
	log_message("Using vagrant for RPC");
	$rpc = new RPC("http://bridge.vagrant/api/","censysad","rSArkEJ4WhvxHK^9");
} else {
	$rpc = new RPC("http://bridge.resrequest.com/api/","censysad","rSArkEJ4WhvxHK^9");
}

$queue = new Queue();
$queue->watch("stock_change");

while($job = $queue->next()) {
	$response = $rpc->Call("ca_stock_change",array($job['principal_id'],$job['ac_accomm_type_id'],$job['dates']));
	if($response === false) {
		log_message("Error sending notification: " . $rpc->Error);
		$queue->release(5);
		continue;
	}

	log_message($response);
	$queue->delete();
}
