<?php
/**
 * Zend Framework (http://framework.zend.com/)
 *
 * @link      http://github.com/zendframework/ZendSkeletonApplication for the canonical source repository
 * @copyright Copyright (c) 2005-2015 Zend Technologies USA Inc. (http://www.zend.com)
 * @license   http://framework.zend.com/license/new-bsd New BSD License
 */

namespace Resrequest\Authentication;

use Zend\Mvc\MvcEvent;
use Zend\Mvc\ModuleRouteListener;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Authentication\AuthenticationService;
use Resrequest\Authentication\Adapter\ApigilityAuthenticationAdapter;
use Zend\Authentication\Storage\Session;
use Zend\Authentication\Storage\StorageInterface;

class Module
{

	public function getConfig()
	{
		if (empty($GLOBALS['domain'])) {
			return array();
		}
		$config = array(
			'apigility-consumer' => array(
				'api-host-url' => $GLOBALS['domain'],
				'oauth' => array(
					'grant_type' => 'password',
					'client_id' => 'resrequest_enterprise',
					'client_secret' => '',
				),
			),
		);
		return array_merge(include __DIR__ . '/config/module.config.php', $config);
	}

	public function getAutoloaderConfig()
	{
		return array(
			'Zend\Loader\StandardAutoloader' => array(
				'namespaces' => array(
					__NAMESPACE__ => __DIR__ . '/src/' . str_replace("\\", "/", __NAMESPACE__),
				),
			),
		);
	}

	public function getServiceConfig()
	{
		return array(
			'factories' => array(
				'Zend\Authentication\AuthenticationService' => function($sm) {
					$adapter = $sm->get(ApigilityAuthenticationAdapter::class);
					$sessionManager = $sm->get('Zend\Session\SessionManager');
					$storage = $sessionManager->getStorage();
					$authenticationService = new AuthenticationService();
					
					$authenticationService->setAdapter($adapter);
					return $authenticationService;
				},
				'Resrequest\Authentication\Adapter\ApigilityAuthenticationAdapter' => function($sm) {
					$factory = new \Resrequest\Authentication\Factory\ApigilityAuthenticationAdapterFactory();
					return $factory($sm);
				},
				'Resrequest\Authentication\Service\Authenticate' => 'Resrequest\Authentication\Factory\AuthenticateFactory',
				'Resrequest\Authentication\Service\Password' => 'Resrequest\Authentication\Factory\PasswordFactory',
			)
		);
	}
}
