<?php

namespace Resrequest\Authentication\Adapter;

use ApigilityConsumer\Service\ClientAuthService;
use Zend\Authentication\Adapter\AbstractAdapter;
use Zend\Authentication\Adapter\AdapterInterface;
use Zend\Authentication\Result;

class ApigilityAuthenticationAdapter
	extends AbstractAdapter
	implements AdapterInterface
{
	/**
	 * @var ClientAuthService
	 */
	private $clientAuthService;

	/**
	 * @param  ClientAuthService $clientAuthService
	 */
	public function __construct(ClientAuthService $clientAuthService)
	{
		$this->clientAuthService = $clientAuthService;
	}

	/**
	 * @return Result
	 */
	public function authenticate()
	{
		$clientResult = $this->clientAuthService->callAPI(
			[
				// your oauth registered route segment in apigility.
				'api-route-segment' => '/oauth',
				'form-data' => [
					'username' => $this->getIdentity(),
					'password' => $this->getCredential(),
				],
				'form-request-method' => 'POST',
			]
		);

		if (!$clientResult->success) {
			return new Result(Result::FAILURE, null, $clientResult::$messages);
		}

		return new Result(RESULT::SUCCESS, $clientResult->data);
	}
}
