<?php

namespace Resrequest\Authentication\Factory;

use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Resrequest\Authentication\Service\Authenticate;
use Resrequest\Authentication\Adapter\ApigilityAuthenticationAdapter;
use Zend\Authentication\Storage\Session;
use Resrequest\Authentication\Service\Password;
use ApigilityConsumer\Service\ClientService;


class AuthenticateFactory implements FactoryInterface
{
	public function createService(ServiceLocatorInterface $serviceLocator)
	{
		$entityManager = $serviceLocator->get('EnterpriseEntityManager');
		$zendAuthentication = $serviceLocator->get('Zend\Authentication\AuthenticationService');
		$clientService = $serviceLocator->get(ClientService::class);
		$passwordService = $serviceLocator->get('Resrequest\Authentication\Service\Password');
		$authService = new Authenticate($serviceLocator, $entityManager, $zendAuthentication, $clientService, $passwordService);
		return $authService;
	}
}
